<?php
// Require widget Class
include_once( plugin_dir_path( __FILE__ ).'widget-class.php' );

// Check if the custom class exists
if ( ! class_exists( 'widget_newsletter' ) )
{
	// Create custom widget class extending CBT_Widget
	class widget_newsletter extends CBT_Widget
	{

		function __construct()
		{
			// Configure widget array
			$args = array(
				// Widget Backend label
				'label' => __('Newsletter Widget', 'cbt'),
				// Widget Backend Description
				'description' => __( '', 'cbt' ),
				'control_ops' => array('width'=>400)
			);

			// Configure the widget fields

			// fields array
			$args['fields'] = array(

				// Title field
				array(
					// field name/label
					'name' => __( 'Title', 'cbt' ),
					// field description
					'desc' => __( '', 'cbt' ),
					// field id
					'id' => 'title',
					// field type ( text, checkbox, textarea, select, select-group )
					'type'=>'text',
					// class, rows, cols
					'class' => 'widefat',
					// default value
					'std' => __( 'Email Newsletter', 'cbt' ),
					'validate' => 'alpha_dash',

					/*

						Filter data before entering the DB
						//////////////////////////////////

						strip_tags ( default )
						wp_strip_all_tags
						esc_attr
						esc_url
						esc_textarea

					*/
					'filter' => 'strip_tags|esc_attr'
				),

				array(
					// field name/label
					'name' => __( 'Text', 'cbt' ),
					// field description
					'desc' => __( 'Displayed above the form', 'cbt' ),
					// field id
					'id' => 'desc',
					// field type ( text, checkbox, textarea, select, select-group )
					'type'=>'textarea',
					// class, rows, cols
					'class' => 'widefat',
					'rows' => '3',
					// default value
					'std' => __( '', 'cbt' ),
					'filter' => ''
				),

				array(
					// field name/label
					'name' => __( 'Opt-in Form HTML Code', 'cbt' ),
					// field description
					'desc' => __( 'Complete form code <b>(Raw HTML Version)</b> from your newsletter service.<br /><small><b>Supported Services:</b> Aweber, ArpReach, ConstantContact, CampaignMonitor, DlGuard, 1Shopping Cart, iContact, InfusionSoft, Interspire, Mailchimp, Madmimi, VashOnMedia</small>', 'cbt' ),
					// field id
					'id' => 'optin_code',
					// field type ( text, checkbox, textarea, select, select-group )
					'type'=>'textarea',
					// class, rows, cols
					'class' => 'widefat',
					'rows' => '7',
					// default value
					'std' => __( '', 'cbt' ),
					'filter' => ''
				),
				
				array( 
					'name' => __( 'Style', 'cbt' ), 							
					'desc' => __( '', 'cbt' ), 
					'id' => 'style', 							
					'type'=>'select', 
					'fields' => array( 								
						array( 
							'name'  => __( 'Default', 'cbt' ), 
							'value' => 'default' 						
						 ), 
						array( 
							'name'  => __( 'Vertical', 'cbt' ), 			
							'value' => 'vertical' 					
						 ), 
						array( 
							'name'  => __( 'Horizontal', 'cbt' ), 
							'value' => 'horizontal'	
						 )
					), 				
					'filter' => 'strip_tags|esc_attr', 
				 ),
				
/*
				array( 
					'name' => __( 'Require name field', 'cbt' ), 							
					'desc' => __( 'If your newsletter service require name field then checkmark the above box', 'cbt' ), 
					'id' => 'require_name', 							
					'type'=>'checkbox', 				
					'std' => 0, // 0 or 1
					'filter' => 'strip_tags|esc_attr', 
				 ), 
*/


				// add more fields

			); // fields array

			// create widget
			$this->create_widget( $args );
		}


		// Output function
		function widget( $args, $data )
		{
			$data = cbt_text_shortcodes_process($data);
			
			if($data['title'])
			{
				$title  = $args['before_title'];
				$title .= apply_filters('widget_title', $data['title']);
				$title .= $args['after_title'];
			}
			
			$style = 'default';
			if($data['style']) $style = $data['style'];
			
			$layout['default'] = array(
				'first_name' => 'col-lg-6',
				'last_name' => 'col-lg-6',
				'email' => 'col-lg-12',
			);
			
			$layout['vertical'] = array(
				'first_name' => 'col-lg-12',
				'last_name' => 'col-lg-12',
				'email' => 'col-lg-12',
			);
			
			$layout['horizontal'] = array(
				'first_name' => 'col-lg-4',
				'last_name' => 'col-lg-4',
				'email' => 'col-lg-4',
			);
			
			$layout = $layout[ $style ];

			$data['require_name'] = true;
			
			if($data['desc']) $data['desc'] = preg_replace('/\[site\-url\]/i', site_url(), $data['desc']);
		  ?>
          <?php echo $before_widget; ?>
          <div class="cbt-newsletter-widget clearfix">
              <div class="cbt-newsletter-title"><?php echo $title; ?></div>
			  <div class="col-lg-12"><?php echo $data['desc']; ?></div>
			  
				<form id="cbt-newsletter-form-<?php echo rand(1000, 9999)?>" class="cbt-newsletter-form form-inline large">
				
					<?php if($data['require_name']):?>
						<div class="<?php echo $layout['first_name']; ?>">
							<div class="input-group">
								<input type="text" name="first_name" placeholder="<?php echo __('Enter your first name', 'cbt');?>" class="form-control cbt-newsletter-field-first-name" />
							</div>
						</div>
						
						<div class="<?php echo $layout['last_name']; ?>">
							<div class="input-group">
								<input type="text" name="last_name" placeholder="<?php echo __('Enter your last name', 'cbt');?>" class="form-control cbt-newsletter-field-last-name" />
							</div>
						</div>
						
						<div class="<?php echo $layout['email']; ?>">
							<div class="input-group">
								<input type="text" name="email" placeholder="<?php echo __('Enter your email address', 'cbt');?>" class="form-control cbt-newsletter-field-email" />
								<span class="input-group-btn">
									<button type="submit" name="submit" class="btn btn-primary"><?php echo __('Sign-up', 'cbt');?></button>
								</span>
							</div>
						</div>
					<?php else:?>
						<div class="input-group">
							<input type="text" name="email" placeholder="<?php echo __('Enter your email address', 'cbt');?>" class="form-control cbt-newsletter-field-email" />
							<span class="input-group-btn">
								<button type="submit" name="submit" class="btn btn-primary"><?php echo __('Sign-up', 'cbt');?></button>
							</span>
						</div>
					<?php endif;?>
				
				
				</form>

			  <div style="display:none;" class="hidden_autoresponder_form"><?php echo $data['parsed_optin_code']?></div>
		  </div>
          <?php echo $after_widget; ?>

          <?php
		}


		function after_validate_fields($data = "")
		{
			if(! isset($data['optin_code'])) return $data;
		
			$optin_code = $data['optin_code'];
			$parsed_optin_code = self::parse_optin_code($optin_code);
			if($parsed_optin_code)
			{
				$data['parsed_optin_code'] = $parsed_optin_code;
			}

			return $data;
		}


		function parse_optin_code($code)
		{
			$possible_name_fields = array(
				'name', // Aweber, 1Shopping Cart
				'cm-name', // CampaignMonitor
				'inf_field_FirstName', // InfusionSoft
				'dlgName', // DlGuard
				'CustomFields[2]', // Interspire
			);
			$possible_first_name_fields = array(
				'name (awf_first)', // Aweber
				'fields_fname', // iContact
				'first_name', // ArpReach
				'firstname', // OfficeAutopilot
				'signup[first_name]', // Madmimi
				'FNAME', // Mailchimp
			);
			$possible_last_name_fields = array(
				'name (awf_last)', // Aweber
				'fields_lname', // iContact
				'last_name', // VashOnMedia, ArpReach
				'lastname', // OfficeAutopilot
				'LNAME',
			);
			$possible_email_fields = array(
				'ea', // ConstantContact
				'email', // Aweber
				'email1', // 1Shopping Cart
				'fields_email', // iContact
				'FormValue_Fields[EmailAddress]', // MailChimp
				'inf_field_Email', // InfusionSoft
				'dlgEmail', // DlGuard
				'email_address', // ArpReach
				'signup[email]', // Madmimi
			);

			$line_break_code = '[@#POPLINEBREAK#@]';
			$count = 0;
			// normalize line breaks
			$code = str_replace("\r\n", "\n", $code);
			$code = str_replace("\r", "\n", $code);

			// temporary remove line breaks
			$code = str_replace("\n", $line_break_code, $code);

			// find the start of the form; chop
			$n = stripos($code, '<form');
			if ($n === false) return false;
			$code = substr($code, $n);

			// find the end of the form; chop, removing "</form>"
			$n = stripos($code, '</form>');
			if ($n === false) return false;
			$code = substr($code, 0, $n);

			// get form start-tag
			$form_start = preg_replace('/^(<[^>]+>).+$/i', '$1', $code);

			// get form method
			$form_method = strtoupper(preg_replace('/^.*method=[\'"]([^\'"]+)[\'"].*$/i',
					'$1', $form_start, -1, $count));
			if ($count == 0) $form_method = 'POST';

			// get form action
			$form_action = preg_replace('/^.*action=[\'"]([^\'"]+)[\'"].*$/i', '$1', $form_start, -1, $count);
			if ($count == 0) return false;

			// construct form start
			$form_start = '<form id="vidd_form-'.rand(1000, 9999).'" method="'.$form_method.'" action="'.$form_action.'">'."\n";


			// get form inner tags
			$inner = preg_replace('/^<[^>]+>(.+)$/i', '$1', $code);

			// split form inner tags
			$tags = array();
			preg_match_all('/<[^>]+>/i', $inner, $tags);
			if (!isset($tags[0])) return false;
			$tags = $tags[0];

			// filter inner tags and construct new "$inner" variable
			$inner = '';
			$name_field = '';
			foreach ($tags as $tag) {
				if (preg_match('/<\s*input/', $tag)) {

					// get "name" attribute value
					$name = preg_replace('/^.*name=[\'"]([^\'"]+)[\'"].*$/i',
						'$1', $tag, -1, $count);
					if ($count == 0) continue;

					// get "value" attribute value
					$value = preg_replace('/^.*value=[\'"]([^\'"]+)[\'"].*$/i',
						'$1', $tag, -1, $count);
					if ($count == 0) $value = '';
					

					//if ($value == '') {
					if ($this->vidd_in_array_i($name, $possible_name_fields)) {
						$value = '[@#POPNAME#@]';
						$name_field = $name;
					} elseif ($this->vidd_in_array_i($name, $possible_first_name_fields)) {
						$value = '[@#POPFIRSTNAME#@]';
					} elseif ($this->vidd_in_array_i($name, $possible_last_name_fields)) {
						$value = '[@#POPLASTNAME#@]';
					} elseif ($this->vidd_in_array_i($name, $possible_email_fields) || // general case
						($name_field == 'cm-name')) { // special case for CampaignMonitor
						$value = '[@#POPEMAIL#@]';
					}
					//}

					$inner .= '<input type="hidden" name="'.$name.
						'" value="'.$value.'" />'."\n";
				}
			}

			// concatenate code
			$code = $form_start.$inner.'</form>';

			// restore line breaks
			$code = str_replace($line_break_code, "\n", $code);
			return $code;
		}

		function vidd_in_array_i($needle, $haystack) 
		{
			foreach ($haystack as $value) 
			{
				//echo '<pre>'.print_r($value, TRUE).'</pre>';
				if (strtolower($value) == strtolower($needle))
				return true;
			}
			return false;
		}



	} // class

	// Register widget
	if ( ! function_exists( 'widget_newsletter' ) )
	{
		function widget_newsletter()
		{
			register_widget('widget_newsletter');
		}

		add_action( 'widgets_init', 'widget_newsletter', 1 );
	}
}