<?php
// Require widget Class
include_once( plugin_dir_path( __FILE__ ).'widget-class.php' );

// Check if the custom class exists
if ( ! class_exists( 'widget_cbt_shortcode' ) )
{
	// Create custom widget class extending CBT_Widget
	class widget_cbt_shortcode extends CBT_Widget
	{

		function __construct()
		{
			// Configure widget array
			$args = array(
				// Widget Backend label
				'label' => __('Shortcode Widget', 'cbt'),
				// Widget Backend Description
				'description' => __( 'Display shortcode in sidebars. WPGlow Builder shortcodes are supported.', 'cbt' ),
				'control_ops' => array('width'=>400)
			);
			
			
			

			// Configure the widget fields

			// fields array
			$args['fields'] = array(


				array(
					// field name/label
					'name' => __( 'Shortcode', 'cbt' ),
					// field description
					'desc' => __( 'Paste-in any shortcode. WPGlow Builder shortcodes are supported.', 'cbt' ),
					// field id
					'id' => 'shortcode',
					// field type ( text, checkbox, textarea, select, select-group )
					'type'=>'textarea',
					// class, rows, cols
					'class' => 'widefat',
					'rows' => '7',
					// default value
					'std' => __( '', 'cbt' ),
					'filter' => ''
				),
				
				
				array(
					'id' => '',
					'type'=>'html',
					'std' => '<center>'.__( '[OR]', 'cbt' ).'</center>',
				),

				array(
					'name' => __( 'Display content from a page', 'cbt' ),
					'id' => 'page',
					'type'=>'select',
					'std' => '',
					'class-p'=>'cbt-shortcode-widget-page-select" style="text-align:center;',
					'fields' => $this->pages_array(), 				
					'filter' => 'strip_tags|esc_attr', 
				),



				// add more fields

			); // fields array

			// create widget
			$this->create_widget( $args );
		}


		function pages_array()
		{
			$out = array();
			
			$out[] = array(
				'name'  => __( '----- Select Page ----', 'cbt' ), 
				'value' => '' 
			);
			
			$args = array(
				'post_type'=>'page',
			);
			$pages = get_pages( $args );
			
			if(! $pages) return $out;
			
			foreach($pages as $page)
			{
				//echo '<pre>'.print_r($page, TRUE).'</pre>';
				$out[] = array(
					'name'  => (trim($page->post_title))?$page->post_title : 'No title (ID: '.$page->ID.')', 
					'value' => $page->ID, 
				);
			}
			
			
			return $out;
		}
		

		// Output function
		function widget( $args, $data )
		{
			if(isset($data['page']) && trim($data['page']) && is_numeric($data['page']))
			{				
				$content = $this->get_page_content( $data['page'] );
				if($content) $data['shortcode'] = $content;
			}
			
			//echo '<pre>'.print_r($data['shortcode'], TRUE).'</pre>';die();
			
			// disable row count so shortcodes dont mess up the row numbering
			global $st_no_row_count;
			$st_no_row_count = true;
			
			?>
			<?php echo $before_widget; ?>
			<div class="cbt-shortcode-widget">
				<?php echo cbt_text_shortcodes_process(do_shortcode($data['shortcode'])); ?>
			</div>
			<?php echo $after_widget; ?>
			
			<?php
			
			// reactivate row count	
			$st_no_row_count = false;
		}


		function get_page_content($id)
		{
			$page = get_post($id);
			if(! $page) return false;
			
			// Get what tab (Classic - Pagebuilder) is active when Save content of this post
			$wr_page_active_tab = get_post_meta( $page->ID, '_wr_page_active_tab', true );
			
			$wr_deactivate_pb = get_post_meta( $page->ID, '_wr_deactivate_pb', true );
			
			$content = $page->post_content;
			
			$content = ST_Pb_Helper_Shortcode::get_builder_tab_content(
				$content, 
				$page,
				$wr_page_active_tab,
				$wr_deactivate_pb
			);

			
			// if not deactivate pagebuilder on this post/page then add its css etc
			if ( empty( $wr_deactivate_pb ) ) 
			{
	
				$custom_css_data = ST_Pb_Helper_Functions::custom_css_data( isset ( $page->ID ) ? $page->ID : NULL );
				extract( $custom_css_data );
	
				if($css_custom)
				{
					$css_custom = html_entity_decode( stripslashes( $css_custom ) );
	
					echo balanceTags( "<style id='wr-pb-custom-{$post->ID}-css'>\n$css_custom\n</style>\n" );
				}
			}

			if(! trim($content)) return false;
			
			return $content;
		}


	} // class

	// Register widget
	if ( ! function_exists( 'widget_cbt_shortcode' ) )
	{
		function widget_cbt_shortcode()
		{
			register_widget('widget_cbt_shortcode');
		}

		add_action( 'widgets_init', 'widget_cbt_shortcode', 1 );
	}
}