<?php
require_once ST_LIBRARY_PATH . '/plugins/embedded-plugins/woocommerce-quantity-increment/woocommerce-quantity-increment.php';

class cbt_woocommerce
{
	public static $show_header_cart = true;
	public static $pb_nav = false;

	function __construct()
	{
		if ( ! class_exists( 'WooCommerce' ) )
			return;

		WooCommerce_Quantity_Increment::get_instance();

		// ==== NAVIGATION CART
		add_filter( 'wp_nav_menu_items', array($this, 'navigation_cart'), 10, 2 );
		add_filter( 'woocommerce_add_to_cart_fragments', array($this, 'navigation_cart_fragment') );
		add_filter( 'st_woo_cart_mobile', array($this, 'navigation_cart_mobile'), 10, 2);

		// ==== PRODUCT LINK CLOSE
		// remove from end
		remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 10 );
		// move to after TITLE
		add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 98 );

		// ==== PRODUCT DETAILS CONTAINER
		add_action( 'woocommerce_after_shop_loop_item_title', array($this, 'shop_loop_item_details_container_open'), 1);
		add_action( 'woocommerce_after_shop_loop_item', array($this, 'shop_loop_item_details_container_close'), 99);


		// ===== PRODUCT SINGLE PAGE
		// move price range to buy area
		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
		add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 65);

		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
		add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 65);

		// wrapper for product info, excerpt
		add_action( 'woocommerce_single_product_summary', array($this, 'single_product_summary_info_container_open'), 1);
		add_action( 'woocommerce_single_product_summary', array($this, 'single_product_summary_info_container_close'), 63);

		// wrapper for add to cart, variation etc
		add_action( 'woocommerce_single_product_summary', array($this, 'single_product_summary_buy_area_container_open'), 64);
		add_action( 'woocommerce_single_product_summary', array($this, 'single_product_summary_buy_area_container_close'), 66);

		// wrapper for related items
		add_action( 'woocommerce_after_single_product_summary', array($this, 'single_product_summary_related_container_open'), 14);
		add_action( 'woocommerce_after_single_product_summary', array($this, 'single_product_summary_related_container_close'), 21);

		// wrapper buy area quantity input
		add_action( 'woocommerce_before_add_to_cart_quantity', array($this, 'single_product_summary_qty_container_open'), 14);
		add_action( 'woocommerce_after_add_to_cart_quantity', array($this, 'single_product_summary_qty_container_close'), 21);

		// reviews form
		add_filter('woocommerce_form_field_args',  array($this, 'wc_form_field_args'),10,3);
	}

	function wc_form_field_args($args, $key, $value) {
		$args['input_class'] = array( 'form-control' );
		return $args;
	}

	function navigation_cart_html()
	{
		$cart_instance = WC()->cart;
		$cart = '';
	    $count = $cart_instance->cart_contents_count;
	    $url = '#';

	    if($cart_instance)
	    	$url = $cart_instance->get_cart_url();

	    $cart .= '<a class="cart-contents" href="'.$url.'" title="'. __( 'View your shopping cart', 'cbt' ) .'">';
	    if ( $count > 0 ) {

	        $cart .= '<span class="cart-contents-count">'.esc_html( $count ).'</span>';

	    }
	    $cart .= '</a>';
		 
		return $cart;
	}

	function navigation_cart( $items, $args )
	{
		global $cbt_options;

		if(self::$pb_nav == true)
		{
			if(self::$show_header_cart == false )
				return $items;
		}
		else
		{
			if( $cbt_options['woo_header_cart'] == false
				OR $args->theme_location == 'footer-nav'  )
				return $items;
		}
		

		if ( is_cart() ) {
			$class = 'current-menu-item';
		} else {
			$class = '';
		}

		$items .= '<li class="menu-item menu-item-st-woo-cart '.$class.'">'.$this->navigation_cart_html().'</li>';
		return $items;
	}

	function navigation_cart_mobile($output, $echo = false)
	{
		global $cbt_options;

		if(self::$pb_nav == true)
		{
			if(self::$show_header_cart == false )
				return;
		}
		elseif( $cbt_options['woo_header_cart'] == false )
		{
			return;
		}

		$output .= '<span class="st-woo-cart-mobile">'.$this->navigation_cart_html().'</span>';
		if($echo)
		{
			echo $output;
		}
		return $output;
	}

	/**
	 * Ensure cart contents update when products are added to the cart via AJAX
	 */
	function navigation_cart_fragment( $fragments ) {
	 
	    $fragments['a.cart-contents'] = $this->navigation_cart_html();
	     
	    return $fragments;
	}

	function single_product_summary_qty_container_open()
	{
		?>
		<div class="st-woo-qty-input">
			<label><?php _e("Quantity", 'cbt'); ?>:</label>
		<?php
	}

	function single_product_summary_qty_container_close()
	{
		?>
		</div>
		<?php
	}


	function single_product_summary_related_container_open()
	{
		?>
		<div class="col-sm-12 st-woo-product-single-related-container">
		<?php
	}

	function single_product_summary_related_container_close()
	{
		?>
			<div class="clearfix"></div>
		</div>
		<?php
	}

	function single_product_summary_buy_area_container_open()
	{
		?>
		<div class="col-md-3">
			<div class="clearfix"></div>
			<div class="st-woo-product-single-buy-area">
		<?php
	}

	function single_product_summary_buy_area_container_close()
	{
		?>
			</div> <!-- .st-woo-product-single-buy-area -->
			<div class="clearfix"></div>
		</div>
		<?php
	}

	function single_product_summary_info_container_open()
	{
		?>
		<div class="col-sm-5 st-woo-product-single-info-container">
		<?php
	}

	function single_product_summary_info_container_close()
	{
		?>
			<div class="clearfix"></div>
		</div>
		<?php
	}

	function shop_loop_item_details_container_open()
	{
		?>
		<div class="woocommerce-product-details__container">
		<?php
	}

	function shop_loop_item_details_container_close()
	{
		?>
			<div class="clearfix"></div>
		</div>
		<?php
	}
	
	
	
}

global $cbt_woocommerce;
$cbt_woocommerce = new cbt_woocommerce();
