<?php
define('cb_theme_framework_dir', dirname( __FILE__ ));

require_once dirname( __FILE__ ) . '/includes/loader.php';
add_action( 'init', 'init_cbt_c_l', 10 );
function init_cbt_c_l()
{
	global $cbt_l;
	$cbt_l->do_c_l();
}

require_once cb_theme_framework_dir . '/includes/logo.php';
require_once cb_theme_framework_dir . '/includes/builder_api.php';
require_once cb_theme_framework_dir . '/includes/custom_template.php';
require_once cb_theme_framework_dir . '/includes/text_shortcodes.php';
require_once cb_theme_framework_dir . '/includes/update.php';
require_once cb_theme_framework_dir . '/includes/functions.php';
require_once cb_theme_framework_dir . '/install_plugins.php';
require_once cb_theme_framework_dir . '/includes/apis.php';
require_once cb_theme_framework_dir . '/includes/redux_compilers.php';
require_once cb_theme_framework_dir . '/includes/widget_contact.php';
require_once cb_theme_framework_dir . '/includes/widget_shortcode.php';
require_once cb_theme_framework_dir . '/includes/widget_newsletter.php';
require_once cb_theme_framework_dir . '/includes/menu_icons.php';
require_once cb_theme_framework_dir . '/includes/metaboxes.php';
require_once cb_theme_framework_dir . '/includes/colors.php';
require_once cb_theme_framework_dir . '/includes/bonus.php';
require_once cb_theme_framework_dir . '/demo_installer_config.php';
require_once cb_theme_framework_dir . '/includes/woocommerce.php';
require_once cb_theme_framework_dir . '/includes/pro.php';
require_once cb_theme_framework_dir . '/includes/comments.php';
require_once cb_theme_framework_dir . '/includes/template_exporter/export.php';

// ------------------------------------------------------
//  Admin messages handler
// ------------------------------------------------------
add_action( 'admin_notices', 'cbt_admin_notice_success' );
function cbt_admin_notice_success() 
{
	$type = 'error';
	$msg = '';
	if(isset($_GET['cbt_success']) && $_GET['cbt_success'])
	{
		$type = 'updated';
		$msg = $_GET['cbt_success'];
	}
	elseif(isset($_GET['cbt_error']) && $_GET['cbt_error'])
	{
		$type = 'error';
		$msg = $_GET['cbt_error'];
	}
	else
	{
		return;
	}
	
    ?>
    <div class="<?php echo $type; ?>">
        <p><?php echo urldecode($msg) ?></p>
    </div>
    <?php
}



// ------------------------------------------------------
//  Revolution slider version detect
// ------------------------------------------------------
add_action( 'admin_notices', 'cbt_revslider_version_notice' );
function cbt_revslider_version_notice()
{
	if(! isset($_GET['page']) OR $_GET['page']!='revslider') return;
	
	global $revSliderVersion;

	$revSliderVersion = '4.0.9';
	if(version_compare($revSliderVersion, '5.0.9', '<'))
	{
		$class = "update-nag";
		$message = '<b>Notice:</b> If you would like to use the latest version of Revolution Slider you can download it <a href="http://members.prostylertheme.com/revolution-slider-update/" target="_blank">here</a> and update manually. We have not bundled it due to its size.';
	    echo"<div class=\"$class\"> <p>$message</p></div>";
    }
}


// ------------------------------------------------------
//  Add video background
// ------------------------------------------------------
function cbt_video_background()
{
	global $cbt_options, $post; 
	
	// If not enabled, then skip
	if($cbt_options['video-background']=='no') return;
	
	if($cbt_options['video-background']=='library')
	{
		$cbt_options['video-background']='youtube';
		$cbt_options['video-background-youtube'] = $cbt_options['video-background-library'];
	}
	
	if($cbt_options['video-background']=='youtube' && trim($cbt_options['video-background-youtube']) && preg_match( '/youtube\.com/', $cbt_options['video-background-youtube'] ))
	{
		add_action( 'wp_footer', 'cbt_video_background_scripts' );
		add_action( 'wp_footer', 'cbt_video_background_script_init' );
		
		$url = trim($cbt_options['video-background-youtube']);
		
		parse_str( $url, $youtube_url );
	
		$data_attr = sprintf(
				"data-property=\"{videoURL:'http://youtu.be/%s', containment:'%s', autoPlay:%s, mute:true, startAt:0, opacity:1, showControls:false, gaTrack:false}\"",
				reset( $youtube_url ),
				"body",
				'true'
				);	
				
		$still = trim($cbt_options['video-background-still']);
		
		if($still)		
			echo '<div class="cbt_video_bg-still" style="position:fixed;top:0;bottom:0;left:0;right:0;z-index: -3;background: transparent url('.$still.') no-repeat top center; background-size: cover;"></div>';
		
		echo '<div class="cbt_video_bg" '.$data_attr.'></div>';
		
	}
	elseif($cbt_options['video-background']=='hosted')
	{
		wp_enqueue_script( 'Videojs-n-BigVideo-js' );
		wp_enqueue_style( 'BigVideo-css' );
		
		$video_mp4 = trim($cbt_options['video-background-hosted-mp4']);
		$video_webm = trim($cbt_options['video-background-hosted-webm']);
		
		if(! $video_mp4 && ! $video_webm) return;

		$still = trim($cbt_options['video-background-still']);
		
		?>
<script type="text/javascript">
jQuery(document).ready(function($)
{
    var BV = new $.BigVideo();
    BV.init();
	if (Modernizr.touch) 
	{
	    <?php if($still): ?>BV.show('<?php echo $still;?>');<?php endif;?>
	} else {
	    BV.show([
        <?php if($video_mp4): ?>{ type: "video/mp4",  src: "<?php echo $video_mp4;?>" }<?php endif;?><?php if($video_webm): ?>,{ type: "video/webm",  src: "<?php echo $video_webm;?>" }<?php endif;?>
		],{ambient:true});
	}

    
});
</script>
		<?php
	}
}

function cbt_video_background_scripts() 
{
	wp_enqueue_script( 'YTPlayer-js' );
	wp_enqueue_style( 'YTPlayer-css' );
}

function cbt_video_background_script_init() 
{
	echo ST_Pb_Helper_Functions::script_box("$('.cbt_video_bg').mb_YTPlayer();");
}


// ------------------------------------------------------
//  Video backgrounds library
// ------------------------------------------------------
function cbt_video_bgs_lib()
{
	$bgs = array();
	
	$bgs[ 'https://www.youtube.com/watch?v=8TKshbom_O0' ] = array(
		'alt' => '',
		'img' => 'http://videobgspst.s3.amazonaws.com/thumbs/1_0008_STILL-Beach.jpg',
	);
	
	$bgs[ 'https://www.youtube.com/watch?v=dnG5Fcerwy4' ] = array(
		'alt' => '',
		'img' => 'http://videobgspst.s3.amazonaws.com/thumbs/1_0000_STILL-city.jpg',
	);
	
	$bgs[ 'https://www.youtube.com/watch?v=UVVMMqy_Dpg' ] = array(
		'alt' => '',
		'img' => 'http://videobgspst.s3.amazonaws.com/thumbs/1_0001_STILL-globe.jpg',
	);
	
	$bgs[ 'https://www.youtube.com/watch?v=i8n-ZxQNMTU' ] = array(
		'alt' => '',
		'img' => 'http://videobgspst.s3.amazonaws.com/thumbs/1_0002_STILL-Molecule.jpg',
	);
	
	$bgs[ 'https://www.youtube.com/watch?v=Wp7LgaeDzN0' ] = array(
		'alt' => '',
		'img' => 'http://videobgspst.s3.amazonaws.com/thumbs/1_0003_STILL-Mountains.jpg',
	);
	
	$bgs[ 'https://www.youtube.com/watch?v=MydB3HgTjyY' ] = array(
		'alt' => '',
		'img' => 'http://videobgspst.s3.amazonaws.com/thumbs/1_0004_STILL-Park.jpg',
	);
	
	$bgs[ 'https://www.youtube.com/watch?v=Xt_TWHGyYUU' ] = array(
		'alt' => '',
		'img' => 'http://videobgspst.s3.amazonaws.com/thumbs/1_0005_STILL-Rain.jpg',
	);
	
	$bgs[ 'https://www.youtube.com/watch?v=m_rnhyi5ltw' ] = array(
		'alt' => '',
		'img' => 'http://videobgspst.s3.amazonaws.com/thumbs/1_0006_STILL-SNOW.jpg',
	);
	
	$bgs[ 'https://www.youtube.com/watch?v=ZzE9P1qDxXw' ] = array(
		'alt' => '',
		'img' => 'http://videobgspst.s3.amazonaws.com/thumbs/1_0007_STILL-Wave.jpg',
	);
	
	$bgs[ 'https://www.youtube.com/watch?v=VGv-uP8wct4' ] = array(
		'alt' => '',
		'img' => 'http://videobgspst.s3.amazonaws.com/thumbs/1_0009_Background.jpg',
	);
	
	
	return $bgs;
}


// ------------------------------------------------------
//  Centering oEmbed
// ------------------------------------------------------
add_filter('embed_oembed_html', 'cbt_center_oembed', 99, 4);
function cbt_center_oembed($html, $url, $attr, $post_id) {
  return '<div class="st_oembed" style="text-align: center;">' . $html . '</div>';
}


// ------------------------------------------------------
//  Adds custom colors to color pallete
// ------------------------------------------------------
add_action('admin_print_footer_scripts', 'cbt_colorpicker');
function cbt_colorpicker()
{
	global $cbt_options;
	
	?>
	<script>
	jQuery(document).ready(function($)
	{
		if(typeof $.wp !== 'undefined' && typeof $.wp.wpColorPicker !== 'undefined')
		{ 
			$.wp.wpColorPicker.prototype.options = {
				defaultColor: false,
				change: false,
				clear: false,
				hide: true,
				palettes: ['#fff', '#000', '<?php echo $cbt_options['content-bg'];?>', '<?php echo $cbt_options['nav-color'];?>', '<?php echo $cbt_options['color1'];?>', '<?php echo $cbt_options['color2'];?>']
			};  
		} 
	});     
	</script>
	
	<style>
.cbb-select2-color-default { background: #C5C5C5 !important; }
.cbb-select2-color-primary { background: <?php echo $cbt_options['color2'];?> !important; }
.cbb-select2-color-secondry { background: <?php echo $cbt_options['color1'];?> !important; }
.cbb-select2-color-blue { background: #377BB5 !important; }
.cbb-select2-color-success { background: #5FB760 !important; }
.cbb-select2-color-warning { background: #EFAC56 !important; }
.cbb-select2-color-danger { background: #D75452 !important; }
.cbb-select2-color-link { background: #fff !important; }
	</style>
	<?php
}



// ------------------------------------------------------
//  Add header style class to body
// ------------------------------------------------------
add_filter('body_class','cbx_body_class');
function cbx_body_class($classes) 
{
	global $cbt_options;
	
	if($cbt_options['boxed_layout'] == '1') $classes[] = 'boxed_layout';
	if($cbt_options['dark-mode'] == '1') $classes[] = 'dark-mode';
	if($cbt_options['nav-text-shadow-disable'] == '1') $classes[] = 'nav-no-text-shadow';
	if(isset($cbt_options['header-border-disable']) && $cbt_options['header-border-disable'] == '1') $classes[] = 'header-border-disable';

	$classes[] = 'header-style-'.$cbt_options['header-style'];
	
	if($cbt_options['header-style']=='4')
	{
		$classes[] = 'theme-shape-'.$cbt_options['header4-shape'];
		
		if($cbt_options['homepage-header-no-bg']=='1' && is_page_template( 'template-home.php' ))
		{
			$classes[] = 'header-no-bg';
		}
	}
	
	if($cbt_options['evo-mode']=='1') $classes[] = 'evo-mode';
	else $classes[] = 'prostyler-default-mode';
	
	return $classes;
}


// ------------------------------------------------------
//  Add admin global script and css
// ------------------------------------------------------
add_action( 'admin_enqueue_scripts', 'cbt_admin_css', 10 );
function cbt_admin_css() 
{
	wp_enqueue_style( 'cbt_admin_css', get_template_directory_uri() . '/library/admin/assets/css/global.css', false, '2.0' );
	
	wp_register_script('cbt_admin', get_template_directory_uri() . '/library/admin/assets/js/global.js', array('jquery'), '2.0' );
	wp_enqueue_script('cbt_admin');

    wp_localize_script(
        'cbt_admin',
        'cbt_admin_vars',
        array(
			'ajax_nonce'       => wp_create_nonce( ST_NONCE ),
			'ajaxurl'          => admin_url( '/admin-ajax.php' ),
        )
    );
}


// ------------------------------------------------------
//  NEX Forms bootstrap conflict fix
// ------------------------------------------------------
add_action( 'wp_print_scripts', 'cbt_nex_fix', 100 );
function cbt_nex_fix() {
	if(is_admin()) return;
	
    wp_deregister_script( 'nex-forms-bootstrap.min' );
	wp_deregister_style('nex-forms-bootstrap-ui');
}


