<?php

/**
ReduxFramework Config File
For full documentation, please visit: https://github.com/ReduxFramework/ReduxFramework/wiki
 **/

if (!class_exists("ReduxFramework")) {
	return;
}

if (!class_exists("Redux_Framework_prostyler_config")) {
	class Redux_Framework_prostyler_config {

		public $args = array();
		public $sections = array();
		public $theme;
		public $ReduxFramework;

		public function __construct() {

			// Just for demo purposes. Not needed per say.
			$this->theme = wp_get_theme();

			// Set the default arguments
			$this->setArguments();

			// Create the sections and fields
			$this->setSections();

			if (!isset($this->args['opt_name'])) {
				// No errors please
				return;
			}

			// ------------------------------------------------------
			//  Custom Extensions loader
			// ------------------------------------------------------
			require_once dirname(__FILE__) . '/admin/CBT_ext_loader.php';

			$this->ReduxFramework = new ReduxFramework($this->sections, $this->args);

		}

		public function setSections() {

			ob_start();
			?>
			<div class="tawkContainer">
				<div class="tawkdiv" style="background: #000;">
					<iframe width="100%" height="340" src="https://www.youtube.com/embed/3WHEtqX3ZC8" frameborder="0" allowfullscreen></iframe>
				</div>
				<div class="tawkdiv tawkText">
				<p class="tawkp">
					<?php _e('Get this totally <b>FREE</b> messaging app app that lets you monitor and chat with visitors on your websites.', 'cbt');?>
				</p>
					<a class="tawkbtn button button-primary button-green" target="_blank" href="http://blog.prostylertheme.com/Sign-Up/"><?php _e('Get free widget', 'cbt');?></a><BR>
				<p class="tawkp">
					<?php _e('It takes less than 30 seconds.', 'cbt');?>
				</p>
				</div>
			</div>

			<?php
			$tawkto_description = ob_get_contents();
			ob_end_clean();

			$patterns = array();
			if (is_admin()) {
				$patterns = cbt::scandir(get_stylesheet_directory() . '/library/images/patterns', array('png', 'gif', 'jpg'));
				foreach ($patterns as $pattern => $pattern_path) {
					$img = get_stylesheet_directory_uri() . '/library/images/patterns/' . $pattern;
					$patterns_out[$img] = array(
						'alt' => $pattern,
						'img' => $img,
					);
				}

				$patterns = $patterns_out;
			}

			// No upload image included
			$patterns_no_upload = $patterns;

			// Include upload image (little plus image)
			$upload_img = get_stylesheet_directory_uri() . '/library/admin/assets/images/upload.png';
			$patterns[$upload_img] = array(
				'alt' => 'Upload Image',
				'img' => $upload_img,
			);

			// ACTUAL DECLARATION OF SECTIONS
			$this->sections[] = array(
				'icon' => 'fa fa-cogs',
				'title' => __('General Settings', 'cbt'),
				'fields' => array(
					array(
						'id' => 'logo',
						'type' => 'media',
						'title' => __('Site logo', 'cbt'),
						'desc' => __('Upload your site logo.', 'cbt'),
						'subtitle' => __('Recommended height: 80px', 'cbt'),
						'default' => array(
							'url' => str_ireplace('http://', '//', get_template_directory_uri() . '/library/images/logo.png'),
						),
					),

					array(
						'id' => 'logo-max-height',
						'type' => 'spinner',
						'title' => __('Maximum logo height (px)', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => __('', 'cbt'),
						'default' => '80',
						'min' => '1',
						'step' => '1',
						'max' => '9999',
						'compiler' => true,
					),

					array(
						'id' => 'logo-text-color',
						'type' => 'color',
						'title' => __('No Logo Text Color', 'cbt'),
						'desc' => 'Sitename text color if no logo provided',
						'transparent' => false,
						'default' => '#FFF',
						'compiler' => true,
					),

					array(
						'id' => 'favicon',
						'type' => 'media',
						'title' => __('Favicon Upload', 'cbt'),
						'desc' => __('', 'cbt'),
						'subtitle' => __('Upload a 32px x 32px .png or .gif image that will be your favicon.'),
						'default' => array(
							'url' => get_template_directory_uri() . '/favicon.png',
						),
					),

					array(
						'id' => 'social-phone',
						'type' => 'text',
						//'required' => array('layout','equals','1'),
						'title' => __('Phone Number', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => 'Shown at the top, above header',
						'default' => '+22 35 141 125',
					),

					array(
						'id' => 'social-email',
						'type' => 'text',
						//'required' => array('layout','equals','1'),
						'title' => __('Email Address', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => 'Shown at the top, above header',
						'default' => 'mail@domain.com',
					),

					array(
						'id' => 'social-icons',
						'type' => 'social_profiles',
						'title' => 'Social Icons',
						'subtitle' => 'These are shown at the top bar above header, contact info widget and where ever short-tag {social icons} is used in pages or posts',
						'desc' => 'Note: you can change order by clicking and dragging on the icon',
					),

					array(
						'id' => 'social-rss',
						'type' => 'switch',
						'title' => __('Show RSS', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => 'Shown along with social icons at the top bar above header, contact info widget and where ever short-tag {social-icons} or {rss} is used in pages or posts',
						'default' => true,
					),

					array(
						'id' => 'google-analytics',
						'type' => 'textarea',
						'title' => __('Google Analytics (or any javascript)', 'cbt'),
						'subtitle' => __('For Google Analytics: Please enter in your google analytics tracking code here. <br/> Remember to include the <strong>entire script from google</strong>, if you just enter your tracking ID it won\'t work.', 'cbt'),
						'desc' => __('<b>IMPORTANT:</b> Make sure javascript includes &lt;script&gt;&lt;/script&gt; tags', 'cbt'),
					),

					array(
						'id' => 'custom-css',
						'type' => 'ace_editor',
						'mode' => 'css',
						'theme' => 'monokai',
						'title' => __('Custom CSS Code', 'cbt'),
						'subtitle' => __('If you have any custom CSS you would like added to the site, please enter it here.', 'cbt'),
						'default' => "",
						'desc' => 'Basic CSS as well as LESS is supported',
						'compiler' => true,
					),

				),
			);

			// TAWK.TO INTEGRATION SECTION
			$this->sections[] = array(
				'icon' => 'fa fa-comments',
				'class' => 'st-live-chat-section st-new-tag',
				'title' => __('Live Chat', 'cbt'),
				'desc' => $tawkto_description,
				'fields' => array(
					array(
						'id' => 'tawk_widget_code',
						'type' => 'textarea',
						'title' => __('Widget Code', 'cbt'),
						'desc' => __('Enter your widget Code', 'cbt'),
					),
					array(
						'id' => 'tawk_visibility_always_display',
						'type' => 'switch',
						'title' => __('Show widget on every page', 'cbt'),
						'default' => '1',
					),
					array(
						'id' => 'tawk_visibility_front_page',
						'type' => 'switch',
						'title' => __('Show on front page', 'cbt'),
						'required' => array('tawk_visibility_always_display', 'equals', '0'),
						'default' => '0',
					),
					array(
						'id' => 'tawk_visibility_category_pages',
						'type' => 'switch',
						'title' => __('Show on Category pages', 'cbt'),
						'required' => array('tawk_visibility_always_display', 'equals', '0'),
						'default' => '0',
					),
					array(
						'id' => 'tawk_visibility_tag_pages',
						'type' => 'switch',
						'title' => __('Show on Tag pages', 'cbt'),
						'required' => array('tawk_visibility_always_display', 'equals', '0'),
						'default' => '0',
					),
					array(
						'id' => 'tawk_visibility_single_post_page',
						'type' => 'switch',
						'title' => __('Show on Single Post Pages', 'cbt'),
						'required' => array('tawk_visibility_always_display', 'equals', '0'),
						'default' => '0',
					),
					array(
						'id' => 'tawk_visibility_exclude_pages',
						'type' => 'switch',
						'title' => __('Exclude Specific URL', 'cbt'),
						'required' => array('tawk_visibility_always_display', 'equals', '1'),
						'default' => '0',
					),
					array(
						'id' => 'tawk_visibility_excluded_pages',
						'type' => 'textarea',
						'title' => __('Excluded URL', 'cbt'),
						'required' => array('tawk_visibility_exclude_pages', 'equals', '1'),
						'desc' => __('Enter the url where you <b>do not</b> want the widget to display.<BR>Separate entries with comma(,).', 'cbt'),
					),
					array(
						'id' => 'tawk_visibility_include_pages',
						'type' => 'switch',
						'title' => __('Include Specific URL', 'cbt'),
						'required' => array('tawk_visibility_always_display', 'equals', '0'),
						'default' => '0',
					),
					array(
						'id' => 'tawk_visibility_included_pages',
						'type' => 'textarea',
						'title' => __('Included URL', 'cbt'),
						'required' => array('tawk_visibility_include_pages', 'equals', '1'),
						'desc' => __('Enter the url where you <b>want</b> the widget to display.<BR>Separate entries with comma(,).', 'cbt'),
					),
				),
			);

			$this->sections[] = array(
				'icon' => 'fa fa-th',
				'title' => __('Theme Presets', 'cbt'),
				'desc' => __('Quick presets to change the look of your website.', 'cbt'),
				'fields' => array(

					array(
						'id' => 'evo-mode',
						'type' => 'switch',
						'title' => __('Modern mode', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => 'Modern mode makes the design flat and minimal. Gradients and patterns will be removed from most of the design.',
						'default' => '1',
					),

					array(
						'id' => 'theme-presets',
						'type' => 'image_select',
						'presets' => true,
						'title' => __('Presets', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => __('', 'cbt'),
						'options' => array(
							'1' => array(
								'alt' => '2 Columns',
								'img' => get_template_directory_uri() . '/library/admin/assets/images/presets/1.png',
								'presets' => array(
									'footer_bg' => '#1A1F2F',
									'footer-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/cross.png',
									'footer-pattern-opacity' => 100,
									'sub-floor-color' => '#10131C',
									'info-box-bg' => '#121620',
									'info-box-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/cross.png',
									'info-box-text-color' => '#fff',
									'color2' => '#FF8A00',
									'color1' => '#10131C',
									'dark-mode' => '0',

									'boxed_layout' => '0',

									'header-style' => '1',
									'top-nav-color' => '#10131C',
									'top-nav-text-color' => '#d9d9d9',
									'disable-top-bar' => '0',
									'header2-bg' => '#121620',
									'header2-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/cross.png',
									'header2-pattern-opacity' => 100,
									'header2-text-color' => '#fff',
									'nav-color' => '#dcdcdc',
									'nav-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/pattern.png',
									'nav-pattern-opacity' => 100,
									'nav-opacity' => 30,
									'nav-text-color' => '#fff',
									'nav-hover-color' => '#FF8A00',
								),
							),

							'4' => array(
								'alt' => '2 Columns',
								'img' => get_template_directory_uri() . '/library/admin/assets/images/presets/4.png',
								'presets' => array(
									'footer_bg' => '#141414',
									'footer-pattern-url' => $upload_img,
									'footer-pattern-opacity' => 30,
									'sub-floor-color' => '#000000',
									'info-box-bg' => '#000000',
									'info-box-pattern-url' => $upload_img,
									'info-box-text-color' => '#fff',
									'color2' => '#00c9e0',
									'color1' => '#10131C', // mobile header bg color
									'dark-mode' => '1',

									'boxed_layout' => '1',
									'background-color' => '#1e1e1e',
									'background-pattern-url' => get_template_directory_uri() . '/library/images/patterns/3px-tile.png',

									'header-style' => '3',
									'top-nav-color' => '#00c9e0',
									'top-nav-text-color' => '#fff',
									'disable-top-bar' => '0',
									'header2-bg' => '#000000',
									'header2-pattern-url' => $upload_img,
									'header2-pattern-opacity' => 100,
									'header2-text-color' => '#fff',
									'nav-color' => '#000000',
									'nav-pattern-url' => $upload_img,
									'nav-pattern-opacity' => 100,
									'nav-opacity' => 100,
									'nav-text-color' => '#fff',
									'nav-hover-color' => '#00c9e0',
								),
							),

							'2' => array(
								'alt' => '2 Columns',
								'img' => get_template_directory_uri() . '/library/admin/assets/images/presets/2.png',
								'presets' => array(
									'footer_bg' => '#380101',
									'footer-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/pattern.png',
									'footer-pattern-opacity' => 30,
									'sub-floor-color' => '#121620',
									'info-box-bg' => '#121620',
									'info-box-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/cross.png',
									'info-box-text-color' => '#fff',
									'color2' => '#841616',
									'color1' => '#121620',
									'dark-mode' => '0',

									'boxed_layout' => '0',

									'header-style' => '2',
									'top-nav-color' => '#10131C',
									'top-nav-text-color' => '#d9d9d9',
									'disable-top-bar' => '0',
									'header2-bg' => '#841616',
									'header2-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/pattern.png',
									'header2-pattern-opacity' => 40,
									'header2-text-color' => '#fff',
									'nav-color' => '#050d1c',
									'nav-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/pattern.png',
									'nav-pattern-opacity' => 40,
									'nav-opacity' => 80,
									'nav-text-color' => '#fff',
									'nav-hover-color' => '#fff',
								),
							),

							'3' => array(
								'alt' => '2 Columns',
								'img' => get_template_directory_uri() . '/library/admin/assets/images/presets/3.png',
								'presets' => array(
									'footer_bg' => '#380101',
									'footer-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/pattern.png',
									'footer-pattern-opacity' => 30,
									'sub-floor-color' => '#121620',
									'info-box-bg' => '#2d1800',
									'info-box-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/cross.png',
									'info-box-text-color' => '#fff',
									'color2' => '#dd9933',
									'color1' => '#121620',
									'dark-mode' => '0',

									'boxed_layout' => '1',
									'background-color' => '#00304c',
									'background-pattern-url' => get_template_directory_uri() . '/library/images/pattern.png',

									'header-style' => '2',
									'top-nav-color' => '#10131C',
									'top-nav-text-color' => '#d9d9d9',
									'disable-top-bar' => '0',
									'header2-bg' => '#dd9933',
									'header2-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/nistri.png',
									'header2-pattern-opacity' => 40,
									'header2-text-color' => '#fff',
									'nav-color' => '#dd9933',
									'nav-pattern-url' => get_stylesheet_directory_uri() . '/library/images/patterns/nistri.png',
									'nav-pattern-opacity' => 40,
									'nav-opacity' => 80,
									'nav-text-color' => '#fff',
									'nav-hover-color' => '#002130',
								),
							),

						),
						'default' => '',
						'compiler' => true,
					),

				),
			);

			global $cbt_colors;
			$this->sections[] = array(
				'icon' => 'fa fa-star',
				'title' => __('Color schemes', 'cbt'),
				'desc' => __('', 'cbt'),
				'fields' => array(
					array(
						'id' => 'raw_new_info',
						'type' => 'raw',
						'content' => $cbt_colors->display(),
					),
				),
			);

			$this->sections[] = array(
				'icon' => 'fa fa-tint',
				'title' => __('Theme Colors', 'cbt'),
				'desc' => __('All accent color related options are listed here.', 'cbt'),
				'fields' => array(

					array(
						'id' => 'color2',
						'type' => 'color',
						'title' => __('Theme Primary Color', 'cbt'),
						'desc' => 'This color is applied on Default buttons, Header border, content colors etc',
						'transparent' => false,
						'default' => '#FF8A00',
						'compiler' => true,
					),

					array(
						'id' => 'color1',
						'type' => 'color',
						'title' => __('Theme Secondary Color', 'cbt'),
						'desc' => 'This color is applied on Mobile header background, Default buttons, content colors etc',
						'transparent' => false,
						'default' => '#00304c',
						'compiler' => true,
					),

					array(
						'id' => 'dark-mode',
						'type' => 'switch',
						'title' => __('Enable Dark Mode?', 'cbt'),
						'desc' => __('Changes content area to black with light text color and matching colors for elements', 'cbt'),
						'default' => '0',
						'compiler' => true,
					),

					array(
						'id' => 'content-bg',
						'type' => 'color',
						'title' => __('Content background color', 'cbt'),
						'desc' => 'Content area background color.',
						'transparent' => false,
						'default' => '#ffffff',
						'required' => array('dark-mode', 'equals', '0'),
						'compiler' => true,
					),

					array(
						'id' => 'content-bg-opacity',
						'type' => 'slider',
						'title' => __('Content background opacity', 'cbt'),
						'subtitle' => __('Select opacity for content background. Useful when used with video backgrounds', 'cbt'),
						'desc' => __('', 'cbt'),
						"default" => 100,
						"min" => 0,
						"step" => 10,
						"max" => 100,
						'display_value' => 'label',
						'compiler' => true,
						'required' => array('dark-mode', 'equals', '0'),
					),

					array(
						'id' => 'footer_bg',
						'type' => 'color',
						'title' => __('Footer background color', 'cbt'),
						'desc' => '',
						'transparent' => false,
						'default' => '#1A1F2F',
						'compiler' => true,
					),

					array(
						'id' => 'footer-pattern-url',
						'type' => 'image_select',
						'title' => __('Footer background', 'cbt'),
						'desc' => '',
						'default' => get_stylesheet_directory_uri() . '/library/images/patterns/cross.png',
						'class' => 'cbt-pattern-selector',
						'options' => $patterns,
						'tiles' => true,
						'compiler' => true,
						'required' => array('evo-mode', 'equals', '0'),
					),

					array(
						'id' => 'footer-pattern-url-alt',
						'type' => 'background',
						'title' => __('Footer custom background', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => __('', 'cbt'),
						'background-color' => false,
						'default' => array(
							'background-repeat' => 'repeat',
							'background-attachment' => 'scroll',
							'background-position' => 'center top',
							'background-size' => 'inherit',
						),
						'required' => array(
							array('footer-pattern-url', 'equals', $upload_img),
							array('evo-mode', 'equals', '0'),
						),
						'compiler' => true,
					),

					array(
						'id' => 'footer-pattern-opacity',
						'type' => 'slider',
						'title' => __('Footer background opacity', 'cbt'),
						'subtitle' => __('Select opacity for footer background texture.', 'cbt'),
						'desc' => __('', 'cbt'),
						"default" => 100,
						"min" => 0,
						"step" => 10,
						"max" => 100,
						'display_value' => 'label',
						'compiler' => true,
						'required' => array('evo-mode', 'equals', '0'),
					),

					array(
						'id' => 'sub-floor-color',
						'type' => 'color',
						'title' => __('Bottom footer bar background color', 'cbt'),
						'desc' => '',
						'transparent' => false,
						'default' => '#10131C',
						'compiler' => true,
					),

					array(
						'id' => 'info-box-bg',
						'type' => 'color',
						'title' => __('Slider Info box background', 'cbt'),
						'desc' => '',
						'transparent' => false,
						'default' => '#121620',
						'compiler' => true,
					),

					array(
						'id' => 'info-box-pattern-url',
						'type' => 'image_select',
						'title' => __('Slider Info box background', 'cbt'),
						'desc' => '',
						'default' => get_stylesheet_directory_uri() . '/library/images/patterns/cross.png',
						'class' => 'cbt-pattern-selector',
						'options' => $patterns,
						'tiles' => true,
						'compiler' => true,
						'required' => array('evo-mode', 'equals', '0'),
					),

					array(
						'id' => 'info-box-pattern-url-alt',
						'type' => 'background',
						'title' => __('Slider Info box custom background', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => __('', 'cbt'),
						'background-color' => false,
						'default' => array(
							'background-repeat' => 'repeat',
							'background-attachment' => 'scroll',
							'background-position' => 'center top',
							'background-size' => 'inherit',
						),
						'required' => array(
							array('info-box-pattern-url', 'equals', $upload_img),
							array('evo-mode', 'equals', '0'),
						),
						'compiler' => true,
					),

					array(
						'id' => 'info-box-pattern-opacity',
						'type' => 'slider',
						'title' => __('Slider Info box background opacity', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => __('', 'cbt'),
						"default" => 100,
						"min" => 0,
						"step" => 10,
						"max" => 100,
						'display_value' => 'label',
						'compiler' => true,
						'required' => array('evo-mode', 'equals', '0'),
					),

					array(
						'id' => 'info-box-text-color',
						'type' => 'color',
						'title' => __('Slider Info box text color', 'cbt'),
						'desc' => '',
						'transparent' => false,
						'default' => '#fff',
						'compiler' => true,
					),

				),
			);

			$this->sections[] = array(
				'icon' => 'edit',
				'icon_class' => 'fa fa-cube',
				'title' => __('Boxed Layout', 'cbt'),
				'desc' => __('All boxed layout related options are listed here.', 'cbt'),
				'fields' => array(
					array(
						'id' => 'boxed_layout',
						'type' => 'switch',
						'title' => __('Enable Boxed Layout throughout site?', 'cbt'),
						'desc' => __('', 'cbt'),
						'default' => '0',
						'compiler' => true,
					),

					array(
						'id' => 'background-pattern-url',
						'type' => 'image_select',
						'title' => __('Background', 'cbt'),
						'desc' => '',
						'default' => get_stylesheet_directory_uri() . '/library/images/patterns/pattern.png',
						'class' => 'cbt-pattern-selector',
						'options' => $patterns,
						'tiles' => true,
						'compiler' => true,
						//'required' => array('boxed_layout','equals', '1'),
					),

					array(
						'id' => 'custom-background',
						'type' => 'background',
						'title' => __('Custom background', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => __('', 'cbt'),
						'background-color' => false,
						'default' => array(
							'background-repeat' => 'repeat',
							'background-attachment' => 'scroll',
							'background-position' => 'center top',
							'background-size' => 'inherit',
						),
						'required' => array(
							//array('boxed_layout', 'equals', '1'),
							array('background-pattern-url', 'equals', $upload_img),
						),
						'compiler' => true,
					),

					array(
						'id' => 'video-background',
						'type' => 'select',
						'title' => __('Display Video Background', 'cbt'),
						'desc' => __('', 'cbt'),
						'options' => array(
							'no' => 'No',
							'library' => 'ProStyler Videos',
							'youtube' => 'Youtube',
							'hosted' => 'Direct Video',
						),
						'default' => 'no',
						'required' => array(
							array('background-pattern-url', 'equals', $upload_img),
						),
					),

					array(
						'id' => 'video-background-library',
						'type' => 'image_select',
						'title' => __('ProStyler Video backgrounds', 'cbt'),
						'subtitle' => __('These are pre-made, ready to go video backgrounds<br />You can download stills for these videos by clicking <a target="_blank" href="http://videobgspst.s3.amazonaws.com/thumbs/stills.zip">HERE</a>', 'cbt'),
						'desc' => __('', 'cbt'),
						'options' => cbt_video_bgs_lib(),
						'default' => '',
						'required' => array(
							array('video-background', 'equals', 'library'),
						),
					),

					array(
						'id' => 'video-background-youtube',
						'type' => 'text',
						//'required' => array('layout','equals','1'),
						'title' => __('Youtube Video URL', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => '',
						'default' => '',
						'required' => array(
							array('video-background', 'equals', 'youtube'),
						),
					),

					array(
						'id' => 'video-background-hosted-mp4',
						'type' => 'text',
						//'required' => array('layout','equals','1'),
						'title' => __('Video URL (MP4)', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => '',
						'default' => '',
						'required' => array(
							array('video-background', 'equals', 'hosted'),
						),
					),

					array(
						'id' => 'video-background-hosted-webm',
						'type' => 'text',
						//'required' => array('layout','equals','1'),
						'title' => __('Video URL (WebM)', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => '',
						'default' => '',
						'required' => array(
							array('video-background', 'equals', 'hosted'),
						),
					),

					array(
						'id' => 'video-background-still',
						'type' => 'media',
						//'required' => array('layout','equals','1'),
						'title' => __('Video Still Image', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => 'Used for mobile and browsers which dont support video',
						'default' => '',
						'required' => array(
							array('video-background', 'equals', array('hosted', 'youtube', 'library')),
						),
					),

					array(
						'id' => 'background-color',
						'type' => 'color',
						'title' => __('Background Color', 'cbt'),
						'desc' => 'If you would rather simply use a solid color for your background, select one here.',
						'default' => '#00304c',
						'transparent' => false,
						//'required' => array('boxed_layout','equals', '1'),
						'compiler' => true,
					),
				),
			);

			$this->sections[] = array(
				'icon' => 'fa fa-envelope-o',
				'title' => __('Contact Page', 'cbt'),
				'desc' => __('To convert an address into latitude & longitude please use <a target="_blank" href="http://www.latlong.net/convert-address-to-lat-long.html">this converter.</a><br />To edit contact information on footer, please go to <a href="' . admin_url('widgets.php') . '" target="_blank">widgets page</a> ', 'cbt'),

				'fields' => array(
					array(
						'id' => 'googlemaps-api',
						'type' => 'text',
						'title' => __('Google Maps API Key', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => '<a class="btn" target="_BLANK" href="https://developers.google.com/maps/documentation/javascript/get-api-key">Get your API Key</a>',
						'default' => 'AIzaSyDQuCppkBnlcYpVlz1mRciD3cwSjcNCh0E',
					),
					array(
						'id' => 'zoom-level',
						'type' => 'text',
						'title' => __('Default Map Zoom Level', 'cbt'),
						'desc' => __('Value should be between 1-18, 1 being the entire earth and 18 being right at street level.', 'cbt'),
						'validate' => 'numeric',
						'default' => '10',
					),
					array(
						'id' => 'enable-map-zoom',
						'type' => 'checkbox',
						'title' => __('Enable Map Zoom In/Out', 'cbt'),
						'desc' => __('Do you want users to be able to zoom in/out on the map?', 'cbt'),
						'default' => '0',
					),
					array(
						'id' => 'center-lat',
						'type' => 'text',
						'title' => __('Map Center Latitude', 'cbt'),
						'desc' => __('Please enter the latitude for the maps center point.', 'cbt'),
						'validate' => 'numeric',
						'default' => '51.508943',
					),
					array(
						'id' => 'center-lng',
						'type' => 'text',
						'title' => __('Map Center Longitude', 'cbt'),
						'desc' => __('Please enter the longitude for the maps center point.', 'cbt'),
						'validate' => 'numeric',
						'default' => '-0.125055',
					),

					array(
						'id' => 'use-marker-img',
						'type' => 'checkbox',
						'title' => __('Use Image for Markers', 'cbt'),
						'desc' => __('Do you want a custom image to be used for the map markers?', 'cbt'),
						'default' => '0',
					),
					array(
						'id' => 'marker-img',
						'type' => 'media',
						'title' => __('Marker Icon Upload', 'cbt'),
						'desc' => __('Please upload an image that will be used for all the markers on your map.', 'cbt'),
						'required' => array('use-marker-img', 'equals', '1'),
					),

					array(
						'id' => 'enable-map-animation',
						'type' => 'checkbox',
						'title' => __('Enable Marker Animation', 'cbt'),
						'desc' => __('This will cause your markers to do a quick bounce as they load in.', 'cbt'),
						'default' => '1',
					),
					array(
						'id' => 'map-point-1',
						'type' => 'switch',
						'title' => __('Location #1', 'cbt'),
						'desc' => __('Toggle location #1', 'cbt'),
						'switch' => true,
						'default' => '0',
					),
					array(
						'id' => 'latitude1',
						'type' => 'text',
						'title' => __('Latitude', 'cbt'),
						'desc' => __('Please enter the latitude for your first location.', 'cbt'),
						'validate' => 'numeric',
						'required' => array('map-point-1', 'equals', '1'),
					),
					array(
						'id' => 'longitude1',
						'type' => 'text',
						'title' => __('Longitude', 'cbt'),
						'desc' => __('Please enter the longitude for your first location.', 'cbt'),
						'validate' => 'numeric',
						'required' => array('map-point-1', 'equals', '1'),
					),
					array(
						'id' => 'map-info1',
						'type' => 'textarea',
						'title' => __('Map Infowindow Text', 'cbt'),
						'desc' => __('If you would like to display any text in an info window for your first location, please enter it here.', 'cbt'),
						'required' => array('map-point-1', 'equals', '1'),
					),

					array(
						'id' => 'map-point-2',
						'type' => 'switch',
						'title' => __('Location #2', 'cbt'),
						'desc' => __('Toggle location #2', 'cbt'),
						'switch' => true,
						'default' => '0',
					),
					array(
						'id' => 'latitude2',
						'type' => 'text',
						'title' => __('Latitude', 'cbt'),
						'desc' => __('Please enter the latitude for your first location.', 'cbt'),
						'validate' => 'numeric',
						'required' => array('map-point-2', 'equals', '1'),
					),
					array(
						'id' => 'longitude2',
						'type' => 'text',
						'title' => __('Longitude', 'cbt'),
						'desc' => __('Please enter the longitude for your first location.', 'cbt'),
						'validate' => 'numeric',
						'required' => array('map-point-2', 'equals', '1'),
					),
					array(
						'id' => 'map-info2',
						'type' => 'textarea',
						'title' => __('Map Infowindow Text', 'cbt'),
						'desc' => __('If you would like to display any text in an info window for your second location, please enter it here.', 'cbt'),
						'required' => array('map-point-2', 'equals', '1'),
					),

					array(
						'id' => 'map-point-3',
						'type' => 'switch',
						'title' => __('Location #3', 'cbt'),
						'desc' => __('Toggle location #3', 'cbt'),
						'switch' => true,
						'default' => '0',
					),
					array(
						'id' => 'latitude3',
						'type' => 'text',
						'title' => __('Latitude', 'cbt'),
						'desc' => __('Please enter the latitude for your first location.', 'cbt'),
						'validate' => 'numeric',
						'required' => array('map-point-3', 'equals', '1'),
					),
					array(
						'id' => 'longitude3',
						'type' => 'text',
						'title' => __('Longitude', 'cbt'),
						'desc' => __('Please enter the longitude for your first location.', 'cbt'),
						'validate' => 'numeric',
						'required' => array('map-point-3', 'equals', '1'),
					),
					array(
						'id' => 'map-info3',
						'type' => 'textarea',
						'title' => __('Map Infowindow Text', 'cbt'),
						'desc' => __('If you would like to display any text in an info window for your third location, please enter it here.', 'cbt'),
						'required' => array('map-point-3', 'equals', '1'),
					),

					array(
						'id' => 'map-greyscale',
						'type' => 'checkbox',
						'title' => __('Greyscale Color', 'cbt'),
						'desc' => __('Toggle a greyscale color scheme (will also unlock a custom color option)', 'cbt'),
						'default' => '0',
					),
					array(
						'id' => 'map-color',
						'type' => 'color',
						'title' => __('Map Extra Color', 'cbt'),
						'desc' => 'Use this to define a main color that will be used in combination with the greyscale option for your map',
						'default' => '',
						'transparent' => false,
						'required' => array('map-greyscale', 'equals', '1'),
					),

				),
			);

			$this->sections[] = array(
				'icon' => 'fa fa-file-text-o',
				'icon_class' => 'icon-large',
				'title' => __('Header', 'cbt'),
				'desc' => __('All Header related options are listed here.', 'cbt'),
				'fields' => array(

					array(
						'id' => 'header-style',
						'type' => 'image_select',
						'title' => __('Header layout style', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => __('', 'cbt'),
						'options' => array(
							'1' => array('alt' => 'Style 1', 'img' => get_template_directory_uri() . '/header-styles/style1.png'),
							'2' => array('alt' => 'Style 2', 'img' => get_template_directory_uri() . '/header-styles/style2.png'),
							'3' => array('alt' => 'Style 3', 'img' => get_template_directory_uri() . '/header-styles/style3.png'),
							'4' => array('alt' => 'Style 4', 'img' => get_template_directory_uri() . '/header-styles/style4.png'),
						),
						'default' => '4',
					),

					array(
						'id' => 'header4-shape',
						'type' => 'select',
						'title' => __('Header shape', 'cbt'),
						'desc' => '',
						'options' => array(
							"curve" => "Curve",
							"arrow" => "Arrow",
							"rectangle" => "Rectangle",
						),
						'default' => 'rectangle',
						'required' => array('header-style', 'equals', array('4')),
					),

					array(
						'id' => 'disable-top-bar',
						'type' => 'switch',
						'title' => __('Disable Top bar?', 'cbt'),
						'desc' => __('Hides the top most social and contact info bar', 'cbt'),
						'default' => '0',
						'required' => array('header-style', 'equals', array('1', '3', '4')),
					),

					array(
						'id' => 'top-bar-no-mobile-hide',
						'type' => 'switch',
						'title' => __('Show Top bar on mobile?', 'cbt'),
						'desc' => __('Shows the top bar on mobile and responsive view', 'cbt'),
						'default' => '0',
						'required' => array(
							array('disable-top-bar', 'equals', '0'),
						),
					),

					array(
						'id' => 'top-nav-color',
						'type' => 'color',
						'title' => __('Top bar background color', 'cbt'),
						'subtitle' => __('Background for the social bar which is displayed at the top', 'cbt'),
						'transparent' => false,
						'default' => '#10131C',
						'compiler' => true,
						'required' => array(
							array('header-style', 'equals', array('1', '3')),
							array('disable-top-bar', 'equals', '0'),
						),
					),

					array(
						'id' => 'top-nav-text-color',
						'type' => 'color',
						'title' => __('Top bar text color', 'cbt'),
						'subtitle' => __('Text color for the social bar which is displayed at the top', 'cbt'),
						'transparent' => false,
						'default' => '#d9d9d9',
						'compiler' => true,
						'required' => array(
							array('header-style', 'equals', array('1', '3')),
							array('disable-top-bar', 'equals', '0'),
						),
					),

					array(
						'id' => 'header2-bg',
						'type' => 'color',
						'title' => __('Header Background color', 'cbt'),
						'desc' => '',
						'default' => '#121620',
						'transparent' => false,
						'compiler' => true,
						'required' => array('header-style', 'equals', array('2', '3')),
					),

					array(
						'id' => 'header2-pattern-url',
						'type' => 'image_select',
						'title' => __('Header Background', 'cbt'),
						'desc' => '',
						'default' => get_stylesheet_directory_uri() . '/library/images/patterns/cross.png',
						'class' => 'cbt-pattern-selector',
						'options' => $patterns,
						'tiles' => true,
						'compiler' => true,
						'required' => array('header-style', 'equals', array('2', '3')),
					),

					array(
						'id' => 'header2-pattern-url-alt',
						'type' => 'background',
						'title' => __('Header custom background', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => __('', 'cbt'),
						'background-color' => false,
						'default' => array(
							'background-repeat' => 'repeat',
							'background-attachment' => 'scroll',
							'background-position' => 'center top',
							'background-size' => 'inherit',
						),
						'required' => array(
							array('header-style', 'equals', array('2', '3')),
							array('header2-pattern-url', 'equals', $upload_img),
						),
						'compiler' => true,
					),

					array(
						'id' => 'header2-pattern-opacity',
						'type' => 'slider',
						'title' => __('Header Background opacity', 'cbt'),
						'subtitle' => __('Select opacity for the background.', 'cbt'),
						'desc' => __('', 'cbt'),
						"default" => 100,
						"min" => 0,
						"step" => 10,
						"max" => 100,
						'display_value' => 'label',
						'compiler' => true,
						'required' => array('header-style', 'equals', array('2', '3')),
					),

					array(
						'id' => 'header2-text-color',
						'type' => 'color',
						'title' => __('Header Text color', 'cbt'),
						'desc' => '',
						'default' => '#fff',
						'transparent' => false,
						'compiler' => true,
						'required' => array('header-style', 'equals', array('2', '3')),
					),

					// ------------------------------------------------------
					//  header style 4
					// ------------------------------------------------------
					array(
						'id' => 'header4-bg',
						'type' => 'color',
						'title' => __('Header Background color', 'cbt'),
						'desc' => '',
						'default' => '#fff',
						'transparent' => false,
						'compiler' => true,
						'required' => array('header-style', 'equals', array('4')),
					),
					array(
						'id' => 'header4-text-color',
						'type' => 'color',
						'title' => __('Header Text color', 'cbt'),
						'desc' => '',
						'default' => '#A8A8A9',
						'transparent' => false,
						'compiler' => true,
						'required' => array('header-style', 'equals', array('4')),
					),

					array(
						'id' => 'homepage-header-no-bg',
						'type' => 'switch',
						'title' => __('No background header for homepage', 'cbt'),
						'desc' => __('Makes the header on homepage transparent. Works best with a slider on the first row', 'cbt'),
						'default' => '0',
						'required' => array('header-style', 'equals', array('4')),
					),

					array(
						'id' => 'header4-no-bg-text-color',
						'type' => 'color',
						'title' => __('Header Text color for no background', 'cbt'),
						'desc' => '',
						'default' => '#fff',
						'transparent' => false,
						'compiler' => true,
						'required' => array(
							array('header-style', 'equals', array('4')),
							array('homepage-header-no-bg', 'equals', '1'),
						),
					),

					array(
						'id' => 'section-navigation',
						'type' => 'section',
						'title' => __('Navigation', 'cbt'),
						'subtitle' => __('Navigation settings.', 'cbt'),
						'indent' => true,
					),

					array(
						'id' => 'nav-color',
						'type' => 'color',
						'title' => __('Background color', 'cbt'),
						'desc' => 'This color is also applied to dropdown menu background',
						'default' => '#dcdcdc',
						'transparent' => false,
						'compiler' => true,
						'required' => array('header-style', 'not', array('4')),
					),

					array(
						'id' => 'nav-pattern-url',
						'type' => 'image_select',
						'title' => __('Background', 'cbt'),
						'desc' => '',
						'default' => get_stylesheet_directory_uri() . '/library/images/patterns/pattern.png',
						'class' => 'cbt-pattern-selector',
						'options' => $patterns,
						'tiles' => true,
						'compiler' => true,
						'required' => array('header-style', 'not', array('4')),
					),

					array(
						'id' => 'nav-pattern-url-alt',
						'type' => 'background',
						'title' => __('Custom background', 'cbt'),
						'subtitle' => __('', 'cbt'),
						'desc' => __('', 'cbt'),
						'background-color' => false,
						'default' => array(
							'background-repeat' => 'repeat',
							'background-attachment' => 'scroll',
							'background-position' => 'center top',
							'background-size' => 'inherit',
						),
						'required' => array('nav-pattern-url', 'equals', $upload_img),
						'compiler' => true,
						'required' => array('header-style', 'not', array('4')),
					),

					array(
						'id' => 'nav-pattern-opacity',
						'type' => 'slider',
						'title' => __('Background opacity', 'cbt'),
						'subtitle' => __('Select opacity for the navigation background.', 'cbt'),
						'desc' => __('', 'cbt'),
						"default" => 100,
						"min" => 0,
						"step" => 10,
						"max" => 100,
						'display_value' => 'label',
						'compiler' => true,
						'required' => array('header-style', 'not', array('4')),
					),

					array(
						'id' => 'nav-opacity',
						'type' => 'slider',
						'title' => __('Navigation bar opacity', 'cbt'),
						'subtitle' => __('Select opacity for the navigation.', 'cbt'),
						'desc' => __('', 'cbt'),
						"default" => 30,
						"min" => 0,
						"step" => 10,
						"max" => 100,
						'display_value' => 'label',
						'compiler' => true,
						'required' => array('header-style', 'not', array('4')),
					),

					array(
						'id' => 'nav-text-color',
						'type' => 'color',
						'title' => __('Text color', 'cbt'),
						'desc' => 'This color is also applied to dropdown menu text',
						'default' => '#fff',
						'transparent' => false,
						'compiler' => true,
						'required' => array('header-style', 'not', array('4')),
					),

					array(
						'id' => 'nav-hover-color',
						'type' => 'color',
						'title' => __('Current item color', 'cbt'),
						'desc' => '',
						'default' => '#FF8A00',
						'transparent' => false,
						'compiler' => true,
					),

					array(
						'id' => 'nav-text-shadow-disable',
						'type' => 'switch',
						'title' => __('Disable Text Shadow?', 'cbt'),
						'desc' => __('', 'cbt'),
						'default' => '0',
						'required' => array('header-style', 'not', array('4')),
					),

					array(
						'id' => 'nav-sticky',
						'type' => 'switch',
						'title' => __('Stick navigation to the top when scrolling up?', 'cbt'),
						'desc' => __('This will display your navigation when you are scrolling back up. Providing quicker access to visitors', 'cbt'),
						'default' => '1',
					),

					array(
						'id' => 'section-end',
						'type' => 'section',
						'indent' => false,
					),

					array(
						'id' => 'section-navigation',
						'type' => 'section',
						'title' => __('Mobile Navigation', 'cbt'),
						'subtitle' => __('Navigation settings for mobile and responsive view.', 'cbt'),
						'indent' => true,
					),

					array(
						'id' => 'nav-mobile-color-v2',
						'type' => 'color',
						'title' => __('Background color', 'cbt'),
						'desc' => '',
						'default' => '#23282D',
						'transparent' => false,
						'compiler' => true,
					),

					array(
						'id' => 'nav-mobile-text-color-v2',
						'type' => 'color',
						'title' => __('Text color', 'cbt'),
						'desc' => '',
						'default' => '#fff',
						'transparent' => false,
						'compiler' => true,
					),

					array(
						'id' => 'nav-mobile-btn-color',
						'type' => 'color',
						'title' => __('Toggle button background color', 'cbt'),
						'desc' => '',
						'default' => '#FF8A00',
						'transparent' => false,
						'compiler' => true,
					),

					array(
						'id' => 'section-end',
						'type' => 'section',
						'indent' => false,
					),

					array(
						'id' => 'section-header-image',
						'type' => 'section',
						'title' => __('Background under header', 'cbt'),
						'subtitle' => __('This background is displayed below the header with parallax effect while scroll. Shown on pages not using Home page template', 'cbt'),
						'indent' => true,
					),

					array(
						'id' => 'page-heading-color',
						'type' => 'color',
						'title' => __('Page heading color', 'cbt'),
						'desc' => '',
						'default' => '#fff',
						'transparent' => false,
						'compiler' => true,
					),

					array(
						'id' => 'header_image',
						'type' => 'media',
						'title' => __('Background Image', 'cbt'),
						'desc' => __('Upload your header background image here', 'cbt'),
						'default' => array(
							'url' => get_template_directory_uri() . '/library/images/top.png',
						),
					),

					array(
						'id' => 'header-color',
						'type' => 'color',
						'title' => __('Background color', 'cbt'),
						'desc' => '',
						'default' => '#fff',
						'transparent' => false,
						'compiler' => true,
					),

					array(
						'id' => 'header-repeat',
						'type' => 'select',
						'title' => __('Background Repeat', 'cbt'),
						'desc' => 'Do you want the background image to repeat? (Turn on when using patterns)',
						'options' => array(
							"no-repeat" => "No-Repeat",
							"repeat" => "Repeat",
						),
						'compiler' => true,
						'default' => 'no-repeat',
					),

					array(
						'id' => 'header-cover',
						'type' => 'checkbox',
						'title' => __('Auto resize background image to fit area?', 'cbt'),
						'desc' => __('This will ensure your background image always fits no matter what size screen the user has. (Don\'t use with patterns)', 'cbt'),
						'default' => '1',
						'compiler' => true,
					),

					array(
						'id' => 'header-border-disable',
						'type' => 'switch',
						'title' => __('Remove border line?', 'cbt'),
						'desc' => __('', 'cbt'),
						'subtitle' => __('Removes the thin border from the bottom', 'cbt'),
						'default' => '0',
						'required' => array('header-style', 'not', array('4')),
					),

					array(
						'id' => 'section-end',
						'type' => 'section',
						'indent' => false,
					),

				),
			);

			$this->sections[] = array(
				'icon' => 'fa fa-file-text-o',
				'icon_class' => 'icon-large',
				'title' => __('Footer', 'cbt'),
				'desc' => __('All footer related options are listed here.', 'cbt'),
				'fields' => array(

					array(
						'id' => 'footer_columns',
						'type' => 'image_select',
						'title' => __('Footer Columns', 'cbt'),
						'subtitle' => __('Please select the number of columns you would like for your footer.', 'cbt'),
						'desc' => __('', 'cbt'),
						'options' => array(
							'2' => array('alt' => '2 Columns', 'img' => get_template_directory_uri() . '/library/admin/images/2col.png'),
							'3' => array('alt' => '3 Columns', 'img' => get_template_directory_uri() . '/library/admin/images/3col.png'),
							'4' => array('alt' => '4 Columns', 'img' => get_template_directory_uri() . '/library/admin/images/4col.png'),
						),
						'default' => '2',
					),

					array(
						'id' => 'footer-copyright-text',
						'type' => 'text',
						'title' => __('Footer Copyright Section Text', 'cbt'),
						'subtitle' => __('Please enter the copyright section text. e.g. All Rights Reserved, Company ltd.<br />You can use {YEAR} to show current year automatically', 'cbt'),
						'desc' => __('', 'cbt'),
					),

					array(
						'id' => 'disable-auto-copyright',
						'type' => 'checkbox',
						'title' => __('Disable Automatic Copyright', 'cbt'),
						'subtitle' => 'By default, your copyright section will say "&copy; {YEAR} {SITENAME}" before the additional text you add above in the Footer Copyright Section Text input - This option allows you to remove that.',
						'desc' => '',
					),

				),
			);

			$this->sections[] = array(
				'icon' => 'fa fa-font',
				'title' => __('Typography', 'cbt'),
				'desc' => __('Default Typography settings'),
				'fields' => array(
					array(
						'id' => 'opt-typography',
						'type' => 'typography',
						'title' => __('Typography', 'cbt'),
						'google' => true,

						'all_styles' => true,

						'font-backup' => false,
						'font-weight' => false,
						'font-style' => false,
						'line-height' => false,
						'subsets' => false,
						'font-size' => false,
						'color' => false,
						'text-align' => false,

						'output' => array('body'),
						'units' => 'px',
						'subtitle' => __('Default sitewide Font face.', 'cbt'),
						'default' => array(
							'font-family' => 'PT Sans Narrow',
							'google' => true,
							'font-style' => '',
						),
					),

					array(
						'id' => 'default-font-size',
						'title' => __('Content font size (px)', 'cbt'),
						'subtitle' => __('Min: 10px, Max: 30px, Default: 16.5px', 'cbt'),
						'desc' => __('Note: Font size set on WPGlow Builder elements is not affected', 'cbt'),
						'compiler' => true,
						'type' => 'slider',

						"default" => 16.5,
						"min" => 10,
						"step" => 0.5,
						"max" => 30,
						'resolution' => 0.1,
						'display_value' => 'text',
					),

					array(
						'id' => 'text-color',
						'type' => 'color',
						'title' => __('Default Font color', 'cbt'),
						'desc' => 'Default content area text color.',
						'transparent' => false,
						'default' => '#909090',
						'required' => array('dark-mode', 'equals', '0'),
						'compiler' => true,
					),

				),
			);

			// @TO-DO: Use redux data argument instead to help with performance
			// maybe with callback
			$posts_template_pages = array();
			$posts_template_pages[''] = 'Default (none)';

			$args = array(
				'sort_order' => 'ASC',
				'sort_column' => 'post_title',
				'number' => '',
				'post_type' => 'page',
				'post_status' => 'publish,private,draft',
			);
			foreach (get_pages($args) as $p) {
				$posts_template_pages[$p->post_name] = $p->post_title;
			}

			$this->sections[] = array(
				'icon' => 'fa fa-list-alt',
				'title' => __('Content Settings', 'cbt'),
				'desc' => __('Choose how certain content is displayed'),
				'fields' => array(
					array(
						'id' => 'breadcrumb',
						'type' => 'switch',
						'title' => __('Breadcrumbs', 'cbt'),
						'desc' => __('Turn breadcrumbs on or off (site-wide)', 'cbt'),
						'default' => 0,
					),

					array(
						'id' => 'section-content-titles',
						'type' => 'section',
						'title' => __('Index Page Titles', 'cbt'),
						'subtitle' => __('Hide titles for different index page types', 'cbt'),
						'indent' => true,
					),

					array(
						'id' => 'hide_title_category',
						'type' => 'switch',
						'title' => __('Hide Title for Category posts page', 'cbt'),
						'desc' => '',
						'default' => 0,
					),

					array(
						'id' => 'hide_title_tags',
						'type' => 'switch',
						'title' => __('Hide Title for Tag posts page', 'cbt'),
						'desc' => '',
						'default' => 0,
					),

					array(
						'id' => 'hide_title_author',
						'type' => 'switch',
						'title' => __('Hide Title for Author posts page', 'cbt'),
						'desc' => '',
						'default' => 0,
					),

					array(
						'id' => 'hide_title_archive',
						'type' => 'switch',
						'title' => __('Hide Title for Archive posts page', 'cbt'),
						'subtitle' => __('Daily, Monthly, Yearly', 'cbt'),
						'desc' => '',
						'default' => 0,
					),

					array(
						'id' => 'section-end',
						'type' => 'section',
						'indent' => false,
					),

					array(
						'id' => 'section-post-settings',
						'type' => 'section',
						'title' => __('Posts Settings', 'cbt'),
						'subtitle' => __('Settings related to posts in blog page and single view', 'cbt'),
						'indent' => true,
					),

					array(
						'id' => 'index_template',
						'type' => 'select',
						'title' => __('Index & Archive Template Page', 'cbt'),
						'desc' => __('Select page to act as a template for blog and archive pages<br /><i>Note: use Content element on the selected page to fill it with content automatically</i>', 'cbt'),
						'options' => $posts_template_pages,
						'default' => '',
					),

					array(
						'id' => 'posts_template',
						'type' => 'select',
						'title' => __('Posts Template Page', 'cbt'),
						'desc' => __('Select page to act as a template for posts<br /><i>Note: use Content element on the selected page to fill it with content automatically</i>', 'cbt'),
						'options' => $posts_template_pages,
						'default' => '',
					),

					array(
						'id' => 'author_profile',
						'type' => 'switch',
						'title' => __('Author Profiles', 'cbt'),
						'desc' => 'Display an author profile below a post in single view',
						'default' => 1,
					),
					array(
						'id' => 'featured',
						'type' => 'select',
						'title' => __('Display Featured Images on', 'cbt'),
						'desc' => __('Display featured images on blog for posts.', 'cbt'),
						'options' => array(
							'1' => 'Never',
							'2' => 'Always',
							'3' => 'Index only',
							'4' => 'Single post only',
							'5' => 'Archive only',
						),
						'default' => '2',
					),

					array(
						'id' => 'posts_hide_author',
						'type' => 'switch',
						'title' => __('Hide Author', 'cbt'),
						'desc' => '',
						'default' => 0,
					),

					array(
						'id' => 'posts_hide_date',
						'type' => 'switch',
						'title' => __('Hide Date', 'cbt'),
						'desc' => '',
						'default' => 0,
					),

					array(
						'id' => 'posts_hide_categories',
						'type' => 'switch',
						'title' => __('Hide Categories', 'cbt'),
						'desc' => '',
						'default' => 0,
					),

					array(
						'id' => 'posts_hide_tags',
						'type' => 'switch',
						'title' => __('Hide Tags', 'cbt'),
						'desc' => '',
						'default' => 0,
					),

					array(
						'id' => 'posts_hide_comments_count',
						'type' => 'switch',
						'title' => __('Hide Comments Count', 'cbt'),
						'desc' => '',
						'default' => 0,
					),

/*
array (
'id' => 'apply_to_archive',
'type' => 'switch',
'title' => __('Apply to Archive', 'cbt'),
'subtitle' => __('Apply above posts settings to Archive pages?', 'cbt'),
'desc' => '',
'default' => 0,
),
 */

					array(
						'id' => 'section-end',
						'type' => 'section',
						'indent' => false,
					),

					array(
						'id' => 'sidebars',
						'type' => 'multi_text',
						'title' => __('Custom Sidebars'),
						'add_text' => 'Add Sidebar',
						'show_empty' => false,
						'subtitle' => __('Add custom widgetised sidebars.'),
						'desc' => __('Click on the add button and define a custom name for your widget. The custom sidebars will appear on <a target="_blank" href="' . admin_url('widgets.php') . '">Widgets section</a> under appearance. These sidebars will also be selectable per page under the "Widgetised Sidebar Element"'),
					),

					array(
						'id' => '404_template',
						'type' => 'select',
						'title' => __('404 Template Page', 'cbt'),
						'desc' => __('Select page to act as a template for 404 error page<br />', 'cbt'),
						'options' => $posts_template_pages,
						'default' => '',
					),

					array(
						'id' => 'password_template',
						'type' => 'select',
						'title' => __('Password protected page Template', 'cbt'),
						'desc' => __('Select page to act as a template for pages, posts which are password protected<br />By default, page\'s or post\'s own template is used.', 'cbt'),
						'options' => $posts_template_pages,
						'default' => '',
					),

				),
			);

			if (class_exists('WooCommerce')) {
				$this->sections[] = array(
					'icon' => 'fa fa-font',
					'title' => __('Woocommerce', 'cbt'),
					'desc' => __('Woocommerce settings'),
					'fields' => array(

						array(
							'id' => 'woo_products_template',
							'type' => 'select',
							'title' => __('Products Template Page', 'cbt'),
							'desc' => __('Select page to act as a template for products<br /><i>Note: use Content element on the selected page to fill it with content automatically</i>', 'cbt'),
							'options' => $posts_template_pages,
							'default' => '',
						),

						array(
							'id' => 'woo_shop_template',
							'type' => 'select',
							'title' => __('Shop Template Page', 'cbt'),
							'desc' => __('Select page to act as a template for woocommerce shop, categories etc<br /><i>Note: use Content element on the selected page to fill it with content automatically</i>', 'cbt'),
							'options' => $posts_template_pages,
							'default' => '',
						),

						array(
							'id' => 'woo_header_cart',
							'type' => 'switch',
							'title' => __('Show Cart on Header', 'cbt'),
							'desc' => '',
							'default' => 1,
						),

						array(
							'id' => 'woo_product_alt_bg',
							'type' => 'color',
							'title' => __('Product page middle section color', 'cbt'),
							'desc' => 'Alternate background color for middle section.',
							'transparent' => true,
							'default' => '#fafafa',
							'required' => array('dark-mode', 'equals', '0'),
						),

						array(
							'id' => 'woo_product_alt_bg_dark',
							'type' => 'color',
							'title' => __('Product page middle section color', 'cbt'),
							'desc' => 'Alternate background color for middle section.',
							'transparent' => true,
							'default' => '#1D1D1D',
							'required' => array('dark-mode', 'equals', '1'),
						),

					),
				);
			}

			$this->sections[] = array(
				'icon' => 'fa fa-cubes',
				'title' => __('Page Builder', 'cbt'),
				'desc' => __('Page builder settings'),
				'fields' => array(

					array(
						'id' => 'builder_disabled_for',
						'type' => 'checkbox',
						'title' => __('Disable PageBuilder for', 'cbt'),
						'desc' => __('Check post types where you do not want ProStyler Builder to be activated', 'cbt'),
						'data' => 'callback',
						'args' => array('cbt_redux_callback_get_post_types'),
					),

					array(
						'id' => 'builder_cache',
						'type' => 'switch',
						'title' => __('Caching', 'cbt'),
						'desc' => __('Select "On" if you want to cache CSS and JS files of ProStyler Builder', 'cbt') . '
							<div class="st_clear_cache">
								<button class="button button-default"
									data-textchange="' . __('Done!', 'cbt') . '" id="st-pb-clear-cache">
									' . __('Clear cache', 'cbt') . '<i class="jsn-icon16 layout-loading jsn-icon-loading"></i>
								</button>
								<span class="hidden layout-message alert"></span>
							</div>
						',
						'default' => 1,
					),

					array(
						'id' => 'builder_disable_help_tab',
						'type' => 'switch',
						'title' => __('Disable help tab', 'cbt'),
						'desc' => __('Select "On" if you want to hide the Help tab from Elements window from ProStyler Builder', 'cbt'),
						'default' => 0,
					),

				),
			);

			$theme_info = '<div class="redux-framework-section-desc">';
			$theme_info .= '<p class="redux-framework-theme-data description theme-uri">' . __('<strong>Theme URL:</strong> ', 'cbt') . '<a href="' . $this->theme->get('ThemeURI') . '" target="_blank">' . $this->theme->get('ThemeURI') . '</a></p>';
			$theme_info .= '<p class="redux-framework-theme-data description theme-author">' . __('<strong>Author:</strong> ', 'cbt') . $this->theme->get('Author') . '</p>';
			$theme_info .= '<p class="redux-framework-theme-data description theme-version">' . __('<strong>Version:</strong> ', 'cbt') . $this->theme->get('Version') . '</p>';
			$theme_info .= '<p class="redux-framework-theme-data description theme-description">' . $this->theme->get('Description') . '</p>';
			$tabs = $this->theme->get('Tags');
			if (!empty($tabs)) {
				$theme_info .= '<p class="redux-framework-theme-data description theme-tags">' . __('<strong>Tags:</strong> ', 'cbt') . implode(', ', $tabs) . '</p>';
			}
			$theme_info .= '</div>';

			$this->sections[] = array(
				'icon' => 'fa fa-key',
				'title' => __('License', 'cbt'),
				'desc' => __('', 'cbt'),
				'fields' => array(

					array(
						'id' => 'cbt_license_input',
						'type' => 'raw',
						'title' => __('License key', 'cbt'),
						'align' => true,
						'content' => '<input type="text" id="cbt_license_key" name="cbt_license-key" value="' . trim(get_option('cbt_license_key')) . '" class="regular-text">',
					),

					array(
						'id' => 'cbt_license_button',
						'type' => 'raw',
						'content' => '<br /><button class="button-primary" id="cbt-activate-license">Activate</button>',
					),

				),

			);

			$pro_fields = array();
			if (get_option('cbt_pro_upgrade') == 'yes') {

				$pro_fields[] = array(
					'id' => 'unbranded-mode',
					'type' => 'switch',
					'title' => __('Unbranded Mode', 'cbt'),
					'subtitle' => __('', 'cbt'),
					'desc' => 'Removes theme branding from Admin area.
				    <p>The following will be affected in Admin panel:<ol>
				    	<li>Theme logos will be removed</li>
				    	<li>Theme will be hidden from Appearance > Themes</li>
				    	<li>Pagebuilder about us page will be hidden</li>
				    	<li>Help tab in Pagebuilder elements settings will be hidden</li>
				    	<li>Any other branding information and links of the theme will be removed</li>
				    </ol></p>
				    <i>Note: You will still need to change site logo from General settings if you are using the default theme branded logo</i>',
					'default' => '0',
				);

				$pro_fields[] = array(
					'id' => 'lock-options-panel',
					'type' => 'switch',
					'title' => __('Lock Options panel', 'cbt'),
					'subtitle' => __('', 'cbt'),
					'desc' => 'Lock theme options panel with password. <b>Highly recommended when Unbranded mode is on</b>',
					'default' => '0',
					'required' => array(
						array('unbranded-mode', 'equals', '1'),
					),
				);

				$pro_fields[] = array(
					'id' => 'options-panel-password',
					'type' => 'text',
					'title' => __('Options Panel Password', 'cbt'),
					'subtitle' => __('', 'cbt'),
					'desc' => 'This password will be used to unlock options panel<br /><br /><b>Remember to make a note of this password. If you lose it, you will not be able to access the options panel</b>',
					'default' => '',
					'required' => array(
						array('unbranded-mode', 'equals', '1'),
						array('lock-options-panel', 'equals', '1'),
					),
				);

				$pro_fields[] = array(
					'id' => 'cbt_pro_other',
					'type' => 'raw',
					'content' => 'Pro Upgrade also includes Color Schemes which can be found in its own Tab on the sidebar (3rd tab from the top).',
				);

			} else {
				$pro_fields[] = array(
					'id' => 'cbt_no_pro',
					'type' => 'raw',
					'content' => 'Your license does not include Pro Upgrade. <br />If you do, then please make sure your license key is correct and click on activate again.',
				);
			}

			$this->sections[] = array(
				'icon' => 'fa fa-trophy',
				'title' => __('Pro Upgrade', 'cbt'),
				'desc' => __('', 'cbt'),
				'fields' => $pro_fields,

			);


			$impExp_fields = array();
			$impExp_fields[] = array(
                    'id' => 'redux_import_export',
                    'type'=> 'import_export',
                    'title' => '',
                    'full_width'    => false,
                );

			$impExp_fields[] = array(
					'title' => '<br />Settings not showing after updating theme?',
					'subtitle' => __('Regenerating theme stylesheet can often fix such issues', 'cbt'),
					'id' => 'cbt_btn_regenerate_css',
					'type' => 'raw',
					'content' => '<br /><a href="' . admin_url() . 'admin.php?page=cbt_options&tab=0&cbt_action=force_regenerate_css" class="button-secondary">Force regenerate stylesheet</a>',
				);

			$impExp_fields[] = array(
					'title' => 'Upgrade old ProStyler (earlier than 4.00) content to ProStyler Revelation',
					'subtitle' => __('This will convert all your site data from older versions of ProStyler to ProStyler Rev', 'cbt'),
					'id' => 'cbt_btn_upgrader',
					'type' => 'raw',
					'content' => '<br /><button class="button-secondary cbt_btn_ajax" id="cbt-btn-upgrader" data-ajax-action="cbt_upgrade_content_prostylerRev" data-msg="This process can take few minutes.'."\n\n".'It is highly recommended to make a backup before proceeding.'."\n\n".'Continue?">Convert Content to ProStyler Rev</button>',
				);

			if (isset($_GET['st_exporter']) && $_GET['st_exporter']) {
				$impExp_fields[] = array(
						'title' => 'Templates',
						'id' => 'cbt_template_import_export',
						'type' => 'raw',
						'content' => '<script src="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.2.1/jstree.min.js"></script><button class="button-secondary cbt_btn_ajax" data-ajax-action="cbt_export_template" id="cbt-btn-template-export">Export as Template</button>',
					);
			}


            $this->sections[] = array(
            	'icon' => 'fa fa-wrench',
                'id' => 'import/export',
                'title' => __( 'Tools', 'redux-framework' ),
                'heading' => __( 'Import/Export & Tools for common issues', 'redux-framework' ),
                'customizer' => false,
                'fields' => $impExp_fields,
            );

			if (file_exists(trailingslashit(dirname(__FILE__)) . 'README.html')) {
				$tabs['docs'] = array(
					'icon' => 'fa fa-book',
					'title' => __('Documentation', 'cbt'),
					'content' => nl2br(file_get_contents(trailingslashit(dirname(__FILE__)) . 'README.html')),
				);
			}

		}

		/**

		All the possible arguments for Redux.
		For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments

		 **/
		public function setArguments() {

			$theme = wp_get_theme(); // For use with some settings. Not necessary.

			$this->args = array(

				// TYPICAL -> Change these values as you need/desire
				'opt_name' => 'cbt_options', // This is where your data is stored in the database and also becomes your global variable name.
				'display_name' => cbt_logo(false), // $theme->get('Name'), // Name that appears at the top of your panel
				'display_version' => $theme->get('Version'), // Version that appears at the top of your panel
				'menu_type' => 'menu', //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
				'allow_sub_menu' => true, // Show the sections below the admin menu item or not
				'menu_title' => __('ProStyler Rev', 'cbt'),
				'page' => __('ProStyler', 'cbt'),
				'google_api_key' => 'AIzaSyDP2if2NMecLO-ouf3k41rZnFlc3mK097c', // Must be defined to add google fonts to the typography module
				'global_variable' => '', // Set a different name for your global variable other than the opt_name
				'dev_mode' => (defined('ST_WP_DEBUG') && true === ST_WP_DEBUG) ? false : false, // Show the time the page took to load, etc
				'system_info' => false, // REMOVE
				'customizer' => false, // Enable basic customizer support
				//'ajax_save' => true,

				// OPTIONAL -> Give you extra features
				'page_priority' => null, // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
				'page_parent' => 'themes.php', // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
				'page_permissions' => 'manage_options', // Permissions needed to access the options panel.
				'menu_icon' => get_template_directory_uri() . '/library/admin/assets/images/icon.png', // Specify a custom URL to an icon
				'last_tab' => '', // Force your panel to always open to a specific tab (by id)
				'page_icon' => 'fa fa-bell-o', // Icon displayed in the admin panel next to your menu_title
				'page_slug' => 'cbt_options', // Page slug used to denote the panel
				'save_defaults' => true, // On load save the defaults to DB before user clicks save or not
				'default_show' => false, // If true, shows the default value next to each field that is not the default value.
				'default_mark' => '', // What to print by the field's title if the value shown is default. Suggested: *

				// CAREFUL -> These options are for advanced use only
				'transient_time' => 60 * MINUTE_IN_SECONDS,
				'output' => true, // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
				'output_tab' => true, // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
				//'domain'             	=> 'redux-framework', // Translation domain key. Don't change this unless you want to retranslate all of Redux.
				'footer_credit' => ' ', // Disable the footer credit of Redux. Please leave if you can help it.

				// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
				'database' => '', // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

				'show_import_export' => false, // REMOVE
				'import_icon' => ' fa fa-floppy-o',

				'help_tabs' => array(),
				'help_sidebar' => '', // __( '', $this->args['domain'] );
				'disable_tracking' => true,
				'allow_tracking' => false,

				'templates_path' => dirname(__FILE__) . '/cbt_framework/redux_templates/',
			);


			// SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
			$this->args['share_icons'][] = array(
				'url' => 'https://www.facebook.com/groups/1550202071895924',
				'title' => 'ProStyler Facebook Group',
				'icon' => 'fa fa-facebook-square',
				// 'img' => '', // You can use icon OR img. IMG needs to be a full URL.
			);
			$this->args['share_icons'][] = array(
				'url' => 'http://members.prostylertheme.com',
				'title' => 'ProStyler Members site',
				'icon' => 'fa fa-globe',
			);

			// Panel Intro text -> before the form

			$this->args['intro_text'] = __('<p>Welcome to ProStyler options panel</p>', 'cbt');

			// Add content after the form.
			$this->args['footer_text'] = __('<p class="cbt-branding-remove">Theme developed and powered by <a href="http://www.prostylertheme.com" target="_blank">ProStyler</a></p>', 'cbt');

		}

	}

	global $cbt_redux;

	$cbt_redux = new Redux_Framework_prostyler_config();

}

function cbt_newIconFont() {
	// Uncomment this to remove elusive icon from the panel completely
	wp_deregister_style('redux-elusive-icon');
	wp_deregister_style('redux-elusive-icon-ie7');

	wp_register_style(
		'redux-font-awesome',
		'//maxcdn.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css',
		array(),
		time(),
		'all'
	);
	wp_enqueue_style('redux-font-awesome');
}
// This example assumes the opt_name is set to redux_demo.  Please replace it with your opt_name value.
add_action('redux/page/cbt_options/enqueue', 'cbt_newIconFont');

function cbt_tawksection_css() {
	wp_enqueue_style('tawk_cbt_admin_css', get_template_directory_uri() . '/library/admin/assets/css/tawk.css', false, '2.0');
}
add_action('redux/page/cbt_options/enqueue', 'cbt_tawksection_css', 10);

function cbt_redux_removeDemoModeLink() {
	// Be sure to rename this function to something more unique
	if (class_exists('ReduxFrameworkPlugin')) {
		remove_filter('plugin_row_meta', array(ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2);
	}
	if (class_exists('ReduxFrameworkPlugin')) {
		remove_action('admin_notices', array(ReduxFrameworkPlugin::get_instance(), 'admin_notices'));
	}
}
add_action('init', 'cbt_redux_removeDemoModeLink');
