<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "redux_moto";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'redux_demo/redux_moto', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */ 

    $sampleHTML = '';
    if ( file_exists( get_template_directory() . '/admin/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( get_template_directory() . '/admin/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();

    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'MOTO Options', 'moto' ),
        'page_title'           => __( 'MOTO Options', 'moto' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => false,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => 'dashicons-screenoptions',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $args['admin_bar_links'][] = array(
        'id'    => 'redux-docs',
        'href'  => 'http://docs.reduxframework.com/',
        'title' => __( 'Documentation', 'moto' ),
    );

    $args['admin_bar_links'][] = array(
        //'id'    => 'redux-support',
        'href'  => 'https://github.com/ReduxFramework/redux-framework/issues',
        'title' => __( 'Support', 'moto' ),
    );

    $args['admin_bar_links'][] = array(
        'id'    => 'redux-extensions',
        'href'  => 'reduxframework.com/extensions',
        'title' => __( 'Extensions', 'moto' ),
    );

    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
    $args['share_icons'][] = array(
        'url'   => 'https://github.com/ReduxFramework/ReduxFramework',
        'title' => 'Visit us on GitHub',
        'icon'  => 'el el-github'
        //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/pages/Redux-Framework/243141545850368',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://twitter.com/reduxframework',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://www.linkedin.com/company/redux-framework',
        'title' => 'Find us on LinkedIn',
        'icon'  => 'el el-linkedin'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        //$args['intro_text'] = sprintf( __( '<p>Did you know that Redux sets a global variable for you? To access any of your saved options from within your code you can use your global variable: <strong>$%1$s</strong></p>', 'moto' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'moto' );
    }

    // Add content after the form.
    

    Redux::setArgs( $opt_name, $args );

    /* 
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'moto' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'moto' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'moto' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'moto' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'moto' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

    // -> START Basic Fields
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'General Settings', 'moto' ),
        'id'               => 'moto_general_setting',
        'desc'             => esc_html__( 'This is theme comman setting.', 'moto' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-home'
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Header Setting', 'moto' ),
        'id'               => 'moto_header_g',
        'subsection'       => true,
        'customizer_width' => '450px',       
        'fields'           => array(
			array(
                'id'       => 'logo-type',
                'type'     => 'switch',
                'title'    => __( 'Choose Logo Type.', 'moto' ),
                'subtitle' => __( '', 'moto' ),
                'default'  => 1,
                'on'       => 'Image',
                'off'      => 'SVG Code',
              ),
			array(
				'id'        => 'moto_weblogo',
				'type'      => 'media',
				'required'  => array('logo-type', 'equals', 1),
				'title'     => esc_html__('Website Logo', 'moto'),				
				'subtitle'  => esc_html__('Upload your logo image.', 'moto'),
			),
			array( 
					'id'       => 'moto_svglogo',
					'type'     => 'textarea',
					'required'  => array('logo-type', 'equals', 0),
					'title'    => __('Enter SVG Code For Logo.', 'moto'),
					'subtitle' => __('', 'moto'),
				),
			array(
				'id'        => 'moto_menu_searchicon',
				'type'      => 'switch',
				'title'     => esc_html__('Search Icon', 'moto'),
				'subtitle'  => esc_html__('show/hide search icon in menu', 'moto'),
				'default'   => true,
			),
			array(
				'id'        => 'moto_preheader',
				'type'      => 'switch',
				'title'     => esc_html__('MOTO Preheader', 'moto'),
				'subtitle'  => esc_html__('show/hide preheader', 'moto'),
				'desc'	  	=> esc_html__(''),
				'default'   => false,
			),
			array(
				'id'        => 'moto_preheader_style',
				'type'      => 'select',
				'required'  => array('moto_preheader', 'equals', 1),
				'title'     => esc_html__('Preheader Style', 'moto'),				
				'subtitle'  => esc_html__('Slect Appropriate Preheader Style', 'moto'),
				'options'  => array(
					'1' => 'Style 1',
					'2' => 'Style 2',
					'3' => 'Style 3'
				),
				'default'  => '1',
			),
			array(
				'id'       => 'header-style',
				'type'     => 'select',
				'title'    => __('Select Header Style', 'moto'), 
				'subtitle' => __('', 'moto'),
				'desc'     => __('Header style 2 and 3 can only be used on front page.For this go to the setting > reading > and set front page.', 'moto'),
				'options'  => array(
					'1' => 'Style 1',
					'2' => 'Style 2',
					'3' => 'Style 3',
					'4' => 'Style 4',
					'5' => 'Style 5',
					'6' => 'Style 6',
					'7' => 'Style 7'
				),
				'default'  => '1',
			),
			array(
				'id'        => 'moto_header_address',
				'type'      => 'textarea',
				'required'  => array('header-style', 'equals', 5),
				'title'     => esc_html__('Address', 'moto'),
				'subtitle'  => esc_html__('This will work only Header style 5.', 'moto'),
				'default'	=> esc_html__('Avenue Cuba, North America','moto')
			),
			array(
				'id'        => 'moto_sticky_header',
				'type'      => 'switch',
				'title'     => esc_html__('Sticky Header', 'moto'),
				'subtitle'  => esc_html__('Enable/Desable Sticky Header', 'moto'),
				'desc'	  	=> esc_html__('Enable option will fix the header on scroll down.'),
				'default'   => true,
			),
			array(
				'id'        => 'sticky_hdback',
				'type'      => 'color_rgba',
				'title'     => 'Set Sticky Header Background Color',
				'subtitle'  => '',
				'desc'      => '',
				'required'  => array('moto_sticky_header', 'equals', 1),
				'options'       => array(
					'show_input'                => true,
					'show_initial'              => true,
					'allow_empty'               => true,
					'clickout_fires_change'     => false,
					'choose_text'               => 'Choose',
					'cancel_text'               => 'Cancel',
					'show_buttons'              => true,
					'use_extended_classes'      => true,
					'palette'                   => null,  // show default
					'input_text'                => 'Select Color'
				),                        
			),
			array(
				'id'        => 'moto_nav_background',
				'type'      => 'media',
				'title'     => esc_html__('Background Image', 'moto'),				
				'subtitle'  => esc_html__('Upload background image for navigation menu.', 'moto'),
				'desc'	  	=> esc_html__('Background image will not work for header styele 2 and header style 6.')
			),
			array(
				'id'        => 'moto_menu_back_switch',
				'type'      => 'switch',
				'title'     => esc_html__('Background Image Switch', 'moto'),
				'subtitle'  => esc_html__('show.hide background image in the menu.', 'moto'),
				'default'   => false,
			),
			
		)
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Sidebar Postion', 'moto' ),
        'id'               => 'moto_sidebar',
        'subsection'       => true,
        'customizer_width' => '450px',
        'desc'             => '',
        'fields'           => array(
			array(
				'id'        => 'moto_sidebarposition',
				'type'      => 'image_select',
				'compiler'  => true,
				'title'     => esc_html__('Theme Sidebar Position', 'moto'),
				'subtitle'  => esc_html__('Select main content and sidebar alignment. Choose between 1, 2 or 3 column layout.', 'moto'),
				'options'   => array(
					'full' => array('alt' => '1 Column',       'img' => ReduxFramework::$_url . 'assets/img/1col.png'),
					'left' => array('alt' => '2 Column Left',  'img' => ReduxFramework::$_url . 'assets/img/2cl.png'),
					'right' => array('alt' => '2 Column Right', 'img' => ReduxFramework::$_url . 'assets/img/2cr.png'),
				),
				'default'   => 'right'
			),
			array(
				'id'        => 'moto_archive_sidebarposition',
				'type'      => 'image_select',
				'compiler'  => true,
				'title'     => esc_html__('Archive Sidebar Position', 'moto'),
				'subtitle'  => esc_html__('Select main content and sidebar alignment. Choose between 1, 2 or 3 column layout.', 'moto'),
				'options'   => array(
					'full' => array('alt' => '1 Column',       'img' => ReduxFramework::$_url . 'assets/img/1col.png'),
					'left' => array('alt' => '2 Column Left',  'img' => ReduxFramework::$_url . 'assets/img/2cl.png'),
					'right' => array('alt' => '2 Column Right', 'img' => ReduxFramework::$_url . 'assets/img/2cr.png'),
				),
				'default'   => 'right'
			),
			array(
				'id'        => 'moto_search_sidebarposition',
				'type'      => 'image_select',
				'compiler'  => true,
				'title'     => esc_html__('Search Sidebar Position', 'moto'),
				'subtitle'  => esc_html__('Select main content and sidebar alignment. Choose between 1, 2 or 3 column layout.', 'moto'),
				'options'   => array(
					'full' => array('alt' => '1 Column',       'img' => ReduxFramework::$_url . 'assets/img/1col.png'),
					'left' => array('alt' => '2 Column Left',  'img' => ReduxFramework::$_url . 'assets/img/2cl.png'),
					'right' => array('alt' => '2 Column Right', 'img' => ReduxFramework::$_url . 'assets/img/2cr.png'),
				),
				'default'   => 'right'
			),
			
		)
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Page', 'moto' ),
        'id'               => 'moto_page',
        'subsection'       => true,
        'customizer_width' => '450px',       
        'fields'           => array(
			array(
				'id'        => 'moto_blog_content',
				'type'      => 'select',
				'title'     => esc_html__('Content In Blog Template', 'moto'),				
				'options'	=> array('full'=>'full content','short'=>'summary'),
				'default'   => 'short',
			),
			array(
				'id'        => 'moto_loader',
				'type'      => 'switch',
				'title'     => esc_html__('Loader On Home Page', 'moto'),
				'subtitle'  => esc_html__('show/hide loader', 'moto'),
				'default'   => true,
			),
			array(
				'id'        => 'moto_loader_img',
				'type'      => 'media',
				'required'  => array('moto_loader', 'equals', 1),
				'title'     => esc_html__('Upload Loader Image', 'moto'),
				'subtitle'  => esc_html__('', 'moto'),
				'default'   => true,
			),
			array(
				'id'        => 'moto_switcher',
				'type'      => 'switch',
				'title'     => esc_html__('MOTO Style Switcher', 'moto'),
				'subtitle'  => esc_html__('show/hide Switcher', 'moto'),
				'desc'	  	=> esc_html__('', 'moto'),
				'default'   => true,
			),
			array(
				'id'        => 'moto_shop_background',
				'type'      => 'media',
				'title'     => esc_html__('Shop Page Banner Image', 'moto'),				
				'subtitle'  => esc_html__('Upload banner for shop page.', 'moto')
			),
			array(
				'id'        => 'moto_shop_banner_switch',
				'type'      => 'switch',
				'title'     => esc_html__('Banner Image Switch', 'moto'),
				'subtitle'  => esc_html__('show/hide banner for shop page.', 'moto'),
				'default'   => false,
			),
		)
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Footer', 'moto' ),
        'id'               => 'moto_footer_g',
        'subsection'       => true,
        'customizer_width' => '450px',        
        'fields'           => array(
		      
			    array(
                   'id' => 'custom_footer_back',
                   'type'  => 'checkbox',
                   'title' => __('Custom Footer Background', 'moto'), 
                   'default' => '0'
                   ),
				array(
					'id'        => 'footer_back_style',
					'type'      => 'select',
					'title'     => esc_html__('Select Background Style', 'moto'),
					'desc'   => __( '', 'moto' ),'options'	=> 
								array(
									'image'	=>	'Background Image',		
									'color'	=>	'Background Color',
								   ),
					'required'  => array('custom_footer_back', 'equals', 1),				
					'default'   => 'color',	
			    ),
    			array(
					'id'       => 'foo_back_color',
					'type'     => 'color',
					'title'    => __('Footer Background Color', 'moto'), 
					'subtitle' => __('Pick a background color for the footer.', 'moto'),
					'required'  => array('footer_back_style', 'equals', 'color'),
					'default'  => '',
					'validate' => 'color',
				),
				array(
					'id'       => 'foo_back_image',
					'type'     => 'media',
					'title'    => __('Footer Background Image', 'moto'),
					'desc'     => __('Upload Background Image Here', 'moto'),
					'required'  => array('footer_back_style', 'equals', 'image'),
					'subtitle' => __('', 'moto')
				),
				array(
					'id'       => 'widget_head_color',
					'type'     => 'color',
					'title'    => __('Widget Heading Color', 'moto'), 
					'subtitle' => __('Pick a heading color for the footer widget.', 'moto'),
					'default'  => '',
					'validate' => 'color',
				),
				array(
					'id'       => 'widget_font_color',
					'type'     => 'color',
					'title'    => __('Widget Font Color', 'moto'), 
					'subtitle' => __('Pick a font color for the footer widget.', 'moto'),
					'default'  => '',
					'validate' => 'color',
				),
			   array(
				'id'        => 'moto_fc_style',
				'type'      => 'select',
				'title'     => esc_html__('Select Copyright Style', 'moto'),
				'desc'   => __( 'This setting will affect theme default Copyright Footer.', 'moto' ),'options'	=> 
							array(
								'fc_style1'=>'Copyright Style One',		
					            'fc_style2'=>'Copyright Style Two',
				               ),		 
				'default'   => 'fc_style1',	
			   ),
				array(
					'id'       => 'copy_back_color',
					'type'     => 'color',
					'title'    => __('Copyright Background Color', 'moto'), 
					'subtitle' => __('Pick a background color for the Copyright Section.', 'moto'),
					'required'  => array('moto_fc_style', 'equals', 'fc_style1'),
					'default'  => '',
					'validate' => 'color',
				),	
				array(
					'id'       => 'copy_text_color',
					'type'     => 'color',
					'title'    => __('Copyright Font Color', 'moto'), 
					'subtitle' => __('Pick a font color for the Copyright Section.', 'moto'),
					'required'  => array('moto_fc_style', 'equals', 'fc_style1'),
					'default'  => '',
					'validate' => 'color',
				),				
			   array(
				   'id'  => 'moto_fc_style2_background',
				   'type'  => 'media',
				   'title' => esc_html__('Background Image', 'moto'),
					'required'  => array('moto_fc_style', 'equals', 'fc_style2'),				   
				   'subtitle'  => esc_html__('Upload background image for copyright style two', 'moto')
			       ),
               array(
				  'id'  => 'moto_copyrighttext',
				  'type' => 'text',
				  'title' => esc_html__('Copyright Text', 'moto'),				
				  'default' => esc_html__('Copyright 2017 MOTO | All Rights Reserved', 'moto'),
			     ),
				array( 
					'id'       => 'moto_tracking_code',
					'type'     => 'textarea',					
					'title'    => __('Enter your google or facebook script', 'moto'),
					'subtitle' => __('', 'moto'),
				),  
			  
		      )
         ) ); 
	
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Version', 'moto' ),
        'id'               => 'moto_version_t',
        'subsection'       => true,
        'customizer_width' => '450px',        
        'fields'           => array(
			array(
				'id'        => 'moto_theme_version',
				'type'      => 'select',
				'title'     => esc_html__('Theme Version Option', 'moto'),				
				'options'	=> 
				array('style'=>'Light Version',			//Default
						'version2'=>'Dark Version'),	//Fashion, 	
					'default'   => 'style',			//Default 
			),
		)
    ) ); 
	
	
		Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Newsletter', 'moto' ),
        'id'               => 'moto_newsletters',
        'subsection'       => true,
        'customizer_width' => '450px',
        'desc'             => '', 
        'fields'           => array(
			
			// Newsletter start
		array(
				'id'        => 'moto_newsletter',
				'type'      => 'switch',
				'title'     => esc_html__('Moto Newsletter', 'moto'),
				'subtitle'  => esc_html__('show/hide Newsletter', 'moto'),
				'desc'	  	=> esc_html__(''),
				'default'   => false,
			),
			array( 
				'id'        => 'moto_newsletter_style',
				'type'      => 'select',				
				'title'     => esc_html__('Newsletter Style', 'moto'),				
				'subtitle'  => esc_html__('Select Newsletter Style', 'moto'),
				'options'  => array(
					'1' => 'Style 1',
					'2' => 'Style 2',
					'3' => 'Style 3'
				),
				'default'  => '1',
			), 
			array(
				'id'        => 'moto_newsletter_image',
				'type'      => 'media',
				'required'  => array('moto_newsletter_style', 'equals', 1),
				'title'     => esc_html__('Image', 'moto'),	
				'desc'	  	=> esc_html__('Please Upload Image.')
			),
			array(
				'id'        => 'moto_newsletter_bgimage',
				'type'      => 'media',
				'required'  => array('moto_newsletter_style', 'greater', 1),
				'title'     => esc_html__('Background Image', 'moto'),	
				'desc'	  	=> esc_html__('Please Upload Background Image.')
			), 
			array(
				'id'        => 'moto_newsletter_title',
				'type'      => 'text',
				'title'     => esc_html__('Title', 'moto'),				
				'desc'  => esc_html__('Enter Title Text', 'moto'),
			), 
			array( 
				'id'       => 'moto_newsletter_desc',
				'type'     => 'textarea',					
				'title'    => __('Enter Newsletter Description.', 'moto'),
				'subtitle' => __('', 'moto'),
			), 
			array( 
				'id'        => 'moto_newsletter_btntext',
				'type'      => 'text',
				'required'  => array('moto_newsletter_style', 'less', 3),				
				'title'     => esc_html__('Subscribe Button Text', 'moto'),				
				'desc'  => esc_html__('Enter Button Text', 'moto'),
				'default'  => 'Subscribe',
			), 
			array( 
				'id'       => 'moto_newsletter_mailchimp_api',
				'type'     => 'text',					
				'title'    => __('Enter Mailchimp API Key.', 'moto'),
				'subtitle' => __('', 'moto'),
			),
			array( 
				'id'       => 'moto_newsletter_mailchimp_list',
				'type'     => 'text',				
				'title'    => __('Enter Mailchimp List Id.', 'moto'),
				'subtitle' => __('', 'moto'),
			),
			
			 
			
	// Newsletter end	
			
		)
    ) );
	
	
	
	
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Styling Options', 'moto' ),
        'id'               => 'moto_style_option',
        'customizer_width' => '450px',       
		'icon'             => 'el-icon-tint',
        'fields'           => array(
			array(
				'id'        => 'moto_layout',
				'type'      => 'select',
				'title'     => esc_html__('Site Layout Style', 'moto'),				
				'options'	=> array( 'mt_boxed'=>'Boxed Layout', 'mt_full_width'=>'Full Width Layout' ),
				'default'   => 'mt_full_width',
			),
			array(
				'id'        => 'moto_bodybackground',
				'type'      => 'background',
				'output'    => array('body'),
				'title'     => esc_html__('Body Background', 'moto'),
				'subtitle'  => esc_html__('Body background with image, color, etc.', 'moto'),
				'default'   => '',
			),
			array(
				'id'        => 'moto_typographybodytext',
				'type'      => 'typography',
				'output'    => array('body'),
				'title'     => esc_html__('Body Font', 'moto'),
				'subtitle'  => esc_html__('Specify the body font properties.', 'moto'),
				'google'    => true,
				'default'   => array(
					'color'         => '',
					'font-size'     => '',
					'font-family'   => '',
					'font-weight'   => '',
				),
			),
			array(
				'id'        => 'moto_typographyh1',
				'type'      => 'typography',
				'output'    => 'h1',
				'title'     => esc_html__('Body Heading H1 Font', 'moto'),
				'subtitle'  => esc_html__('Specify the Heading font properties.', 'moto'),
				'google'    => true,
				'default'   => array(
					'color'         => '',
					'font-size'     => '',
					'font-family'   => '',
					'font-weight'   => '',
				),
			),
			array(
				'id'        => 'moto_typographyh2',
				'type'      => 'typography',
				'output'    => 'h2',
				'title'     => esc_html__('Body Heading H2 Font', 'moto'),
				'subtitle'  => esc_html__('Specify the Heading font properties.', 'moto'),
				'google'    => true,
				'default'   => array(
					'color'         => '',
					'font-size'     => '',
					'font-family'   => '',
					'font-weight'   => '',
				),
			),
			array(
				'id'        => 'moto_typographyh3',
				'type'      => 'typography',
				'output'    => 'h3',
				'title'     => esc_html__('Body Heading H3 Font', 'moto'),
				'subtitle'  => esc_html__('Specify the Heading font properties.', 'moto'),
				'google'    => true,
				'default'   => array(
					'color'         => '',
					'font-size'     => '',
					'font-family'   => '',
					'font-weight'   => '',
				),
			),
			array(
				'id'        => 'moto_typographyh4',
				'type'      => 'typography',
				'output'    => 'h4',
				'title'     => esc_html__('Body Heading H4 Font', 'moto'),
				'subtitle'  => esc_html__('Specify the Heading font properties.', 'moto'),
				'google'    => true,
				'default'   => array(
					'color'         => '',
					'font-size'     => '',
					'font-family'   => '',
					'font-weight'   => '',
				),
			),
			array(
				'id'        => 'moto_typographyh5',
				'type'      => 'typography',
				'output'    => 'h5',
				'title'     => esc_html__('Body Heading H5 Font', 'moto'),
				'subtitle'  => esc_html__('Specify the Heading font properties.', 'moto'),
				'google'    => true,
				'default'   => array(
					'color'         => '',
					'font-size'     => '',
					'font-family'   => '',
					'font-weight'   => '',
				),
			),
			array(
				'id'        => 'moto_typographyh6',
				'type'      => 'typography',
				'output'    => 'h6',
				'title'     => esc_html__('Body Heading H6 Font', 'moto'),
				'subtitle'  => esc_html__('Specify the Heading font properties.', 'moto'),
				'google'    => true,
				'default'   => array(
					'color'         => '',
					'font-size'     => '',
					'font-family'   => '',
					'font-weight'   => '',
				),
			),
			array(
				'id'        => 'moto_theme_color',
				'type'      => 'select',
				'title'     => esc_html__('Theme Color Option', 'moto'),				
				'options'	=> array('style'=>'Default',
								'blue'=>'Blue',
								'dark_red'=>'Dark Red',
								'green'=>'Green',
								'spring_rain'=> 'Spring Rain',
								'lightblue'=>'Light Blue',
								'orange'=>'Orange',
								'pink'=>'Pink',
								'purple'=>'Purple',
								'red'=>'Red',
								'red_stone'=> 'Red Stone',
								'turquoise'=>'Turquoise',
								'dark_green'=>'Dark Green',
								'dark_blue'=>'Dark Blue',
								'bronze'=>'Bronze',
								),
				'default'   => 'style',
			),
			array(
				'id'        => 'moto_customcss',
				'type'      => 'ace_editor',
				'mode'      => 'css',
				'theme'     => 'monokai',
				'title'     => esc_html__('Custom CSS', 'moto'),
				'subtitle'  => esc_html__('Quickly add some CSS to your theme by adding it to this block.', 'moto'),				
				'validate'  => 'css',				
			)
		)
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Social Setting', 'moto' ),
        'id'               => 'moto_social',
        'customizer_width' => '450px',       
		'icon'             => 'el-icon-twitter',
        'fields'           => array(
			array(
				'id'        => 'moto_facebookurl',
				'type'      => 'text',
				'title'     => esc_html__('Facebook', 'moto'),				
				'desc'      => esc_html__('Enter Facebook Url.', 'moto'),
				'default'  => esc_html__('https://www.facebook.com/', 'moto'),
			),
			array(
				'id'        => 'moto_twitterurl',
				'type'      => 'text',
				'title'     => esc_html__('Twitter', 'moto'),				
				'desc'      => esc_html__('Enter Twitter Url.', 'moto'),
				'default'  => esc_html__('https://twitter.com/?lang=en', 'moto'),
			),
			array(
				'id'        => 'moto_linkedinurl',
				'type'      => 'text',
				'title'     => esc_html__('Linkedin', 'moto'),				
				'desc'      => esc_html__('Enter Linkedin Url.', 'moto'),
				'default'  => esc_html__('https://in.linkedin.com/', 'moto'),
			),
			array(
				'id'        => 'moto_instagram',
				'type'      => 'text',
				'title'     => esc_html__('Instagram', 'moto'),				
				'desc'      => esc_html__('Enter Instagram Url.', 'moto'),
				'default'  => esc_html__('https://www.instagram.com/', 'moto'),
			),
			array(
				'id'        => 'moto_flickrurl',
				'type'      => 'text',
				'title'     => esc_html__('Flickr', 'moto'),				
				'desc'      => esc_html__('Enter Flickr Url.', 'moto'),
				'default'  => esc_html__('https://www.flickr.com/', 'moto'),
			),
			array(
				'id'        => 'moto_youtubeurl',
				'type'      => 'text',
				'title'     => esc_html__('Youtube', 'moto'),				
				'desc'      => esc_html__('Enter Youtube Url.', 'moto'),
				'default'  => esc_html__('https://www.youtube.com/', 'moto'),
			),
			array(
				'id'        => 'moto_dribbleurl',
				'type'      => 'text',
				'title'     => esc_html__('Dribbble', 'moto'),				
				'desc'      => esc_html__('Enter Dribbble Url.', 'moto'),
				'default'  => esc_html__('https://dribbble.com/', 'moto'),
			),
			array(
				'id'        => 'moto_gpurl',
				'type'      => 'text',
				'title'     => esc_html__('Google Plus', 'moto'),				
				'desc'      => esc_html__('Enter Google Plus Url.', 'moto'),
				'default'  => esc_html__('https://plus.google.com/', 'moto'),
			),
			array(
				'id'        => 'moto_skypeurl',
				'type'      => 'text',
				'title'     => esc_html__('Skype', 'moto'),				
				'desc'      => esc_html__('Enter Skype Id.', 'moto'),
				'default'  => esc_html__('http://www.skype.com/en/', 'moto'),
			),
			array(
				'id'        => 'moto_pinteresturl',
				'type'      => 'text',
				'title'     => esc_html__('Pinterest', 'moto'),				
				'desc'      => esc_html__('Enter Pinterest Url.', 'moto'),
				'default'  => esc_html__('https://www.facebook.com/', 'moto'),
			), 
			array(
				'id'        => 'moto_vimeourl',
				'type'      => 'text',
				'title'     => esc_html__('Vimeo', 'moto'),				
				'desc'      => esc_html__('Enter Vimeo Url.', 'moto'),
				'default'  => esc_html__('https://vimeo.com/', 'moto'),
			),
			array(
				'id'        => 'moto_displaysocial',
				'type'      => 'sorter',
				'title'     => esc_html__('Show Social Icon On Header','moto'),
				'subtitle'  => esc_html__('You can choose ICON display or NOT.','moto'),
				'compiler'  => 'true',
				'options'   => array(
					'SHOW'   => array(
						'Facebook'    => 'Facebook',
						'Twitter'    => 'Twitter',
						'Vimeo'    => 'Vimeo',
						'Dribbble'    => 'Dribbble',
						'Instagram'    => 'Instagram'   
					),
					'NOT SHOW' => array(
						'Linkedin'  => 'Linkedin',
						'Flickr'   => 'Flickr',
						'Skype'    => 'Skype',
						'Youtube'    => 'Youtube',
						'Google'    => 'Google Plus',
						'Pinterest'    => 'Pinterest'
					)
				)
			)
		)
    ) );
	
   	Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'Single Page Website', 'moto' ),
	'id'    => 'moto_singlepageweb',
	'customizer_width' => '450px', 
	'icon'             => 'el el-resize-vertical',	
	'fields'  => array(
			array(
			   'id'  => 'moto_singlePageSite',
			   'type' => 'switch',
			   'title' => esc_html__('Single Page Website', 'moto'),
			   'subtitle'  => esc_html__('on/off Single Page Website', 'moto'),
			   'desc'      => esc_html__('You can create One Page Website using this option. After "On" this option please visit the documentation to set up Single Page Website.', 'moto'),
			   'default'   => false,
			 ),
		  )
	) );	
	
	Redux::setSection( $opt_name, array(
		'title'            => esc_html__( 'Shop Page Setting', 'moto' ),
		'id'               => 'moto_shop_page',
		'customizer_width' => '450px',
		'icon'             => 'el el-shopping-cart',
		'desc'             => '',
		'fields'           => array(
			array(
				'id'        => 'moto_shop_columns',
				'type'      => 'select',
				'title'     => esc_html__('Shop Page Columns', 'moto'),
				'desc'   => __( 'This setting will affect theme default shop page.', 'moto' ),				
				'options'	=> 
				array(
					'col2'=>'2 Columns',		
					'col3'=>'3 Columns',
					'col4'=>'4 Columns',
				),		
				'default'   => 'col3',	
			),
			array(
				'id'        => 'moto_menu_carticon',
				'type'      => 'switch',
				'title'     => esc_html__('Cart Icon', 'moto'),
				'subtitle'      => esc_html__('show/hide cart icon in menu', 'moto'),
				'default'   => false,
			),
			array(
				'id'        => 'moto_cart_text',
				'type'      => 'text',
				'title'     => esc_html__('Cart Button Text', 'moto'),			
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('Add To Cart', 'moto'),
			),			
		)
		) );
	
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Contact Setting', 'moto' ),
        'id'               => 'moto_contact',
        'customizer_width' => '450px',        
		'icon'             => 'el-icon-map-marker',
		'fields'           => array(
			array(
				'id'        => 'moto_google_map_api',
				'type'      => 'text',
				'title'     => esc_html__('Google Map API key', 'moto'),			
				'desc'      => __('Please enter <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">google map API key</a> if the Map is not working in your site', 'moto'),
				'default'  => esc_html__('', 'moto'),
			),
			array(
				'id'        => 'moto_contactemailaddrs',
				'type'      => 'text',
				'title'     => esc_html__('Email Receiving Address', 'moto'),			
				'desc'      => esc_html__('Enter your email address', 'moto'),
				'default'  => esc_html__('help@motothemes.com', 'moto'),
			),
			array(
				'id'        => 'moto_successmessage',
				'type'      => 'text',
				'title'     => esc_html__('Success Message', 'moto'),				
				'desc'      => esc_html__('Success message text after email delivered', 'moto'),
				'default'  => esc_html__('your message has been sent. please check your inbox', 'moto'),
			),
			array(
				'id'        => 'moto_fromaddrs',
				'type'      => 'text',
				'title'     => esc_html__('Email From Address', 'moto'),				
				'default'  => esc_html__('help@motothemes.com', 'moto'),
			),
			array(
				'id'        => 'moto_mailsubject',
				'type'      => 'text',
				'title'     => esc_html__('Mail Subject', 'moto'),				
				'desc'      => esc_html__('Inquiry MOTO', 'moto'),
				'default'  => esc_html__('Inquiry MOTO', 'moto'),
			),
			array(
				'id'        => 'moto_contact_no',
				'type'      => 'text',
				'title'     => esc_html__('Contact No.', 'moto'),				
				'desc'      => esc_html__('Add your contact here.', 'moto'),
				'default'  => esc_html__('0123456789', 'moto'),
			),
			array(
				'id'        => 'moto_fieldsenable_disable',
				'type'      => 'sorter',
				'title'     => esc_html__('Form Setting','moto'),
				'subtitle'  => esc_html__('You can choose INPUT fields.','moto'),
				'compiler'  => 'true',
				'options'   => array(
					'ENABLE'   => array(
						'NAME'    => 'NAME',
						'PHONENUMBER'    => 'PHONE NUMBER',
						'EMAIL'        => 'EMAIL',
						'SUBJECT'        => 'SUBJECT',
					),
					'DISABLE' => array(
					
					)
				)
			), 
			array(
				'id'        => 'moto_fieldsrequire',
				'type'      => 'sorter',
				'title'     => esc_html__('Required Field','moto'),
				'subtitle'  => esc_html__('You can choose INPUT fields REQUIRED or NOT.','moto'),
				'compiler'  => 'true',
				'options'   => array(
					'REQUIRE'   => array(
						'NAME'    => 'NAME',
						'PHONENUMBER'    => 'PHONE NUMBER',
						'EMAIL'        => 'EMAIL',
						'SUBJECT'        => 'SUBJECT',
					),
					'NOT REQUIRE' => array(
					
					)
				)
			)
		)
    ) );
	
	
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Contact Form Labels', 'moto' ),
        'id'               => 'moto_contact_labels',
        'customizer_width' => '450px',        
		'icon'             => 'el el-list',
		'subsection'       => true,
		'fields'           => array(
            array(
				'id'        => 'name_label',
				'type'      => 'text',
				'title'     => esc_html__('Name Label', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('Name', 'moto'),
			),
			array(
				'id'        => 'email_label',
				'type'      => 'text',
				'title'     => esc_html__('Email Label', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('Email', 'moto'),
			),
			array(
				'id'        => 'phon_label',
				'type'      => 'text',
				'title'     => esc_html__('Phone No. Label', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('Phone', 'moto'),
			),
			array(
				'id'        => 'subject_label',
				'type'      => 'text',
				'title'     => esc_html__('Subject Label', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('Subject', 'moto'),
			),
			array(
				'id'        => 'msg_label',
				'type'      => 'text',
				'title'     => esc_html__('Message Label', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('Message', 'moto'),
			)

        )
    ) );
	
	    Redux::setSection( $opt_name, array(
        'title'            => __( 'Contact Form Placeholders', 'moto' ),
        'id'               => 'moto_contact_placeholders',
        'customizer_width' => '450px',        
		'icon'             => 'el el-list',
		'subsection'       => true,
		'fields'           => array(
            array(
				'id'        => 'name_place',
				'type'      => 'text',
				'title'     => esc_html__('Name Placeholder', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('name', 'moto'),
			),
			array(
				'id'        => 'email_place',
				'type'      => 'text',
				'title'     => esc_html__('Email Placeholder', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('email', 'moto'),
			),
			array(
				'id'        => 'phon_place',
				'type'      => 'text',
				'title'     => esc_html__('Phone No. Placeholder', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('phone no', 'moto'),
			),
			array(
				'id'        => 'subject_place',
				'type'      => 'text',
				'title'     => esc_html__('Subject Placeholder', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('subject', 'moto'),
			),
			array(
				'id'        => 'msg_place',
				'type'      => 'text',
				'title'     => esc_html__('Message Placeholder', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('message', 'moto'),
			),
			array(
				'id'        => 'button_txt',
				'type'      => 'text',
				'title'     => esc_html__('Button Text', 'moto'),				
				'desc'      => esc_html__('', 'moto'),
				'default'  => esc_html__('Send Message', 'moto'),
			)

        )
    ) );
	 
	
    Redux::setSection( $opt_name, array(
        'icon'            => 'el el-list-alt',
        'title'           => __( 'Customizer Only', 'moto' ),
        'desc'            => __( '<p class="description">This Section should be visible only in Customizer</p>', 'moto' ),
        'customizer_only' => true,
        'fields'          => array(
            array(
                'id'              => 'opt-customizer-only',
                'type'            => 'select',
                'title'           => __( 'Customizer Only Option', 'moto' ),
                'subtitle'        => __( 'The subtitle is NOT visible in customizer', 'moto' ),
                'desc'            => __( 'The field desc is NOT visible in customizer.', 'moto' ),
                'customizer_only' => true,
                //Must provide key => value pairs for select options
                'options'         => array(
                    '1' => 'Opt 1',
                    '2' => 'Opt 2',
                    '3' => 'Opt 3'
                ),
                'default'         => '2'
            ),
        )
    ) );
 
   
    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $return['error'] = $field;
                $field['msg']    = 'your custom error message';
            }

            if ( $warning == true ) {
                $return['warning'] = $field;
                $field['msg']      = 'your custom warning message';
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'moto' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'moto' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections; 
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
   /* if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }*/