<?php
/*
Plugin Name: MOTO Core Plugin
Plugin URI: http://motothemes.com/
Description: This plugin create custom post type and some meta option.
Version: 1.0.0
Author: MOTO Themes
Author URI: http://motothemes.com/
*/

define('PLUGIN_PATH', plugin_dir_url( __FILE__ ) ); 
define( 'PLUGIN_PATH_CORE', dirname( __FILE__ ) . '/' );
function motocore_adminload_script(){
	wp_enqueue_script('jquery');
	wp_enqueue_script('jquery-ui-core');
	wp_enqueue_script('jquery-ui-widget');
	wp_enqueue_script('jquery-ui-tabs');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-dialog');
	wp_enqueue_script('jquery-ui-slider');
	wp_enqueue_script('media-upload');
    wp_enqueue_script('thickbox');
	wp_enqueue_style('thickbox');
	wp_enqueue_script('uploadmedia', PLUGIN_PATH. 'js/admin.js', array('jquery','media-upload','thickbox'));
	wp_enqueue_script('datepicker-js', PLUGIN_PATH. 'js/motodatepicker.js');
	wp_enqueue_script('moto-tinymce', PLUGIN_PATH. 'js/tinymce.js');
	wp_enqueue_style('padmincss', PLUGIN_PATH. 'css/admin.css');
	wp_enqueue_style('datepicker-css', PLUGIN_PATH. 'css/motodatepicker.css');
}
add_action('admin_enqueue_scripts','motocore_adminload_script');
/* 
 * Load redux-framework
 */  
require_once 'admin/framework.php';
require_once 'admin/moto-config.php';

require_once 'metaboxes.php';
require_once 'multi-image-upload.php';
require_once 'custompost.php'; 
require_once 'tinymce_shortcodebutton.php'; 
require_once 'moto-widgets.php'; 
require_once 'shortcodes.php'; 
require_once 'moto_shortcodes_map.php';

add_action('wp_footer', 'motocore_tracking_code');
function motocore_tracking_code(){
	global $redux_moto;
	if(isset($redux_moto['moto_tracking_code']) && !empty($redux_moto['moto_tracking_code'])){
		echo $redux_moto['moto_tracking_code'];
	}
}

/************************************************************************
* Way to set menu, import revolution slider, and set home page.
*************************************************************************/

if ( !function_exists( 'wbc_extended_part1' ) ) {
	function wbc_extended_part1( $demo_active_import , $demo_directory_path ) {

		reset( $demo_active_import );
		$current_key = key( $demo_active_import );

		/************************************************************************
		* Import slider(s) for the current demo being imported
		*************************************************************************/

		if ( class_exists( 'RevSlider' ) ) {

			$wbc_sliders_array = array(
				'Solar-Installation' 	  => 'solar-installation.zip',
				'Pool-Cleaners' 	 	  => 'pool_cleaning_slider.zip',
				'Painter' 			 	  => 'painters.zip',
				'Carpenter' 		 	  => 'carpenter_slider.zip',
				'Wedding-Planner' 	 	  => 'wedding_planner.zip',
				'Soccer-Club' 	 	 	  => 'sporty.zip',
				'Bread&Breakfast' 	 	  => 'home-slider.zip',
				'Pool' 				 	  => array('home_slider.zip','about_banner.zip'),
				'Countertop-Installation' => 'countertop.zip',
				'Demolition-Services' 	  => 'demolition.zip',
				'Electricians' 			  => 'electrician.zip',
				'Furniture' 			  => 'furniture.zip',
				'Eco-Friendly' 			  => 'eco-friendly.zip',
				'Wedding-Catering' 		  => 'catering_slider.zip',
				'Wedding-Photography' 	  => 'wds_photography_slider.zip',
				'Car-Body-Shops' 	  	  => 'car_body_shop.zip',
				'Carpet-Installation' 	  => 'carpet-installation-slider.zip',
				'Security-Services' 	  => 'security-srvices.zip',
				'Roofing-Contractors' 	  => 'roof_slider.zip',
				'Tree-Services' 	  	  => 'tree-services.zip',
				'Legal-Services' 	  	  => 'legal-services.zip',
				'Nutritionists' 	  	  => 'nutritionist.zip',
				'Bridal-Dresses' 	 	  => 'bridal_dress.zip',
				'Wine-Tasting-Classes' 	  => 'wine_tast.zip',
				'Ski-Resorts' 	  		  => 'ski_resort.zip',
				'Accountants' 	 	      => 'accountants.zip',
				'Gardeners' 	  		  => 'gardeners.zip',
				'Garage-Door-Services' 	  => 'garage_door.zip',
				'Junk-Removal-And-Hauling'=> 'junkremoval.zip',
				'Veterinarian'			  => 'moto_veterinarian.zip',
				'Barber'			  	  => 'barber-slider.zip',
				'Funeral-Services'		  => 'funeral.zip',
				'Auto-Repair'			  => 'home_slider.zip',
				'Motorcycle-Repairs'	  => 'motorcycle_repair.zip',
				'Towing'			  	  => 'home_slider.zip',
				'Car-Dealers'			  => 'car-dealers.zip',
				'Payroll-Services'		  => 'payroll.zip',
				'Dentists'			  	  => 'dentist_slider.zip',
				'Real-Estate-Agents'	  => 'real_estate_agent.zip',
				'Fishing'			  	  => 'fishing.zip',
				'Vacation-Rentals'		  => 'vacation_rental.zip',
				'Seafood-Restaurants'	  => 'seafood_slider.zip',
				'Bridal-Makeup'			  => 'bridal_mackup.zip',
				'Travel-Agent'			  => 'travel_agent.zip',
				'Landscaping'			  => 'landscaping.zip',
				'Fences-And-Gates'		  => 'fencing.zip',
				'Flooring'			  	  => 'home_slider.zip',
				'Roofing'			  	  => 'roofing_slider.zip',
				'Car-Rental'			  => 'car_rental.zip',
				'Private-Investigation-Services' => 'investigation.zip',
				'Resorts'			  	  => 'resort.zip',
				'Indian-Restaurant'		  => 'indian_restaurant.zip',
				'Amazon-Books'		  	  => 'amazon_store2.zip',
				'Amazon-Electronics'	  => 'amazon_store5.zip',
				'Amazon-Fashion'		  => 'amazon_store3.zip',
				'Amazon-Store'		  	  => 'amazon_store1.zip',
				'Amazon-Watches'		  => 'amazon_store4.zip',
				'Acupuncture-Clinic'	  => 'accupuncture.zip',
				'Chiropractors'	  		  => 'Chiropractors.zip',
				'Damage-Restoration'	  => 'damage_restoration.zip',
				'Handyman'	  			  => 'handyman.zip',
				'HVAC'	  				  => 'hvac_slider.zip',
				'Moving-Company'	  	  => 'moving_company.zip',
				'Optometrists'	  		  => 'optometrists.zip',
				'Plumbing'	  			  => 'plumbing.zip',
				'Shared-Office-Spaces'	  => 'shared_office.zip',
				'Sushi-Bars'	  		  => 'sushi.zip',
				'Affiliate-Blog'	  	  => 'homeslider.zip',
				'Affiliate-Jv-Theme'	  => 'affiliate-home.zip',
				'Callcenter'	  		  => 'callcenter-slider.zip',
				'Driving-School'	  	  => 'driving-slider.zip',
				'Fashion'	  			  => array('home_slider.zip','model_slider_2.zip'),
				'Fitness'	  			  => array('home_slider.zip','about_banner.zip'),
				'Horse-Riding'	  		  => 'riding-slider.zip',
				'Lawyer'	  			  => array('home-slider.zip','about_banner.zip'),
				'Limousine'	  			  => 'limo_slider.zip',
				'Opt-in'	  			  => '',
				'Pets'	  				  => 'pets-slider.zip',
				'Photography'	  		  => array('home_slider.zip','about_banner.zip'),
				'Product-Landing-Page'	  => 'home_slider.zip',
				'Product-Showcase-Page'	  => 'home-banner.zip',
				'Tattoo'	  			  => 'tattoo-slider.zip',
				'Taxi'	  			  	  => 'taxi-slider.zip',
				'Web-Solution'	  		  => 'home_slider.zip',
				'Wine'	  			  	  => 'wine-slider.zip',
				'Yoga'	  			  	  => 'home_slider.zip',	
				'Beer-Bar'	  			  => 'bar-slider.zip',
				'Casino'	  			  => 'casino-slider.zip',
				'Construction'	  		  => array('home_slider.zip','about_banner.zip'),
				'Copywriter'	  		  => 'writer-slider.zip',
				'Education'	  			  => 'home-slider.zip',
				'E-commerce'	  		  => 'home_slider.zip',
				'Event'	  			  	  => 'event-slider.zip',
				'Health-care'	  		  => array('home_slider.zip','about-banner.zip'),
				'Insurance'	  			  => 'insurance-slider.zip',
				'Interior'	  			  => 'interior-slider.zip',
				'Journalist'	  		  => 'journalist-slider.zip',
				'Laundry'	  			  => 'laundry_slider.zip',
				'Music'	  			  	  => 'music_slider.zip',
				'NGO'	  			  	  => 'ngo-slider.zip',
				'Pesticides'	  		  => 'pesticide-slider.zip',
				'Real-Estate'	  		  => array('home_slider.zip','about_banner.zip'),
				'Renovation'	  		  => 'renovate-slider.zip',
				'Restaurant'	  		  => array('home-slider.zip','home-slider-2.zip','home-three.zip'),
				'SPA'	  			  	  => 'spa-slider.zip',
				'Travel'	  			  => array('home_slider.zip','about_banner.zip'),
				'Video'	  			  	  => 'youtube-hero.zip',
				'Wedding'	  			  => 'home_slider.zip',
				'Locksmith'	  			  => 'locksmith.zip',
				'Gutter-Services'	  	  => 'gutter.zip',
			);

			if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_sliders_array ) ) {
				$wbc_slider_import = $wbc_sliders_array[$demo_active_import[$current_key]['directory']];

			if( is_array( $wbc_slider_import ) ){
            foreach ($wbc_slider_import as $slider_zip) {
					if ( !empty($slider_zip) && file_exists( $demo_directory_path.$slider_zip ) ) {
						$slider = new RevSlider();
						$slider->importSliderFromPost( true, true, $demo_directory_path.$slider_zip );
					}
				}
			}else{
				if ( file_exists( $demo_directory_path.$wbc_slider_import ) ) {
					$slider = new RevSlider();
					$slider->importSliderFromPost( true, true, $demo_directory_path.$wbc_slider_import );
				}
			}
			}
		}

		/************************************************************************
		* Setting Menus
		*************************************************************************/

		$wbc_menu_array = array( 'Solar-Installation','Pool-Cleaners','Painter','Carpenter','Wedding-Planner','Soccer-Club','Bread&Breakfast','Pool','Countertop-Installation','Demolition-Services','Electricians','Furniture','Eco-Friendly','Wedding-Catering','Wedding-Photography','Car-Body-Shops','Carpet-Installation','Security-Services','Roofing-Contractors','Tree-Services','Legal-Services','Nutritionists','Bridal-Dresses','Wine-Tasting-Classes','Ski-Resorts','Accountants','Gardeners','Garage-Door-Services','Junk-Removal-And-Hauling','Veterinarian','Barber','Funeral-Services','Auto-Repair','Motorcycle-Repairs','Towing','Car-Dealers','Payroll-Services','Dentists','Real-Estate-Agents','Fishing','Vacation-Rentals','Seafood-Restaurants','Bridal-Makeup','Travel-Agent','Landscaping','Fences-And-Gates','Flooring','Roofing','Car-Rental','Private-Investigation-Services','Resorts','Indian-Restaurant','Amazon-Books','Amazon-Electronics','Amazon-Fashion','Amazon-Store','Amazon-Watches','Acupuncture-Clinic','Chiropractors','Damage-Restoration','Handyman','HVAC','Moving-Company','Optometrists','Plumbing','Shared-Office-Spaces','Sushi-Bars','Affiliate-Blog','Affiliate-Jv-Theme','Callcenter','Driving-School','Fashion','Fitness','Horse-Riding','Lawyer','Limousine','Opt-in','Pets','Photography','Product-Landing-Page','Tattoo','Taxi','Web-Solution','Wine','Yoga','Beer-Bar','Casino','Construction','Copywriter','Education','E-commerce','Event','Health-care','Insurance','Interior','Journalist','Laundry','Music','NGO','Pesticides','Real-Estate','Renovation','Restaurant','SPA','Travel','Video','Wedding','Locksmith','Gutter-Services' );

		if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && in_array( $demo_active_import[$current_key]['directory'], $wbc_menu_array ) ) {
			$top_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
			$preheader_menu = get_term_by( 'name', 'Top Menu', 'nav_menu' );

			if ( isset( $top_menu->term_id ) ) {
				set_theme_mod( 'nav_menu_locations', array(
						'primary' => $top_menu->term_id
					)
				);
			}
			
			if ( isset( $preheader_menu->term_id ) ) {
				set_theme_mod( 'nav_menu_locations', array(
						'pre_header' => $preheader_menu->term_id
					)
				);
			}

		}

		/************************************************************************
		* Set HomePage
		*************************************************************************/

		// array of demos/homepages to check/select from
		$wbc_home_pages = array(
			'Solar-Installation' 		=> 'Home',
			'Pool-Cleaners'		 		=> 'Home',	
			'Painter' 		     		=> 'Home',	
			'Carpenter' 		 		=> 'Home',	
			'Wedding-Planner' 	 		=> 'Home',	
			'Soccer-Club' 		 		=> 'Home',
			'Bread&Breakfast' 		    => 'Home',
			'Pool' 	 			 		=> 'Home',
			'Countertop-Installation'   => 'Home',
			'Demolition-Services' 	 	=> 'Home',
			'Electricians' 	 			=> 'Home',
			'Furniture' 	 			=> 'Home',
			'Eco-Friendly' 	 			=> 'Home',
			'Wedding-Catering' 	 		=> 'Home',
			'Wedding-Photography' 	 	=> 'Home',
			'Car-Body-Shops' 	 		=> 'Home',
			'Carpet-Installation' 	 	=> 'Home',
			'Security-Services' 	 	=> 'Home',
			'Roofing-Contractors' 	 	=> 'Home',
			'Tree-Services' 	 		=> 'Home',
			'Legal-Services' 	 		=> 'Home',
			'Nutritionists' 	 		=> 'Home',
			'Bridal-Dresses' 	 		=> 'Home',
			'Wine-Tasting-Classes' 	 	=> 'Home',
			'Ski-Resorts' 	 			=> 'Home',
			'Accountants' 	 			=> 'Home',
			'Gardeners' 	 			=> 'Home',
			'Garage-Door-Services' 	 	=> 'Home',
			'Junk-Removal-And-Hauling' 	=> 'Home',
			'Veterinarian' 	 			=> 'Home',
			'Barber' 	 				=> 'Home',
			'Funeral-Services' 	 		=> 'Home',
			'Auto-Repair' 	 			=> 'Home',
			'Motorcycle-Repairs' 	 	=> 'Home',
			'Towing' 	 				=> 'Home',
			'Car-Dealers' 	 			=> 'Home',
			'Payroll-Services' 	 		=> 'Home',
			'Dentists' 	 				=> 'Home',
			'Real-Estate-Agents' 	 	=> 'Home',
			'Fishing' 	 				=> 'Home',
			'Vacation-Rentals' 	 		=> 'Home',
			'Seafood-Restaurants' 	 	=> 'Home',
			'Bridal-Makeup' 	 		=> 'Home',
			'Travel-Agent' 	 			=> 'Home',
			'Landscaping' 	 			=> 'Home',
			'Fences-And-Gates' 	 		=> 'Home',
			'Flooring' 	 				=> 'Home',
			'Roofing' 	 				=> 'Home',
			'Car-Rental' 	 			=> 'Home',
			'Private-Investigation-Services' => 'Home',
			'Resorts' 	 				=> 'Home',
			'Indian-Restaurant' 	 	=> 'Home',
			'Amazon-Books' 	 		    => 'Books',
			'Amazon-Electronics' 	 	=> 'Electronics',
			'Amazon-Fashion' 	 		=> 'Fashion',
			'Amazon-Store' 	 			=> 'Amazon Store',
			'Amazon-Watches' 	 		=> 'Watches',
			'Acupuncture-Clinic' 	 	=> 'Home',
			'Chiropractors' 	 		=> 'Home',
			'Damage-Restoration' 	 	=> 'Home',
			'Handyman' 	 				=> 'Home',
			'HVAC' 	 					=> 'Home',
			'Moving-Company' 	 		=> 'Home',
			'Optometrists' 	 			=> 'Home',
			'Plumbing' 	 				=> 'Home',
			'Shared-Office-Spaces' 	 	=> 'Home',
			'Sushi-Bars' 	 			=> 'Home',
			'Affiliate-Blog' 	 		=> 'Home',
			'Affiliate-Jv-Theme' 	 	=> 'Home',
			'Callcenter' 	 			=> 'Home',
			'Driving-School' 	 		=> 'Home',
			'Fashion' 	 				=> 'Home',
			'Fitness' 	 				=> 'Home',
			'Horse-Riding' 	 			=> 'Home',
			'Lawyer' 	 				=> 'Home',
			'Limousine' 	 			=> 'Home',
			'Opt-in' 	 				=> 'Home',
			'Pets' 	 					=> 'Home',
			'Photography' 	 			=> 'Home',
			'Product-Landing-Page' 	 	=> 'Home',
			'Product-Showcase-Page' 	=> 'Home',
			'Tattoo' 	 				=> 'Home',
			'Taxi' 	 					=> 'Home',
			'Web-Solution' 	 			=> 'Home',
			'Wine' 	 					=> 'Home',
			'Yoga' 	 					=> 'Home',
			'Beer-Bar' 	 				=> 'Home',
			'Casino' 	 				=> 'Home',
			'Construction' 	 			=> 'Home',
			'Copywriter' 	 			=> 'Home',
			'Education' 	 			=> 'Home',
			'E-commerce' 	 			=> 'Home',
			'Event' 	 				=> 'Home',
			'Health-care' 	 			=> 'Home',
			'Insurance' 	 			=> 'Home',
			'Interior' 	 				=> 'Home',
			'Journalist' 	 			=> 'Home',
			'Laundry' 	 				=> 'Home',
			'Music' 	 				=> 'Home',
			'NGO' 	 					=> 'Home',
			'Pesticides' 	 			=> 'Home',
			'Real-Estate' 	 			=> 'Home',
			'Renovation' 	 			=> 'Home',
			'Restaurant' 	 			=> 'Home',
			'SPA' 	 					=> 'Home',
			'Travel' 	 				=> 'Home',
			'Video' 	 				=> 'Home',
			'Wedding' 	 				=> 'Home',
			'Locksmith' 	 			=> 'Home',
			'Gutter-Services' 	 		=> 'Home',
		);

		if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_home_pages ) ) {
			$page = get_page_by_title( $wbc_home_pages[$demo_active_import[$current_key]['directory']] );
			if ( isset( $page->ID ) ) {
				update_option( 'page_on_front', $page->ID );
				update_option( 'show_on_front', 'page' );
			}
		}

	}
	// Uncomment the below
	add_action( 'wbc_importer_after_content_import', 'wbc_extended_part1', 10, 2 );
}
?>