<?php
$prefix = 'motocore_';
/*********=========	Start Page MetaBox   =========*********/
$page_option_meta = array(
    'id' => 'section-page-meta',
    'title' => __('Moto Page Setting','moto'),
    'page' => 'page',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
		array(
            'name' => __('Choose Sidebar Postion For This Section', 'moto'),
            'desc' => '',
            'id' => $prefix.'page_sidebarposition',
            'type' => 'sidebarradio',
            'std' => 'full',
			'option' => array(
					'full' => PLUGIN_PATH.'/images/1col.png',
					'left' => PLUGIN_PATH.'/images/2cl.png',
					'right' => PLUGIN_PATH.'/images/2cr.png'
				)
        ),
		array(
            'name' => __('Select Footer', 'moto'),
            'desc' => '',
            'id' => $prefix.'footer_s',
            'type' => 'select',
            'options' => array('footer-1'=>'footer - 1','footer-2'=>'footer - 2')
        )
	)
       
);
// create boxes for team
add_action('admin_menu', 'add_page_meta_boxes');
if(!function_exists('add_page_meta_boxes')){	
	function add_page_meta_boxes()
	{
		global  $page_option_meta;
		add_meta_box($page_option_meta['id'], $page_option_meta['title'], 'show_page_options', $page_option_meta['page'], $page_option_meta['context'], $page_option_meta['priority']);
	}
}
if(!function_exists('show_page_options')){	
	function show_page_options()
	{
		global $page_option_meta, $post;
		// Use nonce for verification
		echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
		echo '<table class="form-table">';
		foreach ($page_option_meta['fields'] as $field) {
			// get current post meta data
			$meta = get_post_meta($post->ID, $field['id'], true);
			switch ($field['type']) {
				case 'sidebarradio':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					if(empty($meta)){
						$meta = 'full';
					}
					foreach($field['option'] as $k=>$v){
						echo '<div class="', ($meta == $k) ? 'moto_chooseborder '
						: '' ,'moto-select-sidebar">
						<div style="display:none;">
						<input type="radio" value="'.$k.'" ',($meta == $k) ? 'checked'
						: '','  name="'.$field['id'].'" ></div>';
						echo '<img src="'.$v.'" alt=""></div>';
					}
				break;
				case 'text':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? stripslashes(htmlspecialchars(($meta), ENT_QUOTES))
						: stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
				case 'select':

                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';

                echo'<select name="' . $field['id'] . '">';

                foreach ($field['options'] as $k=>$v) {

                    echo'<option';
                    if ($meta == $k) {
                        echo ' selected="selected"';
                    }
                    echo' value="'.$k.'">' . $v . '</option>';

                }

                echo'</select>';

                break;
			}
		}
		echo '</table>';
	}
}
add_action('save_post', 'page_save_options');
if(!function_exists('page_save_options')){	
	function page_save_options($post_id)
	{	
		global $page_option_meta;
		$new = '';
		// verify nonce
		if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
			return $post_id;
		}
		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}
		if (defined('DOING_AJAX') && DOING_AJAX)
			return;
		// check permissions
		if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
			if (!current_user_can('edit_page', $post_id)) {
				return $post_id;
			}
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}
	 
		foreach ($page_option_meta['fields'] as $field) {
			$old = get_post_meta($post_id, $field['id'], true);
			if (isset($_POST[$field['id']])) {
				 $new = $_POST[$field['id']];
			}
			if ($new && $new != $old) {
				update_post_meta($post_id, $field['id'], $new);
			} elseif ('' == $new && $old) {
				delete_post_meta($post_id, $field['id'], $old);
			}
		}
	}
}
/*********=========	End Page MetaBox   =========*********/

/*********=========	Start Post MetaBox   =========*********/
$post_option_meta = array(
    'id' => 'section-post-meta',
    'title' => __('Moto Post Setting','moto'),
    'page' => 'post',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
		array(
            'name' => __('Choose Sidebar Postion For This Section', 'moto'),
            'desc' => '',
            'id' => $prefix.'post_sidebarposition',
            'type' => 'sidebarradio',
            'std' => 'right',
			'option' => array(
					'full' => PLUGIN_PATH.'/images/1col.png',
					'left' => PLUGIN_PATH.'/images/2cl.png',
					'right' => PLUGIN_PATH.'/images/2cr.png'
				)
        ),
		array(
            'name' => 'Upload youtube video or quote or slider setting',
            'desc' => 'This options will not work if you select featured image.',
            'id' => $prefix.'postquote_video', 
            'type' => 'select',
            'std' => 'select',
            'options' => array('select', 'video' , 'quote'),
        ),
		array(
            'name' => 'Enter URL Vimeo Or Youtube',
            'desc' => '',
            'id' => $prefix.'url_youtube',
            'type' => 'text',
			'std' => '',
			'cls' => 'hide_row remove_hide_cls_url_youtube'
        ),
		array(
            'name' => 'Quote setting',
            'desc' => '',
            'id' => $prefix.'quote',
            'type' => 'textarea',
			'std' => '',
			'cls' => 'hide_row remove_hide_cls_quote'
        ),
		array(
            'name' => 'Choose icon (For listed view)',
            'desc' => '',
            'id' => $prefix.'iconcls', 
            'type' => 'select',
            'std' => 'select',
            'options' => array('select','icon-mobile', 'icon-laptop', 'icon-desktop', 'icon-tablet', 'icon-phone', 'icon-document', 'icon-documents', 'icon-search', 'icon-clipboard', 'icon-newspaper', 'icon-notebook', 'icon-book-open', 'icon-browser', 'icon-calendar', 'icon-presentation', 'icon-picture', 'icon-pictures', 'icon-video', 'icon-camera', 'icon-printer', 'icon-toolbox', 'icon-briefcase', 'icon-wallet', 'icon-gift', 'icon-bargraph', 'icon-grid', 'icon-expand', 'icon-focus', 'icon-edit', 'icon-adjustments', 'icon-ribbon', 'icon-hourglass', 'icon-lock', 'icon-megaphone', 'icon-shield', 'icon-trophy', 'icon-flag', 'icon-map', 'icon-puzzle', 'icon-basket', 'icon-envelope', 'icon-streetsign', 'icon-telescope', 'icon-gears', 'icon-key', 'icon-paperclip', 'icon-attachment', 'icon-pricetags', 'icon-lightbulb', 'icon-layers', 'icon-pencil', 'icon-tools', 'icon-tools-2', 'icon-scissors', 'icon-paintbrush', 'icon-magnifying-glass', 'icon-circle-compass', 'icon-linegraph', 'icon-mic', 'icon-strategy', 'icon-beaker', 'icon-caution', 'icon-recycle', 'icon-anchor', 'icon-profile-male', 'icon-profile-female', 'icon-bike', 'icon-wine', 'icon-hotairballoon', 'icon-globe', 'icon-genius', 'icon-map-pin', 'icon-dial', 'icon-chat', 'icon-heart', 'icon-cloud', 'icon-upload', 'icon-download', 'icon-target', 'icon-hazardous', 'icon-piechart', 'icon-speedometer', 'icon-global', 'icon-compass', 'icon-lifesaver', 'icon-clock', 'icon-aperture', 'icon-quote', 'icon-scope', 'icon-alarmclock', 'icon-refresh', 'icon-happy', 'icon-sad', 'icon-facebook', 'icon-twitter', 'icon-googleplus', 'icon-rss', 'icon-tumblr', 'icon-linkedin', 'icon-dribbble'),
        )
	) 
);
// create boxes for team
add_action('admin_menu', 'add_post_meta_boxes');
if(!function_exists('add_post_meta_boxes')){	
	function add_post_meta_boxes()
	{
		global  $post_option_meta;
		add_meta_box($post_option_meta['id'], $post_option_meta['title'], 'show_post_options', $post_option_meta['page'], $post_option_meta['context'], $post_option_meta['priority']);
	}
}
if(!function_exists('show_post_options')){	
	function show_post_options()
	{
		global $post_option_meta, $post; $val = '';
		// Use nonce for verification
		echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
		echo '<table class="form-table">';
		foreach ($post_option_meta['fields'] as $field) {
			// get current post meta data
			$meta = '';
			$meta = get_post_meta($post->ID, $field['id'], true);
			switch ($field['type']) {
				case 'sidebarradio':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					if(empty($meta)){
						$meta = 'right';
					}
					foreach($field['option'] as $k=>$v){
						echo '<div class="', ($meta == $k) ? 'moto_chooseborder '
						: '' ,'moto-select-sidebar">
						<div style="display:none;">
						<input type="radio" value="'.$k.'" ',($meta == $k) ? 'checked'
						: '','  name="'.$field['id'].'" ></div>';
						echo '<img src="'.$v.'" alt=""></div>';
					}
				break;
				case 'select':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo'<select name="' . $field['id'] . '" id="' . $field['id'] . '">';
                foreach ($field['options'] as $option) {
                    echo'<option';
                    if ($meta == $option) {
                        echo ' selected="selected"';
						$val = $option;
                    }
                    echo' value="'.$option.'">' . $option . '</option>';
                }
                echo'</select>';
                break;
				case 'text':
					echo '<tr class="'.($val == 'video' ? '' : $field['cls']).'">',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta
						: stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
				case 'textarea':
                echo '<tr class="'.($val == 'quote' ? '' : $field['cls']).'">',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
				$args = array(
					'textarea_rows' => 5,
					'media_buttons' => false,
					'teeny' => true,
					'quicktags' => false,
					'tinymce'=> array(
						'toolbar1'=> 'bold,italic,underline,bullist,numlist,justifyleft,justifycenter,justifyright,undo,redo'
                    )
				);
				wp_editor($meta ? $meta : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), $field['id'],$args);
                break;		
			}
		}
		echo '</table>';
	}
}
add_action('save_post', 'post_save_options');
if(!function_exists('post_save_options')){	
	function post_save_options($post_id)
	{	
		global $post_option_meta;
		$new = '';
		// verify nonce
		if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
			return $post_id;
		}
		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}
		if (defined('DOING_AJAX') && DOING_AJAX)
			return;
		// check permissions
		if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
			if (!current_user_can('edit_page', $post_id)) {
				return $post_id;
			}
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}
	 
		foreach ($post_option_meta['fields'] as $field) {
			$old = get_post_meta($post_id, $field['id'], true);
			if (isset($_POST[$field['id']])) {
				 $new = $_POST[$field['id']];
			}
			if ($new && $new != $old) {
				update_post_meta($post_id, $field['id'], $new);
			} elseif ('' == $new && $old) {
				delete_post_meta($post_id, $field['id'], $old);
			}
		}
	}
}
/*********=========	End Post MetaBox   =========*********/

/*********=========	Start Team MetaBox   =========*********/
$team_option_meta = array(
    'id' => 'section-post-meta',
    'title' => __('Moto Team Setting','moto'),
    'page' => 'team',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
		array(
            'name' => __('designation', 'moto'),
            'desc' => __('Enter designation of member', 'moto'),
            'id' => $prefix.'designation',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'name' => __('Facebook link', 'moto'),
            'desc' => __('Enter facebook link', 'moto'),
            'id' => $prefix.'team_fb',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_fb_s',
            "type" => "social",
            'val' => 'facebook' 
        ),
		array(
            'name' => __('Twitter link', 'moto'),
            'desc' => __('Enter twitter link', 'moto'),
            'id' => $prefix.'team_twt',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_twt_s',
            "type" => "social",
            'val' => 'twitter' 
        ),
		array(
            'name' => __('Linkdin link', 'moto'),
            'desc' => __('Enter linkdin link', 'moto'),
            'id' => $prefix.'team_ld',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_ld_s',
            "type" => "social",
            'val' => 'linkdin' 
        ),
		array(
            'name' => __('Flickr link', 'moto'),
            'desc' => __('Enter flickr link', 'moto'),
            'id' => $prefix.'team_fkr',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_fkr_s',
            "type" => "social",
            'val' => 'flickr' 
        ),
		array(
            'name' => __('Youtube link', 'moto'),
            'desc' => __('Enter youtube link', 'moto'),
            'id' => $prefix.'team_yt',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_yt_s',
            "type" => "social",
            'val' => 'youtube' 
        ),
		array(
            'name' => __('Dribbble link', 'moto'),
            'desc' => __('Enter dribbble link', 'moto'),
            'id' => $prefix.'team_dr',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_dr_s',
            "type" => "social",
            'val' => 'dribbble' 
        ),
		array(
            'name' => __('Google Plus link', 'moto'),
            'desc' => __('Enter google plus link', 'moto'),
            'id' => $prefix.'team_gp',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_gp_s',
            "type" => "social",
            'val' => 'google_plus' 
        ),
		array(
            'name' => __('Skype link', 'moto'),
            'desc' => __('Enter skype link', 'moto'),
            'id' => $prefix.'team_sky',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_sky_s',
            "type" => "social",
            'val' => 'skype' 
        ),
		array(
            'name' => __('Pinterest link', 'moto'),
            'desc' => __('Enter pinterest link', 'moto'),
            'id' => $prefix.'team_pin',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_pin_s',
            "type" => "social",
            'val' => 'pinterest' 
        ),
		array(
            'name' => __('Vimeo link', 'moto'),
            'desc' => __('Enter vimeo link', 'moto'),
            'id' => $prefix.'team_vim',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_vim_s',
            "type" => "social",
            'val' => 'vimeo' 
        ),
		array(
            'name' => __('Instagram link', 'moto'),
            'desc' => __('Enter instagram link', 'moto'),
            'id' => $prefix.'team_ins',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'id' => $prefix.'team_ins_s',
            "type" => "social",
            'val' => 'instagram' 
        ),
	) 
);
// create boxes for team
add_action('admin_menu', 'add_team_meta_boxes');
if(!function_exists('add_team_meta_boxes')){	
	function add_team_meta_boxes()
	{
		global  $team_option_meta;
		add_meta_box($team_option_meta['id'], $team_option_meta['title'], 'show_team_options', $team_option_meta['page'], $team_option_meta['context'], $team_option_meta['priority']);
	}
}
if(!function_exists('show_team_options')){	
	function show_team_options()
	{
		global $team_option_meta, $post;
		// Use nonce for verification
		echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
		echo '<table class="form-table">';
		foreach ($team_option_meta['fields'] as $field) {
			// get current post meta data
			$meta = get_post_meta($post->ID, $field['id'], true);
			switch ($field['type']) {
				case 'text':
					echo '<tr id="rs_', $field['id'], '">',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta
						: stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
				case 'social':
					echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '" value="',$field['val'] , '" ';
					if(isset($meta) && $meta == $field['val']){
						echo ' checked ';
					}
					echo '/>';
                break;
			}
		}
		echo '</table>';
	}
}
add_action('save_post', 'team_save_options');
if(!function_exists('team_save_options')){	
	function team_save_options($post_id)
	{	
		global $team_option_meta;
		$new = '';
		// verify nonce
		if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
			return $post_id;
		}
		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}
		if (defined('DOING_AJAX') && DOING_AJAX)
			return;
		// check permissions
		if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
			if (!current_user_can('edit_page', $post_id)) {
				return $post_id;
			}
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}
	 
		foreach ($team_option_meta['fields'] as $field) {
			$old = get_post_meta($post_id, $field['id'], true);
			if (isset($_POST[$field['id']])) {
				 $new = $_POST[$field['id']];
			}
			if ($new && $new != $old) {
				update_post_meta($post_id, $field['id'], $new);
			} elseif ('' == $new && $old) {
				delete_post_meta($post_id, $field['id'], $old);
			}
		}
	}
}
/*********=========	End Team MetaBox   =========*********/

/*********=========	Start Portfolio MetaBox   =========*********/
$portfolio_option_meta = array(
    'id' => 'section-portfolio-meta',
    'title' => __('Moto portfolio Setting','moto'),
    'page' => 'portfolio',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
		array(
            'name' => __('Choose Sidebar Postion For This Section', 'moto'),
            'desc' => '',
            'id' => $prefix.'portfolio_sidebarposition',
            'type' => 'sidebarradio',
            'std' => 'right',
			'option' => array(
					'full' => PLUGIN_PATH.'/images/1col.png',
					'left' => PLUGIN_PATH.'/images/2cl.png',
					'right' => PLUGIN_PATH.'/images/2cr.png'
				)
        ),
		array(
            'name' => __('Number of related portfolio / enable it', 'moto'),
            'desc' => __('Enter integer value', 'moto'),
            'id' => $prefix.'portfolio_relatedpost',
            "type" => "text",
            'std' => '' 
        ),
		array( 
            'id' => $prefix.'enable',
            "type" => "checkbox",
            'val' => 'yes' 
        )
	) 
);
// create boxes for team
add_action('admin_menu', 'add_portfolio_meta_boxes');
if(!function_exists('add_portfolio_meta_boxes')){	
	function add_portfolio_meta_boxes()
	{
		global  $portfolio_option_meta;
		add_meta_box($portfolio_option_meta['id'], $portfolio_option_meta['title'], 'show_portfolio_options', $portfolio_option_meta['page'], $portfolio_option_meta['context'], $portfolio_option_meta['priority']);
	}
}
if(!function_exists('show_portfolio_options')){	
	function show_portfolio_options()
	{
		global $portfolio_option_meta, $post; $val = '';
		// Use nonce for verification
		echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
		echo '<table class="form-table">';
		foreach ($portfolio_option_meta['fields'] as $field) {
			// get current post meta data
			$meta = '';
			$meta = get_post_meta($post->ID, $field['id'], true);
			switch ($field['type']) {
				case 'sidebarradio':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					if(empty($meta)){
						$meta = 'right';
					}
					foreach($field['option'] as $k=>$v){
						echo '<div class="', ($meta == $k) ? 'moto_chooseborder '
						: '' ,'moto-select-sidebar">
						<div style="display:none;">
						<input type="radio" value="'.$k.'" ',($meta == $k) ? 'checked'
						: '','  name="'.$field['id'].'" ></div>';
						echo '<img src="'.$v.'" alt=""></div>';
					}
				break;
				case 'text':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta
						: stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
				case 'checkbox':
					echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '" value="',$field['val'] , '" ';
					if(isset($meta) && $meta == $field['val']){
						echo ' checked ';
					}
					echo '/>';
                break;
			}
		}
		echo '</table>';
	}
}
add_action('save_post', 'portfolio_save_options');
if(!function_exists('portfolio_save_options')){	
	function portfolio_save_options($post_id)
	{	
		global $portfolio_option_meta;
		$new = '';
		// verify nonce
		if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
			return $post_id;
		}
		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}
		if (defined('DOING_AJAX') && DOING_AJAX)
			return;
		// check permissions
		if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
			if (!current_user_can('edit_page', $post_id)) {
				return $post_id;
			}
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}
	 
		foreach ($portfolio_option_meta['fields'] as $field) {
			$old = get_post_meta($post_id, $field['id'], true);
			if (isset($_POST[$field['id']])) {
				 $new = $_POST[$field['id']];
			}
			if ($new && $new != $old) {
				update_post_meta($post_id, $field['id'], $new);
			} elseif ('' == $new && $old) {
				delete_post_meta($post_id, $field['id'], $old);
			}
		}
	}
}

$portfolio_Sort_description = array(
    'id' => 'section-Sort-Description-meta',
    'title' => __('Moto portfolio Sort Description Setting','moto'),
    'page' => 'portfolio',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
		array(
            'name' => __('Heading', 'moto'),
            'desc' => __('Enter Heading.', 'moto'),
            'id' => $prefix.'p_heading',
            "type" => "text",
            'std' => '' 
        ),
		array(
            'name' => 'Choose Portfolio Width',
            'desc' => '',
            'id' => $prefix.'portfolio_width', 
            'type' => 'select',
            'std' => 'select',
            'options' => array('select','w2'),
        )	
	) 
);
// create boxes for team
add_action('admin_menu', 'add_portfolio_Sort_description_meta_boxes');
if(!function_exists('add_portfolio_Sort_description_meta_boxes')){	
	function add_portfolio_Sort_description_meta_boxes()
	{
		global  $portfolio_Sort_description;
		add_meta_box($portfolio_Sort_description['id'], $portfolio_Sort_description['title'], 'show_portfolio_Sort_description_options', $portfolio_Sort_description['page'], $portfolio_Sort_description['context'], $portfolio_Sort_description['priority']);
	}
}
if(!function_exists('show_portfolio_Sort_description_options')){	
	function show_portfolio_Sort_description_options()
	{
		global $portfolio_Sort_description, $post; $val = '';
		// Use nonce for verification
		echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
		echo '<table class="form-table">';
		foreach ($portfolio_Sort_description['fields'] as $field) {
			// get current post meta data
			$meta = '';
			$meta = get_post_meta($post->ID, $field['id'], true);
			switch ($field['type']) {
				case 'text':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta
						: stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
				case 'select':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo'<select name="' . $field['id'] . '" id="' . $field['id'] . '">';
                foreach ($field['options'] as $option) {
                    echo'<option';
                    if ($meta == $option) {
                        echo ' selected="selected"';
						$val = $option;
                    }
                    echo' value="'.$option.'">' . $option . '</option>';
                }
                echo'</select>'; 
                break;
				case 'textarea':
                echo '<tr class="'.($val == 'quote' ? '' : $field['cls']).'">',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
				$args = array(
					'textarea_rows' => 5,
					'media_buttons' => false,
					'teeny' => true,
					'quicktags' => false,
					'tinymce'=> array(
						'toolbar1'=> 'bold,italic,underline,bullist,numlist,justifyleft,justifycenter,justifyright,undo,redo'
                    )
				);
				wp_editor($meta ? $meta : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), $field['id'],$args);
                break;
			}
		}
		echo '</table>';
	}
}
add_action('save_post', 'portfolio_save_Sort_description_options');
if(!function_exists('portfolio_save_Sort_description_options')){	
	function portfolio_save_Sort_description_options($post_id)
	{	
		global $portfolio_Sort_description;
		$new = '';
		// verify nonce
		if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
			return $post_id;
		}
		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}
		if (defined('DOING_AJAX') && DOING_AJAX)
			return;
		// check permissions
		if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
			if (!current_user_can('edit_page', $post_id)) {
				return $post_id;
			}
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}
	 
		foreach ($portfolio_Sort_description['fields'] as $field) {
			$old = get_post_meta($post_id, $field['id'], true);
			if (isset($_POST[$field['id']])) {
				 $new = $_POST[$field['id']];
			}
			if ($new && $new != $old) {
				update_post_meta($post_id, $field['id'], $new);
			} elseif ('' == $new && $old) {
				delete_post_meta($post_id, $field['id'], $old);
			}
		}
	}
}
/*********=========	End Portfolio MetaBox   =========*********/

/*********=========	Start service MetaBox   =========*********/
$service_option_meta = array(
    'id' => 'section-service-meta',
    'title' => __('Moto service Setting','moto'),
    'page' => 'service',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(	
		array(
            'name' => __('Sub title', 'moto'),
            'desc' => __('Enter Sub title.', 'moto'),
            'id' => $prefix.'s_subtitle',
            "type" => "text",
            'std' => '' 
        ),	
		array(
            'name' => 'Choose image or icon for the service.',
            'desc' => 'This option will only work for service Style 1,2 and 3.',
            'id' => $prefix.'service_icon', 
            'type' => 'select',
            'std' => 'select',
            'options' => array('Select', 'Image' , 'Icon'),
        ),
		array(
            'name' => 'Image',
            'desc' => '',
            'id' => $prefix.'service_img_icon', 
            'type' => 'mt_media',
            'std' => '',
			'cls' => 'hide_row remove_hide_cls_img'
        ),
		array(
            'name' => 'Choose icon',
            'desc' => '',
            'id' => $prefix.'s_iconcls', 
            'type' => 'select',
            'std' => 'select',
            'options' => array('select','icon-mobile', 'icon-laptop', 'icon-desktop', 'icon-tablet', 'icon-phone', 'icon-document', 'icon-documents', 'icon-search', 'icon-clipboard', 'icon-newspaper', 'icon-notebook', 'icon-book-open', 'icon-browser', 'icon-calendar', 'icon-presentation', 'icon-picture', 'icon-pictures', 'icon-video', 'icon-camera', 'icon-printer', 'icon-toolbox', 'icon-briefcase', 'icon-wallet', 'icon-gift', 'icon-bargraph', 'icon-grid', 'icon-expand', 'icon-focus', 'icon-edit', 'icon-adjustments', 'icon-ribbon', 'icon-hourglass', 'icon-lock', 'icon-megaphone', 'icon-shield', 'icon-trophy', 'icon-flag', 'icon-map', 'icon-puzzle', 'icon-basket', 'icon-envelope', 'icon-streetsign', 'icon-telescope', 'icon-gears', 'icon-key', 'icon-paperclip', 'icon-attachment', 'icon-pricetags', 'icon-lightbulb', 'icon-layers', 'icon-pencil', 'icon-tools', 'icon-tools-2', 'icon-scissors', 'icon-paintbrush', 'icon-magnifying-glass', 'icon-circle-compass', 'icon-linegraph', 'icon-mic', 'icon-strategy', 'icon-beaker', 'icon-caution', 'icon-recycle', 'icon-anchor', 'icon-profile-male', 'icon-profile-female', 'icon-bike', 'icon-wine', 'icon-hotairballoon', 'icon-globe', 'icon-genius', 'icon-map-pin', 'icon-dial', 'icon-chat', 'icon-heart', 'icon-cloud', 'icon-upload', 'icon-download', 'icon-target', 'icon-hazardous', 'icon-piechart', 'icon-speedometer', 'icon-global', 'icon-compass', 'icon-lifesaver', 'icon-clock', 'icon-aperture', 'icon-quote', 'icon-scope', 'icon-alarmclock', 'icon-refresh', 'icon-happy', 'icon-sad', 'icon-facebook', 'icon-twitter', 'icon-googleplus', 'icon-rss', 'icon-tumblr', 'icon-linkedin', 'icon-dribbble'),
			'cls' => 'hide_row remove_hide_cls_icon'
        )	
	) 
);
// create boxes for team
add_action('admin_menu', 'add_service_meta_boxes');
if(!function_exists('add_service_meta_boxes')){	
	function add_service_meta_boxes()
	{
		global  $service_option_meta;
		add_meta_box($service_option_meta['id'], $service_option_meta['title'], 'show_service_options', $service_option_meta['page'], $service_option_meta['context'], $service_option_meta['priority']);
	}
}
if(!function_exists('show_service_options')){	
	function show_service_options()
	{
		global $service_option_meta, $post; $val = '';
		// Use nonce for verification
		echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
		echo '<table class="form-table">';
		foreach ($service_option_meta['fields'] as $field) {
			// get current service meta data
			$meta = '';
			$meta = get_post_meta($post->ID, $field['id'], true);
			switch ($field['type']) {
				
				case 'select':
                echo '<tr class="'.($val == 'Icon' ? '' : $field['cls']).'">',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo'<select name="' . $field['id'] . '" id="' . $field['id'] . '">';
                foreach ($field['options'] as $option) {
                    echo'<option';
                    if ($meta == $option) {
                        echo ' selected="selected"';
						$val = $option;
                    }
                    echo' value="'.$option.'">' . $option . '</option>';
                }
                echo'</select>'; 
                break;
				
				case 'text':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta
						: stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
								
				case 'mt_media':
                echo '<tr class="'.($val == 'Image' ? '' : $field['cls']).'">',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo '<input type="text" size="36" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : '','" />
				<input class="button button-primary button-large moto_upload_file" type="button" value="'.esc_html__('Upload Image', 'moto').'" />'; 
                break;
				
				
				
			}
		}
		echo '</table>';
	}
}
add_action('save_post', 'service_save_options');
if(!function_exists('service_save_options')){	
	function service_save_options($post_id)
	{	
		global $service_option_meta;
		$new = '';
		// verify nonce
		if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
			return $post_id;
		}
		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}
		if (defined('DOING_AJAX') && DOING_AJAX)
			return;
		// check permissions
		if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
			if (!current_user_can('edit_page', $post_id)) {
				return $post_id;
			}
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}
	 
		foreach ($service_option_meta['fields'] as $field) {
			$old = get_post_meta($post_id, $field['id'], true);
			if (isset($_POST[$field['id']])) {
				 $new = $_POST[$field['id']];
			}
			if ($new && $new != $old) {
				update_post_meta($post_id, $field['id'], $new);
			} elseif ('' == $new && $old) {
				delete_post_meta($post_id, $field['id'], $old);
			}
		}
	}
}

/*********=========	Start Product MetaBox   =========*********/
$product_option_meta = array(
    'id' => 'section-product-meta',
    'title' => __('Moto Product Setting','moto'),
    'page' => 'product',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(	
		array(
            'name' => __('Single Header title', 'moto'),
            'desc' => __('Enter Header title', 'moto'),
            'id' => $prefix.'product_header_title',
            "type" => "text",
            'std' => '' 
        ),	  
		array(
            'name' => __('Choose Sidebar Postion For This Section', 'moto'),
            'desc' => '',
            'id' => $prefix.'product_sidebarposition',
            'type' => 'sidebarradio',
            'std' => 'right',
			'option' => array(
					'full' => PLUGIN_PATH.'/images/1col.png',
					'left' => PLUGIN_PATH.'/images/2cl.png',
					'right' => PLUGIN_PATH.'/images/2cr.png'
				)
        ),
	) 
);
// create boxes for team
add_action('admin_menu', 'add_product_meta_boxes');
if(!function_exists('add_product_meta_boxes')){	
	function add_product_meta_boxes()
	{
		global  $product_option_meta;
		add_meta_box($product_option_meta['id'], $product_option_meta['title'], 'show_product_options', $product_option_meta['page'], $product_option_meta['context'], $product_option_meta['priority']);
	}
}
if(!function_exists('show_product_options')){	
	function show_product_options()
	{
		global $product_option_meta, $post; $val = '';
		// Use nonce for verification
		echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
		echo '<table class="form-table">';
		foreach ($product_option_meta['fields'] as $field) {
			// get current product meta data
			$meta = '';
			$meta = get_post_meta($post->ID, $field['id'], true);
			switch ($field['type']) {
				case 'sidebarradio':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					if(empty($meta)){ 
					  
						$meta = 'right';
					}  
					foreach($field['option'] as $k=>$v){
						echo '<div class="', ($meta == $k) ? 'moto_chooseborder '
						: '' ,'moto-select-sidebar">
						<div style="display:none;">
						<input type="radio" value="'.$k.'" ',($meta == $k) ? 'checked'
						: '','  name="'.$field['id'].'" ></div>';
						echo '<img src="'.$v.'" alt=""></div>';
					}
				break;
				case 'select':
                echo '<tr>',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
                echo'<select name="' . $field['id'] . '" id="' . $field['id'] . '">';
                foreach ($field['options'] as $option) {
                    echo'<option';
                    if ($meta == $option) {
                        echo ' selected="selected"';
						$val = $option;
                    }
                    echo' value="'.$option.'">' . $option . '</option>';
                }
                echo'</select>'; 
                break;
				case 'text':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? stripslashes(htmlspecialchars(($meta), ENT_QUOTES))
						: stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
				case 'textarea':
                echo '<tr class="'.($val == 'quote' ? '' : $field['cls']).'">',
                '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
                '<td>';
				$args = array(
					'textarea_rows' => 5,
					'media_buttons' => false,
					'teeny' => true,
					'quicktags' => false,
					'tinymce'=> array(
						'toolbar1'=> 'bold,italic,underline,bullist,numlist,justifyleft,justifycenter,justifyright,undo,redo'
                    )
				);
				wp_editor($meta ? $meta : stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), $field['id'],$args);
                break;
			}
		}
		echo '</table>';
	}
}
add_action('save_post', 'product_save_options');
if(!function_exists('product_save_options')){	
	function product_save_options($post_id)
	{	
		global $product_option_meta;
		$new = '';
		// verify nonce
		if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
			return $post_id;
		}
		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}
		if (defined('DOING_AJAX') && DOING_AJAX)
			return;
		// check permissions
		if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
			if (!current_user_can('edit_page', $post_id)) {
				return $post_id;
			}
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}
	 
		foreach ($product_option_meta['fields'] as $field) {
			$old = get_post_meta($post_id, $field['id'], true);
			if (isset($_POST[$field['id']])) {
				 $new = $_POST[$field['id']];
			}
			if ($new && $new != $old) {
				update_post_meta($post_id, $field['id'], $new);
			} elseif ('' == $new && $old) {
				delete_post_meta($post_id, $field['id'], $old);
			}
		}
	}
}
/*********=========	Start Video MetaBox   =========*********/
$video_option_meta = array(
    'id' => 'section-video-meta',
    'title' => __('Moto Video Setting','moto'),
    'page' => 'video',
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
		array(
            'name' => __('Choose Sidebar Postion For This Section', 'moto'),
            'desc' => '',
            'id' => $prefix.'video_sidebarposition',
            'type' => 'sidebarradio',
            'std' => 'full',
			'option' => array(
					'full' => PLUGIN_PATH.'/images/1col.png',
					'left' => PLUGIN_PATH.'/images/2cl.png',
					'right' => PLUGIN_PATH.'/images/2cr.png'
				)
        ),
		array(
            'name' => __('Select Footer', 'moto'),
            'desc' => '',
            'id' => $prefix.'footer_s',
            'type' => 'select',
            'options' => array('footer-1'=>'footer - 1','footer-2'=>'footer - 2')
        ),
		array(
            'name' => __('Vodeo URL', 'moto'),
            'desc' => '',
            'id' => $prefix.'video_url',
            'type' => 'text',
            'std' => ''
        ),
		array(
            'name' => __('Video Author Name', 'moto'),
            'desc' => '',
            'id' => $prefix.'video_author',
            'type' => 'text',
            'std' => ''
        ),
		array(
            'name' => __('Number Of Related Videos', 'moto'),
            'desc' => 'This Videos will disply only on video single page, if they all have same categories.',
            'id' => $prefix.'related_videos',
            'type' => 'text',
            'std' => ''
        )
	)
       
);

add_action('admin_menu', 'add_video_meta_boxes');
if(!function_exists('add_video_meta_boxes')){	
	function add_video_meta_boxes()
	{
		global  $video_option_meta;
		add_meta_box($video_option_meta['id'], $video_option_meta['title'], 'show_video_options', $video_option_meta['page'], $video_option_meta['context'], $video_option_meta['priority']);
	}
}
if(!function_exists('show_video_options')){	
	function show_video_options()
	{
		global $video_option_meta, $post;
		// Use nonce for verification
		echo '<input type="hidden" name="meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
		echo '<table class="form-table">';
		foreach ($video_option_meta['fields'] as $field) {
			// get current post meta data
			$meta = get_post_meta($post->ID, $field['id'], true);
			switch ($field['type']) {
				case 'sidebarradio':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					if(empty($meta)){
						$meta = 'full';
					}
					foreach($field['option'] as $k=>$v){
						echo '<div class="', ($meta == $k) ? 'moto_chooseborder '
						: '' ,'moto-select-sidebar">
						<div style="display:none;">
						<input type="radio" value="'.$k.'" ',($meta == $k) ? 'checked'
						: '','  name="'.$field['id'].'" ></div>';
						echo '<img src="'.$v.'" alt=""></div>';
					}
				break;
				
				case 'text':
					echo '<tr>',
					'<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#999; margin:5px 0 0 0; line-height: 18px;">' . $field['desc'] . '</span></label></th>',
					'<td>';
					echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? stripslashes(htmlspecialchars(($meta), ENT_QUOTES))
						: stripslashes(htmlspecialchars(($field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
                break;
			}
		}
		echo '</table>';
	}
}
add_action('save_post', 'video_save_options');
if(!function_exists('video_save_options')){	
	function video_save_options($post_id)
	{	
		global $video_option_meta;
		$new = '';
		// verify nonce
		if (isset($_POST['meta_box_nonce']) && !wp_verify_nonce($_POST['meta_box_nonce'], basename(__FILE__))) {
			return $post_id;
		}
		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}
		if (defined('DOING_AJAX') && DOING_AJAX)
			return;
		// check permissions
		if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
			if (!current_user_can('edit_page', $post_id)) {
				return $post_id;
			}
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}
	 
		foreach ($video_option_meta['fields'] as $field) {
			$old = get_post_meta($post_id, $field['id'], true);
			if (isset($_POST[$field['id']])) {
				 $new = $_POST[$field['id']];
			}
			if ($new && $new != $old) {
				update_post_meta($post_id, $field['id'], $new);
			} elseif ('' == $new && $old) {
				delete_post_meta($post_id, $field['id'], $old);
			}
		}
	}
}
/*********=========	End Page MetaBox   =========*********/