<?php
/* contact form with info */
class Contact_W_info_Widget extends WP_Widget {
	function __construct() {
		parent::__construct(
			'Contact_W_info_Widget', // Base ID
			esc_html__('Contact form with infomation', 'moto'), // Name
			array( 'description' => esc_html__( 'Footer Contact form with infomation', 'moto' ), ) // Args
		);
	} 
	public function widget( $args, $instance ) {
		
		$title = (!empty($instance[ 'title' ]) ? $instance[ 'title' ] : '');
		$email = (!empty($instance[ 'email' ]) ? $instance[ 'email' ] : '');
		$twt_id = (!empty($instance[ 'twt_id' ]) ? $instance[ 'twt_id' ] : '');
		$phone = (!empty($instance[ 'phone' ]) ? $instance[ 'phone' ] : '');
		$addrs = (!empty($instance[ 'addrs' ]) ? $instance[ 'addrs' ] : '');
		$form = (!empty($instance[ 'form' ]) ? $instance[ 'form' ] : '');
		$name_place = (!empty($instance[ 'name_place' ]) ? $instance[ 'name_place' ] : 'name');
		$email_place = (!empty($instance[ 'email_place' ]) ? $instance[ 'email_place' ] : 'email');
		$phone_place = (!empty($instance[ 'phone_place' ]) ? $instance[ 'phone_place' ] : 'phone');
		$subject_place = (!empty($instance[ 'subject_place' ]) ? $instance[ 'subject_place' ] : 'subject');
		$message_place = (!empty($instance[ 'message_place' ]) ? $instance[ 'message_place' ] : 'message');
		$button_place = (!empty($instance[ 'button_place' ]) ? $instance[ 'button_place' ] : 'Send Message');
		echo '<div class="row no-margin text-center"><hr>
		<h4 class="invo_heading">'.esc_html($title).'</h4></div>';
		echo '<div class="col-md-3 col-sm-6 contact-info text-center"> <span class="icon-envelope"></span>
        <h5 class="accent lowercase">'.esc_html($email).'</h5>
		</div>';
		echo '<div class="col-md-3 col-sm-6 contact-info text-center"> <span class="icon-twitter"></span>
        <h5 class="accent lowercase">'.esc_html($twt_id).'</h5>
		</div>';
		echo '<div class="col-md-3 col-sm-6 contact-info text-center"> <span class="icon-phone"></span>
        <h5 class="accent lowercase">'.esc_html($phone).'</h5>
		</div>';
		echo '<div class="col-md-3 col-sm-6 contact-info text-center"> <span class="icon-map-pin"></span>
        <h5 class="accent">'.esc_html($addrs).'</h5>
		</div>';
		
		global $redux_moto;
	
		wp_register_script('jquery_validation', get_template_directory_uri() . '/js/validation.js', array('jquery'),null,true); 
		wp_enqueue_script('jquery_validation');
		
		$fields = $redux_moto['moto_fieldsenable_disable'];
		$require = $redux_moto['moto_fieldsrequire'];
		$validate = $txt = '';
		if(is_array($fields['ENABLE']) && $form){
			echo '<form method="post" id="moto_contactform">';
			echo '<div class="col-sm-6">';
			foreach($fields['ENABLE'] as $key=>$val){
				switch($key){
					case 'NAME':
						if(isset($require['REQUIRE']['NAME'])){
							$validate = 'data-validation=\'required\'';
							$txt = '*';
						}	
						echo '<div><input type="text" '.($validate).' class="form-control" value="" placeholder="'.esc_html($name_place).esc_attr($txt).'" name="name" /></div>';
					break;
					case 'EMAIL' :
						if(isset($require['REQUIRE']['EMAIL'])){
							$validate = 'data-validation="email"';
							$txt = '*';
						}
						echo '<div><input type="text" '.($validate).' class="form-control" value="" placeholder="'.esc_html($email_place).esc_attr($txt).'" name="email" /></div>';
					break;
					case 'PHONENUMBER' :
						if(isset($require['REQUIRE']['PHONENUMBER'])){
							$validate = 'data-validation="number"';
							$txt = '*';
						}
						echo'<div><input type="text" '.($validate).' class="form-control" value="" placeholder="'.esc_html($phone_place).esc_attr($txt).'" name="phono" /></div>';
					break;
					case 'SUBJECT':
						if(isset($require['REQUIRE']['SUBJECT'])){
							$validate = 'data-validation=\'required\'';
							$txt = '*';
						}
						echo '<div><input type="text" '.($validate).' class="form-control" value="" placeholder="'.esc_html($subject_place).esc_attr($txt).'" name="subject" /></div>';
					break;
				}
				$validate = $txt = '';
			}
			$validate = 'data-validation="required"';
			$txt = '*';
			echo '</div>';
			echo '<div class="col-sm-6"><textarea name="Message" class="form-control" id="Message" '.($validate).' rows="10" placeholder="'.esc_html($message_place).esc_attr($txt).'"></textarea></div>';
			echo '<div class="col-xs-12 text-center top_spacer20"> <a href="" class="btn btn-accent send_mail">'.esc_html($button_place).'<i class="fa fa-long-arrow-right"></i></a> <img src="'.get_template_directory_uri().'/images/ajax-loader.gif" class="moto_loading" alt=""> <input type="hidden" value="'.admin_url('admin-ajax.php').'"  id="moto_ajaxurl"><span id="success_mes"></span></div>';
			echo '</form>';
		}
	}
	public function form( $instance ) {
	$title = $email = $twt_id = $phone = $addrs = $form = '';
		$title = (!empty($instance[ 'title' ]) ? $instance[ 'title' ] : '');
		$email = (!empty($instance[ 'email' ]) ? $instance[ 'email' ] : '');
		$twt_id = (!empty($instance[ 'twt_id' ]) ? $instance[ 'twt_id' ] : '');
		$phone = (!empty($instance[ 'phone' ]) ? $instance[ 'phone' ] : '');
		$addrs = (!empty($instance[ 'addrs' ]) ? $instance[ 'addrs' ] : '');
		$form = (!empty($instance[ 'form' ]) ? $instance[ 'form' ] : '');
		$name_place = (!empty($instance[ 'name_place' ]) ? $instance[ 'name_place' ] : 'name');
		$email_place = (!empty($instance[ 'email_place' ]) ? $instance[ 'email_place' ] : 'email');
		$phone_place = (!empty($instance[ 'phone_place' ]) ? $instance[ 'phone_place' ] : 'phone');
		$subject_place = (!empty($instance[ 'subject_place' ]) ? $instance[ 'subject_place' ] : 'subject');
		$message_place = (!empty($instance[ 'message_place' ]) ? $instance[ 'message_place' ] : 'message');
		$button_place = (!empty($instance[ 'button_place' ]) ? $instance[ 'button_place' ] : 'Send Message');
		
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php echo esc_html__('Title:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'email' ); ?>"><?php echo esc_html__('Email Id','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'email' ); ?>" name="<?php echo $this->get_field_name( 'email' ); ?>" type="text" value="<?php echo esc_attr( $email ); ?>">
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'twt_id' ); ?>"><?php echo esc_html__('Twitter Username','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'twt_id' ); ?>" name="<?php echo $this->get_field_name( 'twt_id' ); ?>" type="text" value="<?php echo esc_attr( $twt_id ); ?>">
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'phone' ); ?>"><?php echo esc_html__('Phone Number','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'phone' ); ?>" name="<?php echo $this->get_field_name( 'phone' ); ?>" type="text" value="<?php echo esc_attr( $phone ); ?>">
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'addrs' ); ?>"><?php echo esc_html__('Google Map Address','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'addrs' ); ?>" name="<?php echo $this->get_field_name( 'addrs' ); ?>" type="text" value="<?php echo esc_attr( $addrs ); ?>">
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'form' ); ?>"><?php echo esc_html__('contact form','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'form' ); ?>" name="<?php echo $this->get_field_name( 'form' ); ?>" type="checkbox" value="1" <?php checked(isset($instance['form']) ? $instance['form'] : 0); ?> >
		</p>
		<h2><?php echo esc_html__('Placeholders For The Form:', 'moto')?></h2>
		<p>
		<label for="<?php echo $this->get_field_id( 'name_place' ); ?>"><?php echo esc_html__('Name:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'name_place' ); ?>" name="<?php echo $this->get_field_name( 'name_place' ); ?>" type="text" value="<?php echo esc_attr( $name_place ); ?>">
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'email_place' ); ?>"><?php echo esc_html__('Email:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'email_place' ); ?>" name="<?php echo $this->get_field_name( 'email_place' ); ?>" type="text" value="<?php echo esc_attr( $email_place ); ?>">
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'phone_place' ); ?>"><?php echo esc_html__('Phone:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'phone_place' ); ?>" name="<?php echo $this->get_field_name( 'phone_place' ); ?>" type="text" value="<?php echo esc_attr( $phone_place ); ?>">
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'subject_place' ); ?>"><?php echo esc_html__('Subject:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'subject_place' ); ?>" name="<?php echo $this->get_field_name( 'subject_place' ); ?>" type="text" value="<?php echo esc_attr( $subject_place ); ?>">
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'message_place' ); ?>"><?php echo esc_html__('Message','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'message_place' ); ?>" name="<?php echo $this->get_field_name( 'message_place' ); ?>" type="text" value="<?php echo esc_attr( $message_place ); ?>">
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'button_place' ); ?>"><?php echo esc_html__('Button Text','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'button_place' ); ?>" name="<?php echo $this->get_field_name( 'button_place' ); ?>" type="text" value="<?php echo esc_attr( $button_place ); ?>">
		</p>
		
		<?php 
	}
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['email'] = ( ! empty( $new_instance['email'] ) ) ? strip_tags( $new_instance['email'] ) : '';
		$instance['twt_id'] = ( ! empty( $new_instance['twt_id'] ) ) ? strip_tags( $new_instance['twt_id'] ) : '';
		$instance['phone'] = ( ! empty( $new_instance['phone'] ) ) ? strip_tags( $new_instance['phone'] ) : '';
		$instance['addrs'] = ( ! empty( $new_instance['addrs'] ) ) ? strip_tags( $new_instance['addrs'] ) : '';
		$instance['form'] = ( ! empty( $new_instance['form'] ) ) ? strip_tags( $new_instance['form'] ) : '';
		$instance['name_place'] = ( ! empty( $new_instance['name_place'] ) ) ? strip_tags( $new_instance['name_place'] ) : '';
		$instance['email_place'] = ( ! empty( $new_instance['email_place'] ) ) ? strip_tags( $new_instance['email_place'] ) : '';
		$instance['phone_place'] = ( ! empty( $new_instance['phone_place'] ) ) ? strip_tags( $new_instance['phone_place'] ) : '';
		$instance['subject_place'] = ( ! empty( $new_instance['subject_place'] ) ) ? strip_tags( $new_instance['subject_place'] ) : '';
		$instance['message_place'] = ( ! empty( $new_instance['message_place'] ) ) ? strip_tags( $new_instance['message_place'] ) : '';
		$instance['button_place'] = ( ! empty( $new_instance['button_place'] ) ) ? strip_tags( $new_instance['button_place'] ) : '';
		
		return $instance;
	}
}
function register_contact_w_info_widgets() {
    register_widget( 'Contact_W_info_Widget' );
}
add_action( 'widgets_init', 'register_contact_w_info_widgets' );
/* contact form with info */

/* photo stream */
class Photo_Stream_Widget extends WP_Widget {
	function __construct() {
		parent::__construct(
			'Photo_Stream_Widget', // Base ID
			esc_html__('Moto Photo Stream Flickr', 'moto'), // Name
			array( 'description' => esc_html__( 'Footer Photo Stream Widget', 'moto' ), ) // Args
		);
	} 
	public function widget( $args, $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
			$no_of_photos = $instance[ 'no_of_photos' ];
			$f_apikey = $instance[ 'f_apikey' ];
			$f_usenm = $instance[ 'f_usenm' ];
		}else {
			$title = 'Photo Stream';
			$no_of_photos = '9';
			$f_apikey = '';
			$f_usenm = '';
		} 
		
		if(!empty($f_apikey) && !empty($f_usenm)){
			require_once PLUGIN_PATH_CORE."extra/flickr/phpFlickr.php";
			$f = new phpFlickr(esc_attr($f_apikey));
			$result = $f->people_findByUsername(esc_attr($f_usenm));
			$nsid = $result["id"];
			$recent = $f->people_getPhotos($nsid,array('per_page'=>$no_of_photos));
			echo $args['before_widget'];
			echo '<div class="flickr-gallery">',$args['before_title'] , esc_attr($title) ,$args['after_title'];
			if(isset($recent['photos']['photo'])){
				foreach ($recent['photos']['photo'] as $photo) {
					echo "<div class=\"f-img\">";
					echo "<img src=\"" . esc_url($f->buildPhotoURL($photo, "Square")) .  "\" width=\"88\" height=\"88\" alt=\"$photo[title]\" class='fadein' />";
					echo "<a class=\"overlay\" target='_blank' href='".esc_url($f->buildPhotoURL($photo))."' data-rel=\"prettyPhoto\"  title=\"View $photo[title]\"><i class=\"fa fa-search accent\"></i>";
					echo "</a>","</div>";
				}
			}
			echo '</div>';
			echo $args['after_widget'];
		}
	}
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) || isset( $instance[ 'no_of_photos' ] ) ) {
			$title = $instance[ 'title' ];
			$no_of_photos = $instance[ 'no_of_photos' ];
			$f_apikey = $instance[ 'f_apikey' ];
			$f_usenm = $instance[ 'f_usenm' ];
		}
		else {
			$title = 'Photo Stream';
			$no_of_photos = '9';
			$f_apikey = '';
			$f_usenm = '';
		}
		
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php echo esc_html__('Title:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'f_apikey' ); ?>"><?php echo esc_html__('Flickr API Key','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'f_apikey' ); ?>" name="<?php echo $this->get_field_name( 'f_apikey' ); ?>" type="text" value="<?php echo esc_attr( $f_apikey ); ?>">
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'f_usenm' ); ?>"><?php echo esc_html__('Flicker Username','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'f_usenm' ); ?>" name="<?php echo $this->get_field_name( 'f_usenm' ); ?>" type="text" value="<?php echo esc_attr( $f_usenm ); ?>">
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'no_of_photos' ); ?>"><?php echo esc_html__('No Of Photos:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'no_of_photos' ); ?>" name="<?php echo $this->get_field_name( 'no_of_photos' ); ?>" type="text" value="<?php echo esc_attr( $no_of_photos ); ?>">
		</p>
		  <?php 
	}
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['no_of_photos'] = ( ! empty( $new_instance['no_of_photos'] ) ) ? strip_tags( $new_instance['no_of_photos'] ) : '';
		$instance['f_apikey'] = ( ! empty( $new_instance['f_apikey'] ) ) ? strip_tags( $new_instance['f_apikey'] ) : '';
		
		$instance['f_usenm'] = ( ! empty( $new_instance['f_usenm'] ) ) ? strip_tags( $new_instance['f_usenm'] ) : '';
		
		return $instance;
	}
}
function register_photo_stream_widgets() {
    register_widget( 'Photo_Stream_Widget' );
}
add_action( 'widgets_init', 'register_photo_stream_widgets' );
/* photo stream */

/* Twitter Feed */
class Twitter_feed extends WP_Widget {
	function __construct() {
		parent::__construct(
			'Twitter_feed', // Base ID
			esc_html__('Moto Twitter Feed', 'moto'), // Name
			array( 'description' => esc_html__( 'Footer Twitter Feed Widget', 'moto' ), ) // Args
		);
	} 
	public function widget( $args, $instance ) {
		
		$title = ( !empty($instance[ 'title' ]) ? $instance[ 'title' ] : '');
		$key = ( !empty($instance[ 'consumer_key' ]) ? $instance[ 'consumer_key' ] : '');
		$secret = ( !empty($instance[ 'consumer_secret' ]) ? $instance[ 'consumer_secret' ] : '');
		$access_token = ( !empty($instance[ 'oauth_access_token' ]) ? $instance[ 'oauth_access_token' ] : '');
		$access_token_secret = ( !empty($instance[ 'oauth_access_token_secret' ]) ? $instance[ 'oauth_access_token_secret' ] : '');
		$count = ( !empty($instance[ 'count_feed' ]) ? $instance[ 'count_feed' ] : '2');
		$username = ( !empty($instance[ 'username' ]) ? $instance[ 'username' ] : '');
		
		require_once (PLUGIN_PATH_CORE . 'extra/twitter/TwitterAPIExchange.php');
		/** Set access tokens here - see: https://dev.twitter.com/apps/ **/
		echo $args['before_widget'];
		if(!empty($instance['oauth_access_token']) && !empty($instance['oauth_access_token_secret']) && !empty($instance['consumer_key']) && !empty($instance['consumer_secret']) ){
			$settings = array(
				'oauth_access_token' => esc_attr($access_token),
				'oauth_access_token_secret' => esc_attr($access_token_secret),
				'consumer_key' => esc_attr($key),
				'consumer_secret' => esc_attr($secret)
			);
			$url = 'https://api.twitter.com/1.1/statuses/user_timeline.json';
			$getfield = '?username='.esc_html($username).'&skip_status=1';
			$requestMethod = 'GET';
			$twitter = new TwitterAPIExchange($settings);
			$twisss= $twitter->setGetfield($getfield)->buildOauth($url, $requestMethod)->performRequest(); 
			$myarr=json_decode($twisss);
			if(!$myarr){
				echo ' <div class="item"> 
				<div class="hs_twitter_feed_content">
				<h4>'.esc_html__('YOu have not created the twitter app , Please create the twitter app for your site. Thankyou','moto').'</h4>
				</div>
				</div>';
			}else{
				echo  $args['before_title'] . esc_attr($title) . $args['after_title'];
				for($i=0;$i<$count;$i++)
				{
					echo '<div class="row no-margin twitter-feed"><i class="fa fa-twitter icon accent"></i>
					<div class="content"> <p class="white">'.esc_attr($myarr[$i]->text).'</p>
                    <p>'.esc_html__(human_time_diff( strtotime($myarr[$i]->created_at), strtotime(date('Y-m-d H:i:s')) ).' Ago','moto').'</p>
                  </div>
                </div>';
				}
			}
		}else{
			echo ' <div class="item"> 
				<div class="hs_twitter_feed_content">
				<h2>'.esc_html__('YOu have not created the twitter app , Please create the twitter app for your site. Thankyou','moto').'</h2>
				</div>
				</div>';
		}
		echo $args['after_widget'];
	}
	public function form( $instance ) {
		$title = ( !empty($instance[ 'title' ]) ? $instance[ 'title' ] : '');
		$key = ( !empty($instance[ 'consumer_key' ]) ? $instance[ 'consumer_key' ] : '');
		$secret = ( !empty($instance[ 'consumer_secret' ]) ? $instance[ 'consumer_secret' ] : '');
		$access_token = ( !empty($instance[ 'oauth_access_token' ]) ? $instance[ 'oauth_access_token' ] : '');
		$access_token_secret = ( !empty($instance[ 'oauth_access_token_secret' ]) ? $instance[ 'oauth_access_token_secret' ] : '');
		$count = ( !empty($instance[ 'count_feed' ]) ? $instance[ 'count_feed' ] : '2');
		$username = ( !empty($instance[ 'username' ]) ? $instance[ 'username' ] : '');
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php echo esc_html__('Title:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php if(isset($title)) echo esc_attr( $title ); ?>">
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'count_feed' ); ?>"><?php echo esc_html__('Show No Of Feed:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'count_feed' ); ?>" name="<?php echo $this->get_field_name( 'count_feed' ); ?>" type="text" value="<?php if(isset($count)) echo esc_attr( $count ); ?>">
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'username' ); ?>"><?php echo esc_html__('twitter username:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'username' ); ?>" name="<?php echo $this->get_field_name( 'username' ); ?>" type="text" value="<?php if(isset($username)) echo esc_attr( $username ); ?>">
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'consumer_key' ); ?>"><?php echo esc_html__('Consumer Key:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'consumer_key' ); ?>" name="<?php echo $this->get_field_name( 'consumer_key' ); ?>" type="text" value="<?php if(isset($key)) echo esc_attr( $key ); ?>">
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'consumer_secret' ); ?>"><?php echo esc_html__('Consumer Secret:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'consumer_secret' ); ?>" name="<?php echo $this->get_field_name( 'consumer_secret' ); ?>" type="text" value="<?php if(isset($secret)) echo esc_attr( $secret ); ?>">
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'oauth_access_token' ); ?>"><?php echo esc_html__('Access Token:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'oauth_access_token' ); ?>" name="<?php echo $this->get_field_name( 'oauth_access_token' ); ?>" type="text" value="<?php if(isset($access_token)) echo esc_attr( $access_token ); ?>">
		</p>
		<p>
		<label for="<?php echo $this->get_field_id( 'oauth_access_token_secret' ); ?>"><?php echo esc_html__('Access Token Secret:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'oauth_access_token_secret' ); ?>" name="<?php echo $this->get_field_name( 'oauth_access_token_secret' ); ?>" type="text" value="<?php if(isset($access_token_secret)) echo esc_attr( $access_token_secret ); ?>">
		</p>
		  <?php 
	}
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['consumer_key'] = ( ! empty( $new_instance['consumer_key'] ) ) ? strip_tags( $new_instance['consumer_key'] ) : '';
		$instance['consumer_secret'] = ( ! empty( $new_instance['consumer_secret'] ) ) ? strip_tags( $new_instance['consumer_secret'] ) : '';
		$instance['oauth_access_token'] = ( ! empty( $new_instance['oauth_access_token'] ) ) ? strip_tags( $new_instance['oauth_access_token'] ) : '';
		$instance['oauth_access_token_secret'] = ( ! empty( $new_instance['oauth_access_token_secret'] ) ) ? strip_tags( $new_instance['oauth_access_token_secret'] ) : '';
		$instance['count_feed'] = ( ! empty( $new_instance['count_feed'] ) ) ? strip_tags( $new_instance['count_feed'] ) : '';
		$instance['username'] = ( ! empty( $new_instance['username'] ) ) ? strip_tags( $new_instance['username'] ) : '';
		return $instance;
	}
}
function register_twitter_feed_widget() {
    register_widget( 'Twitter_feed' );
}
add_action( 'widgets_init', 'register_twitter_feed_widget' );
/* Twitter Feed */

/* Text (About Us) */
class Moto_Text extends WP_Widget {
	function __construct() {
		parent::__construct(
			'Moto_Text', // Base ID
			esc_html__('Moto Text', 'moto'), // Name
			array( 'description' => esc_html__( 'Footer Text Widget', 'moto' ), ) // Args
		);
	} 
	public function widget( $args, $instance ) {
		$title = $description = '';
		if ( !empty( $instance ) ) {
			$title = $instance[ 'title' ];
			$description = $instance[ 'description' ];
		}
		echo $args['before_widget'];
		
		echo '<hr><h4>'. esc_attr($title) .'</h4>';
		
		echo '<p>'.$description.'</p>'; 
		echo moto_social();
		echo $args['after_widget'];
	}
	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'description' => '' ) );
		$title = strip_tags($instance['title']);
		$description = esc_textarea($instance['description']);	 
		?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:','moto'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
       
		<textarea class="widefat" rows="16" cols="20" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_html($description); ?></textarea>
        
		<p><input id="<?php echo $this->get_field_id('filter'); ?>" name="<?php echo $this->get_field_name('filter'); ?>" type="checkbox" <?php checked(isset($instance['filter']) ? $instance['filter'] : 0); ?> />&nbsp;<label for="<?php echo $this->get_field_id('filter'); ?>"><?php esc_html_e('Automatically add paragraphs'); ?></label></p>
		<?php 
	}
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		if ( current_user_can('unfiltered_html') )
			$instance['description'] =  $new_instance['description'];
		else
			$instance['description'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['description']) ) ); // wp_filter_post_kses() expects slashed
		$instance['filter'] = ! empty( $new_instance['filter'] );	
        
		return $instance;
	}
}
function register_moto_text() {
    register_widget( 'Moto_Text' );
}
add_action( 'widgets_init', 'register_moto_text' );
/* Text (About Us) */

/* Contact */
class Moto_Contact extends WP_Widget {
	function __construct() {
		parent::__construct(
			'Moto_Contact', // Base ID
			esc_html__('Moto Contact', 'moto'), // Name
			array( 'description' => esc_html__( 'Footer Contact Widget', 'moto' ), ) // Args
		);
	} 
	public function widget( $args, $instance ) {
		$title = $description = $imgsrc = '';
		if ( !empty( $instance ) ) {
			$title = $instance['title'];
			$office_addrs = $instance['office_addrs'];
			$phone1 = $instance['phone1'];
			$phone2 = $instance['phone2'];
			$email = $instance['email'];			
		}
		echo '<div class="col-md-3 col-sm-6 text-left contact"><div class="mt_footer_content">';
		echo  '<hr><h4>'. esc_attr($title) .'</h4>';
		echo '<div class="row no-margin">
					<i class="icon-globe"></i>
					<p class="white">'.esc_attr($office_addrs).'</p>
				</div>
				<div class="row no-margin">
					<i class="icon-mobile"></i>
					<p class="white">'.esc_attr($phone1).'
					<br><span class="muted">'.esc_attr($phone2).'</span></p>
				</div>
				<div class="row no-margin">
					<i class="icon-envelope"></i>
					<p class="white">'.esc_attr($email).'</p>
				</div>'; 
		echo '</div></div>';
	}
	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'office_addrs' => '', 'phone1' => '', 'phone2' => '', 'email' => '' ) );
		$title = strip_tags($instance['title']);
		$office_addrs = $instance['office_addrs'];
		$phone1 = $instance['phone1'];
		$phone2 = $instance['phone2'];
		$email = $instance['email'];
		?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:','moto'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

		<p><label for="<?php echo $this->get_field_id('office_addrs'); ?>"><?php esc_html_e('Office Address','moto'); ?></label>
		<textarea class="widefat" rows="16" cols="20" id="<?php echo $this->get_field_id('office_addrs'); ?>" name="<?php echo $this->get_field_name('office_addrs'); ?>"><?php echo $office_addrs; ?></textarea></p>
		
		<p><label for="<?php echo $this->get_field_id('phone1'); ?>"><?php esc_html_e('Phone Number:','moto'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('phone1'); ?>" name="<?php echo $this->get_field_name('phone1'); ?>" type="text" value="<?php echo esc_attr($phone1); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('phone2'); ?>"><?php esc_html_e('Mobile Number:','moto'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('phone2'); ?>" name="<?php echo $this->get_field_name('phone2'); ?>" type="text" value="<?php echo esc_attr($phone2); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('email'); ?>"><?php esc_html_e('Email Id:','moto'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('email'); ?>" name="<?php echo $this->get_field_name('email'); ?>" type="text" value="<?php echo esc_attr($email); ?>" /></p>
        
<?php 
	}
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['office_addrs'] = ( ! empty( $new_instance['office_addrs'] ) ) ? strip_tags( $new_instance['office_addrs'] ) : '';
		$instance['phone1'] = ( ! empty( $new_instance['phone1'] ) ) ? strip_tags( $new_instance['phone1'] ) : '';
		$instance['phone2'] = ( ! empty( $new_instance['phone2'] ) ) ? strip_tags( $new_instance['phone2'] ) : '';
		$instance['email'] = ( ! empty( $new_instance['email'] ) ) ? strip_tags( $new_instance['email'] ) : '';
		
		return $instance;
	}
}
function register_moto_contact() {
    register_widget( 'Moto_Contact' );
}
add_action( 'widgets_init', 'register_moto_contact' );
/* Contact */
/* SOCIAL START */
class Moto_social extends WP_Widget {
	function __construct() {
		$widget_ops = array('classname' => 'Moto_social', 'description' => esc_html__('this is social widgets.','moto'));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('moto_social', esc_html__('Moto Social','moto'), $widget_ops, $control_ops);
	}
	public function widget( $args, $instance ) {
		$title = !empty($instance[ 'title' ]) ? $instance[ 'title' ] : '';
	
		echo $args['before_widget'];
			if ( ! empty( $title ) ) {
			 echo '<hr><h4>'. $title .'</h4>';
			}
			echo '<div class="clearfix"></div>';
			echo '<ul class="social">';
			echo !empty($instance['fb']) ? '<li><a href="'.esc_url($instance['fb']).'" class="fa fa-facebook"></a></li>' : '';
			echo !empty($instance['twt']) ? '<li><a href="'.esc_url($instance['twt']).'" class="fa fa-twitter"></a></li>' : '';
			echo !empty($instance['lin']) ? '<li><a href="'.esc_url($instance['lin']).'" class="fa fa-linkedin-square"></a></li>' : '';
			echo !empty($instance['fckr']) ? '<li><a href="'.esc_url($instance['fckr']).'" class="fa fa-flickr"></a></li>' : '';
			echo !empty($instance['yt']) ? '<li><a href="'.esc_url($instance['yt']).'" class="fa fa-youtube"></a></li>' : '';
			echo !empty($instance['driple']) ? '<li><a href="'.esc_url($instance['driple']).'" class="fa fa-dribbble"></a></li>' : '';
			echo !empty($instance['gp']) ? '<li><a href="'.esc_url($instance['gp']).'" class="fa fa-google-plus"></a></li>' : '';
			echo !empty($instance['sky']) ? '<li><a href="skype:'.esc_url($instance['sky']).'?call" class="fa fa-skype"></a></li>' : '';
			echo !empty($instance['pin']) ? '<li><a href="'.esc_url($instance['pin']).'" class="fa fa-pinterest"></a></li>' : '';
			echo !empty($instance['vim']) ? '<li><a href="'.esc_url($instance['vim']).'" class="fa fa-vimeo-square"></a></li>' : '';
			echo !empty($instance['rss']) ? '<li><a href="'.esc_url($instance['rss']).'" class="fa fa-rss"></a></li>' : '';
			echo !empty($instance['insg']) ? '<li><a href="'.esc_url($instance['insg']).'" class="fa fa-instagram"></a></li>' : '';			
			echo '</ul>';
			
		
		echo $args['after_widget'];
	}
	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '') );
		$title = strip_tags($instance['title']);		
		$fb = !empty($instance['fb']) ? $instance['fb'] : '';
		$twt = !empty($instance['twt']) ? $instance['twt'] : '';
		$lin = !empty($instance['lin']) ? $instance['lin'] : '';
		$fckr = !empty($instance['fckr']) ? $instance['fckr'] : '';
		$yt = !empty($instance['yt']) ? $instance['yt'] : '';
		$driple = !empty($instance['driple']) ? $instance['driple'] : '';
		$gp = !empty($instance['gp']) ? $instance['gp'] : '';
		$sky = !empty($instance['sky']) ? $instance['sky'] : '';
		$pin = !empty($instance['pin']) ? $instance['pin'] : '';
		$vim = !empty($instance['vim']) ? $instance['vim'] : '';
		$rss = !empty($instance['rss']) ? $instance['rss'] : '';
		$insg = !empty($instance['insg']) ? $instance['insg'] : '';
    ?>
	 <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:'); ?></label>
	 <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
	 </p>
		<p><label for="<?php echo $this->get_field_id('fb'); ?>"><?php esc_html_e('Facebook:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('fb'); ?>" name="<?php echo $this->get_field_name('fb'); ?>" type="text" value="<?php echo esc_attr($fb); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('twt'); ?>"><?php esc_html_e('Twitter:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('twt'); ?>" name="<?php echo $this->get_field_name('twt'); ?>" type="text" value="<?php echo esc_attr($twt); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('lin'); ?>"><?php esc_html_e('Linkedin:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('lin'); ?>" name="<?php echo $this->get_field_name('lin'); ?>" type="text" value="<?php echo esc_attr($lin); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('fckr'); ?>"><?php esc_html_e('Flickr:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('fckr'); ?>" name="<?php echo $this->get_field_name('fckr'); ?>" type="text" value="<?php echo esc_attr($fckr); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('yt'); ?>"><?php esc_html_e('Youtube:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('yt'); ?>" name="<?php echo $this->get_field_name('yt'); ?>" type="text" value="<?php echo esc_attr($yt); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('driple'); ?>"><?php esc_html_e('Dribbble:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('driple'); ?>" name="<?php echo $this->get_field_name('driple'); ?>" type="text" value="<?php echo esc_attr($driple); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('gp'); ?>"><?php esc_html_e('Google Plus:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('gp'); ?>" name="<?php echo $this->get_field_name('gp'); ?>" type="text" value="<?php echo esc_attr($gp); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('sky'); ?>"><?php esc_html_e('Skype:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('sky'); ?>" name="<?php echo $this->get_field_name('sky'); ?>" type="text" value="<?php echo esc_attr($sky); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('pin'); ?>"><?php esc_html_e('Pinterest:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('pin'); ?>" name="<?php echo $this->get_field_name('pin'); ?>" type="text" value="<?php echo esc_attr($pin); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('vim'); ?>"><?php esc_html_e('Vimeo:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('vim'); ?>" name="<?php echo $this->get_field_name('vim'); ?>" type="text" value="<?php echo esc_attr($vim); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('rss'); ?>"><?php esc_html_e('Rss:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('rss'); ?>" name="<?php echo $this->get_field_name('rss'); ?>" type="text" value="<?php echo esc_attr($rss); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('insg'); ?>"><?php esc_html_e('Instagram:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('insg'); ?>" name="<?php echo $this->get_field_name('insg'); ?>" type="text" value="<?php echo esc_attr($insg); ?>" /></p>
		
		
<?php 
	}
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance; 
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['fb'] = !empty($new_instance['fb']) ? $new_instance['fb'] : '';
		$instance['twt'] = !empty($new_instance['twt']) ? $new_instance['twt'] : '';
		$instance['lin'] = !empty($new_instance['lin']) ? $new_instance['lin'] : '';
		$instance['fckr'] = !empty($new_instance['fckr']) ? $new_instance['fckr'] : '';
		$instance['yt'] = !empty($new_instance['yt']) ? $new_instance['yt'] : '';
		$instance['driple'] = !empty($new_instance['driple']) ? $new_instance['driple'] : '';
		$instance['gp'] = !empty($new_instance['gp']) ? $new_instance['gp'] : '';
		$instance['sky'] = !empty($new_instance['sky']) ? $new_instance['sky'] : '';
		$instance['pin'] = !empty($new_instance['pin']) ? $new_instance['pin'] : '';
		$instance['vim'] = !empty($new_instance['vim']) ? $new_instance['vim'] : '';
		$instance['rss'] = !empty($new_instance['rss']) ? $new_instance['rss'] : '';
		$instance['insg'] = !empty($new_instance['insg']) ? $new_instance['insg'] : '';
		return $instance;
	}    
}
function moto_register_about_store_widget() {
    register_widget( 'Moto_social' ); 
}
add_action( 'widgets_init', 'moto_register_about_store_widget' );

//Single Image
class MotoSingleImage extends WP_Widget {
	function __construct() {
		parent::__construct(
			'moto_single_image', // Base ID
			esc_html__('Moto Single Image', 'moto'), // Name
			array( 'description' => esc_html__( 'Single Image', 'moto' ), ) // Args
		);
	} 
	public function widget( $args, $instance ) {
		$moto_image = (!empty($instance[ 'moto_image' ]) ? $instance[ 'moto_image' ] : '');
		echo $args['before_widget'];
		echo '<img src="'.$moto_image.'">';
		echo $args['after_widget'];
	}
	public function form( $instance ) {
		$moto_image = (!empty($instance[ 'moto_image' ]) ? $instance[ 'moto_image' ] : '');		
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'moto_image' ); ?>"><?php echo esc_html__('Upload Image:','moto'); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'moto_image' ); ?>" name="<?php echo $this->get_field_name( 'moto_image' ); ?>" type="text" value="<?php echo esc_attr( $moto_image ); ?>">
		<input type="button" class="button button-primary moto_upload_file" value="<?php echo esc_html__('Upload', 'moto');?>" />
		</p>
		<?php 
	}
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['moto_image'] = ( ! empty( $new_instance['moto_image'] ) ) ? strip_tags( $new_instance['moto_image'] ) : '';
		return $instance;
	}
}
function register_moto_single_image() {
    register_widget( 'MotoSingleImage' );
}
add_action( 'widgets_init', 'register_moto_single_image' );

/**
 *Moto Google Map Widget
 */
class Googlemap extends WP_Widget {
	function __construct() {
		parent::__construct(
			'Googlemap', // Base ID
			esc_html__('Moto Google Map', 'moto'), // Name
			array( 'description' => esc_html__( 'Moto Google Map', 'moto' ), ) // Args
		);
	} 
	public function widget( $args, $instance ) {
	echo $args['before_widget'];
	$map_zoom = $scroll = $maptype = $mapid = $latitude = $longitude = $height = '';
	$mapid ='widget';
	$maptype = 'googlemap';
	$map_zoom = (!empty($instance[ 'map_zoom' ]) ? $instance[ 'map_zoom' ] : '');	
	$map_title = (!empty($instance[ 'map_title' ]) ? $instance[ 'map_title' ] : 'Find Us');	
	$scroll = (!empty($instance[ 'scroll' ]) ? $instance[ 'scroll' ] : '');
	$latitude = (!empty($instance[ 'latitude' ]) ? $instance[ 'latitude'] : '');	
	$longitude = (!empty($instance[ 'longitude' ]) ? $instance['longitude'] : '');
	$height = (!empty($instance[ 'height' ]) ? $instance[ 'height' ] : '');
	?>
  <script type="text/javascript">
	var myCenter = new google.maps.LatLng(<?php echo esc_js($latitude); ?> ,<?php echo esc_js($longitude); ?>);
	function initialize() {
		var mapProp = {
			center: myCenter,
			zoom: <?php echo esc_js($map_zoom); ?>,
			scrollwheel: <?php echo esc_js($scroll); ?>,
			mapTypeId: google.maps.MapTypeId.<?php echo esc_js($maptype); ?>,
			styles: [{"featureType":"landscape.man_made","elementType":"geometry","stylers":[{"color":"#f7f1df"}]},{"featureType":"landscape.natural","elementType":"geometry","stylers":[{"color":"#d0e3b4"}]},{"featureType":"landscape.natural.terrain","elementType":"geometry","stylers":[{"visibility":"off"}]},{"featureType":"poi","elementType":"labels","stylers":[{"visibility":"off"}]},{"featureType":"poi.business","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"poi.medical","elementType":"geometry","stylers":[{"color":"#fbd3da"}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#bde6ab"}]},{"featureType":"road","elementType":"geometry.stroke","stylers":[{"visibility":"off"}]},{"featureType":"road","elementType":"labels","stylers":[{"visibility":"off"}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#ffe15f"}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#efd151"}]},{"featureType":"road.arterial","elementType":"geometry.fill","stylers":[{"color":"#ffffff"}]},{"featureType":"road.local","elementType":"geometry.fill","stylers":[{"color":"black"}]},{"featureType":"transit.station.airport","elementType":"geometry.fill","stylers":[{"color":"#cfb2db"}]},{"featureType":"water","elementType":"geometry","stylers":[{"color":"#a2daf2"}]}]
		};
		var map = new google.maps.Map(document.getElementById("<?php echo esc_js($mapid); ?>"), mapProp);
		var marker = new google.maps.Marker({
			position: myCenter,
			map: map,
			title: '<?php echo esc_js($info_title); ?>',
			icon: '<?php echo get_template_directory_uri().'/images/map_marker.png'; ?>',
		});
		var contentString = "<?php echo esc_js($info_title); ?>";
		marker.setMap(map); 
		var infowindow = new google.maps.InfoWindow({
			content: contentString,
			pixelOffset : 0,  
		});
		google.maps.event.addListener(marker, 'click', function () {
			infowindow.open(map, marker);
		});
	}
	google.maps.event.addDomListener(window, 'load', initialize);
	</script>
	<?php
     echo '<hr><h4>'.$map_title.'</h4><div id="'.esc_attr($mapid).'" style="width:100%;height:'.esc_attr($height).'px;" class="google_map" ></div>'; 
     echo $args['after_widget'];
	}
	public function form( $instance ) {
	   $map_zoom = $scroll = $maptype = $latitude = $longitude = $height = '';
	   $map_title = (!empty($instance[ 'map_title' ]) ? $instance[ 'map_title' ] : 'Find Us');	
	   $map_zoom = (!empty($instance[ 'map_zoom' ]) ? $instance[ 'map_zoom' ] : '');	
	   $scroll = (!empty($instance[ 'scroll' ]) ? $instance[ 'scroll' ] : '');
       	
       $latitude = (!empty($instance[ 'latitude' ]) ? $instance[ 'latitude' ] : '');	
	   $longitude = (!empty($instance[ 'longitude' ]) ? $instance[ 'longitude' ] : '');
	   $height = (!empty($instance[ 'height' ]) ? $instance[ 'height' ] : '');
	?>
	<p>
	<label for="<?php echo $this->get_field_id( 'map_title' ); ?>"><?php echo esc_html__('Title:','moto'); ?></label> 
	<input class="widefat" id="<?php echo $this->get_field_id( 'map_title' ); ?>" name="<?php echo $this->get_field_name( 'map_title' ); ?>" type="text" value="<?php echo esc_attr( $map_title ); ?>">
	</p>
	<p>
	<label for="<?php echo $this->get_field_id( 'map_zoom' ); ?>"><?php echo esc_html__('Map Zoom:','moto'); ?></label> 
	<input class="widefat" id="<?php echo $this->get_field_id( 'map_zoom' ); ?>" name="<?php echo $this->get_field_name( 'map_zoom' ); ?>" type="text" value="<?php echo esc_attr( $map_zoom ); ?>">
	<span><?php esc_html_e('Enter zoom level like: 7,8,9,10,11,12,13,14,15,16,17');?></span>
	</p>
	<p>
	<label for="<?php echo $this->get_field_id( 'scroll' ); ?>"><?php echo esc_html__('Map Scroll','moto'); ?></label> 
	<input class="widefat" id="<?php echo $this->get_field_id( 'scroll' ); ?>" name="<?php echo $this->get_field_name( 'scroll' ); ?>" type="text" value="<?php echo esc_attr( $scroll ); ?>">
	<span><?php esc_html_e('Enter true or false.');?></span>
	</p>
	<p>
	<label for="<?php echo $this->get_field_id( 'height' ); ?>"><?php echo esc_html__('Map Height','moto'); ?></label> 
	<input class="widefat" id="<?php echo $this->get_field_id( 'height' ); ?>" name="<?php echo $this->get_field_name( 'height' ); ?>" type="text" value="<?php echo esc_attr( $height ); ?>">
	<span><?php esc_html_e('Enter map height.');?></span>
	</p>
	<p>
	<label for="<?php echo $this->get_field_id('latitude'); ?>"><?php echo esc_html__('Latitude','moto'); ?></label> 
	<input class="widefat" id="<?php echo $this->get_field_id('latitude'); ?>" name="<?php echo $this->get_field_name('latitude'); ?>" type="text" value="<?php echo esc_attr( $latitude ); ?>">
	</p>
	<p>
	<label for="<?php echo $this->get_field_id('longitude'); ?>"><?php echo esc_html__('Longitude','moto'); ?></label> 
	<input class="widefat" id="<?php echo $this->get_field_id('longitude'); ?>" name="<?php echo $this->get_field_name('longitude'); ?>" type="text" value="<?php echo esc_attr( $longitude ); ?>">
	</p>
	<?php 
	}
    public function update( $new_instance, $old_instance ) {
		$instance = array();
		
		$instance['map_zoom'] = ( ! empty( $new_instance['map_zoom'] ) ) ? strip_tags( $new_instance['map_zoom'] ) : '';
		
		$instance['scroll'] = ( ! empty( $new_instance['scroll'] ) ) ? strip_tags( $new_instance['scroll'] ) : '';
		
		$instance['latitude'] = ( ! empty( $new_instance['latitude'] ) ) ? strip_tags( $new_instance['latitude'] ) : '';
		
		$instance['longitude'] = ( ! empty( $new_instance['longitude'] ) ) ? strip_tags( $new_instance['longitude'] ) : '';
		
		$instance['height'] = ( ! empty( $new_instance['height'] ) ) ? strip_tags( $new_instance['height'] ) : '';
		
		return $instance;
		
	}
}
function register_moto_google_map() {
    register_widget( 'Googlemap' );
}
add_action( 'widgets_init', 'register_moto_google_map' );