<?php
add_action( 'init', 'moto_theme_shortcodes' );
function moto_theme_shortcodes() {
if( class_exists( 'originbuilder' ) ) {
$or = originbuilder::globe();
	/* service */
	$services_cats = get_terms( 'service_categories', array('orderby'=> 'name','order' => 'ASC'));
	$cats = array( 'all' => 'All' );	
	foreach($services_cats as $services_cat) 
	{ 
	  $cats[$services_cat->slug] = $services_cat->slug;			
	}
	$or->add_map( array('moto_services_shortcode' => array(
			'name' => __('Services', 'moto'),
			'description' => __('MOTO Services', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'No Of Services', 'moto' ),
						'name'			=> 'no_service',
						'description'	=> __( 'No Of Services Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Category slug', 'moto' ),
						'name'			=> 'cat',
						'options'		=> $cats,
						'description'	=> __( 'Choose Category', 'moto' ),
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Services Order', 'moto' ),
						'name'			=> 'service_order',
						'options'		=> array(
											'asc' => __( 'Ascending', 'moto' ),
											'desc' => __( 'Descending', 'moto' ),
										),
						array(
							'asc' => __( 'Ascending', 'moto' ),
							'desc' => __( 'Descending', 'moto' ),
						),
						'description'	=> __( 'Choose Services Order', 'moto' ),
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Services Style', 'moto' ),
						'name'			=> 'service_style',
						'options'		=> array(
							'1' => __( 'Style 1', 'moto' ),
							'2' => __( 'Style 2', 'moto' ),
							'3' => __( 'Style 3', 'moto' ),
							'4' => __( 'Style 4', 'moto' ),
						),
						'description'	=> __( 'Choose Services Style', 'moto' ),
					),					
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background color', 'moto' ),
						'name'			=> 'bg_color',
						'description'	=> __( 'Choose Background color', 'moto' )
					),
				),

			)
		)) 
	);
		/* Moto Creative Call To Action */	
	$or->add_map( array('moto_creative_call_action_shortcode' => array(
			'name' => __('Moto Creative Call To Action', 'moto'),
			'description' => __('Call To Action', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Formate', 'moto' ),
						'name'			=> 'action_formate',
						'options'		=> array(
										'formate_1' => 'formate1',
										'formate_2' => 'formate2'
										),
						'description'	=> __( '', 'moto' ),
					 ),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Sub Title', 'moto' ),
						'name'			=> 'sub_title',
						'description'	=> __( 'Sub Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Text', 'moto' ),
						'name'			=> 'btn_txt',
						'relation'	=> array(
							'parent'	=> 'action_formate',
							'show_when'	=> 'formate_1'
						),
						'description'	=> __( 'This button will work only for Formate 1.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Link', 'moto' ),
						'name'			=> 'btn_link',
						'relation'	=> array(
							'parent'	=> 'action_formate',
							'show_when'	=> 'formate_1'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Video Link', 'moto' ),
						'name'			=> 'video_link',
						'relation'	=> array(
							'parent'	=> 'action_formate',
							'show_when'	=> 'formate_2'
						),
						'description'	=> __( 'Video Link', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Text Alignment', 'moto' ),
						'name'			=> 'text_alignment',
						'options'		=> array(
											'txt_center' => 'Center',
											'txt_left'   => 'Left',
											'txt_right'  => 'Right'
										),
						'description'	=> __( '', 'moto' ), 
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Background Style', 'moto' ),
						'name'			=> 'background_style',
						'options'		=> array(
								'image' => 'Image',
								'color' => 'Color',
						),
						'description'	=> __( 'Choose Option', 'moto' ),
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Images', 'moto' ),
						'name'			=> 'bg_image',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'image'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background Color', 'moto' ),
						'name'			=> 'color',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'color'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Overlay ', 'moto' ),
						'name'			=> 'overlay',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'image'
						),
						'options' => array(
									'yes' => __( 'Yes', 'moto' )
								),
						'value'			=> 'yes',		
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Overlay Color', 'moto' ),
						'name'			=> 'overlay_color',
						'relation'	=> array(
							'parent'	=> 'overlay',
							'show_when'	=> 'yes'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
				),

			)
		))
	);
/* Portfolio view */ 
	$or->add_map( array('moto_portfolio_view' => array(
			'name' => __('Portfolio View', 'moto'),
			'description' => __('Portfolio View', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Number of Portfolio', 'moto' ),
						'name'			=> 'portfoliocountpost',
						'description'	=> __( 'Enter integer value ex. 6', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Portfolio View', 'moto' ),
						'name'			=> 'portfolio_view',
						'options'		=> array(
											'column_3'  => '3 column',
											'column_4'  => '4 column',
											'dynamic'   => 'Dynamic column'
										),
						'description'	=> __( '', 'moto' ), 
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Portfolio Hover Effect', 'moto' ),
						'name'			=> 'portfolio_hover',
						'options'		=> array(
											'hover1'  => 'Hover 1',
											'hover2'  => 'Hover 2',
											'hover3'  => 'Hover 3',
											'hover4'  => 'Hover 4',
											'hover5'  => 'Hover 5',
											'hover6'  => 'Hover 6',
											'hover7'  => 'Hover 7',
											'hover8'  => 'Hover 8'
										),
						'description'	=> __( 'Select Appropriate Effect.', 'moto' ), 
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Enable Magnifier ', 'moto' ),
						'name'			=> 'magnifier',
						'options' => array(
									'yes' => __( 'Yes', 'moto' )
								),
						'value'			=> 'yes',		
						'description'	=> __( 'Desable will add the permalink to the item.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'No Padding', 'moto' ),
						'name'			=> 'no_padding',
						'options' => array(
									'no_padding' => __( 'no_padding', 'moto' )
								),
						'value'			=> 'no_padding',		
						'description'	=> __( 'Desable will add the no paddingthe item.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Enable Filter', 'moto' ),
						'name'			=> 'en_filter',
						'options' => array(
									'yes' => __( 'Yes', 'moto' )
								),
						'value'			=> 'yes',		
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					)
				),

			)
		))
	);
//Portfolio Description
	$or->add_map( array('moto_portfolio_description_shortcode' => array(
			'name' => __('Portfolio Description', 'moto'),
			'description' => __('Portfolio Description', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'value'			=> __('PORTFOLIO SINGLE','moto'),
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Title with underline', 'moto' ),
						'name'			=> 'titleunderline',
						'options' => array(
									'yes' => __( 'Yes', 'moto' )
								),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'SubTitle', 'moto' ),
						'name'			=> 'subtitle',
						'value'			=> __('FOR PRINT AND WEB','moto'),
						'description'	=> __( 'SubTitle text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'port_desc',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),					
				),

			)
		))
	);	
/* Team */ 
	$team_cats = get_terms( 'team_categories', array('orderby'=> 'name','order' => 'ASC'));
	$cats = array( 'all' => 'All' );	
	foreach($team_cats as $team_cat) 
	{ 
	  $cats[$team_cat->slug] = $team_cat->slug;			
	}	
	$or->add_map( array('moto_team_shortcode' => array(
			'name' => __('Team', 'moto'),
			'description' => __('MOTO Team', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Show No of Team Member', 'moto' ),
						'name'			=> 'team_no',
						'options'		=> array(
											'3'  => '3',
											'6'  => '6',
											'9'  => '9',
											'12' => '12',
											'15' => '15'
										),
						'description'	=> __( '', 'moto' ), 
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Team Category', 'moto' ),
						'name'			=> 'team_cats',
						'options'		=> $cats,
						'description'	=> __( '', 'moto' ), 
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Order', 'moto' ),
						'name'			=> 'order',
						'options'		=> array(
											'ASC'  => 'Ascending',
											'DESC'  => 'Descending'
										),
						'description'	=> __( '', 'moto' ), 
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background color', 'moto' ),
						'name'			=> 'bg_color',
						'description'	=> __( 'Choose Background color', 'moto' )
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Team Style Option.', 'moto' ),
						'name'			=> 'team_style',
						'options'		=> array(
											'style1'  => 'Style 1',
											'style2'  => 'Style 2',
											'style3'  => 'Style 3'
										),
						'description'	=> __( '', 'moto' ), 
					),
				),

			)
		))
	);
/* Client */ 
	$or->add_map( array('moto_client_shortcode' => array(
			'name' => __('Client Logos', 'moto'),
			'description' => __('Client Logos', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Formate', 'moto' ),
						'name'			=> 'formate',
						'options'		=> array(
										"formate_1" => "Formate 1",
										"formate_2" => "Formate 2",
									),
						'description'	=> __( '', 'moto' ), 
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_images',
						'label'			=> __( 'Upload Client logos', 'moto' ),
						'name'			=> 'logos',
						'description'	=> __( 'Select client logos', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Image', 'moto' ),
						'name'			=> 'client_back',
						'relation'	=> array(
							'parent'	=> 'formate',
							'show_when'	=> 'formate_1'
						),
						'description'	=> __( 'Select Image!', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Overlay ', 'moto' ),
						'name'			=> 'overlay',
						'relation'	=> array(
							'parent'	=> 'formate',
							'show_when'	=> 'formate_1'
						),
						'options' => array(
									'yes' => __( 'Yes', 'moto' )
								),
						'value'			=> 'yes',		
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Overlay Color', 'moto' ),
						'name'			=> 'overlay_color',
						'relation'	=> array(
							'parent'	=> 'overlay',
							'show_when'	=> 'yes'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background color', 'moto' ),
						'name'			=> 'color',
						'relation'	=> array(
							'parent'	=> 'formate',
							'show_when'	=> 'formate_2'
						),
						'description'	=> __( 'Choose Background color', 'moto' )
					),
					
				),

			)
		))
	);
 
//Information
	$or->add_map( array('moto_information_shortcode' => array(
			'name' => __('Information', 'moto'),
			'description' => __('Information', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Subtitle', 'moto' ),
						'name'			=> 'subtitle',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'desc',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Text', 'moto' ),
						'name'			=> 'btn_txt',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Url', 'moto' ),
						'name'			=> 'btn_url',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Button Alignment', 'moto' ),
						'name'			=> 'btn_align',
						'description'	=> __( 'Choose Alignment', 'moto' ),
						'options'		=> array(
											'center'  => 'Center',
											'left'    => 'Left',
											'right'   => 'Right'
										),
						'admin_label'	=> true
					),
				),

			)
		))
	);
	
//Contact Map
	$or->add_map( array('moto_map_shortcode' => array(
			'name' => __('Google Map', 'moto'),
			'description' => __('Google Map', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Map Latitude & Longitude', 'moto' ),
						'name'			=> 'lat_long',
						'description'	=> __( 'Eg. : Latitude,Longitude', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Map Height', 'moto' ),
						'name'			=> 'map_height',
						'description'	=> __( 'Height in pixel.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Map Type', 'moto' ),
						'name'			=> 'map_type',
						'description'	=> __( 'Choose Map Type', 'moto' ),
						'options'		=> array(
											'road_map'   => 'Road Map',
											'sat_map'    => 'Satellite Map',
											'hybrid_map' => 'Hybrid Map',
										),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Map Zoom', 'moto' ),
						'name'			=> 'map_zoom',
						'description'	=> __( 'Choose Map Zoom', 'moto' ),
						'options'		=> array(
											'7'    => '7',
											'8'    => '8',
											'9'    => '9',
											'10'   => '10',
											'11'   => '11',
											'12'   => '12',
											'13'   => '13',
											'14'   => '14',
											'15'   => '15',
											'16'   => '16',
											'17'   => '17',
											'18'   => '18',
										),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Map Scroll', 'moto' ),
						'name'			=> 'map_scroll',
						'description'	=> __( 'Choose Scroll', 'moto' ),
						'options'		=> array(
											'yes'   => 'Yes',
											'no'    => 'No'
										),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Infobox Title', 'moto' ),
						'name'			=> 'info_title',
						'description'	=> __( 'Infobox Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
				),

			)
		))
	);
//Contact Form
	$or->add_map( array('moto_contact_form_shortcode' => array(
			'name' => __('Contact Form', 'moto'),
			'description' => __('Contact Form', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'description',
						'description'	=> __( 'Description text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						     'type'	 => 'color_picker',
						     'label' => __( 'Heading color', 'moto' ),
						     'name'	 => 'head_color',
						     'description'	=> __( 'Choose Heading Color', 'moto' ),
						     'admin_label'	=> true
					),
					array(
						     'type'	 => 'color_picker',
						     'label' => __( 'Text color', 'moto' ),
						     'name'	 => 'text_color',
						     'description'	=> __( 'Choose Text Color', 'moto' ),
						     'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Show Contact Form', 'moto' ),
						'name'			=> 'contact',
						'options' => array(
									'yes' => __( 'yes', 'moto' )
								),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Contact Form', 'moto' ),
						'name'			=> 'contact_style',
						'options'		=> array(
											'style1'  => 'Style 1',
											'style2'  => 'Style 2',
											'style3'  => 'Style 3',
											'style4'  => 'Style 4',
											'style5'  => 'Style 5',
											'style6'  => 'Style 6',
											'style7'  => 'Style 7',
											'style8'  => 'Style 8',
											'style9'  => 'Style 9',
											'style10'  => 'Style 10'
										),
						'relation'	=> array( 
							'parent'	=> 'contact',
							'show_when'	=> 'yes'
						),
						'description'	=> __( '', 'moto' ),
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Button Alignment', 'moto' ),
						'name'			=> 'btn_align',
						'options'		=> array(
											'left'  => 'Left',
											'right'  => 'Right'
										),
						'relation'	=> array( 
							'parent'	=> 'contact',
							'show_when'	=> 'yes'
						),
						'description'	=> __( '', 'moto' ),
					),
				), 

			)
		))
	);
//Twitter Feed
	$or->add_map( array('moto_twitterfeed_shortcode' => array(
			'name' => __('Twitter Feed', 'moto'),
			'description' => __('Twitter Feed', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Show No Of Feed', 'moto' ),
						'name'			=> 'feedcount',
						'description'	=> __( 'Ex. 2','moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Twitter Username', 'moto' ), 
						'name'			=> 'usename',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Consumer Key', 'moto' ),
						'name'			=> 'key',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Consumer Secret', 'moto' ),
						'name'			=> 'secret',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Access Token', 'moto' ),
						'name'			=> 'access_token',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Access Token Secret', 'moto' ),
						'name'			=> 'access_token_secret',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
				),

			)
		))
	);
//Social Setting
	$or->add_map( array('moto_social_shortcode' => array(
			'name' => __('Social', 'moto'),
			'description' => __('MOTo Social', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Facebook Url', 'moto' ),
						'name'			=> 'fb_url',
						'description'	=> __( 'if not need,then leave blank','moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Twitter Url', 'moto' ), 
						'name'			=> 'twt_url',
						'description'	=> __( 'if not need,then leave blank', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Linkedin Url', 'moto' ),
						'name'			=> 'linked_url',
						'description'	=> __( 'if not need,then leave blank', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Flickr Url', 'moto' ),
						'name'			=> 'flickr_url',
						'description'	=> __( 'if not need,then leave blank', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Youtube Url', 'moto' ),
						'name'			=> 'yotube_url',
						'description'	=> __( 'if not need,then leave blank', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Dribbble Url', 'moto' ),
						'name'			=> 'dribbble_url',
						'description'	=> __( 'if not need,then leave blank', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Google Plus Url', 'moto' ),
						'name'			=> 'gp_url',
						'description'	=> __( 'if not need,then leave blank', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Skype Id', 'moto' ),
						'name'			=> 'sky_url',
						'description'	=> __( 'if not need,then leave blank', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Pinterest Url', 'moto' ),
						'name'			=> 'pin_url',
						'description'	=> __( 'if not need,then leave blank', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Vimeo Url', 'moto' ),
						'name'			=> 'vim_url',
						'description'	=> __( 'if not need,then leave blank', 'moto' ),
						'admin_label'	=> true
					),
				),

			)
		))
	);
//MOTO Heading
	$or->add_map( array('moto_heading_shortcode' => array(
			'name' => __('Moto Heading', 'moto'),
			'description' => __('Moto Heading', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Add Letter Space', 'moto' ),
						'name'			=> 'heading_cls',
						'options' => array(
									'invo_heading' => __( 'Yes', 'moto' )
								),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Align', 'moto' ),
						'name'			=> 'text_align',
						'description'	=> __( 'Choose Align', 'moto' ),
						'options'		=> array(
											'center'  => 'Center',
											'left'    => 'Left',
											'right'   => 'Right'
										),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Heading Style', 'moto' ),
						'name'			=> 'head_style',
						'description'	=> __( 'Choose Style', 'moto' ),
						'options'		=> array(
											'h1'  => 'H1',
											'h2'  => 'H2',
											'h3'  => 'H3',
											'h4'  => 'H4',
											'h5'  => 'H5',
											'h6'  => 'H6'
										),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Font Color.', 'moto' ),
						'name'			=> 'font_color',
						'value'			=> '',
						'description'	=> __( 'Choose font color', 'moto' ),
					),	
					
				),

			)
		))
	);
//About Us
	$or->add_map( array('moto_about_shortcode' => array(
			'name' => __('About Us', 'moto'),
			'description' => __('About Us', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'about_desc',
						'description'	=> __( '', 'moto' ),
						'value' => 'Sample Text',
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload signature', 'moto' ),
						'name'			=> 'moto_image',
						'description'	=> __( 'Select Image!', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Designation', 'moto' ),
						'name'			=> 'designation',
						'description'	=> __( 'Text Here.', 'moto' ),
						'admin_label'	=> true
					),					
				),

			)
		))
	);	
	
	$or->add_map( array('moto_about_Slider' => array(
			'name' => __('About Us Slider', 'moto'),
			'description' => __('About Slider', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Slider Style', 'moto' ),
						'name'			=> 'aboutslider_style',
						'options'		=> array(
											'style1'  => 'Style 1',
											'style2'  => 'Style 2',
											'style3'  => 'Style 3'
										),
						'description'	=> __( '', 'moto' ), 
					),
					array(
						'type'			=> 'attach_images',
						'label'			=> __( 'Upload Slider Images', 'moto' ),
						'name'			=> 'abt_slider',
						'description'	=> __( 'Select Images!', 'moto' ),
						'admin_label'	=> true,
						'relation'	=> array(
							'parent'	=> 'aboutslider_style',
							'show_when'	=> array('style1','style2')
						),
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Video Image', 'moto' ),
						'name'			=> 'abt_vdeo_img',
						'description'	=> __( 'Select Image!', 'moto' ),
						'admin_label'	=> true,
						'relation'	=> array(
							'parent'	=> 'aboutslider_style',
							'show_when'	=> array('style3')
						),
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Video Link', 'moto' ),
						'name'			=> 'abt_vdeo_link',
						'description'	=> __( 'Enter Youtube Video Link.', 'moto' ),
						'admin_label'	=> true,
						'relation'	=> array(
							'parent'	=> 'aboutslider_style',
							'show_when'	=> array('style3')
						),
					)					
				),

			)
		))
	);	
//Blog Listed
	$p_cat = array('all'=>'All');
	$categories = get_categories();
	foreach($categories as $category) { 
		$p_cat[$category->slug] = $category->slug;
	}
	$or->add_map( array('moto_blog_listed' => array(
			'name' => __('Blog Listed', 'moto'),
			'description' => __('Blog Listed', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array( 
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Formate', 'moto' ),
						'name'			=> 'post_formate',
						'description'	=> __( '', 'moto' ),
						'options'		=> array(
										'formate_1' => 'formate1',
										'formate_2' => 'formate2',
										'formate_3' => 'formate3',
										'formate_4' => 'formate4',
										'formate_5' => 'formate5'
									),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Number of post', 'moto' ),
						'name'			=> 'countpost',
						'description'	=> __( '', 'moto' ),
						'options'		=> array(
										'all'=> 'All',
										'custom' => 'Custom',
									),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Enter the number of posts.', 'moto' ),
						'name'			=> 'xyzcbc',
						'relation'	=> array(
							'parent'	=> 'countpost', 
							'show_when'	=> 'custom'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Category', 'moto' ),
						'name'			=> 'category',
						'description'	=> __( 'select for showing post', 'moto' ),
						'options'		=> $p_cat,
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Set background Color.', 'moto' ),
						'name'			=> 'post_back',
						'value'			=> '#f4f4f4',
						'description'	=> __( 'Choose background color', 'moto' ),
					),					
				),

			)
		))
	);	
//MOTO Effective Banner
	$or->add_map( array('moto_effective_shortcode' => array(
			'name' => __('Moto Effective Banner', 'moto'),
			'description' => __('Moto Effective Banner', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Sub Title', 'moto' ),
						'name'			=> 'sub_title',
						'description'	=> __( 'Sub Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Url', 'moto' ),
						'name'			=> 'in_url',
						'description'	=> __( 'Url Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Icon', 'moto' ),
						'name'			=> 'icon',
						'description'	=> __( 'Choose Icon', 'moto' ),
						'options'			=> array('select','icon-mobile'=>'icon-mobile', 'icon-laptop'=>'icon-laptop', 'icon-desktop'=>'icon-desktop', 'icon-tablet'=>'icon-tablet', 'icon-phone'=>'icon-phone', 'icon-document'=>'icon-document', 'icon-documents'=>'icon-documents', 'icon-search'=>'icon-search', 'icon-clipboard'=>'icon-clipboard', 'icon-newspaper'=>'icon-newspaper', 'icon-notebook'=>'icon-notebook', 'icon-book-open'=>'icon-book-open', 'icon-browser'=>'icon-browser', 'icon-calendar'=>'icon-calendar', 'icon-presentation'=>'icon-presentation', 'icon-picture'=>'icon-picture', 'icon-pictures'=>'icon-pictures', 'icon-video'=>'icon-video', 'icon-camera'=>'icon-camera', 'icon-printer'=>'icon-printer', 'icon-toolbox'=>'icon-toolbox', 'icon-briefcase'=>'icon-briefcase', 'icon-wallet'=>'icon-wallet', 'icon-gift'=>'icon-gift', 'icon-bargraph'=>'icon-bargraph', 'icon-grid'=>'icon-grid', 'icon-expand'=>'icon-expand', 'icon-focus'=>'icon-focus', 'icon-edit'=>'icon-edit', 'icon-adjustments'=>'icon-adjustments', 'icon-ribbon'=>'icon-ribbon', 'icon-hourglass'=>'icon-hourglass', 'icon-lock'=>'icon-lock', 'icon-megaphone'=>'icon-megaphone', 'icon-shield'=>'icon-shield', 'icon-trophy'=>'icon-trophy', 'icon-flag'=>'icon-flag', 'icon-map'=>'icon-map', 'icon-puzzle'=>'icon-puzzle', 'icon-basket'=>'icon-basket', 'icon-envelope'=>'icon-envelope', 'icon-streetsign'=>'icon-streetsign', 'icon-telescope'=>'icon-telescope', 'icon-gears'=>'icon-gears', 'icon-key'=>'icon-key', 'icon-paperclip'=>'icon-paperclip', 'icon-attachment'=>'icon-attachment', 'icon-pricetags'=>'icon-pricetags', 'icon-lightbulb'=>'icon-lightbulb', 'icon-layers'=>'icon-layers', 'icon-pencil'=>'icon-pencil', 'icon-tools'=>'icon-tools', 'icon-tools-2'=>'icon-tools-2', 'icon-scissors'=>'icon-scissors', 'icon-paintbrush'=>'icon-paintbrush', 'icon-magnifying-glass'=>'icon-magnifying-glass', 'icon-circle-compass'=>'icon-circle-compass', 'icon-linegraph'=>'icon-linegraph', 'icon-mic'=>'icon-mic', 'icon-strategy'=>'icon-strategy', 'icon-beaker'=>'icon-beaker', 'icon-caution'=>'icon-caution', 'icon-recycle'=>'icon-recycle', 'icon-anchor'=>'icon-anchor', 'icon-profile-male'=>'icon-profile-male', 'icon-profile-female'=>'icon-profile-female', 'icon-bike'=>'icon-bike', 'icon-wine'=>'icon-wine', 'icon-hotairballoon'=>'icon-hotairballoon', 'icon-globe'=>'icon-globe', 'icon-genius'=>'icon-genius', 'icon-map-pin'=>'icon-map-pin', 'icon-dial'=>'icon-dial', 'icon-chat'=>'icon-chat', 'icon-heart'=>'icon-heart', 'icon-cloud'=>'icon-cloud', 'icon-upload'=>'icon-upload', 'icon-download'=>'icon-download', 'icon-target'=>'icon-target', 'icon-hazardous'=>'icon-hazardous', 'icon-piechart'=>'icon-piechart', 'icon-speedometer'=>'icon-speedometer', 'icon-global'=>'icon-global', 'icon-compass'=>'icon-compass', 'icon-lifesaver'=>'icon-lifesaver', 'icon-clock'=>'icon-clock', 'icon-aperture'=>'icon-aperture', 'icon-quote'=>'icon-quote', 'icon-scope'=>'icon-scope', 'icon-alarmclock'=>'icon-alarmclock', 'icon-refresh'=>'icon-refresh', 'icon-happy'=>'icon-happy', 'icon-sad'=>'icon-sad', 'icon-facebook'=>'icon-facebook', 'icon-twitter'=>'icon-twitter', 'icon-googleplus'=>'icon-googleplus', 'icon-rss'=>'icon-rss', 'icon-tumblr'=>'icon-tumblr', 'icon-linkedin'=>'icon-linkedin', 'icon-dribbble'=>'icon-dribbble'),
						//'options'		=> $p_cat,
						'admin_label'	=> true
					),
					
				),

			)
		))
	);
//MOTO Welcome Banner
	$or->add_map( array('moto_welcome_banner_shortcode' => array(
			'name' => __('Moto Welcome Banner', 'moto'),
			'description' => __('Moto Welcome Banner', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'welcomebanner_title',
						'description'	=> __( 'Enter your Title.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Image', 'moto' ),
						'name'			=> 'bg_image',
						'description'	=> __( 'Select Image!', 'moto' ),
						'admin_label'	=> true
					),					
				),

			)
		))
	);
//MOTO How We Work Banner
	$or->add_map( array('moto_how_we_work_banner_shortcode' => array(
			'name' => __('Moto HOW WE WORK  Banner', 'moto'),
			'description' => __('HOW WE WORK', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'hww_banner_title',
						'description'	=> __( 'Enter your Title.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Color', 'moto' ),
						'name'			=> 'bg_color',
						'description'	=> __( 'Choose Color', 'moto' ),
						'options'		=> array(
											'light'   => 'Light Yellow',
											'dark'    => 'Dark Yellow'
										),
						'admin_label'	=> true
					),				
				),

			)
		))
	);
//MOTO Shop Banner
	$or->add_map( array('moto_shop_banner_shortcode' => array(
			'name' => __('Moto Shop  Banner', 'moto'),
			'description' => __('Shop  Banner', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Enter your Title.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Url', 'moto' ),
						'name'			=> 'in_url',
						'description'	=> __( 'Url Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Sub Title', 'moto' ),
						'name'			=> 'sub_title',
						'description'	=> __( 'Sub Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Background Style', 'moto' ),
						'name'			=> 'background_style',
						'options'		=> array(
								'image' => 'Image',
								'color' => 'Color',
						),
						'description'	=> __( 'Choose Option', 'moto' ),
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Images', 'moto' ),
						'name'			=> 'bg_image',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'image'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background Color', 'moto' ),
						'name'			=> 'color',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'color'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					)	
				),

			)
		))
	);
//MOTO Brand
	$or->add_map( array('moto_brands_fun' => array(
			'name' => __('Moto Brands', 'moto'),
			'description' => __('Moto Brands', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Enter your Title.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'description',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Text', 'moto' ),
						'name'			=> 'btn_text',
						'description'	=> __( 'Button text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Link', 'moto' ),
						'name'			=> 'btn_link',
						'description'	=> __( 'Button Link Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_images',
						'label'			=> __( 'Upload Brands logos', 'moto' ),
						'name'			=> 'brands_logos',
						'description'	=> __( 'Select Image!', 'moto' ),
						'admin_label'	=> true
					),					
				),

			)
		))
	);
//MOTO Accordion Shortcode
		$or->add_map( array('moto_accordion_shortcode' => array(
			'name' => __('Moto Accordion', 'moto'),
			'description' => __('Accordion Shortcode', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO Accordion Setting',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'accordion_list',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Accordion Style', 'moto' ),
						'name'			=> 'style',
						'options'		=> array(
										"1" => "Style 1",
										"2" => "Style 2",
										"3" => "Style 3"
									),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[accordion_list title="Add Feature"][/accordion_list]'
		))
	);
	$or->add_map( array('accordion_list' => array(
			'name' => __('Add Item', 'moto'),
			'description' => __('Accordion Item', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO Single Accordion Setting',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'desc',
						'description'	=> __( 'Description Here', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
		))
	);
//MOTO Title With Slider
	$or->add_map( array('moto_title_slider_fun' => array(
			'name' => __('Moto Title With Slider', 'moto'),
			'description' => __('Title With Slider', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Enter your Title.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_images',
						'label'			=> __( 'Upload Slider Images', 'moto' ),
						'name'			=> 'invo_slide',
						'description'	=> __( 'Select Images', 'moto' ),
						'admin_label'	=> true
					),
				),

			)
		))
	);
//Moto Mailchimp Subscribe
	$or->add_map( array('moto_mailchimp' => array(
			'name' => __('Moto Mailchimp Subscribe', 'moto'),
			'description' => __('Mailchimp Subscribe', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Formate', 'moto' ),
						'name'			=> 'formate',
						'options'		=> array(
										"formate_1" => "Formate 1",
										"formate_2" => "Formate 2",
									),	
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Logo Image.', 'moto' ),
						'name'			=> 'logo',
						'relation'	=> array(
									'parent'	=> 'formate',
									'show_when'	=> 'formate_2'
								),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Enter your Title.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Subtitle', 'moto' ),
						'name'			=> 'subtitle',
						'relation'	=> array(
									'parent'	=> 'formate',
									'show_when'	=> 'formate_2'
								),
						'description'	=> __( 'Enter your Title.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __("Description",'moto'),
						'name'			=> 'description',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Form Heading', 'moto' ),
						'name'			=> 'heading',
						'relation'	=> array(
									'parent'	=> 'formate',
									'show_when'	=> 'formate_2'
								),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __("Mailchimp API key",'moto'),
						'name'			=> 'api_key',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __("Mailchimp List ID",'moto'),
						'name'			=> 'list_id',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Image.', 'moto' ),
						'name'			=> 'back_img',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Enable Social Icons.', 'moto' ),
						'name'			=> 'enable_social',
						'options' => array(
									'yes' => __( 'Yes', 'moto' )
								),
						'description'	=> __( 'You can see it in the Moto Options.', 'moto' ),
						'admin_label'	=> true
					),
				),

			)
		))
	);
//MOTO Product Purchase
	$or->add_map( array('moto_product_purchase' => array(
			'name' => __('Moto Product Purchase', 'moto'),
			'description' => __('Product Purchase', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Enter your Title.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'desc',
						'description'	=> __( 'Enter your Title.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_images',
						'label'			=> __( 'Upload Product Image.', 'moto' ),
						'name'			=> 'pro_img',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'First Button Text', 'moto' ),
						'name'			=> 'btn1_txt',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'First Button LInk', 'moto' ),
						'name'			=> 'btn1_link',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Second Button Text', 'moto' ),
						'name'			=> 'btn2_txt',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Second Button LInk', 'moto' ),
						'name'			=> 'btn2_link',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
				),

			)
		))
	);
// Moto Videos By Category
$terms = get_terms('video_categories');
$video_cats[] = 'All';
foreach ( $terms as $term ) 
	{
		$video_cats[$term->name] = $term->name;					 // this will give us a name of category.	
	}
	$or->add_map( array('moto_video_short' => array(
			'name' => __('Moto Videos By Category', 'moto'),
			'description' => __('Videos By Category', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
				    array(
							'type'			=> 'dropdown',
							'label'			=> __( 'Category', 'moto' ),
							'name'			=> 'cat_list',
							'description'	=> __( 'Choose Scroll', 'moto' ),
							'options'		=> $video_cats,
							'admin_label'	=> true
						),
					array(
						'type'			=> 'text',
						'label'			=> __( 'No. of video', 'moto' ),
						'name'			=> 'video_no',
						'description'	=> __( 'Empty field will display all videos.', 'moto' ),
						'admin_label'	=> true
					),
				),

			)
		))
	);
// Moto Featured and Latest Post With Slider
	$or->add_map( array('moto_fol_post' => array(
			'name' => __('Moto Featured OR Latest Video', 'moto'),
			'description' => __('Featured OR Latest Video', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
				    array(
							'type'			=> 'dropdown',
							'label'			=> __( 'Select Video Option', 'moto' ),
							'name'			=> 'fol_list',
							'description'	=> __( '', 'moto' ),
							'options'		=> array(
											'featured' => 'Featured Video',
											'recent'   => 'Recent Video'
										),
							'admin_label'	=> true
						),
					array(
						'type'			=> 'text',
						'label'			=> __( 'no. of video', 'moto' ),
						'name'			=> 'video_no',
						'description'	=> __( 'Enter the no. of video.', 'moto' ),
						'admin_label'	=> true
					),
				),

			)
		))
	);
/* MOTO Features */	
	$or->add_map( array('moto_feature' => array(
			'name' => __('Feature', 'moto'),
			'description' => __('Feature', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO Feature Setting',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_feature_list',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Format', 'moto' ),
						'name'			=> 'format',
						'options'		=> array(
											'format1' => 'Formate 1',
											'format2'   => 'Formate 2'
										),
						'description'	=> __( 'Choose Format', 'moto' ), 
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Sub Description', 'moto' ),
						'name'			=> 'sub_des',
						'description'	=> __( '', 'moto' ),
						'relation'	=> array(
									'parent'	=> 'format',
									'show_when'	=> 'format2'
								),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'description',
						'relation'	=> array(
									'parent'	=> 'format',
									'show_when'	=> 'format2'
								),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Images', 'moto' ),
						'name'			=> 'image',
						'description'	=> __( '', 'moto' ),
						'relation'	=> array(
									'parent'	=> 'format',
									'show_when'	=> 'format2'
								),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background color', 'moto' ),
						'name'			=> 'bg_color',
						'relation'	=> array(
									'parent'	=> 'format',
									'show_when'	=> 'format2'
								),						
						'description'	=> __( 'Choose Background color', 'moto' ), 
					),
				),

			),
			'content' => '[moto_feature_list title="Add Feature"][/moto_feature_list]'
		))
	);
	$or->add_map( array('moto_feature_list' => array(
			'name' => __('Add Feature', 'moto'),
			'description' => __('Add Feature', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO Single Feature Setting',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Text', 'moto' ),
						'name'			=> 'text',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'URL', 'moto' ),
						'name'			=> 'url',
						'description'	=> __( 'url here', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'	      => 'icon_picker',
						'name'	      => 'icon',
						'label'	      => 'Select Icon',
						'description'	=> __( 'Select icon from library.', 'moto' ),
						'admin_label' => true,
					)
				),

			),
		))
	);
//MOTO History Shortcode 	
	$or->add_map( array('moto_history_shortcode' => array(
			'name' => __('History', 'moto'),
			'description' => __('History', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'History Setting',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_history_list',
				'display' => 'vertical'
			),
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[moto_history_list title="History"][/moto_history_list]'
		))
	);
	$or->add_map( array('moto_history_list' => array(
			'name' => __('History', 'moto'),
			'description' => __('History', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Add History Setting',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'SubTitle', 'moto' ),
						'name'			=> 'subtitle',
						'description'	=> __( 'SubTitle here', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'description',
						'description'	=> __( 'description here', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Icon', 'moto' ),
						'name'			=> 'icon',
						'description'	=> __( 'Choose Icon', 'moto' ),
						'options'			=> array('select','icon-mobile'=>'icon-mobile', 'icon-laptop'=>'icon-laptop', 'icon-desktop'=>'icon-desktop', 'icon-tablet'=>'icon-tablet', 'icon-phone'=>'icon-phone', 'icon-document'=>'icon-document', 'icon-documents'=>'icon-documents', 'icon-search'=>'icon-search', 'icon-clipboard'=>'icon-clipboard', 'icon-newspaper'=>'icon-newspaper', 'icon-notebook'=>'icon-notebook', 'icon-book-open'=>'icon-book-open', 'icon-browser'=>'icon-browser', 'icon-calendar'=>'icon-calendar', 'icon-presentation'=>'icon-presentation', 'icon-picture'=>'icon-picture', 'icon-pictures'=>'icon-pictures', 'icon-video'=>'icon-video', 'icon-camera'=>'icon-camera', 'icon-printer'=>'icon-printer', 'icon-toolbox'=>'icon-toolbox', 'icon-briefcase'=>'icon-briefcase', 'icon-wallet'=>'icon-wallet', 'icon-gift'=>'icon-gift', 'icon-bargraph'=>'icon-bargraph', 'icon-grid'=>'icon-grid', 'icon-expand'=>'icon-expand', 'icon-focus'=>'icon-focus', 'icon-edit'=>'icon-edit', 'icon-adjustments'=>'icon-adjustments', 'icon-ribbon'=>'icon-ribbon', 'icon-hourglass'=>'icon-hourglass', 'icon-lock'=>'icon-lock', 'icon-megaphone'=>'icon-megaphone', 'icon-shield'=>'icon-shield', 'icon-trophy'=>'icon-trophy', 'icon-flag'=>'icon-flag', 'icon-map'=>'icon-map', 'icon-puzzle'=>'icon-puzzle', 'icon-basket'=>'icon-basket', 'icon-envelope'=>'icon-envelope', 'icon-streetsign'=>'icon-streetsign', 'icon-telescope'=>'icon-telescope', 'icon-gears'=>'icon-gears', 'icon-key'=>'icon-key', 'icon-paperclip'=>'icon-paperclip', 'icon-attachment'=>'icon-attachment', 'icon-pricetags'=>'icon-pricetags', 'icon-lightbulb'=>'icon-lightbulb', 'icon-layers'=>'icon-layers', 'icon-pencil'=>'icon-pencil', 'icon-tools'=>'icon-tools', 'icon-tools-2'=>'icon-tools-2', 'icon-scissors'=>'icon-scissors', 'icon-paintbrush'=>'icon-paintbrush', 'icon-magnifying-glass'=>'icon-magnifying-glass', 'icon-circle-compass'=>'icon-circle-compass', 'icon-linegraph'=>'icon-linegraph', 'icon-mic'=>'icon-mic', 'icon-strategy'=>'icon-strategy', 'icon-beaker'=>'icon-beaker', 'icon-caution'=>'icon-caution', 'icon-recycle'=>'icon-recycle', 'icon-anchor'=>'icon-anchor', 'icon-profile-male'=>'icon-profile-male', 'icon-profile-female'=>'icon-profile-female', 'icon-bike'=>'icon-bike', 'icon-wine'=>'icon-wine', 'icon-hotairballoon'=>'icon-hotairballoon', 'icon-globe'=>'icon-globe', 'icon-genius'=>'icon-genius', 'icon-map-pin'=>'icon-map-pin', 'icon-dial'=>'icon-dial', 'icon-chat'=>'icon-chat', 'icon-heart'=>'icon-heart', 'icon-cloud'=>'icon-cloud', 'icon-upload'=>'icon-upload', 'icon-download'=>'icon-download', 'icon-target'=>'icon-target', 'icon-hazardous'=>'icon-hazardous', 'icon-piechart'=>'icon-piechart', 'icon-speedometer'=>'icon-speedometer', 'icon-global'=>'icon-global', 'icon-compass'=>'icon-compass', 'icon-lifesaver'=>'icon-lifesaver', 'icon-clock'=>'icon-clock', 'icon-aperture'=>'icon-aperture', 'icon-quote'=>'icon-quote', 'icon-scope'=>'icon-scope', 'icon-alarmclock'=>'icon-alarmclock', 'icon-refresh'=>'icon-refresh', 'icon-happy'=>'icon-happy', 'icon-sad'=>'icon-sad', 'icon-facebook'=>'icon-facebook', 'icon-twitter'=>'icon-twitter', 'icon-googleplus'=>'icon-googleplus', 'icon-rss'=>'icon-rss', 'icon-tumblr'=>'icon-tumblr', 'icon-linkedin'=>'icon-linkedin', 'icon-dribbble'=>'icon-dribbble'),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'date_picker',
						'label'			=> __( 'History date', 'moto' ),
						'name'			=> 'h_date',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
		))
	);
/* MOTO Achievement */	
	$or->add_map( array('moto_achievement' => array(
			'name' => __('Achievement', 'moto'),
			'description' => __('Achievement', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO Achievement Setting',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_achievement_list',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Achievement Style', 'moto' ),
						'name'			=> 'achievement_style',
						'options'		=> array(
											'style1'  => 'Style 1',
											'style2'  => 'Style 2',
											'style3'  => 'Style 3'
										),
						'description'	=> __( '', 'moto' ), 
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Background Style', 'moto' ),
						'name'			=> 'background_style',
						'options'		=> array(
								'image' => 'Image',
								'color' => 'Color',
						),
						'description'	=> __( 'Choose Option', 'moto' ),
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Images', 'moto' ),
						'name'			=> 'bg_img',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'image'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background Color', 'moto' ),
						'name'			=> 'color',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'color'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Overlay ', 'moto' ),
						'name'			=> 'overlay',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'image'
						),
						'options' => array(
									'yes' => __( 'Yes', 'moto' )
								),
						'value'			=> 'yes',		
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Overlay Color', 'moto' ),
						'name'			=> 'overlay_color',
						'relation'	=> array(
							'parent'	=> 'overlay',
							'show_when'	=> 'yes'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					
				),

			),
			'content' => '[moto_achievement_list title="Add List"][/moto_achievement_list]'
		))
	);
	$or->add_map( array('moto_achievement_list' => array(
			'name' => __('Add List', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO List Setting',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Number', 'moto' ),
						'name'			=> 'number',
						'description'	=> __( 'Numerical value here', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Text', 'moto' ),
						'name'			=> 'text',
						'description'	=> __( 'Text here', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Icon', 'moto' ),
						'name'			=> 'icon',
						'description'	=> __( 'Choose Icon only for Style 2 and Style 3. Icons will not work properly with Style 1.', 'moto' ),
						'options'			=> array('select'=>'select','icon-mobile'=>'icon-mobile', 'icon-laptop'=>'icon-laptop', 'icon-desktop'=>'icon-desktop', 'icon-tablet'=>'icon-tablet', 'icon-phone'=>'icon-phone', 'icon-document'=>'icon-document', 'icon-documents'=>'icon-documents', 'icon-search'=>'icon-search', 'icon-clipboard'=>'icon-clipboard', 'icon-newspaper'=>'icon-newspaper', 'icon-notebook'=>'icon-notebook', 'icon-book-open'=>'icon-book-open', 'icon-browser'=>'icon-browser', 'icon-calendar'=>'icon-calendar', 'icon-presentation'=>'icon-presentation', 'icon-picture'=>'icon-picture', 'icon-pictures'=>'icon-pictures', 'icon-video'=>'icon-video', 'icon-camera'=>'icon-camera', 'icon-printer'=>'icon-printer', 'icon-toolbox'=>'icon-toolbox', 'icon-briefcase'=>'icon-briefcase', 'icon-wallet'=>'icon-wallet', 'icon-gift'=>'icon-gift', 'icon-bargraph'=>'icon-bargraph', 'icon-grid'=>'icon-grid', 'icon-expand'=>'icon-expand', 'icon-focus'=>'icon-focus', 'icon-edit'=>'icon-edit', 'icon-adjustments'=>'icon-adjustments', 'icon-ribbon'=>'icon-ribbon', 'icon-hourglass'=>'icon-hourglass', 'icon-lock'=>'icon-lock', 'icon-megaphone'=>'icon-megaphone', 'icon-shield'=>'icon-shield', 'icon-trophy'=>'icon-trophy', 'icon-flag'=>'icon-flag', 'icon-map'=>'icon-map', 'icon-puzzle'=>'icon-puzzle', 'icon-basket'=>'icon-basket', 'icon-envelope'=>'icon-envelope', 'icon-streetsign'=>'icon-streetsign', 'icon-telescope'=>'icon-telescope', 'icon-gears'=>'icon-gears', 'icon-key'=>'icon-key', 'icon-paperclip'=>'icon-paperclip', 'icon-attachment'=>'icon-attachment', 'icon-pricetags'=>'icon-pricetags', 'icon-lightbulb'=>'icon-lightbulb', 'icon-layers'=>'icon-layers', 'icon-pencil'=>'icon-pencil', 'icon-tools'=>'icon-tools', 'icon-tools-2'=>'icon-tools-2', 'icon-scissors'=>'icon-scissors', 'icon-paintbrush'=>'icon-paintbrush', 'icon-magnifying-glass'=>'icon-magnifying-glass', 'icon-circle-compass'=>'icon-circle-compass', 'icon-linegraph'=>'icon-linegraph', 'icon-mic'=>'icon-mic', 'icon-strategy'=>'icon-strategy', 'icon-beaker'=>'icon-beaker', 'icon-caution'=>'icon-caution', 'icon-recycle'=>'icon-recycle', 'icon-anchor'=>'icon-anchor', 'icon-profile-male'=>'icon-profile-male', 'icon-profile-female'=>'icon-profile-female', 'icon-bike'=>'icon-bike', 'icon-wine'=>'icon-wine', 'icon-hotairballoon'=>'icon-hotairballoon', 'icon-globe'=>'icon-globe', 'icon-genius'=>'icon-genius', 'icon-map-pin'=>'icon-map-pin', 'icon-dial'=>'icon-dial', 'icon-chat'=>'icon-chat', 'icon-heart'=>'icon-heart', 'icon-cloud'=>'icon-cloud', 'icon-upload'=>'icon-upload', 'icon-download'=>'icon-download', 'icon-target'=>'icon-target', 'icon-hazardous'=>'icon-hazardous', 'icon-piechart'=>'icon-piechart', 'icon-speedometer'=>'icon-speedometer', 'icon-global'=>'icon-global', 'icon-compass'=>'icon-compass', 'icon-lifesaver'=>'icon-lifesaver', 'icon-clock'=>'icon-clock', 'icon-aperture'=>'icon-aperture', 'icon-quote'=>'icon-quote', 'icon-scope'=>'icon-scope', 'icon-alarmclock'=>'icon-alarmclock', 'icon-refresh'=>'icon-refresh', 'icon-happy'=>'icon-happy', 'icon-sad'=>'icon-sad', 'icon-facebook'=>'icon-facebook', 'icon-twitter'=>'icon-twitter', 'icon-googleplus'=>'icon-googleplus', 'icon-rss'=>'icon-rss', 'icon-tumblr'=>'icon-tumblr', 'icon-linkedin'=>'icon-linkedin', 'icon-dribbble'=>'icon-dribbble'),
						'admin_label'	=> true
					),
				),

			),
		))
	);
/* MOTO Process */	
	$or->add_map( array('moto_process' => array(
			'name' => __('Moto Process', 'moto'),
			'description' => __('Moto Process', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO Process Setting',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_process_list',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Background Style', 'moto' ),
						'name'			=> 'background_style',
						'options'		=> array(
								'image' => 'Image',
								'color' => 'Color',
						),
						'description'	=> __( 'Choose Option', 'moto' ),
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Images', 'moto' ),
						'name'			=> 'bg_img',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'image'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background Color', 'moto' ),
						'name'			=> 'color',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'color'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Overlay ', 'moto' ),
						'name'			=> 'overlay',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'image'
						),
						'options' => array(
									'yes' => __( 'Yes', 'moto' )
								),
						'value'			=> 'yes',		
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Overlay Color', 'moto' ),
						'name'			=> 'overlay_color',
						'relation'	=> array(
							'parent'	=> 'overlay',
							'show_when'	=> 'yes'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[moto_process_list title="Add List"][/moto_process_list]'
		))
	);
	$or->add_map( array('moto_process_list' => array(
			'name' => __('Add List', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO List Setting',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'desc',
						'description'	=> __( 'Discription here', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Icon', 'moto' ),
						'name'			=> 'icon',
						'description'	=> __( 'Choose Icon', 'moto' ),
						'options'			=> array('select','icon-mobile'=>'icon-mobile', 'icon-laptop'=>'icon-laptop', 'icon-desktop'=>'icon-desktop', 'icon-tablet'=>'icon-tablet', 'icon-phone'=>'icon-phone', 'icon-document'=>'icon-document', 'icon-documents'=>'icon-documents', 'icon-search'=>'icon-search', 'icon-clipboard'=>'icon-clipboard', 'icon-newspaper'=>'icon-newspaper', 'icon-notebook'=>'icon-notebook', 'icon-book-open'=>'icon-book-open', 'icon-browser'=>'icon-browser', 'icon-calendar'=>'icon-calendar', 'icon-presentation'=>'icon-presentation', 'icon-picture'=>'icon-picture', 'icon-pictures'=>'icon-pictures', 'icon-video'=>'icon-video', 'icon-camera'=>'icon-camera', 'icon-printer'=>'icon-printer', 'icon-toolbox'=>'icon-toolbox', 'icon-briefcase'=>'icon-briefcase', 'icon-wallet'=>'icon-wallet', 'icon-gift'=>'icon-gift', 'icon-bargraph'=>'icon-bargraph', 'icon-grid'=>'icon-grid', 'icon-expand'=>'icon-expand', 'icon-focus'=>'icon-focus', 'icon-edit'=>'icon-edit', 'icon-adjustments'=>'icon-adjustments', 'icon-ribbon'=>'icon-ribbon', 'icon-hourglass'=>'icon-hourglass', 'icon-lock'=>'icon-lock', 'icon-megaphone'=>'icon-megaphone', 'icon-shield'=>'icon-shield', 'icon-trophy'=>'icon-trophy', 'icon-flag'=>'icon-flag', 'icon-map'=>'icon-map', 'icon-puzzle'=>'icon-puzzle', 'icon-basket'=>'icon-basket', 'icon-envelope'=>'icon-envelope', 'icon-streetsign'=>'icon-streetsign', 'icon-telescope'=>'icon-telescope', 'icon-gears'=>'icon-gears', 'icon-key'=>'icon-key', 'icon-paperclip'=>'icon-paperclip', 'icon-attachment'=>'icon-attachment', 'icon-pricetags'=>'icon-pricetags', 'icon-lightbulb'=>'icon-lightbulb', 'icon-layers'=>'icon-layers', 'icon-pencil'=>'icon-pencil', 'icon-tools'=>'icon-tools', 'icon-tools-2'=>'icon-tools-2', 'icon-scissors'=>'icon-scissors', 'icon-paintbrush'=>'icon-paintbrush', 'icon-magnifying-glass'=>'icon-magnifying-glass', 'icon-circle-compass'=>'icon-circle-compass', 'icon-linegraph'=>'icon-linegraph', 'icon-mic'=>'icon-mic', 'icon-strategy'=>'icon-strategy', 'icon-beaker'=>'icon-beaker', 'icon-caution'=>'icon-caution', 'icon-recycle'=>'icon-recycle', 'icon-anchor'=>'icon-anchor', 'icon-profile-male'=>'icon-profile-male', 'icon-profile-female'=>'icon-profile-female', 'icon-bike'=>'icon-bike', 'icon-wine'=>'icon-wine', 'icon-hotairballoon'=>'icon-hotairballoon', 'icon-globe'=>'icon-globe', 'icon-genius'=>'icon-genius', 'icon-map-pin'=>'icon-map-pin', 'icon-dial'=>'icon-dial', 'icon-chat'=>'icon-chat', 'icon-heart'=>'icon-heart', 'icon-cloud'=>'icon-cloud', 'icon-upload'=>'icon-upload', 'icon-download'=>'icon-download', 'icon-target'=>'icon-target', 'icon-hazardous'=>'icon-hazardous', 'icon-piechart'=>'icon-piechart', 'icon-speedometer'=>'icon-speedometer', 'icon-global'=>'icon-global', 'icon-compass'=>'icon-compass', 'icon-lifesaver'=>'icon-lifesaver', 'icon-clock'=>'icon-clock', 'icon-aperture'=>'icon-aperture', 'icon-quote'=>'icon-quote', 'icon-scope'=>'icon-scope', 'icon-alarmclock'=>'icon-alarmclock', 'icon-refresh'=>'icon-refresh', 'icon-happy'=>'icon-happy', 'icon-sad'=>'icon-sad', 'icon-facebook'=>'icon-facebook', 'icon-twitter'=>'icon-twitter', 'icon-googleplus'=>'icon-googleplus', 'icon-rss'=>'icon-rss', 'icon-tumblr'=>'icon-tumblr', 'icon-linkedin'=>'icon-linkedin', 'icon-dribbble'=>'icon-dribbble'),
						'admin_label'	=> true
					),
				),

			),
		))
	);
/* MOTO Pricing */	
	$or->add_map( array('moto_pricing' => array(
			'name' => __('Moto Pricing', 'moto'),
			'description' => __('Moto Pricing', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO Pricing Setting',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_add_pricing_features',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Currency', 'moto' ),
						'name'			=> 'currency',
						'description'	=> __( 'Currency Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Price', 'moto' ),
						'name'			=> 'price',
						'description'	=> __( 'Price Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Time', 'moto' ),
						'name'			=> 'time',
						'description'	=> __( 'Time Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Text', 'moto' ),
						'name'			=> 'btn_text',
						'description'	=> __( 'Button Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Link', 'moto' ),
						'name'			=> 'btn_link',
						'description'	=> __( 'Button Link Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Active', 'moto' ),
						'name'			=> 'active',
						'description'	=> __( 'Button Link Here.', 'moto' ),
						'options' => array(
									'highlight-pricing' => __( 'Yes', 'moto' )
								),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Pricing Table Style Option.', 'moto' ),
						'name'			=> 'pricing_style',
						'options'		=> array(
											'style1'  => 'Style 1',
											'style2'  => 'Style 2',
											'style3'  => 'Style 3'
										),
						'description'	=> __( '', 'moto' ), 
					),
				),

			),
			'content' => '[moto_add_pricing_features title="Add Pricing Features"][/moto_add_pricing_features]'
		))
	);
	$or->add_map( array('moto_add_pricing_features' => array(
			'name' => __('Add Pricing Features', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO Pricing List',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Features Text', 'moto' ),
						'name'			=> 'features',
						'description'	=> __( 'Enter Features Text', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
		))
	);
/* MOTO Website Features */	
	$or->add_map( array('moto_our_features' => array(
			'name' => __('Website Features', 'moto'),
			'description' => __('Website Features', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO Website Features',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_add_our_features',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Formate', 'moto' ),
						'name'			=> 'feature_formate',
						'options'	 	=> array(
									'formate_1' => 'formate1',
									'formate_2' => 'formate2'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Images', 'moto' ),
						'name'			=> 'image',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background color', 'moto' ),
						'name'			=> 'bg_color',
						'description'	=> __( 'Choose Background color', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[moto_add_our_features title="Add Website Features"][/moto_add_our_features]'
		))
	);
	$or->add_map( array('moto_add_our_features' => array(
			'name' => __('Add Website Features', 'moto'),
			'description' => __('Add Website Features', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Single Features',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Features Title', 'moto' ),
						'name'			=> 'features_title',
						'description'	=> __( 'Enter Features Title', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Icon', 'moto' ),
						'name'			=> 'icon',
						'description'	=> __( 'Choose Icon', 'moto' ),
						'options'			=> array('select','icon-mobile'=>'icon-mobile', 'icon-laptop'=>'icon-laptop', 'icon-desktop'=>'icon-desktop', 'icon-tablet'=>'icon-tablet', 'icon-phone'=>'icon-phone', 'icon-document'=>'icon-document', 'icon-documents'=>'icon-documents', 'icon-search'=>'icon-search', 'icon-clipboard'=>'icon-clipboard', 'icon-newspaper'=>'icon-newspaper', 'icon-notebook'=>'icon-notebook', 'icon-book-open'=>'icon-book-open', 'icon-browser'=>'icon-browser', 'icon-calendar'=>'icon-calendar', 'icon-presentation'=>'icon-presentation', 'icon-picture'=>'icon-picture', 'icon-pictures'=>'icon-pictures', 'icon-video'=>'icon-video', 'icon-camera'=>'icon-camera', 'icon-printer'=>'icon-printer', 'icon-toolbox'=>'icon-toolbox', 'icon-briefcase'=>'icon-briefcase', 'icon-wallet'=>'icon-wallet', 'icon-gift'=>'icon-gift', 'icon-bargraph'=>'icon-bargraph', 'icon-grid'=>'icon-grid', 'icon-expand'=>'icon-expand', 'icon-focus'=>'icon-focus', 'icon-edit'=>'icon-edit', 'icon-adjustments'=>'icon-adjustments', 'icon-ribbon'=>'icon-ribbon', 'icon-hourglass'=>'icon-hourglass', 'icon-lock'=>'icon-lock', 'icon-megaphone'=>'icon-megaphone', 'icon-shield'=>'icon-shield', 'icon-trophy'=>'icon-trophy', 'icon-flag'=>'icon-flag', 'icon-map'=>'icon-map', 'icon-puzzle'=>'icon-puzzle', 'icon-basket'=>'icon-basket', 'icon-envelope'=>'icon-envelope', 'icon-streetsign'=>'icon-streetsign', 'icon-telescope'=>'icon-telescope', 'icon-gears'=>'icon-gears', 'icon-key'=>'icon-key', 'icon-paperclip'=>'icon-paperclip', 'icon-attachment'=>'icon-attachment', 'icon-pricetags'=>'icon-pricetags', 'icon-lightbulb'=>'icon-lightbulb', 'icon-layers'=>'icon-layers', 'icon-pencil'=>'icon-pencil', 'icon-tools'=>'icon-tools', 'icon-tools-2'=>'icon-tools-2', 'icon-scissors'=>'icon-scissors', 'icon-paintbrush'=>'icon-paintbrush', 'icon-magnifying-glass'=>'icon-magnifying-glass', 'icon-circle-compass'=>'icon-circle-compass', 'icon-linegraph'=>'icon-linegraph', 'icon-mic'=>'icon-mic', 'icon-strategy'=>'icon-strategy', 'icon-beaker'=>'icon-beaker', 'icon-caution'=>'icon-caution', 'icon-recycle'=>'icon-recycle', 'icon-anchor'=>'icon-anchor', 'icon-profile-male'=>'icon-profile-male', 'icon-profile-female'=>'icon-profile-female', 'icon-bike'=>'icon-bike', 'icon-wine'=>'icon-wine', 'icon-hotairballoon'=>'icon-hotairballoon', 'icon-globe'=>'icon-globe', 'icon-genius'=>'icon-genius', 'icon-map-pin'=>'icon-map-pin', 'icon-dial'=>'icon-dial', 'icon-chat'=>'icon-chat', 'icon-heart'=>'icon-heart', 'icon-cloud'=>'icon-cloud', 'icon-upload'=>'icon-upload', 'icon-download'=>'icon-download', 'icon-target'=>'icon-target', 'icon-hazardous'=>'icon-hazardous', 'icon-piechart'=>'icon-piechart', 'icon-speedometer'=>'icon-speedometer', 'icon-global'=>'icon-global', 'icon-compass'=>'icon-compass', 'icon-lifesaver'=>'icon-lifesaver', 'icon-clock'=>'icon-clock', 'icon-aperture'=>'icon-aperture', 'icon-quote'=>'icon-quote', 'icon-scope'=>'icon-scope', 'icon-alarmclock'=>'icon-alarmclock', 'icon-refresh'=>'icon-refresh', 'icon-happy'=>'icon-happy', 'icon-sad'=>'icon-sad', 'icon-facebook'=>'icon-facebook', 'icon-twitter'=>'icon-twitter', 'icon-googleplus'=>'icon-googleplus', 'icon-rss'=>'icon-rss', 'icon-tumblr'=>'icon-tumblr', 'icon-linkedin'=>'icon-linkedin', 'icon-dribbble'=>'icon-dribbble'),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'description',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'URL', 'moto' ),
						'name'			=> 'in_url',
						'description'	=> __( 'Enter URL', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
		))
	);
/* WE ARE MOTO */	
	$or->add_map( array('moto_we_are_moto' => array(
			'name' => __('We Are Moto', 'moto'),
			'description' => __('We Are Moto', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'We Are Moto Features',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_text_slider',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Sub Title', 'moto' ),
						'name'			=> 'sub_title',
						'description'	=> __( 'Sub Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Images', 'moto' ),
						'name'			=> 'image',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background color', 'moto' ),
						'name'			=> 'bg_color',
						'description'	=> __( 'Choose Background color', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[moto_text_slider title="Add Text Slider"][/moto_text_slider]'
		))
	);
	$or->add_map( array('moto_text_slider' => array(
			'name' => __('Add Text Slider', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Add Text Slides',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'description',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
		))
	);
/* Theme Features */	
	$or->add_map( array('moto_theme_features_fun' => array(
			'name' => __('Theme Features', 'moto'),
			'description' => __('Theme Features', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Theme Features',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_add_theme_features',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'No Padding top', 'moto' ),
						'name'			=> 'padding',
						'options'		=> array(
							'no_padding_top' => 'No Padding top',
							'no_padding_bottom' => 'No Padding Bottom',
							'no-padding' => 'No Padding',
							'no-margin' => 'No margin'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background color', 'moto' ),
						'name'			=> 'bg_color',
						'description'	=> __( 'Choose Background color', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[moto_add_theme_features title="Add Theme Feature"][/moto_add_theme_features]'
		))
	);
	$or->add_map( array('moto_add_theme_features' => array(
			'name' => __('Add Theme Features', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Feature',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select column', 'moto' ),
						'name'			=> 'column',
						'description'	=> __( 'Choose column', 'moto' ),
						'options'		=> array(
							'column_3'	=> '3 Columns',
							'column_4'	=> '4 Columns',
						),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Left Border', 'moto' ),
						'name'			=> 'left_border',
						'description'	=> __( 'Choose Left Border', 'moto' ),
						'options'		=> array(
							'yes'	=> 'Yes',
							'no'	=> 'No',
						),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Sub Title', 'moto' ),
						'name'			=> 'sub_title',
						'description'	=> __( 'Sub Title text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Icon', 'moto' ),
						'name'			=> 'icon',
						'description'	=> __( 'Choose Icon', 'moto' ),
						'options'			=> array('select','icon-mobile'=>'icon-mobile', 'icon-laptop'=>'icon-laptop', 'icon-desktop'=>'icon-desktop', 'icon-tablet'=>'icon-tablet', 'icon-phone'=>'icon-phone', 'icon-document'=>'icon-document', 'icon-documents'=>'icon-documents', 'icon-search'=>'icon-search', 'icon-clipboard'=>'icon-clipboard', 'icon-newspaper'=>'icon-newspaper', 'icon-notebook'=>'icon-notebook', 'icon-book-open'=>'icon-book-open', 'icon-browser'=>'icon-browser', 'icon-calendar'=>'icon-calendar', 'icon-presentation'=>'icon-presentation', 'icon-picture'=>'icon-picture', 'icon-pictures'=>'icon-pictures', 'icon-video'=>'icon-video', 'icon-camera'=>'icon-camera', 'icon-printer'=>'icon-printer', 'icon-toolbox'=>'icon-toolbox', 'icon-briefcase'=>'icon-briefcase', 'icon-wallet'=>'icon-wallet', 'icon-gift'=>'icon-gift', 'icon-bargraph'=>'icon-bargraph', 'icon-grid'=>'icon-grid', 'icon-expand'=>'icon-expand', 'icon-focus'=>'icon-focus', 'icon-edit'=>'icon-edit', 'icon-adjustments'=>'icon-adjustments', 'icon-ribbon'=>'icon-ribbon', 'icon-hourglass'=>'icon-hourglass', 'icon-lock'=>'icon-lock', 'icon-megaphone'=>'icon-megaphone', 'icon-shield'=>'icon-shield', 'icon-trophy'=>'icon-trophy', 'icon-flag'=>'icon-flag', 'icon-map'=>'icon-map', 'icon-puzzle'=>'icon-puzzle', 'icon-basket'=>'icon-basket', 'icon-envelope'=>'icon-envelope', 'icon-streetsign'=>'icon-streetsign', 'icon-telescope'=>'icon-telescope', 'icon-gears'=>'icon-gears', 'icon-key'=>'icon-key', 'icon-paperclip'=>'icon-paperclip', 'icon-attachment'=>'icon-attachment', 'icon-pricetags'=>'icon-pricetags', 'icon-lightbulb'=>'icon-lightbulb', 'icon-layers'=>'icon-layers', 'icon-pencil'=>'icon-pencil', 'icon-tools'=>'icon-tools', 'icon-tools-2'=>'icon-tools-2', 'icon-scissors'=>'icon-scissors', 'icon-paintbrush'=>'icon-paintbrush', 'icon-magnifying-glass'=>'icon-magnifying-glass', 'icon-circle-compass'=>'icon-circle-compass', 'icon-linegraph'=>'icon-linegraph', 'icon-mic'=>'icon-mic', 'icon-strategy'=>'icon-strategy', 'icon-beaker'=>'icon-beaker', 'icon-caution'=>'icon-caution', 'icon-recycle'=>'icon-recycle', 'icon-anchor'=>'icon-anchor', 'icon-profile-male'=>'icon-profile-male', 'icon-profile-female'=>'icon-profile-female', 'icon-bike'=>'icon-bike', 'icon-wine'=>'icon-wine', 'icon-hotairballoon'=>'icon-hotairballoon', 'icon-globe'=>'icon-globe', 'icon-genius'=>'icon-genius', 'icon-map-pin'=>'icon-map-pin', 'icon-dial'=>'icon-dial', 'icon-chat'=>'icon-chat', 'icon-heart'=>'icon-heart', 'icon-cloud'=>'icon-cloud', 'icon-upload'=>'icon-upload', 'icon-download'=>'icon-download', 'icon-target'=>'icon-target', 'icon-hazardous'=>'icon-hazardous', 'icon-piechart'=>'icon-piechart', 'icon-speedometer'=>'icon-speedometer', 'icon-global'=>'icon-global', 'icon-compass'=>'icon-compass', 'icon-lifesaver'=>'icon-lifesaver', 'icon-clock'=>'icon-clock', 'icon-aperture'=>'icon-aperture', 'icon-quote'=>'icon-quote', 'icon-scope'=>'icon-scope', 'icon-alarmclock'=>'icon-alarmclock', 'icon-refresh'=>'icon-refresh', 'icon-happy'=>'icon-happy', 'icon-sad'=>'icon-sad', 'icon-facebook'=>'icon-facebook', 'icon-twitter'=>'icon-twitter', 'icon-googleplus'=>'icon-googleplus', 'icon-rss'=>'icon-rss', 'icon-tumblr'=>'icon-tumblr', 'icon-linkedin'=>'icon-linkedin', 'icon-dribbble'=>'icon-dribbble'),
						'admin_label'	=> true
					),
				),

			),
		))
	);
/* Mobile Features */	
	$or->add_map( array('moto_mobile_features_fun' => array(
			'name' => __('Mobile Features', 'moto'),
			'description' => __('Mobile Features', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Mobile Features',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_add_mobile_features',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Icon Position', 'moto' ),
						'name'			=> 'icon_position',
						'options'		=> array(
							'Left' => 'Left',
							'Right' => 'Right'
						),
						'description'	=> __( 'Choose Icon Position', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[moto_add_mobile_features title="Add Mobile Feature"][/moto_add_mobile_features]'
		))
	);
	$or->add_map( array('moto_add_mobile_features' => array(
			'name' => __('Add Mobile Features', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Single Feature',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Title color', 'moto' ),
						'name'			=> 'title_color',
						'description'	=> __( 'Choose Title Color', 'moto' ),
						'admin_label'	=> true
					 ),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Icon', 'moto' ),
						'name'			=> 'icon',
						'description'	=> __( 'Choose Icon', 'moto' ),
						'options'			=> array('select','icon-mobile'=>'icon-mobile', 'icon-laptop'=>'icon-laptop', 'icon-desktop'=>'icon-desktop', 'icon-tablet'=>'icon-tablet', 'icon-phone'=>'icon-phone', 'icon-document'=>'icon-document', 'icon-documents'=>'icon-documents', 'icon-search'=>'icon-search', 'icon-clipboard'=>'icon-clipboard', 'icon-newspaper'=>'icon-newspaper', 'icon-notebook'=>'icon-notebook', 'icon-book-open'=>'icon-book-open', 'icon-browser'=>'icon-browser', 'icon-calendar'=>'icon-calendar', 'icon-presentation'=>'icon-presentation', 'icon-picture'=>'icon-picture', 'icon-pictures'=>'icon-pictures', 'icon-video'=>'icon-video', 'icon-camera'=>'icon-camera', 'icon-printer'=>'icon-printer', 'icon-toolbox'=>'icon-toolbox', 'icon-briefcase'=>'icon-briefcase', 'icon-wallet'=>'icon-wallet', 'icon-gift'=>'icon-gift', 'icon-bargraph'=>'icon-bargraph', 'icon-grid'=>'icon-grid', 'icon-expand'=>'icon-expand', 'icon-focus'=>'icon-focus', 'icon-edit'=>'icon-edit', 'icon-adjustments'=>'icon-adjustments', 'icon-ribbon'=>'icon-ribbon', 'icon-hourglass'=>'icon-hourglass', 'icon-lock'=>'icon-lock', 'icon-megaphone'=>'icon-megaphone', 'icon-shield'=>'icon-shield', 'icon-trophy'=>'icon-trophy', 'icon-flag'=>'icon-flag', 'icon-map'=>'icon-map', 'icon-puzzle'=>'icon-puzzle', 'icon-basket'=>'icon-basket', 'icon-envelope'=>'icon-envelope', 'icon-streetsign'=>'icon-streetsign', 'icon-telescope'=>'icon-telescope', 'icon-gears'=>'icon-gears', 'icon-key'=>'icon-key', 'icon-paperclip'=>'icon-paperclip', 'icon-attachment'=>'icon-attachment', 'icon-pricetags'=>'icon-pricetags', 'icon-lightbulb'=>'icon-lightbulb', 'icon-layers'=>'icon-layers', 'icon-pencil'=>'icon-pencil', 'icon-tools'=>'icon-tools', 'icon-tools-2'=>'icon-tools-2', 'icon-scissors'=>'icon-scissors', 'icon-paintbrush'=>'icon-paintbrush', 'icon-magnifying-glass'=>'icon-magnifying-glass', 'icon-circle-compass'=>'icon-circle-compass', 'icon-linegraph'=>'icon-linegraph', 'icon-mic'=>'icon-mic', 'icon-strategy'=>'icon-strategy', 'icon-beaker'=>'icon-beaker', 'icon-caution'=>'icon-caution', 'icon-recycle'=>'icon-recycle', 'icon-anchor'=>'icon-anchor', 'icon-profile-male'=>'icon-profile-male', 'icon-profile-female'=>'icon-profile-female', 'icon-bike'=>'icon-bike', 'icon-wine'=>'icon-wine', 'icon-hotairballoon'=>'icon-hotairballoon', 'icon-globe'=>'icon-globe', 'icon-genius'=>'icon-genius', 'icon-map-pin'=>'icon-map-pin', 'icon-dial'=>'icon-dial', 'icon-chat'=>'icon-chat', 'icon-heart'=>'icon-heart', 'icon-cloud'=>'icon-cloud', 'icon-upload'=>'icon-upload', 'icon-download'=>'icon-download', 'icon-target'=>'icon-target', 'icon-hazardous'=>'icon-hazardous', 'icon-piechart'=>'icon-piechart', 'icon-speedometer'=>'icon-speedometer', 'icon-global'=>'icon-global', 'icon-compass'=>'icon-compass', 'icon-lifesaver'=>'icon-lifesaver', 'icon-clock'=>'icon-clock', 'icon-aperture'=>'icon-aperture', 'icon-quote'=>'icon-quote', 'icon-scope'=>'icon-scope', 'icon-alarmclock'=>'icon-alarmclock', 'icon-refresh'=>'icon-refresh', 'icon-happy'=>'icon-happy', 'icon-sad'=>'icon-sad', 'icon-facebook'=>'icon-facebook', 'icon-twitter'=>'icon-twitter', 'icon-googleplus'=>'icon-googleplus', 'icon-rss'=>'icon-rss', 'icon-tumblr'=>'icon-tumblr', 'icon-linkedin'=>'icon-linkedin', 'icon-dribbble'=>'icon-dribbble'),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'description',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
		))
	);
/* MOTO Latest Works */	
	$or->add_map( array('moto_latest_works_fun' => array(
			'name' => __('Latest Works', 'moto'),
			'description' => __('Latest Works', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Latest Works',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_add_latest_works',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Main Title', 'moto' ),
						'name'			=> 'main_title',
						'description'	=> __( 'Main Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Images', 'moto' ),
						'name'			=> 'image',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Sub Title', 'moto' ),
						'name'			=> 'sub_title',
						'description'	=> __( 'Sub Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Text', 'moto' ),
						'name'			=> 'btn_text',
						'description'	=> __( 'Button Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Link', 'moto' ),
						'name'			=> 'btn_link',
						'description'	=> __( 'Button Link Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background color', 'moto' ),
						'name'			=> 'bg_color',
						'description'	=> __( 'Choose Background color', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[moto_add_latest_works title="Add Latest Works"][/moto_add_latest_works]'
		))
	);
	$or->add_map( array('moto_add_latest_works' => array(
			'name' => __('Add Latest Works', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Single Work',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Icon', 'moto' ),
						'name'			=> 'icon',
						'description'	=> __( 'Choose Icon', 'moto' ),
						'options'			=> array('select','icon-mobile'=>'icon-mobile', 'icon-laptop'=>'icon-laptop', 'icon-desktop'=>'icon-desktop', 'icon-tablet'=>'icon-tablet', 'icon-phone'=>'icon-phone', 'icon-document'=>'icon-document', 'icon-documents'=>'icon-documents', 'icon-search'=>'icon-search', 'icon-clipboard'=>'icon-clipboard', 'icon-newspaper'=>'icon-newspaper', 'icon-notebook'=>'icon-notebook', 'icon-book-open'=>'icon-book-open', 'icon-browser'=>'icon-browser', 'icon-calendar'=>'icon-calendar', 'icon-presentation'=>'icon-presentation', 'icon-picture'=>'icon-picture', 'icon-pictures'=>'icon-pictures', 'icon-video'=>'icon-video', 'icon-camera'=>'icon-camera', 'icon-printer'=>'icon-printer', 'icon-toolbox'=>'icon-toolbox', 'icon-briefcase'=>'icon-briefcase', 'icon-wallet'=>'icon-wallet', 'icon-gift'=>'icon-gift', 'icon-bargraph'=>'icon-bargraph', 'icon-grid'=>'icon-grid', 'icon-expand'=>'icon-expand', 'icon-focus'=>'icon-focus', 'icon-edit'=>'icon-edit', 'icon-adjustments'=>'icon-adjustments', 'icon-ribbon'=>'icon-ribbon', 'icon-hourglass'=>'icon-hourglass', 'icon-lock'=>'icon-lock', 'icon-megaphone'=>'icon-megaphone', 'icon-shield'=>'icon-shield', 'icon-trophy'=>'icon-trophy', 'icon-flag'=>'icon-flag', 'icon-map'=>'icon-map', 'icon-puzzle'=>'icon-puzzle', 'icon-basket'=>'icon-basket', 'icon-envelope'=>'icon-envelope', 'icon-streetsign'=>'icon-streetsign', 'icon-telescope'=>'icon-telescope', 'icon-gears'=>'icon-gears', 'icon-key'=>'icon-key', 'icon-paperclip'=>'icon-paperclip', 'icon-attachment'=>'icon-attachment', 'icon-pricetags'=>'icon-pricetags', 'icon-lightbulb'=>'icon-lightbulb', 'icon-layers'=>'icon-layers', 'icon-pencil'=>'icon-pencil', 'icon-tools'=>'icon-tools', 'icon-tools-2'=>'icon-tools-2', 'icon-scissors'=>'icon-scissors', 'icon-paintbrush'=>'icon-paintbrush', 'icon-magnifying-glass'=>'icon-magnifying-glass', 'icon-circle-compass'=>'icon-circle-compass', 'icon-linegraph'=>'icon-linegraph', 'icon-mic'=>'icon-mic', 'icon-strategy'=>'icon-strategy', 'icon-beaker'=>'icon-beaker', 'icon-caution'=>'icon-caution', 'icon-recycle'=>'icon-recycle', 'icon-anchor'=>'icon-anchor', 'icon-profile-male'=>'icon-profile-male', 'icon-profile-female'=>'icon-profile-female', 'icon-bike'=>'icon-bike', 'icon-wine'=>'icon-wine', 'icon-hotairballoon'=>'icon-hotairballoon', 'icon-globe'=>'icon-globe', 'icon-genius'=>'icon-genius', 'icon-map-pin'=>'icon-map-pin', 'icon-dial'=>'icon-dial', 'icon-chat'=>'icon-chat', 'icon-heart'=>'icon-heart', 'icon-cloud'=>'icon-cloud', 'icon-upload'=>'icon-upload', 'icon-download'=>'icon-download', 'icon-target'=>'icon-target', 'icon-hazardous'=>'icon-hazardous', 'icon-piechart'=>'icon-piechart', 'icon-speedometer'=>'icon-speedometer', 'icon-global'=>'icon-global', 'icon-compass'=>'icon-compass', 'icon-lifesaver'=>'icon-lifesaver', 'icon-clock'=>'icon-clock', 'icon-aperture'=>'icon-aperture', 'icon-quote'=>'icon-quote', 'icon-scope'=>'icon-scope', 'icon-alarmclock'=>'icon-alarmclock', 'icon-refresh'=>'icon-refresh', 'icon-happy'=>'icon-happy', 'icon-sad'=>'icon-sad', 'icon-facebook'=>'icon-facebook', 'icon-twitter'=>'icon-twitter', 'icon-googleplus'=>'icon-googleplus', 'icon-rss'=>'icon-rss', 'icon-tumblr'=>'icon-tumblr', 'icon-linkedin'=>'icon-linkedin', 'icon-dribbble'=>'icon-dribbble'),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'description',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Link', 'moto' ),
						'name'			=> 'link',
						'description'	=> __( 'Link Here.', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
		))
	);
	
	/* Profile Slider */
	$or->add_map( array('moto_Profile_slider' => array(
			'name' => __('MOTO Profile Slider', 'moto'),
			'description' => __('Profile slider', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Profile',
			'is_container' => true,
			'params' => array(
				array(
					'type'			=> 'text',
					'label'			=> __( 'Title', 'moto' ),
					'name'			=> 'title',
					'description'	=> __( 'Title Text Here.', 'moto' ),
					'admin_label'	=> true
				),
				
				array(
					'type' => 'group',
					'label'			=> __( 'Testimonials', 'originbuilder' ),
					'name' 			=> 'testimonials',
					'description'	=> __( 'Add your testimonials here.', 'originbuilder' ),
					'params' 		=> array(
						array(
							'type'			=>  'text',
							'label'			=> __( 'Name', 'originbuilder' ),
							'name'			=> 'name',
							'description'	=> __( "Here is testimonial name", 'originbuilder' ),
						), 
						array(
							'type'			=> 'attach_image',
							'label'			=> __( 'Profile picture', 'moto' ),
							'name'			=> 'testi_pic_3',
							'description'	=> __( 'Here is testimonial profile picture', 'moto' )
						),
						array(
							'type'			=>  'text',
							'label'			=> __( 'Designation', 'originbuilder' ),
							'name'			=> 'designation',
							'description'	=> __( "Here is testimonial designation", 'originbuilder' ),
						), 
						array(
							'type'			=>  'textarea',
							'label'			=> __( 'Description', 'originbuilder' ),
							'name'			=> 'description',
							'description'	=> __( "Here is testimonial description", 'originbuilder' ),
						),
						array(
							'type'			=>  'text',
							'label'			=> __( 'Button text', 'originbuilder' ),
							'name'			=> 'btn_txt',
							'description'	=> __( "Here is testimonial description", 'originbuilder' ),
						),
						array(
							'type'			=>  'text',
							'label'			=> __( 'Button Url', 'originbuilder' ),
							'name'			=> 'btn_url',
							'description'	=> __( "Here is testimonial description", 'originbuilder' ),
						),
					),
				),
				
				array(
					'type'			=> 'dropdown',
					'label'			=> __( 'Slide alignment ', 'moto' ),
					'name'			=> 'slide_align',
					'options'		=> array(
						'left' => 'left',
						'center' => 'center',
						'right' => 'right'
					),
					'admin_label'	=> true,
					'value'			=> 'center'
				),
				
			)
		)
	) );
	/* Profile Slider */
	
/* MOTO Testimonials */	
	$or->add_map( array('moto_testimonial' => array(
			'name' => __('MOTO Testimonials', 'moto'),
			'description' => __('MOTO Testimonials', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Testimonials',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_single_testimonial',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Formate', 'moto' ),
						'name'			=> 'formate',
						'description'	=> __( 'Child element doesn\'t work for Formate 3 & Formate 4.', 'moto' ),
						'options'		=> array(
							'formate_1' => 'Formate 1',
							'formate_2' => 'Formate 2',
							'formate_3' => 'Formate 3'
						),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Image.', 'moto' ),
						'name'			=> 'testi_back',
						'description'	=> __( '', 'moto' ),
						'relation'		=> array(
							'parent'	=> 'formate',
							'show_when'	=> 'formate_1'
						),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Product Image.', 'moto' ),
						'name'			=> 'product_img',
						'description'	=> __( '', 'moto' ),
						'relation'		=> array(
							'parent'	=> 'formate',
							'show_when'	=> 'formate_1'
						),
						'admin_label'	=> true
					),	
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background color', 'moto' ),
						'name'			=> 'color',
						'description'	=> __( 'Choose Background color', 'moto' ),
						'relation'		=> array(
							'parent'	=> 'formate',
							'show_when'	=> array('formate_2','formate_3')
						),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Heading color', 'moto' ),
						'name'			=> 'hd_color',
						'description'	=> __( 'Choose HEading color', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Font color', 'moto' ),
						'name'			=> 'ft_color',
						'description'	=> __( 'Choose Font color', 'moto' ),
						'admin_label'	=> true
					),
                    array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Select Navigation Style', 'moto' ),
						'name'			=> 'navigation',
						'description'	=> __( 'Choose Icon', 'moto' ),
						'options'			=> array('select','nav_arrow'=>'Arrow', 'nav_dot'=>'Dots','nav_none'=>'Auto Play'),
						'admin_label'	=> true
					  ),					
				),

			),
			'content' => '[moto_single_testimonial title="Single Testimonial"][/moto_single_testimonial]'
		))
	);
	$or->add_map( array('moto_single_testimonial' => array(
			'name' => __('Single Testimonial', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Single Testimonial',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Designation', 'moto' ),
						'name'			=> 'designation',
						'description'	=> __( 'Designation Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'desc',
						'description'	=> __( 'Add Description Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Visitor Name', 'moto' ),
						'name'			=> 'name',
						'description'	=> __( 'Add Visitor Name Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Visitor Image.', 'moto' ),
						'name'			=> 'visitor_img',
						'description'	=> __( 'Upload Image', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
		))
	);
/* WHAT WE PROVIDES */	
	$or->add_map( array('moto_wwp' => array(
			'name' => __('What We Provides', 'moto'),
			'description' => __('What We Provides', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'What We Provides',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_single_wwp',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'ppw_des',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Image', 'moto' ),
						'name'			=> 'image',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[moto_single_wwp title="Add Setting"][/moto_single_wwp]'
		))
	);
	$or->add_map( array('moto_single_wwp' => array(
			'name' => __('Add Setting', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Description',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Heading', 'moto' ),
						'name'			=> 'head',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'description',
						'description'	=> __( 'Add Description Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'	      => 'icon_picker',
						'name'	      => 'icon',
						'label'	      => 'Select Icon',
						'description'	=> __( 'Select icon from library.', 'moto' ),
						'admin_label' => true,
					)
				),

			),
		))
	);
/* OUR LATEST PROJECTS */	
	$or->add_map( array('our_latest_projects' => array(
			'name' => __('OUR LATEST PROJECTS', 'moto'),
			'description' => __('OUR LATEST PROJECTS', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'OUR LATEST PROJECTS',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_single_project',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Title Text Here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'desc',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Text', 'moto' ),
						'name'			=> 'button',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Button Link', 'moto' ),
						'name'			=> 'btn_link',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[moto_single_project title="Add Project"][/moto_single_project]'
		))
	);
	$or->add_map( array('moto_single_project' => array(
			'name' => __('Add Project', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Project',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Project Image', 'moto' ),
						'name'			=> 'upload_project',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Project Link', 'moto' ),
						'name'			=> 'project_link',
						'description'	=> __( '', 'moto' ), 
						'admin_label'	=> true
					),
				),

			),
		))
	);
	
	// MOTO Sales Funnel
	$or->add_map( array('moto_sales_funnel' => array(
			'name' => __('Moto Sales Funnel', 'moto'),
			'description' => __('Sales Funnel', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Moto Sales Funnel',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'single_funnel',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Enter title here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Subtitle', 'moto' ),
						'name'			=> 'subtitle',
						'description'	=> __( 'Enter subtitle here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Image', 'moto' ),
						'name'			=> 'back_img',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Heading color', 'moto' ),
						'name'			=> 'hd_color',
						'description'	=> __( 'Choose HEading color', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Font color', 'moto' ),
						'name'			=> 'ft_color',
						'description'	=> __( 'Choose Font color', 'moto' ),
						'admin_label'	=> true
					),
				),

			),
			'content' => '[single_funnel title="Add Funnel"][/single_funnel]'
		))
	);
	$or->add_map( array('single_funnel' => array(
			'name' => __('Add Funnel', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Funnel',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( '', 'moto' ), 
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Price', 'moto' ),
						'name'			=> 'price',
						'description'	=> __( '', 'moto' ), 
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Description', 'moto' ),
						'name'			=> 'desc',
						'description'	=> __( '', 'moto' ), 
						'admin_label'	=> true
					),
				),

			),
		))
	);
	
// MOTO JV Slogan
	$or->add_map( array('moto_jv_slogan' => array(
			'name' => __('Moto JV Slogan', 'moto'),
			'description' => __('JV Slogan', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'textarea',
						'label'			=> __( 'Slogan', 'moto' ),
						'name'			=> 'slogan',
						'description'	=> __( '', 'moto' ), 
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Image', 'moto' ),
						'name'			=> 'slogan_image',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true 
					),
				),

			),
		))
	);
	
	// MOTO JV Prizes
	$or->add_map( array('moto_jv_prizes' => array(
			'name' => __('Moto Jv Prizes', 'moto'),
			'description' => __('Jv Prizes', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Moto Jv Prizes',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'single_prize',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( 'Enter title here.', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Title Tag', 'moto' ),
						'name'			=> 'title_tag',
						'options'		=> array(
											'h1'  => 'H1',
											'h2'  => 'H2',
											'h3'  => 'H3',
											'h4'  => 'H4',
											'h5'  => 'H5',
											'h6'  => 'H6'
										),
						'description'	=> __( '', 'moto' ), 
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Prize Image', 'moto' ),
						'name'			=> 'price_img',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Background Style', 'moto' ),
						'name'			=> 'background_style',
						'options'		=> array(
								'image' => 'Image',
								'color' => 'Color',
						),
						'description'	=> __( 'Choose Option', 'moto' ),
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Background Images', 'moto' ),
						'name'			=> 'back_img',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'image'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Overlay ', 'moto' ),
						'name'			=> 'overlay',
						'relation'	=> array(
							'parent'	=> 'background_style',
							'show_when'	=> 'image'
						),
						'options' => array(
									'yes' => __( 'Yes', 'moto' )
								),
						'value'			=> 'yes',		
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Overlay Color', 'moto' ),
						'name'			=> 'overlay_color',
						'relation'	=> array(
							'parent'	=> 'overlay',
							'show_when'	=> 'yes'
						),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					),
					array(
					'type'			=> 'color_picker',
					'label'			=> __( 'Background Color', 'moto' ),
					'name'			=> 'color',
					'relation'	=> array(
						'parent'	=> 'background_style',
						'show_when'	=> 'color'
					),
					'description'	=> __( '', 'moto' ),
					'admin_label'	=> true
				),
				),

			),
			'content' => '[single_prize title=""][/single_prize]'
		))
	);
	$or->add_map( array('single_prize' => array(
			'name' => __('Add Prize', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Prize',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( '', 'moto' ), 
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Title Tag', 'moto' ),
						'name'			=> 'title_tag',
						'options'		=> array(
											'h1'  => 'H1',
											'h2'  => 'H2',
											'h3'  => 'H3',
											'h4'  => 'H4',
											'h5'  => 'H5',
											'h6'  => 'H6'
										),
						'description'	=> __( '', 'moto' ), 
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Subtitle', 'moto' ),
						'name'			=> 'subtitle',
						'description'	=> __( '', 'moto' ), 
						'admin_label'	=> true
					)
				),

			),
		))
	);
// MOTO Expert Profile
	$or->add_map( array('moto_expert_profile' => array(
			'name' => __('Moto Expert Profile', 'moto'),
			'description' => __('Expert Profile', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Title', 'moto' ),
						'name'			=> 'title',
						'description'	=> __( '', 'moto' ), 
						'admin_label'	=> true
					),
					array(
						'type'			=> 'attach_image',
						'label'			=> __( 'Upload Expert Image', 'moto' ),
						'name'			=> 'expert_img',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true 
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Expert Name', 'moto' ),
						'name'			=> 'name',
						'description'	=> __( '', 'moto' ), 
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Facbook Page URL', 'moto' ),
						'name'			=> 'fb_url',
						'description'	=> __( 'Eg: facebook.com/fbexample', 'moto' ), 
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Skype ID', 'moto' ),
						'name'			=> 'skype_id',
						'description'	=> __( 'Eg: John Doe', 'moto' ), 
						'admin_label'	=> true
					),
				), 
			),
		))
	);
	// MOTO Revolution Slider
if( class_exists( 'RevSlider' ) ) {
	$sld = new RevSlider();
	$sliders = $sld->getArrSliders();
	$slider_option = array();
	if(!empty($sliders)){
		foreach($sliders as $slider){
			$alias = $slider->getParam('alias','false');
			$title = $slider->getTitle();
			$slider_option[$alias] = $title;
		}
	}
	$or->add_map( array('moto_revolution_slider' => array(
			'name' => __('Moto Revolution Slider', 'moto'),
			'description' => __('Revolution Slider', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Revolution Slider', 'moto' ),
						'name'			=> 'rv_sliders',
						'description'	=> __( '', 'moto' ),
						'options'		=> $slider_option,
						'admin_label'	=> true
					)
				), 
			),
		))
	);
}	
	// Moto Recent Products
	$or->add_map( array('recent_products' => array(
			'name' => __('LIsts Recent Products', 'moto'),
			'description' => __('Recent products', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Per page', 'moto' ),
						'name'			=> 'per_page',
						'value'			=> 12,
						'description'	=> __( 'The "per_page" shortcode determines how many products to show on the page', 'moto' ), 
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Columns', 'moto' ),
						'name'			=> 'columns',
						'description'	=> __( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'moto' ),
						'options'		=> array( '3' => 3, '4' => 4 ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Sort order', 'moto' ),
						'name'			=> 'order',
						'description'	=> sprintf( __( 'Designates the ascending or descending order. More at %s.', 'js_composer' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
						'options'		=> array( 'DESC' => 'Descending', 'ASC' => 'Ascending' ),
						'admin_label'	=> true
					)
				), 
			),
		))
	);
	
		// Moto Recent Products
		
	$product_cats = get_terms( 'product_cat', array('orderby'=> 'name','order' => 'ASC'));
	$cats = array();	
	$cats[] = 'all';	
	foreach($product_cats as $pro_cat) 
	{ 
	  $cats[$pro_cat->slug] = $pro_cat->slug;			
	}	
	$or->add_map( array('products_with_slider' => array(
			'name' => __('Products With Slider', 'moto'),
			'description' => __('Products With Slider', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Number Of Products', 'moto' ),
						'name'			=> 'per_page',
						'value'			=> 6,
						'description'	=> __( '', 'moto' ), 
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Category', 'moto' ),
						'name'			=> 'pro_cat',
						'description'	=> __( 'Select Product Category', 'moto' ),
						'options'		=> $cats,
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Sort order', 'moto' ),
						'name'			=> 'order',
						'description'	=> sprintf( __( 'Designates the ascending or descending order. More at %s.', 'js_composer' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
						'options'		=> array( 'DESC' => 'Descending', 'ASC' => 'Ascending' ),
						'admin_label'	=> true
					)
				), 
			),
		))
	);
	
	// Moto Featured Products
	$or->add_map( array('featured_products' => array(
			'name' => __('Moto Featured Products', 'moto'),
			'description' => __('Display "featured" products', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Per page', 'moto' ),
						'name'			=> 'per_page',
						'value'			=> 12,
						'description'	=> __( 'The "per_page" shortcode determines how many products to show on the page', 'moto' ), 
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Columns', 'moto' ),
						'name'			=> 'columns',
						'description'	=> __( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'moto' ),
						'options'		=> array( '3' => 3, '4' => 4 ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Sort order', 'moto' ),
						'name'			=> 'order',
						'description'	=> sprintf( __( 'Designates the ascending or descending order. More at %s.', 'js_composer' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
						'options'		=> array( 'DESC' => 'Descending', 'ASC' => 'Ascending' ),
						'admin_label'	=> true
					)
				), 
			),
		))
	);
	
	// Moto Products
	$or->add_map( array('products' => array(
			'name' => __('Moto Products', 'moto'),
			'description' => __('Show multiple products', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			
			'tab_icons' => array(
				'general' => 'et-tools'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Columns', 'moto' ),
						'name'			=> 'columns',
						'description'	=> __( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'moto' ),
						'options'		=> array( '3' => 3, '4' => 4 ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Sort order', 'moto' ),
						'name'			=> 'order',
						'description'	=> sprintf( __( 'Designates the ascending or descending order. More at %s.', 'js_composer' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
						'options'		=> array( 'DESC' => 'Descending', 'ASC' => 'Ascending' ),
						'admin_label'	=> true
					)
				), 
			),
		))
	);
	
	// Add cart
	$or->add_map( array('woocommerce_cart' => array(
			'name' => __('Cart', 'moto'),
			'description' => __('Cart', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'css_box' => true,
			'tab_icons' => array(
				'general' => 'et-tools' 
			),
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Woocommerce Cart', 'moto' ),
						'name'			=> 'cart',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true,
						'value'		=> 'cart'
					)
				), 
			),
		))
	);
	
	// Checkout
	$or->add_map( array('woocommerce_checkout' => array(
			'name' => __('Checkout', 'moto'),
			'description' => __('Checkout', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'css_box' => true,
			'tab_icons' => array(
				'general' => 'et-tools' 
			),
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Woocommerce Checkout', 'moto' ),
						'name'			=> 'checkout',
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true,
						'value'		=> 'checkout' 
					)
				), 
			),
		))
	);
	
// Progressbars	
	$or->add_map( array('moto_progressbar' => array(
			'name' => __('Moto Progressbar', 'moto'),
			'description' => __('Moto Progressbar', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'MOTO Progressbar Setting',
			'is_container' => true,
			'views' => array(
				'type' => 'views_sections',
				'sections' => 'moto_progressbar_item',
				'display' => 'vertical'
			),	
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'dropdown',
						'label'			=> __( 'Progressbar Style', 'moto' ),
						'name'			=> 'progressbar_style',
						'options'		=> array(
											'style1'  => 'Style 1',
											'style2'  => 'Style 2'
										),
						'description'	=> __( '', 'moto' ), 
					),
				),

			),
			'content' => '[moto_progressbar_item title="Add Item"][/moto_progressbar_item]'
		))
	);
	// Progressbars	Children
		$or->add_map( array('moto_progressbar_item' => array(
			'name' => __('Add Item', 'moto'),
			'description' => __('', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Progressbar Item Setting',
			'is_container' => true,
			'system_only' => true,
			'params' => array(
				'general' => array(
					array(
						'type'			=> 'text',
						'label'			=> __( 'Label', 'moto' ),
						'name'			=> 'label',
						'description'	=> __( 'Enter bar label here', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'text',
						'label'			=> __( 'Value', 'moto' ),
						'name'			=> 'value',
						'description'	=> __( 'Enter numerical value here (Eg: 50, 60, 70).', 'moto' ),
						'admin_label'	=> true
					),
					array(
						'type'			=> 'color_picker',
						'label'			=> __( 'Background color', 'moto' ),
						'name'			=> 'bg_color',						
						'description'	=> __( 'Choose Background color', 'moto' ), 
					),
					array(
						'type'			=> 'checkbox',
						'label'			=> __( 'Enable Tooltip.', 'moto' ),
						'name'			=> 'enable_tooltip',
						'options' => array(
									'yes' => __( 'Yes', 'moto' )
								),
						'description'	=> __( '', 'moto' ),
						'admin_label'	=> true
					)
				),

			),
		))
	);
// Moto Bgvideo Section
		$or->add_map( array('moto_bgvideo_section_shortcode' => array(
			'name' => __('Moto Background Video', 'moto'),
			'description' => __('Background Video', 'moto'),
			'icon' => 'or-icon-moto',
			'category' => '',
			'title'	=> 'Background Video Section',
			'is_container' => true,
			'params' => array(
				'general' => array(
					    array(
						     'type' => 'text',
						     'label'	=> __( 'Video Url', 'moto' ),
						     'name'	=> 'videourl',
						     'description' => __( 'Enter Video Url here', 'moto' ),
						     'admin_label' => true
					        ),
						 array(
						     'type' => 'text',
						     'label'	=> __( 'Title', 'moto' ),
						     'name'	=> 'title',
						     'description' => __( 'Enter Title here', 'moto' ),
						     'admin_label' => true
					         ),
					     array(
						     'type'	 => 'color_picker',
						     'label' => __( 'Title color', 'moto' ),
						     'name'	 => 'title_color',
						     'description'	=> __( 'Choose Title Color', 'moto' ),
						     'admin_label'	=> true
					       ),
						 array(
						     'type' => 'text',
						     'label'	=> __( 'Sub Title', 'moto' ),
						     'name'	=> 'subtitle',
						     'description' => __( 'Enter Sub Title here', 'moto' ),
						     'admin_label' => true
					        ),
						array(
						     'type'	 => 'color_picker',
						     'label' => __( 'Sub Title color', 'moto' ),
						     'name'	 => 'subtitle_color',
						     'description'	=> __( 'Choose Sub Title Color', 'moto' ),
						     'admin_label'	=> true
					       ),
						array( 
						     'type'	=> 'textarea',
						     'label' => __( 'Description', 'moto' ),
						     'name' => 'description',
						     'description'	=> __( '', 'moto' ), 
						     'admin_label'	=> true
					       ),
						 array(
						     'type' => 'text',
						     'label'	=> __( 'Button Text', 'moto' ),
						     'name'	=> 'buttontext',
						     'description' => __( 'Enter Button Text here', 'moto' ),
						     'admin_label' => true
					        ),
						array(
						     'type' => 'text',
						     'label'	=> __( 'Button Url', 'moto' ),
						     'name'	=> 'buttonurl',
						     'description' => __( 'Enter Button Url here', 'moto' ),
						     'admin_label' => true
					        ),
					
				        ),

			    ),
		    ))
	   );
}
}