<?php
function moto_datepicker($settings, $value){
	return ' <script>jQuery(function() {    jQuery( "#datepicker" ).datepicker({dateFormat : "d MM, yy"});  });</script><div class="my_param_block">'
             .'<input name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-textinput ' .
             esc_attr( $settings['param_name'] ) . ' ' .
             esc_attr( $settings['type'] ) . '_field" type="text" id="datepicker" value="' . esc_attr( $value ) . '" />' .
             '</div>';
}
add_shortcode( 'moto_about_shortcode', 'moto_about_shortcode_function' );
function moto_about_shortcode_function( $atts ){
	extract( shortcode_atts( array(
		'title' => '',
		'moto_image' => '',
		'about_desc' => '',
		'designation' => ''
	), $atts ) );
	$result = '';
	if(!empty($title)){
		$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
	}
	$result .= '<p>'.esc_html(base64_decode($about_desc)).'</p>';
	$result .= '<div class="sign">';
				if(!empty($moto_image)){
					$src = wp_get_attachment_image_src($moto_image,'full');
					$result .= '<img src="'.esc_url($src[0]).'" alt="">';
				}
				if(!empty($designation)){
					$result .= '<h5 class="muted">'.esc_attr($designation).'</h5>';
				}
	$result .= '</div>';
	return $result;
}
// About Slider
add_shortcode( 'moto_about_Slider', 'moto_about_Slider_function' );
function moto_about_Slider_function( $atts ){
	extract( shortcode_atts( array(
		'abt_slider' => '',
		'aboutslider_style' => '',
		'abt_vdeo_img' => '',
		'abt_vdeo_link' => ''
	), $atts ) );
	$result = $cls = '';
	if( $aboutslider_style == 'style2' ){
		$cls = 'has_dots';
	}else{
		$cls = 'no_dots';
	}
	if( $aboutslider_style == 'style3' ){
		$src = wp_get_attachment_image_src($abt_vdeo_img,'full');
		$result .= '<div class="mt_video_content">
					<div class="container">
						<div class="row">
								<div class="mt_video_thumb">
									<img src="'.esc_url($src[0]).'" alt=""> 
									<a href="'.esc_attr($abt_vdeo_link).'" class="open_video play_btn" rel="prettyPhoto"><i class="fa fa-play-circle" aria-hidden="true"></i></a>
								</div>
						</div>
					</div>
				</div>';
	}else{
	$images_id = explode(',', $abt_slider);
	$result .= '<div class="mt_slider_content">
					<div class="container">
						<div class="row">
								<div class="mt_about_slider '.esc_attr($cls).'">
									<div class="owl-carousel owl-theme">';
									foreach( $images_id as $imgid ){
									$src = wp_get_attachment_image_src($imgid,'full');
										$result .= '<div class="item">
											<img src="'.esc_url($src[0]).'" alt="">
										</div>';
									}
									$result .= '</div>
								</div>
						</div>
					</div>
				</div>';
	}
	return $result;
}
add_shortcode( 'moto_feature', 'moto_feature_function' );
function moto_feature_function( $atts, $content ){
	extract( shortcode_atts( array(
		'title' => '',
		'format' => '',
		'sub_title' => '',
		'sub_des' => '',
		'image' => '',
		'description' => '',
		'bg_color' => '',
	), $atts ) );
	$result = '';
	if($format=='format2'){
	$src = wp_get_attachment_image_src($image,'full');
	//$result .= '<section>';
	$result .= '<div class="invo_main_feature"';
	if(!empty($bg_color)){
	$result .= 'style="background-color:'.$bg_color.';"';
	}
	$result .= '>';
	$result .= '<div class="container">';
	$result .= '<div class="row">';
	if(!empty($src[0])){
		$result .= '<div class="col-sm-6">';
		$result .= '<img src="'.esc_url($src[0]).'" class="shadow-img" alt="">';
		$result .= '</div>';
	}
    $result .= '<div class="col-sm-6">';
    if(!empty($title)){
		$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
	}
    $result .= '<p>'.esc_html(base64_decode($sub_des)).'</p>';
    $result .= '<ul class="list">';	
	$result .= do_shortcode($content); 
	$result .= '</ul>';	
     $result .= '<p>'.esc_html(base64_decode($description)).'</p>';
     $result .= '</div>';
     $result .= '</div>';
     $result .= '</div>';
     $result .= '</div>';
	 //$result .= '</section>';
	}else{
	if(!empty($title))
		if(!empty($title)){
		$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
	}
	$result .= '<ul class="list">';	
	$result .= do_shortcode($content);
	$result .= '</ul>';	
    }	
	return $result;
}
add_shortcode( 'moto_feature_list', 'moto_feature_list_function' );
function moto_feature_list_function( $atts, $content ){
	extract( shortcode_atts( array(
		'text' => '',
		'url' => '',
		'icon' => ''
	), $atts ) );
	if( !empty($icon) ){
		$f_icon = $icon;
	}else{
		$f_icon = 'fa fa-check';
	}
	return '<li><a href="'.esc_url($url).'"><span class="list_icon"><i class="'.esc_attr($f_icon).'"></i></span>'.esc_attr($text).'</a></li>';
}

// Team Shortcode
add_shortcode( 'moto_team_shortcode', 'moto_team_shortcode_function' );
function moto_team_shortcode_function( $atts, $content = null ){
	extract( shortcode_atts( array(
		'title' => '',
		'team_no' => '',
		'team_cats' => '',
		'order' => '',
		'bg_color' => '',
		'team_style' => ''
	), $atts ) );
	$result = $src = $designation = $fb_s = $social_links = '';
	if( $team_style == 'style2' ){
		$cls = 'team_style_two';
	}elseif( $team_style == 'style3' ){
		$cls = 'circle_team';
	}else{
		$cls = 'default_team';
	}
	//$result .= '<section>';
	$result .= '<div class="invo_main_team"';
	if(!empty($bg_color)){
	$result .= ' style="background-color:'.$bg_color.';"';
	}
	$result .= '>';
	$result .= '<div class="container">';
	$result .= '<div class="text-center">';
	$result .= '<div class="row text-center no-margin">';
	
	if(!empty($title)){
		$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
	}
	
	$result .= '<div class="row team">';
	
	$categories = array();
	if($team_cats !='all'){
	$categories =  array(
					 array(
						'taxonomy' => 'team_categories',  
						'field' => 'slug',
						'terms'    => $team_cats,
					),
				);
	$args = array(
    	'post_type' => 'team',
		'post_status'=> 'publish',
		'posts_per_page' => $team_no,
		'order'   => $order,
	    'tax_query' => $categories,
		);
	}else{
		$args = array( 'post_type' =>'team','posts_per_page' => $team_no, 'order'   => $order );
	}
	$team = get_posts( $args );
	foreach ( $team as $post ) : setup_postdata( $post ); 
		if(has_post_thumbnail($post->ID)){
			$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
			$attachment_url = wp_get_attachment_image_src( $post_thumbnail_id, 'full' );
			if( $team_style == 'style3' ){
				$src = moto_resize( $attachment_url[0], 200, 200, true );
			}
			
		}
		$designation = get_post_meta($post->ID,'motocore_designation',true);
		$fb_s = get_post_meta($post->ID,'motocore_team_fb_s',true);
		$twt_s = get_post_meta($post->ID,'motocore_team_twt_s',true);
		$dr_s = get_post_meta($post->ID,'motocore_team_dr_s',true);
		$vim_s = get_post_meta($post->ID,'motocore_team_vim_s',true);
		$ins_s = get_post_meta($post->ID,'motocore_team_ins_s',true);
		$pin_s = get_post_meta($post->ID,'motocore_team_pin_s',true);
		$sky_s = get_post_meta($post->ID,'motocore_team_sky_s',true);
		$gp_s = get_post_meta($post->ID,'motocore_team_gp_s',true);
		$yt_s = get_post_meta($post->ID,'motocore_team_yt_s',true);
		$fkr_s = get_post_meta($post->ID,'motocore_team_fkr_s',true);
		$lin_s = get_post_meta($post->ID,'motocore_team_ld_s',true);
		
			if($fb_s == 'facebook'){
				$fb = get_post_meta($post->ID,'motocore_team_fb',true);
				$social_links .= '<li><a class="facebook" href="'.esc_url($fb).'"><i class="fa fa-facebook"></i></a></li>';
			}
			if($twt_s == 'twitter'){
				$twt = get_post_meta($post->ID,'motocore_team_fb',true);
				$social_links .= '<li><a class="twitter" href="'.esc_url($twt).'"><i class="fa fa-twitter"></i></a></li>';
			}
			if($ins_s == 'instagram'){ 
				$ins = get_post_meta($post->ID,'motocore_team_ins',true);
				$social_links .= '<li><a class="dribbble" href="'.esc_url($ins).'"><i class="fa fa-dribbble"></i></a></li>';
			} 
			if($vim_s == 'vimeo'){
				$vim = get_post_meta($post->ID,'motocore_team_vim',true);
				$social_links .= '<li><a class="vimeo" href="'.esc_url($vim).'" target="_blank"><i class="fa fa-vimeo-square"></i></a></li>';
			} 
			if($dr_s == 'dribbble'){ 
				$dr = get_post_meta($post->ID,'motocore_team_dr',true);
				$social_links .= '<li><a class="dribbble" href="'.esc_url($dr).'"><i class="fa fa-dribbble"></i></a></li>';
			} 
			if($sky_s == 'skype'){ 
				$sky = get_post_meta($post->ID,'motocore_team_sky',true);
				$social_links .= '<li><a class="skype" href="skype:'.esc_attr($sky).'?call" target="_blank"><i class="fa fa-skype"></i></a></li>';
			}
			if($yt_s == 'youtube'){ 
				$yt = get_post_meta($post->ID,'motocore_team_yt',true);
				$social_links .= '<li><a class="youtube" href="'.esc_url($yt).'" target="_blank"><i class="fa fa-youtube"></i></a></li>';
			}  
			if($lin_s == 'linkdin'){ 
				$link = get_post_meta($post->ID,'motocore_team_ld',true);
				$social_links .= '<li><a class="linkedin" href="'.esc_url($link).'" target="_blank"><i class="fa fa-linkedin-square"></i></a></li>';
			} 
			if($fkr_s == 'flickr'){ 
				$fkr = get_post_meta($post->ID,'motocore_team_fkr',true);
				$social_links .= '<li><a class="flickr" href="'.esc_url($fkr).'" target="_blank"><i class="fa fa-flickr"></i></a></li>';
			}
			if($gp_s == 'google_plus'){ 
				$gp = get_post_meta($post->ID,'motocore_team_gp',true);
				$social_links .= '<li><a class="gplus" href="'.esc_url($gp).'" target="_blank"><i class="fa fa-google-plus"></i></a></li>';
			}
			if($pin_s == 'pinterest'){ 
				$pin = get_post_meta($post->ID,'motocore_team_pin',true);
				$social_links .= '<li><a class="pinterest" href="'.esc_url($pin).'" target="_blank"><i class="fa fa-pinterest"></i></a></li>';
			}
		if( $team_style == 'style2' ){
			$result .= '<div class="col-md-4 team-member team_style_two">
                    <div class="mt_team_wrapper">
                        <div class="mt_team_img"><img src="'.esc_url($attachment_url[0]).'" /></div>
                        <div class="mt_team_detail">
                            <h4 class="team_name">'.esc_attr(get_the_title($post->ID)).'</h4>
                            <span class="team_status">'.esc_attr($designation).'</span>
							<div class="social_wrapper">
								<ul class="social">';
									$result .= $social_links;
								$result .= '</ul>
							</div>
                        </div>
                    </div>
                </div>';
		}elseif( $team_style == 'style3' ){
			$result .= '<div class="col-md-4 team-member circle_team">
                    <div class="mt_team_wrapper">
                        <div class="mt_team_img"><img src="'.esc_url($src).'" /></div>
                        <div class="mt_team_detail">
                            <h4 class="team_name">'.esc_attr(get_the_title($post->ID)).'</h4>
                            <span class="team_status">'.esc_attr($designation).'</span>
							<p>'.get_the_content().'</p>
							<div class="social_wrapper">
								<ul class="social">';
									$result .= $social_links;
								$result .= '</ul>
							</div>
                        </div>
                    </div>
                </div>';
		}else{
			$result .= '<div class="col-md-4 team-member text-center"><div class="mt_team_wrapper default_team"><div class="mt_team_img"><img src="'.esc_url($attachment_url[0]).'" /><div class="mt_overlay">';
			$result .= '<div class="mt_team_content"><div class="social_wrapper"><ul class="social">';
			$result .= $social_links;
			$result .= '</ul></div><p>'.get_the_content().'</p></div>';
			$result .= '</div></div><div class="mt_team_detail"><h5>'.esc_attr(get_the_title($post->ID)).'</h5><h5 class="muted">'.esc_attr($designation).'</h5></div></div></div>';
		}
		
		$src = $social_links = '';
	endforeach; 
	wp_reset_postdata();
	$result .= '</div>';
	$result .= '</div>';
	$result .= '</div>';
	$result .= '</div></div>';
	//$result .= '</section>';
	return $result;
}
add_shortcode('moto_history_shortcode','moto_history_shortcode_function');
function moto_history_shortcode_function( $atts, $content ){
	extract( shortcode_atts( array(
		'title' => 'something'
	), $atts ) );
	global $history_i;
	$result = '';
	$history_i = 0;
	
	$result .= '<div class="row no-margin text-center">';
	
	if(!empty($title)){
		$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
	}
	
	$result .= '<div class="timeline"><div class="col-lg-12 col-md-12">';
	$result .= do_shortcode($content);		
	$result .= '</div></div></div>';
	
	return $result;
}
add_shortcode('moto_history_list','moto_history_list_function');
function moto_history_list_function($atts){
	extract( shortcode_atts( array(
		'title' => 'OUR COMPANY HISTORY',
		'subtitle' => 'something',
		'description' => '',
		'icon' => '', 
		'h_date' => '',
	), $atts ) );
	$result = '';
	$result .= '<div class="post invo_history">';
	
		$result .= '<div class="col-md-2 text-center">
						<span class="'.esc_attr($icon).' icon"></span>
					</div>';
					
		$result .= '<div class="col-md-5 text-center posted">
					<h6 class="accent heading">'.esc_html__('Posted on','moto').' '.esc_attr($h_date).'</h6>
				</div>';			
					
		$result .= '<div class="col-md-5 text-left desc">
					<h5>'.esc_attr($title).'</h5>
					<h6 class="muted spaced">'.esc_attr($subtitle).'</h6>
					<p>'.esc_attr(base64_decode($description)).'</p>
					</div>';
		
	$result .= '</div>';
	return $result;
}
add_shortcode('moto_client_shortcode','moto_client_shortcode_function');
function moto_client_shortcode_function($atts){
	extract( shortcode_atts( array(
		'formate' => '',
		'title' => '',
		'logos' => '', 
		'client_back' => '',
		'color' => '',
		'overlay' => '',
		'overlay_color' => ''
	), $atts ) );

	$result = '';
	
	if( $overlay == 'yes' && !empty($overlay_color) ){
		$overlaycolor = $overlay_color;
	}else{
		$overlaycolor = '';
	}
		
	if( !empty($color) ){
		$backcolor = $color;
	}else{
		$backcolor = '';
	}
	
	$back_src = wp_get_attachment_image_src($client_back,'full');
	$logos = explode(',',$logos);
	if( $formate == 'formate_1' ){
	$result .= '<section class="clients_wraper" data-stellar-background-ratio="0.5" data-stellar-vertical-offset="100" style="background-image:url('.esc_url($back_src[0]).');">';
	if( $overlay == 'yes' ){
		$result .= '<div class="mt_overlay mt_opacity" style="background-color:'.esc_attr($overlaycolor).'"></div>';
	}
	
	if(!empty($title)){ $result .= '<div class="row no-margin text-center"><hr><h4 class="invo_heading">'.esc_attr($title).'</h4></div>'; }
	$result .= '<div class="container"><div class="row"><div class="col-md-12"><div class="owl-clients">';
	for($i=0;$i<count($logos);$i++){
		$src = wp_get_attachment_image_src($logos[$i],'full'); 
		$result .= '<div class="item text-center"><img src="'.esc_url($src[0]).'" alt=""></div>';
	}
	$result .= '</div></div></div></div></section>'; 
	}else{
	$result .= '<div class="mt_partner_section" style="background-color:'.$color.'">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12">
				<div class="owl-clients owl-carousel owl-theme">';
					for($i=0;$i<count($logos);$i++){
						$src = wp_get_attachment_image_src($logos[$i],'full'); 
						$result .= '<div class="item text-center"><img src="'.esc_url($src[0]).'" alt=""></div>';
					}
				$result .= '</div>
			</div>
		</div>
	</div>
</div>';
	}
	return $result; 
}
add_shortcode('moto_blog_listed','moto_blog_listed_function');
function moto_blog_listed_function($atts){
	extract( shortcode_atts( array(
		'post_formate' => '',
		'title' => '',
		'xyzcbc' => '',
		'countpost' => 'All',
		'category' => 'All',
		'post_back' => '#f4f4f4'
	), $atts ) ); 

	$result = $thumb = $cate_name = $src = $nopost = '';
	if( $countpost == 'all' ){
		$countpost = -1;
	}else{
		$nopost = $xyzcbc;
	}
	if( $category == 'all' ){
		$category = '';
	}else{
		$cate_name = $category;
	}
	$args = array(   
		'post_type' => 'post',
		'posts_per_page' => $nopost,
		'category_name' => $cate_name
	); 
	$blog_qry = new WP_Query( $args );	
	$attachment_url = '';
	global $post;
	$no = 6;$i = 0;
	if( $post_formate == 'formate_1' ){
	
		if(!empty($title)){
			$result .= '<div class="no-margin text-center"><hr><h4 class="invo_heading">'.esc_html($title).'</h4></div>';
		}
	
	if($blog_qry->have_posts()): 
		while($blog_qry->have_posts()) : $blog_qry->the_post();
			if(has_post_thumbnail($post->ID)){
				$thumb = get_post_thumbnail_id($post->ID);
				$attachment_url = wp_get_attachment_url($thumb, 'full');
			}
			$icon = get_post_meta($post->ID,'motocore_iconcls',true);
			$result .= '<div class="container-fluid blog-diagonal" data-background="'.esc_url($attachment_url).'">
	<div class="col-md-'.esc_attr($no).' arrow"></div>
	<div class="container">  
		<div class="row">
			<div class="col-md-6">
				<div class="row no-margin blog-diagonal-title">
					<div class="'.esc_attr($icon).' spec-icon"></div>
					<a href="'.esc_url( get_permalink() ).'"><h5 class="heading">'.get_the_title($post->ID).'<br>
					<span class="heading-bottom">'.esc_html__('Posted on ','moto').' '.get_the_date().'</span></h5></a>
			</div>
			</div>
		</div>
	</div>
</div>';
		if($i%2 == 0)
			$no = $no + 1;
		else
			$no = $no - 2;
		$i++;
		endwhile;		
	endif;
	wp_reset_postdata();
}elseif( $post_formate == 'formate_2' ){
	$result .= '<div class="mt_blog_section" style="background: '.$post_back.'">';
					if(!empty($title)){
						$result .= '<div class="no-margin text-center"><hr><h4 class="invo_heading">'.esc_html($title).'</h4></div>';
					}
		$result .= '<div class="container"> 
			<div class="row">';
	if($blog_qry->have_posts()): 
		while($blog_qry->have_posts()) : $blog_qry->the_post();
			if(has_post_thumbnail($post->ID)){
				$thumb = get_post_thumbnail_id($post->ID);
				$attachment_url = wp_get_attachment_url($thumb, 'full');
			}
			$icon = get_post_meta($post->ID,'motocore_iconcls',true);
			$result .= '<div class="col-md-4">
					<div class="mt_blog_wrapper">
						<h5 class="post_date"><i class="fa fa-calendar" aria-hidden="true"></i>'.get_the_date().'</h5>
						<div class="mt_img_wrapper">
							<img src="'.esc_url($attachment_url).'" alt="">
						</div>
						<div class="mt_blog_detail">
							<h4><a href="'.get_the_permalink().'">'.get_the_title().'</a></h4>
							<p>'.get_the_excerpt().'</p>
							<a href="'.get_the_permalink().'" class="read_more">'.esc_html__('Continue ...', 'moto').'</a> 
						</div>
					</div>
				</div>';
		if($i%2 == 0)
			$no = $no + 1;
		else
			$no = $no - 2;
		$i++;
		endwhile;		
	endif;
	wp_reset_postdata();
	$result .= '</div></div></div>';
}elseif( $post_formate == 'formate_3' ){
	if($blog_qry->have_posts()):
	$result .= '<div class="mt_blog_section blog_list"><div class="masonary_blog">';
					if(!empty($title)){
						$result .= '<div class="no-margin text-center"><hr><h4 class="invo_heading">'.esc_html($title).'</h4></div>';
					}
				$result .= '<div class="col-md-12 blog_div">';
		while($blog_qry->have_posts()) : $blog_qry->the_post();
		if(has_post_thumbnail($post->ID)){
				$thumb = get_post_thumbnail_id($post->ID);
				$attachment_url = wp_get_attachment_url($thumb, 'full');
				$src = moto_resize( $attachment_url, 369, 276, true );
			}
			$result .= '<div class="mt_blog_wrapper">
						<div class="mt_img_wrapper">
							<img src="'.esc_url($src).'" alt="">
						</div>
						<div class="mt_blog_detail">';
							if ( 'post' == get_post_type() ) :
							$result .= '<h5 class="post_date"><i class="fa fa-calendar" aria-hidden="true"></i>'.get_the_date().'</h5>';
					  	    endif;
							$result .= '
							<h4 class="post_title"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h4>
							<p>'.get_the_excerpt().'</p>
							<a href="'.get_the_permalink().'" class="read_more">'.esc_html__('Continue ...', 'moto').'</a>
						</div>
					</div>';
		endwhile;
		$result .= '</div></div></div>';		
	endif;	
	wp_reset_postdata();
}elseif( $post_formate == 'formate_4' ){
		$count= 1;
	if($blog_qry->have_posts()):
	$result .= '<div class="mt_blog_section masonary_blog_section" style="background: '.esc_attr($post_back).'">';
				if(!empty($title)){
						$result .= '<div class="no-margin text-center"><hr><h4 class="invo_heading">'.esc_html($title).'</h4></div>';
					}
				$result .= '<div class="masonary_blog">';
		$position = moto_get_sidebar_position();
		while($blog_qry->have_posts()) : $blog_qry->the_post();
		if( $count == 4 ){ $count= 1; }
			if (has_post_thumbnail($post->ID)){
				$thumb = get_post_thumbnail_id($post->ID);
				$attachment_url = wp_get_attachment_url($thumb, 'full');	
			}
		if($count <= 3){
			switch($count){
				case 1:
					$src = moto_resize( $attachment_url, 330, 150, true );
				break; 
				case 2:
					$src = moto_resize( $attachment_url, 330, 250, true );
				break;
				case 3:
					$src = moto_resize( $attachment_url, 330, 350, true );
				break;						
			}
		if( $position == 'right' || $position == 'left' ){
			$result .= '<div class="col-md-6 blog_div">';
		}else{
			$result .= '<div class="col-md-4 blog_div">';
		}
		
		$result .= '<div class="mt_blog_wrapper">
							<div class="mt_img_wrapper">
								<img src="'.esc_url($src).'" alt="">
							</div> 
							<div class="mt_blog_detail">
								<h4><a href="'.get_the_permalink().'">'.get_the_title().'</a></h4>
								<p>'.get_the_excerpt().'</p>
								<a href="'.get_the_permalink().'" class="read_more">'.esc_html__('Continue ...', 'moto').'</a>
							</div>
						</div>
					</div>';
			
		}	
		$count++;
		endwhile;
		$result .= '</div></div>';		
	endif;	
	wp_reset_postdata();
}elseif( $post_formate == 'formate_5' ){
	if($blog_qry->have_posts()):
	$result .= '<div class="mt_blog_section blog_classic">';
						if(!empty($title)){
						$result .= '<div class="no-margin text-center"><hr><h4 class="invo_heading">'.esc_html($title).'</h4></div>';
					}
		while($blog_qry->have_posts()) : $blog_qry->the_post();
		if(has_post_thumbnail($post->ID)){
				$thumb = get_post_thumbnail_id($post->ID);
				$attachment_url = wp_get_attachment_url($thumb, 'full');
			}
			$result .= '<div class="col-md-4 blog_div">
							<div class="mt_blog_wrapper">
								<h5 class="post_date"><i class="fa fa-calendar" aria-hidden="true"></i>'.get_the_date().'</h5>
								<div class="mt_img_wrapper">
									<img src="'.esc_url($attachment_url).'" alt="">
								 </div>
								<div class="mt_blog_detail">
									<h4 class="post_title"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h4>
									<p>'.get_the_excerpt().'</p>
									<a href="'.get_the_permalink().'" class="read_more">'.esc_html__('Continue ...', 'moto').'</a>
								</div>
							</div>
						</div>';
		endwhile;
		$result .= '</div>';
wp_reset_postdata();		
	endif;
}
	
	return $result;
}
add_shortcode('moto_portfolio_description_shortcode','moto_portfolio_description_shortcode_function');
function moto_portfolio_description_shortcode_function( $atts ){
	extract( shortcode_atts( array(
		'title' => '',
		'titleunderline' => '',
		'port_desc' => '',
		'subtitle' => ''
	), $atts ) ); 
	$result = '';
	if(!empty($title)){
		if($titleunderline == 'yes')
			$result .= '<hr><h4 class="portfolio_title">'.esc_attr($title).'</h4>';
		else
			$result .= '<h4 class="alt no-transform model_title"><b>'.esc_attr($title).'</b></h4>';
	}
	if(!empty($subtitle))
		$result .= '<h6 class="spaced muted">'.esc_attr($subtitle).'</h6>';
	if(strpos($port_desc,"<p>"))
		$result .= esc_html(base64_decode($port_desc));
	else
		$result .= '<p>'.esc_html(base64_decode($port_desc)).'</p>';
	return $result;
}
add_shortcode('moto_social_shortcode','moto_social_shortcode_function');
function moto_social_shortcode_function($atts){
	extract( shortcode_atts( array(
		'title' => '',
		'fb_url' => '',
		'twt_url' => '',
		'linked_url' => '',
		'flickr_url' => '',
		'yotube_url' => '',
		'dribbble_url' => '',
		'gp_url' => '',
		'sky_url' => '',
		'pin_url' => '',
		'vim_url' => '',
	), $atts ) ); 
	$result = '';
	if(!empty($title)){
		$result .= '<hr><h4 class="model_title">'.esc_html($title).'</h4>';
	}
	$result .= '<div class="project"><ul class="social inv_ul_margin">';
	if(!empty($fb_url)){
	$result .= '<li><a href="'.esc_url($fb_url).'" class="facebook_bg" target="_blank"><i class="fa fa-facebook"></i></a></li>';
	}
	if(!empty($twt_url)){
	$result .= '<li><a href="'.esc_url($twt_url).'" class="twitter_bg" target="_blank"><i class="fa fa-twitter"></i></a></li>';
	}
	if(!empty($linked_url)){
	$result .= '<li><a href="'.esc_url($linked_url).'" class="linkedin_bg" target="_blank"><i class="fa fa-linkedin-square"></i></a></li>';
	} 
	if(!empty($flickr_url)){
	$result .= '<li><a href="'.esc_url($flickr_url).'" class="flickr_bg" target="_blank"><i class="fa fa-flickr"></i></a></li>';
	}
	if(!empty($yotube_url)){
	$result .= '<li><a href="'.esc_url($yotube_url).'" class="youtube_bg" target="_blank"><i class="fa fa-youtube"></i></a></li>';
	 }
	if(!empty($dribbble_url)){
	$result .= '<li><a href="'.esc_url($dribbble_url).'" class="dribbble_bg" target="_blank"><i class="fa fa-dribbble"></i></a></li>';
	}
	if(!empty($gp_url)){
	$result .= '<li><a href="'.esc_url($gp_url).'" class="gplus_bg" target="_blank"><i class="fa fa-google-plus"></i></a></li>';
	}
	if(!empty($pin_url)){
	$result .= '<li><a href="'.esc_url($pin_url).'" class="pinterest_bg" target="_blank"><i class="fa fa-pinterest"></i></a></li>';
	}
	if(!empty($sky_url)){
	$result .= '<li><a href="skype:'.esc_attr($sky_url).'?call" class="skype_bg" target="_blank"><i class="fa fa-skype"></i></a></li>';
	}
	if(!empty($vim_url)){
	$result .= '<li><a href="'.esc_url($vim_url).'" class="vimeo_bg" target="_blank"><i class="fa fa-vimeo-square"></i></a></li>';
	} 
	$result .= '</ul></div>';
	return $result;
}

//POrtfolio View Shortcode
add_shortcode('moto_portfolio_view','moto_portfolio_view_shortcode');
function moto_portfolio_view_shortcode( $atts ){
	extract( shortcode_atts( array(
		'title' => '',
		'portfoliocountpost' => '',
		'portfolio_view' => '',
		'magnifier' => '',
		'portfolio_hover' => '',
		'no_padding' => '',
		'en_filter' => ''
	), $atts ) ); 
	
	$result = $catname = $heading = $description = $accent = $cls = $thumb = $attachment_url = $hover_cls = '';
	
	switch($portfolio_hover){
		case 'hover1':
		$hover_cls = 'default_portfolio';
		break;
		
		case 'hover2':
		$hover_cls = 'center_hover';
		break;
		
		case 'hover3':
		$hover_cls = 'zoomIn_hover';
		break;
		
		case 'hover4':
		$hover_cls = 'border_hover';
		break;
		
		case 'hover5':
		$hover_cls = 'flip_hover';
		break;
		
		case 'hover6':
		$hover_cls = 'classic_hover';
		break;
		
		case 'hover7':
		$hover_cls = 'gradient_hover';
		break;
		
		case 'hover8':
		$hover_cls = 'grayscale_hover';
		break;
	}
	
	$taxonomy = 'portfolio_categories';
	$categories = get_terms( $taxonomy, array( 'parent' => 0 ) );
	$result .= '<section>';			
	if(count($categories) > 0){   
		$result .= '<div class="row no-margin text-center">';
		if(!empty($title)){
			$result .= '<hr><h4 class="invo_heading">'.esc_attr($title).'</h4>';
		}
		if( isset( $en_filter ) && empty( $en_filter ) || $en_filter == 'yes' ){
			$result .= '<div class="portfolio-filter"><a href="#" class="btn btn-default active" data-filter="*">'.esc_html__('All','moto').'</a>';
			foreach($categories as $category)
			{ 
				$result .= '<a href="#" class="btn btn-default" data-filter=".'.esc_attr($category->slug).'">'.esc_attr($category->name).'</a>';
			}
			$result .= '</div>';
		}
		$result .= '</div>';
		$portfolio_query = new WP_Query( array( 'post_type' => 'portfolio', 'posts_per_page' => $portfoliocountpost) );
		global $post;
		$j= 0;
		if($portfolio_query->have_posts()): 
			$result .= '<div class="portfolio-container">';
			while($portfolio_query->have_posts()) : $portfolio_query->the_post();
				$terms = get_the_terms( $post->ID, 'portfolio_categories' );
				if(is_array($terms)){   
					if(count($terms) > 0 ){
						foreach ( $terms as $term ){
							$catname .= $term->slug.' ';
						}   
					} 	
				}
				
					$thumb = get_post_thumbnail_id($post->ID);
					if( $magnifier == 'yes' ){
						$val			= 'prettyPhoto[pp_gal]';							//Enable Pretty Photo
					}else{
						$val			= '';
					}
				
				if($portfolio_view=='column_4'){
				  if($no_padding=='no_padding'){	
				      $result .= '<div class="item no_padding '.esc_attr(rtrim($catname,' ')).' '.esc_attr($hover_cls).'">';
				     } else{
				      $result .= '<div class="item '.esc_attr(rtrim($catname,' ')).' '.esc_attr($hover_cls).'">';
				   }
				$result .= '<div class="portfolio_content">';
							$catname = '';
				if (has_post_thumbnail($post->ID)){	
						$thumb = get_post_thumbnail_id($post->ID);
						$image_url = wp_get_attachment_url($thumb, 'full');
						$src = moto_resize( $image_url, 423, 315, true );
						$result .= '<img src="'.esc_url($src).'">';
				}

				$result .= '<div class="overlay">
						<div class="description">
							<h4 class="white"><a href="'.esc_attr(get_the_permalink()).'">'.esc_attr(get_the_title($post->ID)).'</a></h4>';
							if( $magnifier == 'yes' ){
								$result .= '<a href="'.esc_url($image_url).'" rel="'.esc_attr($val).'" class="mt_view"><i class="fa fa-search-plus" aria-hidden="true"></i></a>';
							}else{
								$result .= '<a href="'.esc_url(get_the_permalink() ).'" rel="'.esc_attr($val).'" class="mt_view"><i class="fa fa-search-plus" aria-hidden="true"></i></a>';
							}
							
							
						$result .= '</div>
					</div>';
				$result .= '</div></div>';
				}elseif($portfolio_view=='dynamic'){
				  $cls = get_post_meta($post->ID,'motocore_portfolio_width',true);
				  if($no_padding=='no_padding'){
					$result .= '<div class="item no_padding '.$cls.' '.esc_attr(rtrim($catname,' ')).' '.esc_attr($hover_cls).'">';
				  } else {
					  $result .= '<div class="item '.$cls.' '.esc_attr(rtrim($catname,' ')).' '.esc_attr($hover_cls).'">';
				  }
			       $result .= '<div class="portfolio_content">';
					$catname = '';
					if (has_post_thumbnail($post->ID)){	
						$thumb = get_post_thumbnail_id($post->ID);
						$image_url = wp_get_attachment_url($thumb, 'full');
						$result .= moto_set_feature_image($post->ID,'');
						
					}
					$result .= '<div class="overlay">
							<div class="description">
								<h4 class="white"><a href="'.esc_url(get_permalink($post->ID)).'">'.esc_attr(get_the_title($post->ID)).'</a></h4>';
									if( $magnifier == 'yes' ){
									$result .= '<a href="'.esc_url($image_url).'" rel="'.esc_attr($val).'" class="mt_view"><i class="fa fa-search-plus" aria-hidden="true"></i></a>';
									}else{
										$result .= '<a href="'.esc_url(get_the_permalink() ).'" rel="'.esc_attr($val).'" class="mt_view"><i class="fa fa-search-plus" aria-hidden="true"></i></a>';
									}
							$result .= '</div>
						</div>';
					$result .= '</div></div>';
				}
				else{
					if($no_padding=='no_padding'){
					  $result .= '<div class="item w3 no_padding '.esc_attr(rtrim($catname,' ')).' '.esc_attr($hover_cls).'">';
					} else{ 
					  $result .= '<div class="item w3 '.esc_attr(rtrim($catname,' ')).' '.esc_attr($hover_cls).'">';
					}
					  $result .= '<div class="portfolio_content"> 
					'; $catname = '';
					if (has_post_thumbnail($post->ID)){
						$thumb = get_post_thumbnail_id($post->ID);
						$image_url = wp_get_attachment_url($thumb, 'full');
						$src = moto_resize( $image_url, 566, 423, true );
						$result .= '<img src="'.esc_url($src).'">';
					}
					$result .= '<div class="overlay">
							<div class="description">
								<h4 class="white"><a href="'.esc_url(get_permalink($post->ID)).'">'.esc_attr(get_the_title($post->ID)).'</a></h4>';
								if( $magnifier == 'yes' ){
									$result .= '<a href="'.esc_url($image_url).'" rel="'.esc_attr($val).'" class="mt_view"><i class="fa fa-search-plus" aria-hidden="true"></i></a>';
									}else{
										$result .= '<a href="'.esc_url(get_the_permalink() ).'" rel="'.esc_attr($val).'" class="mt_view"><i class="fa fa-search-plus" aria-hidden="true"></i></a>';
									}
							$result .= '</div>
						</div>';
					$result .= '</div></div>';
				}
			endwhile; 
			$result .= '</div>';	
		endif;
		wp_reset_postdata();
	}
	$result .= '</section>';
	return $result;
}
add_shortcode('moto_map_shortcode','moto_map_function');
function moto_map_function($atts){
	extract( shortcode_atts( array(
		'info_title' => '',
		'lat_long' => '',
		'map_height' => '',
		'map_scroll' => '',
		'map_type' => '',
		'map_zoom' => '',
	), $atts ) );
	$result = $mapid = $scroll = '';
	$mapid = 'moto_mapid'.uniqid();
	if($map_type =='sat_map'){
		$maptype = 'SATELLITE'; 
	}elseif($map_type =='hybrid_map'){
		$maptype = 'HYBRID';
	}else{
		$maptype = 'ROADMAP';
	}
	$latlong = explode(',',$lat_long);
	if($map_scroll=='Yes'){
		$scroll = 'true';
	}else{
		$scroll = 'false';
	}
	?> 
	<script type="text/javascript">
	var myCenter = new google.maps.LatLng(<?php echo esc_js($latlong[0]); ?> ,<?php echo esc_js($latlong[1]); ?>);
	function initialize() {
		var mapProp = {
			center: myCenter,
			zoom: <?php echo esc_js($map_zoom); ?>,
			scrollwheel: <?php echo esc_js($scroll); ?>,
			mapTypeId: google.maps.MapTypeId.<?php echo esc_js($maptype); ?>,
			styles: [{"featureType":"landscape.man_made","elementType":"geometry","stylers":[{"color":"#f7f1df"}]},{"featureType":"landscape.natural","elementType":"geometry","stylers":[{"color":"#d0e3b4"}]},{"featureType":"landscape.natural.terrain","elementType":"geometry","stylers":[{"visibility":"off"}]},{"featureType":"poi","elementType":"labels","stylers":[{"visibility":"off"}]},{"featureType":"poi.business","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"poi.medical","elementType":"geometry","stylers":[{"color":"#fbd3da"}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#bde6ab"}]},{"featureType":"road","elementType":"geometry.stroke","stylers":[{"visibility":"off"}]},{"featureType":"road","elementType":"labels","stylers":[{"visibility":"off"}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#ffe15f"}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#efd151"}]},{"featureType":"road.arterial","elementType":"geometry.fill","stylers":[{"color":"#ffffff"}]},{"featureType":"road.local","elementType":"geometry.fill","stylers":[{"color":"black"}]},{"featureType":"transit.station.airport","elementType":"geometry.fill","stylers":[{"color":"#cfb2db"}]},{"featureType":"water","elementType":"geometry","stylers":[{"color":"#a2daf2"}]}]
		};
		var map = new google.maps.Map(document.getElementById("<?php echo esc_js($mapid); ?>"), mapProp);
		var marker = new google.maps.Marker({
			position: myCenter,
			map: map,
			title: '<?php echo esc_js($info_title); ?>',
			icon: '<?php echo get_template_directory_uri().'/images/map_marker.png'; ?>',
		});
		var contentString = "<?php echo esc_js($info_title); ?>";
		marker.setMap(map); 
		var infowindow = new google.maps.InfoWindow({
			content: contentString,
			pixelOffset : 0,  
		});
		google.maps.event.addListener(marker, 'click', function () {
			infowindow.open(map, marker);
		});
	}
	google.maps.event.addDomListener(window, 'load', initialize);
	</script>
	<?php
    $result .= '<div id="'.esc_attr($mapid).'" style="width:100%;height:'.esc_attr($map_height).'px;" class="google_map" ></div>'; 
    return $result;
}

//Contact Form
add_shortcode('moto_contact_form_shortcode','moto_contact_form_function');
function moto_contact_form_function($atts){
	extract( shortcode_atts( array(
		'title' => '',
		'description' => '',
		'contact' => '',
		'contact_style' => '',
		'btn_align' => ''
	), $atts ) );
	
	if( $btn_align == 'left' ){
		$btn_alignment = 'text-left';
	}else{
		$btn_alignment = 'text-right';
	}
	$result = $div_class = $div_class1 = $div_class2 = $message_label = $mt_cont_fied = $form_class = $subject_class = $name_field = $ph_field = $email_field = $sub_field = $msg_field = $btn_class = '';
	global $redux_moto;
	
	//Labels
	$name_label = $redux_moto['name_label'];
	$email_label = $redux_moto['email_label'];
	$phone_label = $redux_moto['phon_label'];
	$subject_label = $redux_moto['subject_label'];
	$message_label = $redux_moto['msg_label'];
	
	// Placholders
	$name_place = $redux_moto['name_place'];
	$email_place = $redux_moto['email_place'];
	$phon_place = $redux_moto['phon_place'];
	$subject_place = $redux_moto['subject_place'];
	$msg_place = $redux_moto['msg_place'];
	$button_txt = $redux_moto['button_txt'];
	
	wp_register_script('jquery_validation', get_template_directory_uri() . '/js/validation.js', array('jquery'),null,true); 
	wp_enqueue_script('jquery_validation');
	$fields = $redux_moto['moto_fieldsenable_disable'];
	$require = $redux_moto['moto_fieldsrequire'];
	$validate = $txt = '';
	
	$result .= '<div class="row no-margin text-center contact_heading">';

			if(!empty($title)){
				$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
			}
			
			$result .= '<p>'.esc_html(base64_decode($description)).'</p>
		</div>';
		
	if(is_array($fields['ENABLE']) && $contact == 'yes'){
	
		if( $contact_style == 'style2' ){
			$form_class = 'three_coloumn';
			$div_class1 = 'col-lg-4 col-md-4';
			$subject_class = 'col-lg-12 col-md-12';
			$div_class2 = 'col-lg-12 col-md-12';
			
		}
		elseif( $contact_style == 'style3' ){
			$form_class = 'moto_contact_form two_coloumn';
			$div_class1 = 'col-lg-6 col-md-6';
			$div_class2 = 'col-lg-12 col-md-12';
			$subject_class = 'col-lg-6 col-md-6';
		}elseif( $contact_style == 'style4' ){
			$form_class = 'moto_contact_form mt_border';
			$div_class1 = 'col-lg-6 col-md-6';
			$subject_class = 'col-lg-6 col-md-6';
			$div_class2 = 'col-lg-12 col-md-12';
			
		}elseif( $contact_style == 'style5' ){
			$form_class = 'moto_contact_form mt_border';
			$div_class1 = 'col-lg-4 col-md-4';
			$subject_class = 'col-lg-12 col-md-12';
			$div_class2 = 'col-lg-12 col-md-12';
			
		}elseif( $contact_style == 'style6' ){
			$form_class = 'moto_contact_form mt_background_form';
			$div_class1 = 'col-lg-4 col-md-4';
			$subject_class = 'col-lg-12 col-md-12';
			$div_class2 = 'col-lg-12 col-md-12';
			
		}elseif( $contact_style == 'style7' ){
			$form_class = 'moto_contact_form mt_icon_form';
			$div_class1 = 'col-lg-4 col-md-4';
			$subject_class = 'col-lg-12 col-md-12';
			$div_class2 = 'col-lg-12 col-md-12';
			$name_field = 'name_field';$ph_field = 'ph_field';$email_field = 'email_field';$sub_field = 'sub_field';$msg_field = 'msg_field';
			
		}elseif( $contact_style == 'style8' ){
			$form_class = 'moto_contact_form mt_background_form mt_icon_form';
			$div_class1 = 'col-lg-4 col-md-4';
			$subject_class = 'col-lg-12 col-md-12';
			$div_class2 = 'col-lg-12 col-md-12';
			$name_field = 'name_field';$ph_field = 'ph_field';$email_field = 'email_field';$sub_field = 'sub_field';$msg_field = 'msg_field';
			
		}elseif( $contact_style == 'style9' ){
			$form_class = 'moto_contact_form mt_border mt_icon_form';
			$div_class1 = 'col-lg-4 col-md-4';
			$subject_class = 'col-lg-12 col-md-12';
			$div_class2 = 'col-lg-12 col-md-12';
			$name_field = 'name_field';$ph_field = 'ph_field';$email_field = 'email_field';$sub_field = 'sub_field';$msg_field = 'msg_field';
			
		}elseif( $contact_style == 'style10' ){
			$form_class = 'moto_contact_form mt_border mt_icon_form';
			$div_class1 = 'col-lg-12 col-md-12';
			$subject_class = 'ccol-lg-12 col-md-12';
			$div_class2 = 'col-lg-12 col-md-12';
			$btn_class = 'block_btn';
			$name_field = 'name_field';$ph_field = 'ph_field';$email_field = 'email_field';$sub_field = 'sub_field';$msg_field = 'msg_field';
			
		}else{
			$div_class = 'col-sm-6';
			$div_class2 = 'col-sm-6';
			$subject_class = '';
		}	
		$result .= '<form method="post" id="moto_contactform_shortcode" class="'.esc_attr($form_class).'"><div class="'.esc_attr($div_class).'">';
			foreach($fields['ENABLE'] as $key=>$val){
				switch($key){
					case 'NAME':
						if(isset($require['REQUIRE']['NAME'])){
							$validate = 'data-validation=\'required\'';
							$txt = '*';
						}	
						$result .= '<div class="'.esc_attr($div_class1).'">
						<div class="mt-contact-field">
						<h4 class="contact_label">'.esc_html($name_label).'</h4><div class="form-group '.esc_attr($name_field).'">
						<input type="text" '.($validate).' class="contact_field" value="" placeholder="'.esc_html($name_place).esc_attr($txt).'" name="name" /></div></div></div>';
					break;
					case 'EMAIL' :
						if(isset($require['REQUIRE']['EMAIL'])){
							$validate = 'data-validation="email"';
							$txt = '*';
						}
						$result .= '<div class="'.esc_attr($div_class1).'">
						<div class="mt-contact-field"><h4 class="contact_label">'.esc_html($email_label).'</h4><div class="form-group '.esc_attr($email_field).'"><input type="text" '.($validate).' class="contact_field" value="" placeholder="'.esc_html($email_place).esc_attr($txt).'" name="email" /></div></div></div>';
					break;
					case 'PHONENUMBER' :
						if(isset($require['REQUIRE']['PHONENUMBER'])){
							$validate = 'data-validation="number"';
							$txt = '*';
						}
						$result .= '<div class="'.esc_attr($div_class1) .'"><div class="mt-contact-field"><h4 class="contact_label">'.esc_html($phone_label).'</h4><div class="form-group '.esc_attr($ph_field).'"><input type="text" '.($validate).' class="contact_field" value="" placeholder="'.esc_html($phon_place).esc_attr($txt).'" name="phono" /></div></div></div>';
					break;
					case 'SUBJECT':
						if(isset($require['REQUIRE']['SUBJECT'])){
							$validate = 'data-validation=\'required\'';
							$txt = '*';
						}
						$result .= '<div class="'.esc_attr($subject_class).'"><div class="mt-contact-field"><h4 class="contact_label">'.esc_html($subject_label).'</h4><div class="form-group '.esc_attr($sub_field).'"><input type="text" '.($validate).' class="contact_field" value="" placeholder="'.esc_html($subject_place).esc_attr($txt).'" name="subject" /></div></div></div>';
					break;
				}
				$validate = $txt = '';
			}
			$validate = 'data-validation="required"';
			$txt = '*';
			$result .= '</div>';
			$result .= '<div class="'.esc_attr($div_class2).'">
			<div class="mt-contact-field">
			<h4 class="contact_label">'.esc_html($message_label).'</h4><div class="form-group '.esc_attr($msg_field).'"><textarea name="Message" class=" contact_field" id="Message" '.($validate).' rows="10" placeholder="'.esc_html($msg_place).'"></textarea></div></div></div>';
			$result .= '<div class="col-xs-12 '.esc_attr($btn_alignment).'"> <a href="" class="btn btn-accent send_mail_shortcode '.esc_attr($btn_class).'">'.esc_html($button_txt).'<i class="fa fa-long-arrow-right"></i></a> <img src="'.get_template_directory_uri().'/images/ajax-loader.gif" class="moto_loading_shortcode" alt=""> <input type="hidden" value="'.admin_url('admin-ajax.php').'"  id="moto_ajaxurl_shortcode">
			<span id="success_mes_shortcode"></span></div>';
			$result .= '</form>';
	}
	return $result;
}
add_shortcode('moto_twitterfeed_shortcode','moto_twitterfeed_function');
function moto_twitterfeed_function($atts){
	extract( shortcode_atts( array(
		'title' => '',
		'feedcount' => '',
		'usename' => '',
		'key' => '',
		'secret' => '',
		'access_token' => '',
		'access_token_secret' => ''
	), $atts ) );
	$result = '';
	require_once (PLUGIN_PATH_CORE . 'extra/twitter/TwitterAPIExchange.php');
	$result .= '<div class="row no-margin">';
	if(!empty($title)){
		$result .= '<hr><h4 class="model_title">'.esc_html($title).'</h4>';
	}
	if(!empty($key) && !empty($secret) && !empty($access_token_secret) && !empty($access_token) ){
		$settings = array(
			'oauth_access_token' => esc_attr($access_token),
			'oauth_access_token_secret' => esc_attr($access_token_secret),
			'consumer_key' => esc_attr($key),
			'consumer_secret' => esc_attr($secret)
		);
		$url = 'https://api.twitter.com/1.1/statuses/user_timeline.json';
		$getfield = '?username='.esc_html($usename).'&skip_status=1';
		$requestMethod = 'GET';
		$twitter = new TwitterAPIExchange($settings);
		$twisss= $twitter->setGetfield($getfield)->buildOauth($url, $requestMethod)->performRequest(); 
		$myarr=json_decode($twisss);
		if(!$myarr){
			$result .= ' <div class="item"> 
			<div class="hs_twitter_feed_content">
			<h2>'.esc_html__('YOu have not created the twitter app , Please create the twitter app for your site. Thankyou','moto').'</h2>
			</div>
			<div class="carousel-caption"></div>
			</div>';
		}else{ 
			for($i=0;$i<$feedcount;$i++){
				$result .= '<div class="row no-margin twitter-feed"><i class="fa fa-twitter icon accent"></i>';
					$result .= '<div class="content"><p><span class="accent">@'.esc_html($usename).'</span> '.esc_html($myarr[$i]->text).'</p><p class="muted">'.esc_html__(human_time_diff( strtotime($myarr[$i]->created_at), strtotime(date('Y-m-d H:i:s')) )).esc_html__(' ago','moto').'</p></div>';
				$result .= '</div>';
			}
		}
	}else{
		$result .= ' <div class="item"> 
			<div class="hs_twitter_feed_content">
			<h2>'.esc_html__('You have not created the twitter app , Please create the twitter app for your site. Thankyou','moto').'</h2>
			</div>
			<div class="carousel-caption"></div>
			</div>';
	}
	$result .= '</div>';
	return $result; 
}
add_shortcode('moto_information_shortcode','moto_information_function');
function moto_information_function($atts){
	extract( shortcode_atts( array(
		'title' => '',
		'subtitle' => '',
		'desc' => '',
		'btn_txt' => '',
		'btn_url' => '',
		'btn_align' => ''
	), $atts ) );
	//print_r($atts);
	$result = '';
	$result .= '<div class="row no-margin ">';
	if(!empty($title))
		$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
	if(!empty($subtitle))				
		$result .= '<h5 class="spaced muted invo_word_spacing">'.esc_html($subtitle).'</h5>';
	$result .= '<p>'.base64_decode($desc).'</p>';
	if( $btn_align == 'left' ){
		$btn_cls = 'text-left';
	}elseif( $btn_align == 'right' ){
		$btn_cls = 'text-right';
	}else{
		$btn_cls = 'text-center';
	}
	$result .= '<div class="row no-margin '.esc_attr($btn_cls).' extra-padding-top"><a href="'.esc_url($btn_url).'" class="btn btn-default">'.esc_html($btn_txt).'<i class="fa fa-long-arrow-right"></i></a></div>';
	$result .= '</div>';
	return $result;
}

//MOTO Achievement
add_shortcode('moto_achievement','moto_achievement_function'); 
function moto_achievement_function($atts, $content){
	extract( shortcode_atts( array(
		'achievement_style' => '',
		'background_style' => '',
		'bg_img' => '',
		'color' => '',
		'overlay' => '',
		'overlay_color' => ''
	), $atts ) );
	$result = $cls1 = $cls2 =  '';
	if( $achievement_style == 'style1' ){
		$cls1 = 'facts white';
		$cls2 = 'achie_style1';
	}
	
	$result .= '<input type="hidden" id="achieve_style" value="'.esc_attr($achievement_style).'">';
	if( $background_style == 'image' ){
		$src = wp_get_attachment_image_src($bg_img,'full');
		$result .= '<div class="mt_achievement_section '.esc_attr($cls2).'" data-stellar-background-ratio="0.5" style="background-image:url('. $src[0] .')">';

		if( $overlay == 'yes' ){
			if( !empty($overlay_color) ){
				$overlaycolor = $overlay_color;
			}else{
				$overlaycolor = '';
			}
			
			$result .= '<div class="mt_overlay mt_opacity" style="background-color:'.esc_attr($overlaycolor).'"></div>';
			}
	}else{
		$result .= '<div class="mt_achievement_section '.esc_attr($cls2).'" style="background-color:'.esc_attr($color).';">';
	}
	
	$result .= '<div class="container">';
	$result .= '<div class="row"><div class="'.esc_attr($cls1).'">';
	$result .= do_shortcode($content);
	$result .= '</div></div>'; 
	$result .= '</div></div>';
	
	return $result;
}
add_shortcode('moto_achievement_list','moto_achievement_list_function');
function moto_achievement_list_function($atts){
	extract( shortcode_atts( array(
		'number' => '',
		'text' => '',
		'icon' => ''
	), $atts ) );
	$result = $cls = $hr = '';
	global $color;
	if($color != ''){
	$cls = 'white';
	}else{
	$cls = '';
	}
	
	$result .= '<div class="col-md-3 col-sm-6 achieve_insert fact text-center counter_box">';
	if( $icon != 'select' ){
		$result .= '<div class="mt_achievement_wrapper">
					<i class="'.esc_attr($icon).'" aria-hidden="true"></i>
				</div>';
	}else{
		$hr = '<hr class="'.esc_attr($cls).'">';
	}
	$result .= '<h1 class="ach_no count-no" data-to="'.esc_html($number).'" data-speed="10000">'.esc_html($number).'</h1>';
		$result .= $hr;
	$result .= '<h5 class="ach_title">'.esc_html($text).'</h5>';
	$result .= '</div>';
	return $result;  
}

// MOTO Pricing List
add_shortcode('moto_pricing','moto_pricing_function');
function moto_pricing_function($atts,$content){
	extract( shortcode_atts( array(
		'title' => 'Title',
		'currency' => '', 
		'price' => '',
		'time' => '',
		'btn_text' => '',
		'btn_link' => '',
		'active' => '',
		'pricing_style' => ''
	), $atts ) );
	$result = $cls = '';
	if(!empty($active)){
		$cls = $active;
	}else{
		$cls = '';
	}
	
	if($active == 'Active'){
		$cls = ' highlight-pricing';
	}
	if( $pricing_style == 'style2' ){
		$result .= '<div class="price_style_two '.esc_attr($cls).'">
						<div class="pricing-heading">
							<h4 class="white price_title">'.esc_html($title).'</h4>
							<div class="price_wrapper">
								<div class="price">
									<h1 class="heading">'.esc_html($price).'<span>'.esc_html($currency).'</span></h1>
									<h5 class="small">'.esc_html($time).'</h5>
								</div>
							</div>
						</div>
						<div class="mt_price_content">
							<ul>'.do_shortcode($content).'</ul>
						</div>
						<div class="mt_price_footer">
							<a href="'.esc_url($btn_link).'" class="btn btn-default">'.esc_html($btn_text).'</a>
						</div>
					</div>';
	}elseif( $pricing_style == 'style3' ){
		$result .= '<div class="price_style_circle '.esc_attr($cls).'">
					<div class="pricing-heading">
						<div class="price_wrapper">
							<div class="price">
								<h1 class="heading">'.esc_html($price).'<span>'.esc_html($currency).'</span></h1>
							</div>
						</div>
						<h4 class="white price_title">'.esc_html($title).'</h4>
						<h5 class="plan_year">'.esc_html($time).'</h5>
					</div>
					<div class="mt_price_content">
						<ul>'.do_shortcode($content).'</ul>
					</div>
					<div class="mt_price_footer">
						<a href="'.esc_url($btn_link).'" class="btn btn-default">'.esc_html($btn_text).'</a>
					</div>
				</div>';
	}else{
		$result .= '<div class="pricing-table text-center '.esc_attr($cls).'">';
		$result .= '<div class="pricing-heading"><h4 class="white">'.esc_html($title).'</h4>
		<div class="price"><h1 class="heading">'.esc_html($price).'<sup>'.esc_html($currency).'</sup></h1><h5 class="small">'.esc_html($time).'</h5></div>
		</div>';
		$result .= '<ul class="">';
		$result .= do_shortcode($content);
		$result .= '</ul>';
		$result .= '<a href="'.esc_url($btn_link).'" class="btn btn-default">'.esc_html($btn_text).'</a>';
		$result .= '</div>';
	}
	
	
	return $result;
}
add_shortcode('moto_add_pricing_features','moto_add_pricing_features_function');
function moto_add_pricing_features_function($atts){
	extract( shortcode_atts( array(
		'features' => ''
	), $atts ) );
	$result = '<li>'.esc_html($features).'</li>';
	return $result;
}

/*************** Moto Process Shortcode Function******************/
add_shortcode('moto_process','moto_process_function');
function moto_process_function( $atts, $content = null ){
	extract( shortcode_atts( array(
		'title' => '',
		'background_style' => '',
		'bg_img' => '',
		'color' => '',
		'overlay' => '',
		'overlay_color' => '',
	), $atts ) );
	$result = '';
	if( $background_style == 'image' ){
		$src = wp_get_attachment_image_src($bg_img,'full');
		$result .= '<div class="mt_process_section mt_process_padding" data-stellar-background-ratio="0.5" style="background-image:url('.esc_url($src[0]).');">';
	}elseif( $background_style == 'color' ){
		$result .= '<div class="mt_process_section mt_process_padding" style="background-color:'.esc_attr($color).';">';
	}else{
		$src = wp_get_attachment_image_src($bg_img,'full');
		$result .= '<div class="mt_process_section mt_process_padding" data-stellar-background-ratio="0.5" style="background-image:url('.esc_url($src[0]).');">';
	}
	
	if( $overlay == 'yes' && !empty($overlay_color) ){
		$overlaycolor = $overlay_color;
	}else{
		$overlaycolor = '';
	}
	if( !empty( $title ) ){
	$title = '<div class="text-center"><hr><h4 class="white invo_heading">'.esc_html($title).'</h4></div>';
	}
	
	if( $overlay == 'yes' ){
		$result .= '<div class="mt_overlay mt_opacity" style="background-color:'.esc_attr($overlaycolor).'"></div>';
	}
	$result .= '<div class="container">
				<div class="row">'.$title.''.do_shortcode($content).'</div></div></div>';	
	return $result;
}

add_shortcode('moto_process_list','moto_process_list_function');
function moto_process_list_function( $atts ){
	extract( shortcode_atts( array(
		'title' => '',
		'desc' => '',
		'icon' => ''
	), $atts ) );
	$result = ''; 
	$result .= '<div class="col-lg-3 col-md-3">
                <div class="mt_work_wrapper">
                    <div class="mt_work_icon"><span><i class="'.esc_attr($icon).'" aria-hidden="true"></i></span>
                    </div>
                    <div class="mt_work_content">
                        <h4>'.esc_html($title).'</h4>
                        <p>'.esc_html(base64_decode($desc)).'</p>
                    </div>
                </div>
            </div>';	
	return $result;
}
/*************** Moto Process Shortcode Function End******************/

/*************** Services Shortcode Function******************/
add_shortcode( 'moto_services_shortcode', 'moto_services_shortcode_fun' );
function moto_services_shortcode_fun($atts){
	extract( shortcode_atts( array(
		'title' => '', 
		'no_service' => '', 
		'service_order' => '', 
		'cat' => '',
		'service_style' => '',
		'bg_color' => '',
	), $atts ) );
	$result = $morder = $subtitle = $iconcls = '';

	if($service_order=='asc'){
	   $morder = 'ASC';
	}else{  
	   $morder = 'DESC';
	}
	global $post;
	$categories = array();
	if($cat !='all'){
	        $categories =  array(
                             array(
                                'taxonomy' => 'service_categories',  
                                'field' => 'slug',
                                'terms'    => $cat,
                            ),
	                    );
	$args = array(
    	'post_type' => 'service',
		'post_status'=> 'publish',
		'posts_per_page' => $no_service,
		'order'   => $morder,
	    'tax_query' => $categories,
		);
	}  			
	else{
		$args = array(
    	'post_type' => 'service',
		'post_status'=> 'publish',
		'posts_per_page' => $no_service,
		'order'   => $morder,
		);
	}
    $service_query = new WP_Query($args);
	
	$result .= '<div class="invo_main_section moto_service_section"';
	if(!empty($bg_color)){
	$result .= ' style="background-color:'.$bg_color.';"';
	}
	$result .= '>';
	if($service_style == '2'){
	$result .= '<div class="container">';
	$result .= '<div class="text-center">';
	$result .= '<div class="row no-margin text-center">';
	if(!empty($title)){
		$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
	}
		$result .= '</div><div class="row">';
			if($service_query->have_posts()): 	
			$c = 0; while($service_query->have_posts()) : $service_query->the_post(); 
			if( $c == 4) {
				$result .= '<div class="clearfix"></div>';
				$c = 0;
			}
			$c++;
			$result .= '<div class="col-md-3 col-sm-6"><div class="mt_service_detail"><div class="service">';
			
			
			$iconType = get_post_meta($post->ID,'motocore_service_icon',true);
			if( $iconType == 'Image' ){
				$icon_src = get_post_meta($post->ID,'motocore_service_img_icon',true);
				$crop_src = moto_resize($icon_src, 80,80,true);
				$result .= '<img src="'.esc_url($crop_src).'" class="srvice_img_icon img-circle">';
			}else{
				$iconcls = get_post_meta($post->ID,'motocore_s_iconcls',true);
				$result .= '<span class="'.esc_attr($iconcls).' icon accent"></span>';
			}
			
				$result .= '<h5><a href="'.get_the_permalink().'">'.esc_html(get_the_title( $post->ID)).'</a></h5>';
				$result .= '<div class="mt_service_text">'.get_the_excerpt().'</div>';
				$result .= '</div></div></div>';
			endwhile;   
			endif;
			wp_reset_postdata();  
		$result .= '</div>';
	$result .= '</div>';
	$result .= '</div>';
	}elseif( $service_style == '3' ){
		$result .= '<div class="moto_service_three">
					<div class="container">';
					$result .= '<div class="row no-margin text-center">';
					if(!empty($title)){
						$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
					}
						$result .= '</div>
						<div class="row">';
						if($service_query->have_posts()):
						while($service_query->have_posts()) : $service_query->the_post();
							$result .= '<div class="col-md-4">
								<div class="mt_service_wrapper">
									<div class="mt_service_img">';
									$thumb = get_post_thumbnail_id($post->ID);
									$attachment_url = wp_get_attachment_url($thumb, 'full');
									$src = moto_resize( $attachment_url, 360, 262, true );
									$result .= '<img src="'.esc_url($src).'" alt=""> 
									</div>
									<div class="mt_service_content">
										<h5 class="heading"><a href="'.get_the_permalink().'">'.esc_html(get_the_title( $post->ID)).'</a></h5>
										<p>'.get_the_excerpt($post->ID).'</p>
									</div>
								</div>
							</div>';
						endwhile;	
						endif;
						wp_reset_postdata();
						$result .= '</div>
					</div>
				</div>';
	}elseif( $service_style == '4' ){
		$result .= '<div class="service_circle">
					<div class="container">';
					$result .= '<div class="row no-margin text-center">';
					if(!empty($title)){
						$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
					}
						$result .= '</div>
						<div class="row">';
						if($service_query->have_posts()):
						while($service_query->have_posts()) : $service_query->the_post();
							$result .= '<div class="col-lg-4 col-md-4">
											<div class="mt_service_content text-center">';
											
												$iconType = get_post_meta($post->ID,'motocore_service_icon',true);
												if( $iconType == 'Image' ){
													$icon_src = get_post_meta($post->ID,'motocore_service_img_icon',true);
													$crop_src = moto_resize($icon_src, 80,80,true);
													$result .= '<img src="'.esc_url($crop_src).'" class="srvice_img_icon img-circle">';
												}else{
													$iconcls = get_post_meta($post->ID,'motocore_s_iconcls',true);
													$result .= '<div class="spec_icon"><span class="'.esc_attr($iconcls).'"></span></div>';
												}
												
												$result .= '<h5 class="heading"><a href="'.get_the_permalink().'">'.esc_html(get_the_title( $post->ID)).'</a></h5>
												<p>'.get_the_excerpt($post->ID).'</p>
											</div>
										</div>';
						endwhile;	
						endif;
						wp_reset_postdata();
						$result .= '</div>
					</div>
				</div>';
	}else{ 	
	$result .= '<div class="container">';
	$result .= '<div class="row no-margin text-center">';
	if(!empty($title)){
		$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
	}
	$result .= '</div><div class="row">';
		if($service_query->have_posts()): 
		$p = 0;		
	    while($service_query->have_posts()) : $service_query->the_post();
		if( $p == 3) {
				$result .= '<div class="clearfix"></div>';
				$p = 0;
			}
			$p++;
		    $subtitle = get_post_meta($post->ID,'motocore_s_subtitle',true);
			$result .= '<div class="col-md-4 col-sm-6 text-left spec"><div class="row no-margin spec-title mt_service_wrapper">';
			
			$iconType = get_post_meta($post->ID,'motocore_service_icon',true);
			if( $iconType == 'Image' ){
				$icon_src = get_post_meta($post->ID,'motocore_service_img_icon',true);
				$crop_src = moto_resize($icon_src, 80,80,true);
				$result .= '<img src="'.esc_url($crop_src).'" class="srvice_img_icon img-circle">';
			}else{
				$iconcls = get_post_meta($post->ID,'motocore_s_iconcls',true);
				$result .= '<div class="'.esc_attr($iconcls).' spec-icon"></div>';
			}
			
			$result .= '<div class="mt_service_content"><h5 class="heading"><a href="'.get_the_permalink().'"><b>'.esc_html(get_the_title( $post->ID)).'</b></a><br>';
			$result .= '<span class="spaced muted heading-bottom">'.esc_html($subtitle).'</span>';
			$result .= '</h5>';
			$result .= '<p>'.get_the_excerpt($post->ID).'</p></div>';
			$result .= '</div></div>';
		endwhile; 
		endif;
		wp_reset_postdata(); 
	$result .= '</div>';	
	$result .= '</div>';
	}
	$result .= '</div>';
	return $result;
}
/*************** Moto Heading Shortcode Function******************/
add_shortcode( 'moto_heading_shortcode', 'moto_heading_shortcode_fun' );
function moto_heading_shortcode_fun($atts){
	extract( shortcode_atts( array(
		'title' => '', 
		'heading_cls' => '', 
		'text_align' => '',
		'head_style' => '',
		'font_color' => ''
	), $atts ) ); 
	$result= $cls = '';
	if( empty( $head_style ) ){
		$head_style = 'h4';
	}if( empty($font_color) ){
		$font_color = '';
	}
	if($text_align =='right'){
		$cls = 'text-right';
	}elseif($text_align =='left'){
		$cls = 'text-left';
	}else{
		$cls = 'text-center';
	}
	$result .= '<div class="row no-margin '.esc_attr($cls).'">';
	$result .= '<hr style="background:'.esc_attr($font_color).'">';
	$result .= '<'.esc_html( $head_style ).' class="'.esc_attr($heading_cls).'" style="color:'.esc_attr($font_color).'">'.esc_html($title).'</'.esc_html( $head_style ).'>';
	$result .= '</div>';
	return $result;
}
/*************** Moto Effective Shortcode Function******************/
add_shortcode( 'moto_effective_shortcode', 'moto_effective_shortcode_fun' );
function moto_effective_shortcode_fun($atts){
	extract( shortcode_atts( array(
		'title' => '', 
		'sub_title' => '', 
		'in_url' => '', 
		'icon' => '', 
	), $atts ) );
	$result='';	
	$result .= '<div class="col-md-12 intro-padding"><div class="box_link_wrapper">';
    $result .= '<a href="'.esc_url($in_url).'" class=" box-link-holder light-yellow-bg">';
    $result .= '<div class="box-link yellow-bg text-center">';
    $result .= '<h5 class="dark-accent">'.esc_html($title).'</h5>';
    $result .= '<span class="'.esc_html($icon).' big-icon white"></span>';
    $result .= '<h5 class="white">'.esc_html($sub_title).'</h5>';
    $result .= '</div>';
    $result .= '</a></div></div>';	 
	return $result;
}
/*************** Moto Effective Shortcode Function******************/
add_shortcode( 'moto_welcome_banner_shortcode', 'moto_welcome_banner_shortcode_fun' );
function moto_welcome_banner_shortcode_fun($atts){
	extract( shortcode_atts( array(
		'welcomebanner_title' => '', 
		'bg_image' => '', 
	), $atts ) );	
	$src = wp_get_attachment_image_src($bg_image,'full');
	if(empty($src)){
	  $img = '';
	}else{
	$img = $src[0];
	} 
	$result='';	
	$result .= '<div class="col-md-12 col-sm-12 intro-padding">';
    $result .= '<div class="intro-box" data-background="'.esc_url($img).'">';
    $result .= '<div class="col-md-8 col-md-offset-2"><div class="alt white">'.esc_html(base64_decode($welcomebanner_title)).'</div></div>';
    $result .= '</div>';
    $result .= '</div>';
	return $result;
}
/*************** Moto HOW WE WORK Shortcode Function******************/
add_shortcode( 'moto_how_we_work_banner_shortcode', 'moto_how_we_work_banner_shortcode_fun' );
function moto_how_we_work_banner_shortcode_fun($atts,$content){
	extract( shortcode_atts( array(
	'hww_banner_title' => '', 	
	'bg_color' => '', 	
	), $atts ) );
	$result= $cls= '';	
	if($bg_color == 'dark' ){
	 $cls= 'yellow-bg discount-box';
	}else{
	 $cls= 'light-yellow-bg intro-box1';
	}

	$result .= '<div class="col-md-12 col-sm-12 intro-padding">';
    $result .= '<div class="'.esc_attr($cls).' text-center">';
    $result .= '<p>'.esc_html(base64_decode($hww_banner_title)).'</p>';
    $result .= '</div>';
    $result .= '</div>';
	return $result;
}
/*************** Moto HOW WE WORK Shortcode Function******************/
add_shortcode( 'moto_shop_banner_shortcode', 'moto_shop_banner_shortcode_fun' );
function moto_shop_banner_shortcode_fun($atts,$content){
	extract( shortcode_atts( array(
	'title' => '', 	
	'in_url' => '', 	
	'sub_title' => '', 	
	'background_style' => '',
	'bg_image' => '',
	'color' => ''
	), $atts ) );
	
	$result='';	
	$result .= '<div class="col-md-12 text-center intro-padding">';
	if( $background_style == 'image' ){
		$src = wp_get_attachment_image_src($bg_image,'full');
		$result .= '<div class="winter-shop" data-background="'.esc_url($src[0]).'">';
	}
	if( $background_style == 'color' ){
		$result .= '<div class="winter-shop" style="background-color:'.esc_attr($color).'";">';
	}
    
    $result .= '<a href="'.esc_url($in_url).'"><div class="">';
    $result .= '<h3 class="white"><b>'.esc_html($title).'</b></h3>';
    $result .= '</div></a>';
    $result .= '<hr><h4 class="white mt_shop_bnr_head">'.esc_html($sub_title).'</h4>';
    $result .= '</div></div>';
	return $result;
}
/*********Add Our Features************/
add_shortcode('moto_our_features','moto_our_features_function');
function moto_our_features_function($atts,$content){
	extract( shortcode_atts( array(
		'feature_formate' => 'formate_1',
		'title' => '',
		'image' => '',
		'bg_color' => '',
	), $atts ) );
	$result = '';
	$result .= '<div class="invo_main_section"';
	if(!empty($bg_color)){
	$result .= ' style="background-color:'.$bg_color.';"';
	}
	$result .= '>';	
	//$result .= '<section class="in_website_feature">';
	$result .= '<div class="container-fluid no-margin"><div class="row">';
	
	if( $feature_formate == 'formate_1' ){
		$result .= '<div class="col-md-6  text-left">';
		$result .= '<div class="row no-margin">';
		if(!empty($title)){
		$result .= '<hr>';
		$result .= '<h4 class="invo_heading">'.esc_html($title).'</h4>';
		}
		$result .= '</div>';
		$result .= do_shortcode($content);
		$result .= '</div>';
		$result .= '<div class="col-md-5 col-md-offset-1 no-padding">';
		$src = wp_get_attachment_image_src($image,'full');
		if(!empty($src[0]))	{
		$result .= '<img src="'.esc_url($src[0]).'" class="full-width" alt="">';
		}
		$result .= '</div>';
	} else{
		$result .= '<div class="col-md-6">';
		$src = wp_get_attachment_image_src($image,'full');
		if(!empty($src[0]))	{
		$result .= '<img src="'.esc_url($src[0]).'" class="full-width" alt="">';
		}
		$result .= '</div>';
		
		$result .= '<div class="col-md-5 col-md-offset-1 text-left">';
		$result .= '<div class="row no-margin">';
		if(!empty($title)){
		$result .= '<hr>';
		$result .= '<h4 class="invo_heading">'.esc_html($title).'</h4>';
		}
		$result .= '</div>';
		$result .= do_shortcode($content);
		$result .= '</div>';
	}
	
	
	
	
	$result .= '</div></div>';
	$result .= '</div>';
	//$result .= '</section>';
	return $result;
}
/*********Add Our Features************/
add_shortcode('moto_add_our_features','moto_add_our_features_function');
function moto_add_our_features_function($atts){
	extract( shortcode_atts( array(
		'features_title' => '',
		'icon' => '',
		'description' => '',
		'in_url' => '',
	), $atts ) );
	$result = '';
	$result .= '<div class="row no-margin">';
	$result .= '<a href="'.esc_attr($in_url).'" class="feature"> <span class="'.esc_html($icon).' icon"></span>';
    $result .= '<div class="feature-details"><h4 class="heading">'.esc_html($features_title).'</h4>';
    $result .= '<p>'.esc_html(base64_decode($description)).'</p>';
    $result .= '</div></a></div>';
	return $result;
}
/*************** Moto Creative Call To Action Shortcode Function******************/
add_shortcode( 'moto_creative_call_action_shortcode', 'moto_creative_call_action_shortcode_fun' );
function moto_creative_call_action_shortcode_fun($atts,$content){
	extract( shortcode_atts( array(
	'title' => '', 	
	'action_formate' => '', 	
	'sub_title' => '', 	 	
	'btn_txt' => '', 	 	
	'btn_link' => '', 	 	
	'video_link' => '',	
	'text_alignment' => '',	
	'background_style' => '',
	'bg_image' => '',
	'color' => '',
	'overlay' => '',
	'overlay_color' => '',
	), $atts ) );
	$result='';
	$src = wp_get_attachment_image_src($bg_image,'full');
	if(empty($src)){
	  $img = get_template_directory_uri().'/images/call_to_action.jpg';
	}else{
	$img = $src[0];
	}
	
	if( $background_style == 'image' ){
		$result .= '<section class="call-to-action" data-stellar-background-ratio="0.5" style="background: url('.esc_url($img).');">';
		if( $overlay == 'yes' ){
			if( !empty($overlay_color) ){
				$overlaycolor = $overlay_color;
			}else{
				$overlaycolor = '';
			}
			
			$result .= '<div class="mt_overlay mt_opacity" style="background-color:'.esc_attr($overlaycolor).'"></div>';
			}
	}else{
		$result .= '<section class="call-to-action" style="background-color:'.esc_attr($color).';">';
	}
		
	$alignment = 'text-center';
	//echo $text_alignment;
	if($text_alignment == 'txt_left'){
		$alignment = 'text-left';
	}
	if($text_alignment == 'txt_right'){
		$alignment = 'text-right';
	}	

	if(	$action_formate == 'formate_1' ){
		
		$result .= '<div class="container"><div class="row">';
		$result .= '<div class="col-md-12 '.esc_html($alignment).'">';
		$result .= '<h2 class="spaced">'.esc_html($title).'</h2>';
		$result .= '<h3 class="accent spaced">'.esc_html($sub_title).'</h3>';
		$result .= '<a href="'.esc_url($btn_link).'" class="btn btn-accent">'.esc_html($btn_txt).'<i class="fa fa-long-arrow-right"></i></a></div>';
		$result .= '</div></div></section>';
	}else{
		$result .= '<div class="container"><div class="row">';
		$result .= '<div class="col-md-12 '.esc_html($alignment).'">';
		$result .= '<h2 class="spaced">'.esc_html($title).'</h2>';
		$result .= '<h3 class="accent spaced">'.esc_html($sub_title).'</h3>';
		$result .= '<a href="'.esc_url($video_link).'" data-gal="prettyPhoto[iframes]" class="btn video_btn"><i class="fa fa-play-circle-o"></i></a></div>';
		$result .= '</div></div></section>';
	}
	return $result;
}
/***************  We Are Moto Shortcode Function******************/
add_shortcode( 'moto_we_are_moto', 'moto_we_are_moto_fun_shortcode_fun' );
function moto_we_are_moto_fun_shortcode_fun($atts,$content){
	extract( shortcode_atts( array(
	'title' => '', 	
	'sub_title' => '', 
	'image' => '', 	
	'bg_color' => '', 	
	), $atts ) );
	$src = wp_get_attachment_image_src($image,'full');
	if(empty($src)){
	  $img = get_template_directory_uri().'/images/call_to_action.jpg';
	}else{
	$img = $src[0];
	}
	$result='';	
	//$result .= '<section class="no_padding_bottom">';
	 $result .= '<div class="invo_main_weinvo"';
	if(!empty($bg_color)){
	$result .= ' style="background-color:'.$bg_color.';"';
	}
	$result .= '>';
	$result .= '<div class="container">';
	$result .= '<div class="text-center"><div class="row no-margin">';
	if(!empty($title)){
	$result .= '<hr><h4 class="invo_heading">'.esc_html($title).'</h4>';
	}
	if(!empty($sub_title)){
	$result .= '<h5 class="spaced muted">'.esc_html($sub_title).'</h5>';
	}
	$result .= '</div>';
	$result .= '<div class="row">';
	$result .= '<div class="col-md-8 col-md-offset-2">';
	$result .= '<div class="owl-carousel owl-text">';
	$result .= do_shortcode($content);
	$result .= '</div>';
	$result .= '</div>';
	$result .= '</div>';
	if(!empty($src[0])){
	$result .= '<div class="row facts">';
	$result .= '<div class="col-md-12">';
	$result .= '<img src="'.esc_url($src[0]).'" class="full-width devices-img" alt="">';
	$result .= '</div>';
	$result .= '</div>';
	}
	$result .= '</div>';
	$result .= '</div>';
	$result .= '</div>';
	//$result .= '</section>';
	return $result;
}
/*********Add Text Slider************/
add_shortcode('moto_text_slider','moto_text_slider_function');
function moto_text_slider_function($atts){
	extract( shortcode_atts( array(
		'description' => '',
	), $atts ) );
	$result = '';
	$result .= '<div class="item">';	
    $result .= '<p>'.esc_html(base64_decode($description)).'</p>';
    $result .= '</div>';
	return $result;
}
/***************  Theme Features Shortcode Function******************/
add_shortcode( 'moto_theme_features_fun', 'moto_theme_features_fun_shortcode' );
function moto_theme_features_fun_shortcode($atts,$content){
	extract( shortcode_atts( array(
	'padding' => '', 			
	'bg_color' => '', 			
	), $atts ) );
	$result= $cls = $maincls = '';
	$cls = explode(',',$padding); 
	for($i=0;$i<count($cls);$i++){
	$maincls .= $cls[$i].' ';
	}
	 //$result .= '<section class="'.$maincls.'">';
	$result .= '<div class="'.$maincls.'invo_main_section mt_spec_icon"';
	if(!empty($bg_color)){
	$result .= ' style="background-color:'.$bg_color.';"';
	}
	$result .= '>';
	$result .= '<div class="container">';
	
	$result .= '<div class="text-center">';
	$result .= '<div class="row facts">';
	$result .= do_shortcode($content);
	$result .= '</div>';
	$result .= '</div>';
	$result .= '</div>';
	$result .= '</div>';
	//$result .= '</section>';
	return $result;
}
/*********Add Text Slider************/
add_shortcode('moto_add_theme_features','moto_add_theme_features_function');
function moto_add_theme_features_function($atts){
	extract( shortcode_atts( array(
		'title' => '',
		'column' => '',
		'left_border' => '',
		'sub_title' => '',
		'icon' => '',
	), $atts ) );
	$result = $clm = $cls = '';
	if($column=='column_4'){
	$clm = '4 col-sm-6 ';
	}else{
	$clm = '3 spec-title';
	}
	if($left_border == 'no'){
	$cls = 'spec';
	}else{
	$cls = 'fact invo_facts'; 
	}
	$result .= '<div class="col-md-'.$clm.' '.$cls.' text-left">';
	if($column=='column_4'){
	$result .= '<div class="row no-margin spec-title">';
	}
	$result .= '<div class="'.esc_attr($icon).' spec-icon"></div>';
	$result .= '<h5 class="heading"><b>'.esc_html($title).'</b><br>';
	$result .= '<span class="spaced muted heading-bottom">'.esc_html($sub_title).'</span>';
	$result .= '</h5>';
	if($column=='column_4'){
	$result .= '</div>';
	}
	$result .= '</div>';
	return $result;
} 
/***************  Mobile Features Shortcode Function******************/
add_shortcode( 'moto_mobile_features_fun', 'moto_mobile_features_fun_shortcode' );
function moto_mobile_features_fun_shortcode($atts,$content){
	extract( shortcode_atts( array(
	'icon_position' => '', 			
	), $atts ) ); 
	$result= $cls = '';	
	if($icon_position=='Right'){
	$cls = 'text-right small-feature-left';
	}else{
	$cls = '';
	}	
	$result .='<div class="'.esc_attr($cls).'">';
	$result .= do_shortcode($content);
	$result .='</div>';
	return $result;
}
/*Add Mobile Features*/
add_shortcode('moto_add_mobile_features','moto_add_mobile_features_function');
function moto_add_mobile_features_function($atts){
	extract( shortcode_atts( array(
		'title' => '',
		'title_color' =>'#404040',
		'icon' => 'icon-tools',
		'description' => '',
	), $atts ) );
	$result = '';
	$result .= '<div class="row no-margin small-feature">';
	$result .= '<span class="'.esc_attr($icon).' accent icon"></span>';
	$result .= '<div class="content">';
	$result .= '<h5 class="heading" style="color:'.$title_color.'"><b>'.esc_html($title).'</b><br></h5>';
	$result .= '<p>'.esc_html(base64_decode($description)).'</p>';
	$result .= '</div></div>';
	return $result;
}
/* Moto Accordion Shortcode */

add_shortcode( 'moto_accordion_shortcode', 'moto_accordion_shortcode_fun' );
function moto_accordion_shortcode_fun($atts,$content){
	extract( shortcode_atts( array(
		'style' => ''
	), $atts ) );
	$result = '';
	if( $style == "2" ){
		$cls = 'accordion_classic';
	}elseif( $style == "3" ){
		$cls = 'accordion_light';
	}else{
		$cls = 'default_accordion';
	}
	$result .= '<div class="mt_accordion '.esc_attr($cls).'">
					<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
						'.do_shortcode($content).'
					</div>
				</div>';
	return $result;
}

add_shortcode( 'accordion_list', 'accordion_list_fun' );
function accordion_list_fun($atts){
	extract( shortcode_atts( array(
		'title' => '',
		'desc' => ''
	), $atts ) );
	$result = '';
	static $i = 0;
	$cls = $cls2 = '';
	if( $i == 0 ){
		$cls = 'in';
		
	}else{
		$cls2 = 'collapsed';
	}
$tstr = str_replace(' ', '', $title);
	$tid = preg_replace('/[^A-Za-z0-9\-]/', '', $tstr);
	
		$result .= '<div class="panel panel-default">
						<div class="panel-heading" role="tab">
						  <h4 class="panel-title">
							<a class="'.esc_attr($cls2).'" role="button" data-toggle="collapse" data-parent="#accordion" href="#'.$tid.'" aria-expanded="true" aria-controls="'.$tid.'">'.esc_html($title).'</a>
						  </h4>
						</div>
						<div id="'.$tid.'" class="panel-collapse collapse '.esc_attr($cls).'" role="tabpanel">
						  <div class="panel-body">'.esc_html(base64_decode($desc)).'</div>
						</div>
					  </div>';
					 $i++;
	return $result;
}


/***************  Latest Works Shortcode Function******************/
add_shortcode( 'moto_latest_works_fun', 'moto_latest_works_fun_shortcode' );
function moto_latest_works_fun_shortcode($atts,$content){
	extract( shortcode_atts( array(
	'main_title' => '', 			
	'image' => '', 			
	'title' => '', 			
	'sub_title' => '', 			
	'btn_text' => 'Go Shopping', 			
	'btn_link' => '', 			
	'bg_color' => '', 			
	), $atts ) );
	$src = wp_get_attachment_image_src($image,'full');
	$result= '';
	//$result .='<section>';
	$result .= '<div class="invo_main_section"';
	if(!empty($bg_color)){
	$result .= ' style="background-color:'.$bg_color.';"';
	}
	$result .= '>';
	$result .='<div class="container-fluid no-margin"><div class="row">';
	$result .='<div class="col-md-4 col-md-offset-2 text-left">';
	$result .='<div class="row no-margin">';
	if(!empty($main_title)){
	$result .='<hr><h4 class="invo_heading">'.esc_html($main_title).'</h4>';
	}
	$result .='</div>';
	$result .= do_shortcode($content);
	$result .='</div>';
	$result .='<div class="col-md-3 no-padding text-center vcenter">';
	if(!empty($title)){
	$result .='<h4 class="alt">'.esc_html($title).'</h4>';
	}
	if(!empty($sub_title)){
	$result .='<h5 class="accent">'.esc_html($sub_title).'</h5>';
	}
	$result .='<a href="'.esc_url($btn_link).'" class="btn btn-default">'.esc_html($btn_text).' <i class="fa fa-long-arrow-right"></i></a>';
	$result .='</div>';
	$result .='<div class="col-md-3 hidden-xs hidden-sm">';
	if(!empty($src[0])){
	$result .='<img src="'.esc_url($src[0]).'" class="full-width" alt="">';
	}
	$result .='</div>';
	$result .='</div></div>';
	$result .='</div>';
	//$result .='</section>';
	return $result;
}
/*Add Latest Works*/
add_shortcode('moto_add_latest_works','moto_add_latest_works_function');
function moto_add_latest_works_function($atts){
	extract( shortcode_atts( array(
		'title' => '',
		'icon' => 'icon-tools',
		'description' => '',
		'link' => '',
	), $atts ) );
	$result = '';
	$result .= '<div class="row no-margin">';
	$result .= '<a href="'.esc_url($link).'" class="feature"><span class="'.esc_attr($icon).' icon"></span>';
	$result .= '<div class="feature-details"><h4 class="heading">'.esc_html($title).'</h4>';
	$result .= '<p>'.esc_html(base64_decode($description)).'</p>';
	$result .= '</div></a>';
	$result .= '</div>';
	return $result;
}
/***************  Latest Works Shortcode Function******************/
add_shortcode( 'moto_brands_fun', 'moto_brands_fun_shortcode' );
function moto_brands_fun_shortcode($atts,$content){
	extract( shortcode_atts( array(
	'title' => '', 			
	'description' => '',	
	'btn_text' => '', 			
	'btn_link' => '', 			
	'brands_logos' => '', 			
	), $atts ) ); 
	$result = '';
	$logos = explode(',',$brands_logos);
	$result .='<section class="no-margin no-padding">';
	$result .='<div class="container-fluid">';
	$result .='<div class="row fashion"><div class="col-md-6 yellow-bg top-fashion">';
	$result .='<div class="col-md-6 col-md-offset-6">';
	$result .='<hr class="white"><h4 class="invo_heading white">'.esc_html($title).'</h4>';
	$result .='<p class="white">'.esc_html(base64_decode($description)).'</p>';
	$result .='<a href="'.esc_url($btn_link).'" class="btn btn-white pull-right">'.esc_html($btn_text).'</a>';
	$result .='</div></div>';
	$result .='<div class="col-md-6">
	<div class="owl-clients client_style_three no-navigation">';
		$quotient = floor(count($logos)/4);
		$remainder = count($logos)%4;

		for( $i=1; $i<=$quotient; $i++ ){
		if( $i==1){
			$br_id = 0;
		}
		$result .='<div class="item">';
			for( $j=1; $j<=4; $j++ ){
			$src = wp_get_attachment_image_src($logos[$br_id],'full');
				$result .='<div class="col-lg-6 col-md-6 mt_client_div text-center">
					<img src="'.esc_url($src[0]).'" alt="">
				</div>';
				$br_id++;
			}
			echo '<br>';
		$result .='</div>';
		}

		if( $remainder > 0 ){
				$result .='<div class="item">';
			for( $k=1; $k<=$remainder; $k++ ){
			$src = wp_get_attachment_image_src($logos[$br_id],'full');
				$result .='<div class="col-lg-6 col-md-6 mt_client_div text-center">
					<img src="'.esc_url($src[0]).'" alt="">
				</div>';
				$br_id++;
			}
		$result .='</div>';
		}
	$result .='</div> </div>';
	$result .='</div>';
	$result .='</div></div></section>';
	return $result; 
}
/*************** Title With Slider Shortcode Function******************/
add_shortcode( 'moto_title_slider_fun', 'moto_title_slider_fun_shortcode' );
function moto_title_slider_fun_shortcode($atts,$content){
	extract( shortcode_atts( array(
	'title' => '',
	'invo_slide' => '', 			
	), $atts ) );
	$result = $src = $slides = '';
	$result .='<div class="mt_single_portfolio">';
	if( isset($title) && !empty( $title ) ){
		$result .='<div class="container"><div class="row">';
		$result .='<div class="col-md-12 text-center"><hr>';
		$result .='<h4 class="model_title">'.esc_html($title).'</h4>';
		$result .='</div></div></div>';
	}
	
	$result .='<div class="row"><div class="col-md-12">';
	$result .='<div class="owl-project">';
	$slides = explode(',',$invo_slide);
	for($i=0;$i<count($slides);$i++){
		$src = wp_get_attachment_image_src($slides[$i],'full');
		$result .='<div class="item">';
		$result .='<img src="'.esc_url($src[0]).'" class="full-width" alt="">';
		$result .='</div>';
	}		
	$result .='</div>';
	$result .='</div></div></div>';
	return $result;
}

/**********Moto Testimonial***********/
add_shortcode( 'moto_testimonial', 'moto_testimonial_shortcode' );
function moto_testimonial_shortcode($atts,$content = null){
	extract( shortcode_atts( array(
	'formate' => 'formate_1',			
	'title' => '',			
	'testi_back' => '',
	'product_img' => '',
	'color'	=> '',
	'hd_color'	=> '',
	'ft_color'	=> '',
	'navigation' => '', 
	), $atts ) );
	$back_img = wp_get_attachment_image_src($testi_back,'full');
	$product_img = wp_get_attachment_image_src($product_img,'full');
	//product description slider
	
	global $moto_testi_style, $headingColor, $fontColor;
	$moto_testi_style = $formate;
	
	if( isset( $hd_color ) ){
		$headingColor = $hd_color;
	}else{
		$headingColor = '';
	}
	
	if( isset( $ft_color ) ){
		$fontColor = $ft_color;
	}else{
		$fontColor = '';
	}
	
	$result= '';
	$result .= '<input type="hidden" id="testi_icon_color" value="'.esc_attr($headingColor).'">';
if( $formate != 'formate_3' ){
	if( $navigation == 'nav_arrow' ){
		$nav_cls = 'nav_arrow';
	}elseif( $navigation == 'nav_dot' ){
		$nav_cls = 'nav_dot';
	}else{
		$nav_cls = 'nav_none';
	}
}else{
	if( $navigation == 'nav_arrow' ){
		$nav_cls = 'nav_arrowes';
	}elseif( $navigation == 'nav_dotes' ){
		$nav_cls = 'nav_dotes';
	}else{
		$nav_cls = 'nav_nones';
	}
}

	
	if( $formate == 'formate_1' ){
		$result .= '<div class="mt_product_review" data-stellar-background-ratio="0.5" style="background-image: url('.esc_url($back_img[0]).');" data-scroll-index="1">
			<div class="container">
				<div class="row">
					<div class="col-lg-6 col-md-6">
					
						<div class="mt_product_img_wrapper">
							<img src="'.esc_url($product_img[0]).'" alt="">
						</div>
					</div>
					<div class="col-lg-6 col-md-6">';
					    $result .= '<div class="product_description_wrapper '.$nav_cls.'">';
					   $result .= '<h3 class="mt_title" style="color:'.esc_attr($headingColor).'">'.esc_html($title).'</h3>
							<div class="owl-carousel owl-theme">';
							$result .= do_shortcode($content);			
				$result .= '</div></div></div></div>
			</div>
		</div><!-- product description section-->';
	}elseif( $formate == 'formate_2' ){
		   $result .='<div class="mt_testimonial_section product_description_wrapper '.$nav_cls.'" style="background-color:'.$color.';">';
		$result .='<div class="container">
				<div class="row">
					<div class="col-lg-8 col-md-8 col-lg-offset-2 col-md-offset-2">
						<h3 style="color:'.esc_attr($headingColor).'">'.esc_html($title).'</h3>
						<div class="owl-carousel owl-theme">';
							$result .= do_shortcode($content);
						$result .= '</div>
						</div>
				    </div>
			    </div>
		   </div>';
	}elseif( $formate == 'formate_3' ){
		    $result .= '<div class="mt_testimonial_section style_three '.$nav_cls.'" style="background-color:'.$color.';">';
			$result .= '<div class="owl-carousel owl-theme">';
			$result .= do_shortcode($content); 
			$result .= '</div>';
			$result .= '</div>';
	}
	
	$moto_testi_style = $headingColor = $fontColor = '';
	
	return $result;
}
add_shortcode( 'moto_single_testimonial', 'moto_single_testimonial_shortcode' );
function moto_single_testimonial_shortcode($atts,$content = null){
	extract( shortcode_atts( array(
	'title' => '',
	'desc' => '', 			 
	'name' => '', 			
	'visitor_img' => '',
    'designation' => '',	
	), $atts ) );
	global $moto_testi_style,$headingColor, $fontColor;
	$result = '';
	
	$src = '';
	$attachment_url = wp_get_attachment_image_src( $visitor_img, 'full' );
	if( isset($attachment_url[0]) && !empty($attachment_url[0]) )
		$src = moto_resize( $attachment_url[0], 86, 86, true );
	
	if( $moto_testi_style == 'formate_3' ){
		$result .= '<div class="item">';
			$result .= '<div class="mt_testimonial_data">';
				$result .= '<div class="mt_testimonial_content">';
					$result .= '<span class="testimonial_icon"><i class="fa fa-quote-left" aria-hidden="true"></i></span>';
					$result .= '<p>'.esc_html(base64_decode($desc)).'</p>';
				$result .= '</div>';
				$result .= '<span class="mt_authore_img"><img src="'.esc_url($src).'" alt=""></span>';
				$result .= '<div class="mt_authore_data">';
				$result .= '<span class="mt_authore_name" style="color:'.esc_attr($fontColor).'">'.esc_html($name).'</span>';
				$result .= '<span class="designation" style="color:'.esc_attr($fontColor).'">'.esc_html($designation).'</span>';
				$result .= '<span class="mt_authore_city" style="color:'.esc_attr($headingColor).'">'.esc_html($title).'</span>';
				$result .= '</div>';
			$result .= '</div>';
		$result .= '</div>';
	}else{
		$result .='<div class="item">
			<div class="mt_product_description">
				<h5 style="color:'.esc_attr($headingColor).'">'.esc_html($title).'</h5>
				
				<p style="color:'.esc_attr($fontColor).'">'.esc_html(base64_decode($desc)).'</p>
				<div class="mt_authore_detail">
					<span class="mt_authore_img"><img src="'.esc_url($src).'" alt=""></span><span class="mt_authore_name" style="color:'.esc_attr($headingColor).'">'.esc_html($name).'</span>
					<span class="designation" style="color:'.esc_attr($fontColor).'">'.esc_html($designation).'</span>
				</div>
			</div>
		</div>';

	}	
	return $result; 
}

/********MAilchimp Start*********/
add_shortcode( 'moto_mailchimp', 'moto_mailchimp_shortcode' );
function moto_mailchimp_shortcode( $atts ){
	extract( shortcode_atts( array(
	'formate' => 'formate_1',
	'logo' => '',
	'title' => '',
	'subtitle' => '',
	'description' => '',
	'heading' => '',	
	'api_key' => '', 			
	'list_id' => '' ,			
	'back_img' => '',		
	'enable_social' => ''		
	), $atts ) );
	$logo = wp_get_attachment_image_src($logo,'full');
	$back_img = wp_get_attachment_image_src($back_img,'full');
	$result = '';
	$result .='<input type="hidden" id="mailchimp_api" value="'.esc_attr($api_key).'">
			   <input type="hidden" id="mailchimp_list_id" value="'.esc_attr($list_id).'">';
	if( $formate == 'formate_1' ){
	$result .='<div class="mt_subscribe_section" data-stellar-background-ratio="0.5" style="background-image: url('.$back_img[0].');">
	<div class="mt_white_overlay"></div>
		<div class="container">
			<div class="row">
				<div class="col-lg-8 col-md-8 col-lg-offset-2 col-md-offset-2"> 
					<div class="mt_headeing_wrapper">
						<h3 class="mt_title">'.esc_html($title).'</h3>
						<p>'.esc_html(base64_decode($description)).'</p>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-8 col-md-8 col-lg-offset-2 col-md-offset-2">
					<div class="mt_subscribe_form">
						<input type="email" class="form-control mailchimp_email" placeholder="'.esc_html__('Email Address', 'moto').'">
						<a href="#" class="btn btn_default mailchimp_btn">'.esc_html__('send', 'moto').'</a>
						<div class="mailchimp_message"></div>
						<div class="mailchimp_error"></div>
					</div>';
					if($enable_social == 'yes'){
						$result .='<div class="moto_social_link">';
							$result .= moto_social();
						$result .='</div>';
					}
				$result .='</div>
			</div>
		</div>
	</div>';
	}else{

	$result .='<div class="mt_subscribe_wrapper" data-stellar-background-ratio="0.5" style="background-image: url('.$back_img[0].');">
	<div class="container">
		<div class="row">
			<div class="col-lg-6 col-lg-offset-3 col-md-6 col-md-offset-3 pull-right">
				<div class="mt_subscribe_form_wrapper">
					<h2>'.esc_html($title).'<span>'.esc_html($subtitle).'</span> </h2>
					<div class="mt_subscribe_form">
						<h3>'.esc_html($heading).'</h3>
						<div class="form-group">
							<input type="text" class="form-control subscriber" placeholder="'.esc_html__('Name', 'moto').'">
						</div>
						<div class="form-group">
							<input type="email" class="form-control mailchimp_email" placeholder="'.esc_html__('Email address', 'moto').'">
						</div>
						<a href="#" class="btn btn_default mailchimp_btn">'.esc_html__('subscribe', 'moto').'</a>
						<div class="mailchimp_message"></div>
						<div class="mailchimp_error"></div>
						<p><i class="fa fa-lock" aria-hidden="true"></i>'.esc_html(base64_decode($description)).'</p>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="mt_optin_header">
		<div class="container">
			<div class="row">';
			if($logo){
				$result .='<div class="mt_optin_logo">
					<a href="#" class="navbar-brand"><img src="'.esc_url($logo[0]).'" alt="..."></a> 
				</div>';
			} 
				
				if($enable_social == 'true'){
						$result .='<div class="moto_social_link">';
							$result .= moto_social();
						$result .='</div>';
					}
		$result .='</div>
		</div>
	</div>
</div>';
}
	return $result; 	
}
/********Purchase Product Start*********/
add_shortcode( 'moto_product_purchase', 'moto_product_purchase_shortcode' );
function moto_product_purchase_shortcode($atts,$content = null){
	extract( shortcode_atts( array(
	'title' => '',
	'desc' => '', 			 
	'pro_img' => '', 			
	'btn1_txt' => '' ,			
	'btn1_link' => '',
	'btn2_txt' => '', 
	'btn2_link' => '',
	), $atts ) );
	$pro_img = wp_get_attachment_image_src($pro_img,'full');
	$result = '';
	$result .='	<div class="mt_product_purchase_section" data-stellar-background-ratio="0.5">	
				<div class="container">
					<div class="row">
						<div class="col-lg-8 col-md-8 col-lg-offset-2 col-md-offset-2">
							<div class="mt_headeing_wrapper">
								<h3 class="mt_title">'.esc_html($title).'</h3>
								<p>'.esc_html(base64_decode($desc)).'</p>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-8 col-md-8 col-lg-offset-2 col-md-offset-2">
							<div class="mt_download_section">
								<div class="mt_product_img">
									<img src="'.esc_attr($pro_img[0]).'" alt="">
								</div>
								<div class="mt_download_btn_wrapper">
									<a href="'.esc_attr($btn1_link).'" class="btn moto_btn">'.esc_attr($btn1_txt).'</a><a href="'.esc_attr($btn2_link).'" class="btn moto_btn">'.esc_attr($btn2_txt).'</a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>';
	return $result; 
}

/********Moto Latest Or Featured Post Start*********/
add_shortcode( 'moto_fol_post', 'moto_fol_post_shortcode' );
function moto_fol_post_shortcode( $atts ){
	extract( shortcode_atts( array( 
	'title' 	=> '',		 
	'fol_list'  => 'featured', 			
	'video_no'  => ''
	), $atts ) );
	$result = '';

	$result .='<div class="mt_popular_video_section">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12">
			<hr>
			<h4 class="invo_heading">'.esc_html($title).'</h4> 
				<div class="owl-carousel owl-theme">';
				if( $fol_list == 'featured' ){
								$args = array( 'post_type' => 'video', 'posts_per_page' => esc_attr($video_no),
										'tax_query' => array(
													array(
														'taxonomy' => 'video_categories',
														'field'    => 'slug',
														'terms'    => array( 'featured' ),
												)	
											)				
										);
				$query = new WP_Query( $args );
				global $post;
				if ( $query->have_posts() ) {
						while( $query->have_posts() ){
							$query->the_post();
							$author  = get_post_meta( $post->ID,'motocore_video_author', true );
							$vid_url = get_post_meta( $post->ID,'motocore_video_url', true );
							if( !empty( $author ) ){
								$author_name = $author;
							}else{
								$author_name = get_the_author();
							}
							$result .='<div class="item">
								<div class="mt_popular_video_wrapper">
									<div class="mt_video_img">
										<iframe src="'.esc_url($vid_url).'" frameborder="0" allowfullscreen></iframe>
										<a href="'.get_the_permalink().'" class="video_play_btn"><i class="fa fa-play" aria-hidden="true"></i></a>
									</div>
									<div class="mt_video_detail_wrapper">
										<h3 class="mt_video_title"><a href="#">'.get_the_title().'</a></h3>
										<h4 class="mt_meta_tag"><span class="video_authore">'.esc_html__('By: ','moto').''.esc_html($author_name).'</span><span class="video_date">'.get_the_date().'</span><span class="video_comment">'.get_comments_number().''.esc_html__(' Comments', 'moto').'</span></h4>
										<p>'.get_the_excerpt().'</p>
										<a href="#" class="btn-default btn">'.esc_html('read more','moto').'</a>
									</div>
								</div>
							</div>';
							
						}
				}
/* Restore original Post Data */
wp_reset_postdata();
				}else{
				$args = array( 'post_type' => 'video', 'posts_per_page' => esc_attr($video_no) );
				$query = new WP_Query( $args );
				global $post;
				if ( $query->have_posts() ) {
						while( $query->have_posts() ){
							$query->the_post();
							$author  = get_post_meta( $post->ID,'motocore_video_author', true );
							$vid_url = get_post_meta( $post->ID,'motocore_video_url', true );
							if( !empty( $author ) ){
								$author_name = $author;
							}else{
								$author_name = get_the_author();
							}

					$result .='<div class="item">
									<div class="mt_popular_video_wrapper">
										<div class="mt_video_img">
											<iframe src="'.esc_url($vid_url).'" frameborder="0" allowfullscreen></iframe>
											<a href="'.get_the_permalink().'" class="video_play_btn"><i class="fa fa-play" aria-hidden="true"></i></a>
										</div>
										<div class="mt_video_detail_wrapper">
											<h3 class="mt_video_title"><a href="#">'.get_the_title().'</a></h3>
											<h4 class="mt_meta_tag"><span class="video_authore">'.esc_html__('By: ','moto').''.esc_html($author_name).'</span><span class="video_date">'.get_the_date().'</span><span class="video_comment">'.get_comments_number().''.esc_html__(' Comments', 'moto').'</span></h4>
										</div>
									</div>	
							   </div>';
							  }
						}
/* Restore original Post Data */
wp_reset_postdata();					
				}
				$result .='</div>
			</div>
		</div>
	</div>
</div>';
	return $result; 
}
/********MAilchimp Start*********/
add_shortcode( 'moto_video_short', 'moto_video_short_shortcode' );
function moto_video_short_shortcode($atts,$content = null){
	extract( shortcode_atts( array(
	'cat_list' => 'All',	
	'video_no' => ''	
	), $atts ) );
	$result = $video_cat = '';
	if(empty($video_no)){
		$video_no = -1;
	}
	if( $cat_list != 'All' ){
		$video_cat =  array(
						array(
							'taxonomy' => 'video_categories',
							'field'    => 'name',
							'terms'    =>  array( $cat_list ), 
								)	
							);
	}
	$result .='<div class="mt_video_section"><div class="row">';
				$args = array( 'post_type' => 'video',
							   'posts_per_page' => esc_attr($video_no),
							   'tax_query' => 	$video_cat
							);
				$query = new WP_Query( $args );
				global $post;
				if ( $query->have_posts() ) {
						while( $query->have_posts() ){
							$query->the_post();
							$author  = get_post_meta( $post->ID,'motocore_video_author', true );
							$vid_url = get_post_meta( $post->ID,'motocore_video_url', true );
							if( !empty( $author ) ){
								$author_name = $author;
							}else{
								$author_name = get_the_author();
							}
		
			$result .='<div class="col-lg-4 col-md-4 col-sm-6">
							<div class="mt_port_video_wrapper">
								<iframe src="'.esc_url($vid_url).'" frameborder="0" allowfullscreen></iframe>
								<a href="'.get_the_permalink().'" class="video_play_btn"><i class="fa fa-play" aria-hidden="true"></i></a>
								<div class="mt_video_detail_wrapper">
									<h3 class="mt_video_title"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
									<h4 class="mt_meta_tag"><span class="video_authore">'.esc_html__('By: ','moto').''.esc_html($author_name).'</span><span class="video_date">'.get_the_date().'</span><span class="video_comment"><i class="fa fa-comment" aria-hidden="true"></i>'.get_comments_number( 'no responses', 'one response', '% responses' ).''.esc_html__(' Comments', 'moto').'</span></h4>
								</div>
							</div>
					  </div>';
					}
				}
/* Restore original Post Data */
wp_reset_postdata();				
		$result .='</div></div>';
	return $result; 
}
/******** What we provide *********/
add_shortcode('moto_wwp','moto_wwp_shortcode_function');
function moto_wwp_shortcode_function( $atts, $content = null ){
	extract( shortcode_atts( array(
		'title' => '',
		'ppw_des' => '',
		'image' => ''
	), $atts ) );
	$result = $src = '';
	$src = wp_get_attachment_image_src($image,'full');
	$result .= '<div class="mt_showcase_service_wrapper">
	<div class="container">
		<div class="row">
			<div class="col-lg-5 col-md-5">
				<div class="mt_showcase_product_img">
					<img src="'.esc_url($src[0]).'" alt="moto">
				</div>
			</div>
			<div class="col-lg-7 col-md-7">
				<div class="mt_showcase_service">
					<h2>'.esc_html($title).'</h2>
					<p>'.esc_html(base64_decode($ppw_des)).'</p>
					';
					$result .= '<ul>'.do_shortcode($content).'</ul>';	
					
				$result .= '</div>
			</div>
		</div>
	</div>
</div>';
	
	return $result;
}
add_shortcode('moto_single_wwp','moto_single_wwp_shortcode_function');
function moto_single_wwp_shortcode_function( $atts, $content = null ){
	extract( shortcode_atts( array(
		'head' => '',
		'description' => '',
		'icon' => ''
	), $atts ) );
	$result = '';
	$result .= '<li><span><i class="'.esc_attr($icon).'" aria-hidden="true"></i></span>
							<div class="showcase_service">
								<h4>'.esc_html($head).'</h4>
								<p>'.esc_html(base64_decode($description)).'</p>
							</div>
						</li>';
	return $result;
}
/*** OUR LATEST PROJECTS ****/
add_shortcode('our_latest_projects','our_latest_projects_function');
function our_latest_projects_function( $atts, $content = null ){
	extract( shortcode_atts( array(
		'title' => '',
		'desc' => '',
		'button' => '',
		'btn_link' => ''
	), $atts ) );
	$result = '';	
	$result .= '<div class="mt_showcase_project_section">
	<div class="container">
		<div class="row">
			<div class="col-lg-10 col-md-10 col-lg-offset-1 col-md-offset-1">
				<div class="col-lg-6 col-md-6 padding_0">
					<div class="mt_showcase_project_text">
						<h2>'.esc_html($title).'</h2>
						<p>'.esc_html(base64_decode($desc)).'</p>
						<a href="'.esc_url($btn_link).'" class="btn btn-default">'.esc_html($button).'</a>
					</div>
				</div>
				<div class="col-lg-6 col-md-6 padding_0">
					<div class="showcase_project_slider">';
						$result .= do_shortcode($content);	
					$result .='</div>
				</div>
			</div>
		</div>
	</div>
</div>';
	
	return $result;
}
add_shortcode('moto_single_project','moto_single_project_function');
function moto_single_project_function( $atts, $content = null ){
	extract( shortcode_atts( array(
		'upload_project' => '',
		'project_link' => ''
	), $atts ) );
	$result = '';
	$src = wp_get_attachment_image_src($upload_project,'full');
	$result .= '<div class="showcase_project">
									<a href="'.esc_url($project_link).'"><img src="'.esc_url($src[0]).'" alt=""></a>
								</div>	';
	
	return $result;
}

// MOTO Sales Funnel
add_shortcode('moto_sales_funnel','moto_sales_funnel_function');
function moto_sales_funnel_function( $atts, $content = null ){
	extract( shortcode_atts( array(
		'title' => '',
		'subtitle' => '',
		'back_img' => '',
		'hd_color' => '',
		'ft_color' => '',
	), $atts ) );
	$result = '';
	$src = wp_get_attachment_image_src($back_img,'full');
	$result .= '<div class="mt_jv_funnel_section" style="background-image: url('.esc_url($src[0]).')">
	<div class="mt_overlay mt_opacity"></div>
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12">
				<div class="mt_jv_funnel_content">
					<h2 style="color:'.esc_attr($hd_color).'">'.esc_html($title).'</h2>
					<h4 style="color:'.esc_attr($ft_color).'">'.esc_html($subtitle).'</h4>
				</div>
			</div>
			'.do_shortcode($content).' 
		</div>
	</div>
</div>';	
	return $result;
}
add_shortcode('single_funnel','single_funnel_function');
function single_funnel_function( $atts, $content = null ){
	extract( shortcode_atts( array(
		'title' => '',
		'price' => '',
		'desc' => '',
	), $atts ) );
	$result = '';
	$result .= '<div class="col-lg-3 col-md-3 col-sm-6">
				<div class="mt_funnel">
					<div class="mt_funnel_wrapper">
						<h4>'.esc_html($title).'</h4>
						<h5>'.esc_html($price).'</h5>
						<p>'.base64_decode(esc_html($desc)).'</p>
					</div>
				</div>
			</div>';	
	return $result; 
}
// MOTO JV Slogan
add_shortcode('moto_jv_slogan','moto_jv_slogan_function');
function moto_jv_slogan_function( $atts ){
	extract( shortcode_atts( array(
		'slogan' => '',
		'slogan_image' => ''
	), $atts ) );
	$result = $src = '';
	$src = wp_get_attachment_image_src($slogan_image,'full');
	$result .= '<div class="mt_jv_slogan" style="">
			<div class="container">
				<div class="row">
					<div class="col-lg-12 col-md-12">
						<img src="'.esc_attr($src[0]).'" alt="moto">
						<p>'.base64_decode(esc_html($slogan)).'</p>
					</div>
				</div>
			</div>
		</div>';	
	return $result; 
}
// MOTO JV Prizes
add_shortcode('moto_jv_prizes','moto_jv_prizes_function');
function moto_jv_prizes_function( $atts, $content = null ){
	extract( shortcode_atts( array(
		'title' => '',
		'title_tag' => '',
		'price_img' => '',
		'background_style' => '',
		'back_img' => '',
		'overlay' => '',
		'overlay_color' => '',
		'color' => '',
	), $atts ) );
	$result = '';
	if( !empty( $title_tag ) ){
		$htag = $title_tag;
	}else{
		$htag = 'h3';
	}
	if( $background_style == 'image' ){
		$back_img = wp_get_attachment_image_src($back_img,'full');
		$result .= '<div class="mt_jv_prize_section" style="background-image:url('.esc_url($back_img[0]).')">';
		if( $overlay == 'yes' && !empty($overlay_color) ){
			$overlaycolor = $overlay_color;
		}else{
			$overlaycolor = '';
		}
	}else{
		$result .= '<div class="mt_jv_prize_section" style="background-color:'.esc_attr($color).';">';
	}
	
	if( $overlay == 'yes' ){
		$result .= '<div class="mt_overlay mt_opacity" style="background-color:'.esc_attr($overlaycolor).'"></div>';
	}
	
	$price_img = wp_get_attachment_image_src($price_img,'full');
	
	
	$result .= '<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12">
			<div class="row no-margin text-center"><hr><'.esc_attr($htag).' class="invo_heading mt_jv_heading">'.esc_attr($title).'</'.esc_attr($htag).'></div>
			</div>
			<div class="col-lg-6 col-md-6">
				<div class="mt_jv_prize_img">
					<img src="'.esc_url($price_img[0]).'" alt="">
				</div>
			</div>
			<div class="col-lg-6 col-md-6">
				<div class="mt_jv_prize_detail">
					'.do_shortcode($content).'
				</div>
			</div>
		</div>
	</div>
</div>';	
	return $result; 
}
add_shortcode('single_prize','single_prize_function');
function single_prize_function( $atts ){
	extract( shortcode_atts( array(
		'title' => '',
		'title_tag' => '',
		'subtitle' => ''
	), $atts ) );
	$result = '';
	if( !empty( $title_tag ) ){
		$htag = $title_tag;
	}else{
		$htag = 'h5';
	}
	$result .= '<div class="mt_jv_prize">
						<span class="prize_icon"><i class="fa fa-check" aria-hidden="true"></i></span><'.esc_attr($htag).' class="mt_jv_price_text">'.esc_html($title).'<span>'.esc_html($subtitle).'</span></'.esc_attr($htag).'>
					</div>';	
	return $result; 
}
// MOTO Expert Profile
add_shortcode('moto_expert_profile','moto_expert_profile_function');
function moto_expert_profile_function( $atts ){
	extract( shortcode_atts( array(
		'title' => '',
		'expert_img' => '',
		'name' => '',
		'fb_url' => '',
		'skype_id' => '',
	), $atts ) );
	$result = '';
	$src = wp_get_attachment_image_src($expert_img, 'full');
	$result .= '<div class="mt_support_section">
	<div class="container">
		<div class="row">
			<div class="col-lg-10 col-md-10 col-lg-offset-1 col-md-offset-1">
				<div class="mt_support_wrapper">
					<h2>'.esc_html($title).'</h2>
					<div class="mt_support">
						<div class="mt_support_img">
							<img src="'.esc_url($src[0]).'" alt="">
						</div>
						<div class="mt_support_detail">
							<h2>'.esc_html($name).'</h2>
							<p><span><i class="fa fa-facebook" aria-hidden="true"></i></span>: '.esc_url($fb_url).'</p>
							<p><span><i class="fa fa-skype" aria-hidden="true"></i></span>: '.esc_html($skype_id).'</p>
						</div>
					</div>
				</div>
			</div>
		</div> 
	</div>
</div>';	
	return $result; 
}
// MOTO Revolution Slider
add_shortcode('moto_revolution_slider','moto_rev_slider_function');
function moto_rev_slider_function( $atts ){
	extract( shortcode_atts( array(
		'rv_sliders' => '',
	), $atts ) );
	$result = '';
	$result = do_shortcode('[rev_slider alias="'.esc_attr($rv_sliders).'"]');
	return $result;
}
// MOTO Progressbars
add_shortcode('moto_progressbar','moto_progressbar_function'); 
function moto_progressbar_function($atts, $content){
	extract( shortcode_atts( array(
		'progressbar_style' => ''
	), $atts ) );
	$result = '';
	$result .= '<input type="hidden" class="progress_style" value="'.esc_attr($progressbar_style).'"><div class="mt_progress_bar '.esc_attr($progressbar_style).'">'.do_shortcode($content).'</div>';
	
	return $result;
}

// MOTO Progressbars Children
add_shortcode('moto_progressbar_item','moto_progressbar_item_function'); 
function moto_progressbar_item_function($atts){
	extract( shortcode_atts( array(
		'label' => '',
		'value' => '',
		'bg_color' => '',
		'enable_tooltip' => '',
	), $atts ) );
	$result = '';
	if( $enable_tooltip == 'yes' ){
		$cls = 'tooltip_bar';
	}else{ $cls = ''; }
	if( !isset($bg_color) ){
		$bg_color = '#ffc925';
	}
	$result .= '<div class="progress_wrapper">
					    <h5 class="progess_label">'.esc_html($label).'</h5>
						<div class="progress colored_progress '.esc_attr($cls).'">
						  <div class="progress-bar" role="progressbar" aria-valuenow="'.esc_attr($value).'" aria-valuemin="0" aria-valuemax="100" style="background-color:'.esc_attr($bg_color).';width: '.esc_attr($value).'%" >
							<span>'.esc_attr($value).'%</span>
						  </div>
						</div>
					</div>';
	
	return $result;
}

// MOTO Products With Slider
add_shortcode('products_with_slider','moto_products_with_slider_function'); 
function moto_products_with_slider_function($atts){
	extract( shortcode_atts( array(
		'per_page' => '',
		'pro_cat' => '',
		'order' => ''
	), $atts ) );
	ob_start();
?>
				<div class="woocommerce mt_woo_product_wrapper">
				    <div class="container">
						<div class="row">
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
								<div class="mt_wooproduct">
									<div class="owl-carousel owl-theme">
<?php									
$args = array( 'post_type' => 'product', 'posts_per_page' => $per_page, 'product_cat' => $pro_cat,  'order' => $order );
$loop = new WP_Query( $args );		
		if(  $loop->have_posts() ):
			while( $loop->have_posts() ): $loop->the_post(); ?>
					<div class="item">
						<div class="product moto_product">
							<div class="mt_product_wrapper">
								<div class="product-holder">
									<?php do_action('woocommerce_before_shop_loop_item_title');	?>
									<div class="overlay">
										<a href="<?php echo  wp_get_attachment_url( get_post_thumbnail_id(), 'full' ); ?>" data-rel="prettyPhoto"><i class="fa fa-plus"></i></a><a href="<?php the_permalink(); ?>"><i class="fa fa-eye" aria-hidden="true"></i></a>
									</div>
								</div>
								<?php
								do_action( 'woocommerce_shop_loop_item_title' );
								do_action( 'woocommerce_after_shop_loop_item_title' );
								do_action( 'woocommerce_after_shop_loop_item' );
								?>
							</div>
						</div>
					</div>
				<?php	
					endwhile;
					wp_reset_postdata();
				endif;
	?>				
	</div></div></div></div></div></div>		
<?php
	return ob_get_clean();
}

add_shortcode('moto_Profile_slider','moto_Profile_slider_function'); 
function moto_Profile_slider_function($atts){
	extract( shortcode_atts( array(
		'title' => '',
		'testimonials' => '',
		'slide_align' => 'center'
	), $atts ) );
	
	$results = '';
	
	$slides = json_decode( base64_decode( $testimonials ) );
	
	$results .= '<div class="mt_skew_slider_wrapper text-'.$slide_align.'">';
		$results .= '<div class="skew_overlay"></div>';
			$results .= '<div class="mt_skew_content_wrapper">';
				$results .= '<h3 class="skew_heading">'.$title.'</h3>';
					$results .= '<div class="mt_skew_slider">';
						$results .= '<div class="owl-carousel owl-theme">';
						
						if(!empty($slides)){
							foreach($slides as $slide){
								$src = '';
								$attachment_url = wp_get_attachment_image_src( $slide->testi_pic_3, 'full' );
								if( isset($attachment_url[0]) && !empty($attachment_url[0]) )
									$src = moto_resize( $attachment_url[0], 80, 60, true );
								$results .= '<div class="item">';
									$results .= '<div class="mt_skew_content">';
										$results .= '<span class="skew_img">';
											$results .= '<img src="'.$src.'" alt="">';
										$results .= '</span>';
										$results .= '<h5 class="skew_sub_title">'.$slide->designation.'</h5>';
										$results .= '<h4 class="skew_main_title">'.$slide->name.'</h4>';
										$results .= '<p>'.base64_decode( $slide->description ).'</p>';
										if(!empty($slide->btn_txt)){
										  $results .= '<a href="'.$slide->btn_url.'" class="btn skew_btn btn-default" target="_blank">'.$slide->btn_txt.'</a>';
										} 
									$results .= '</div>';
								$results .= '</div>';
							}
						}
						
				$results .= '</div>';
			$results .= '</div>';
		$results .= '</div>';
	$results .= '</div>';
			
	return $results;
}

/**
 *Moto Bgvideo Section
 */
add_shortcode('moto_bgvideo_section_shortcode','moto_bgvideo_section'); 
function moto_bgvideo_section($atts){
	extract( shortcode_atts( array(
		'videourl' => '',
		'title' => '',
		'subtitle' => '',
		'description' => '',
		'buttontext' => '',
		'buttonurl' => '',
		'title_color' => '#ffc925',
		'subtitle_color' => 'rgba(255, 255, 255, 0.88)',
	), $atts ) );
$results = '';
$results .='<div class="mt_bgvideo_section">';
          if(!empty($videourl)){
	         $results .='<video autoplay="" loop="">
		            <source src="'.esc_url($videourl).'" type="video/mp4">
	           </video>';
			} 
$results .='<div class="mt_opacity mt_overlay"></div>
	         <div class="container">
		       <div class="row">
			     <div class="col-md-12">
				  <div class="video_overlay">';
				  if(!empty($title)){
					$results .= '<h1 class="mt_video_heading" style="color:'.$title_color.'">'.esc_html($title).'</h1>';
				  }
				  if(!empty($subtitle)){
					$results .= '<h3 class="mt_video_subheading" style="color:'.$subtitle_color.'">'.esc_html($subtitle).'</h3>';
				   }
			    if(!empty($description)){
			      $results .= '<p>'.base64_decode($description).'</p>';
			    }
			   if(!empty($buttontext)){
			      $results .= '<a href="'.esc_url($buttonurl).'" class="btn btn-default">'.esc_html($buttontext).'</a>';
			   }
	$results .= '</div>
			</div>
		</div>
	</div>
</div>';
return $results;
}