<?php
/**
 * The template for displaying comments.
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package moto
 */
/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<div id="comments" class="comments-area">
<div class="row comments">
	<?php // You can start editing here -- including this comment! ?>
	<?php if ( have_comments() ) : ?>
		<hr>
		<h4>
			<?php
				printf( // WPCS: XSS OK.
					esc_html( _nx( 'ONE COMMENT', '%1$s COMMENTS', get_comments_number(), 'comments title', 'moto' ) ),
					number_format_i18n( get_comments_number() )
				);
			?>
		</h4>
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
		<nav id="comment-nav-above" class="navigation comment-navigation" role="navigation">
			<h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'moto' ); ?></h2>
			<div class="nav-links">
				<div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments', 'moto' ) ); ?></div>
				<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments', 'moto' ) ); ?></div>
			</div><!-- .nav-links -->
		</nav><!-- #comment-nav-above -->
		<?php endif; // Check for comment navigation. ?>
		<?php
			wp_list_comments( array(
				'style'      => 'div',
				'short_ping' => true,
				'reply_text' => '<i class="fa fa-reply"></i> Reply',
				'callback'   => 'moto_custom_comments',
			) );
		?>
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
		<nav id="comment-nav-below" class="navigation comment-navigation" role="navigation">
			<h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'moto' ); ?></h2>
			<div class="nav-links">
				<div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments', 'moto' ) ); ?></div>
				<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments', 'moto' ) ); ?></div>
			</div><!-- .nav-links -->
		</nav><!-- #comment-nav-below -->
		<?php endif; // Check for comment navigation. ?>
	<?php endif; // Check for have_comments(). ?>
	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'moto' ); ?></p>
	<?php endif; ?>
	<?php 
	$commenter = wp_get_current_commenter();
	$aria_req = ( $req ? " aria-required='true'" : '' );
	if(is_user_logged_in()){
		$textarea = '<div class="row"><div class="col-md-12"><textarea rows="7" class="form-control default" name="comment" placeholder="'.esc_html__('MESSAGE','moto').'"></textarea></div></div>';
	}else{
		$textarea = '<div class="col-md-6 left_spacer"><textarea rows="7" class="form-control default" name="comment" placeholder="'.esc_html__('MESSAGE','moto').'"></textarea></div>';
	}
	$fields =  array(
		'author' => '<div class="col-md-6 right_spacer"><input type="text" class="form-control default" name="author" placeholder="'.esc_html__('NAME','moto').'" value="' . esc_attr( $commenter['comment_author'] ).'" ' . $aria_req .'  />',
		'email'  => '<input type="text" class="form-control default" value="' . esc_attr( $commenter['comment_author_email'] ).'" ' . $aria_req .' placeholder="'.esc_html__('EMAIL','moto').'" name="email" />',
		'subject'  => '<input type="text" id="url" name="url" class="form-control default" value="' . esc_attr( $commenter['comment_author_url'] ).'" placeholder="'.esc_html__('Website','moto').'" name="subject" /></div>',
	);
	$comments_args = array(
		'fields' =>  $fields, 
		'id_form' => 'moto_comment_form',
		 'title_reply'=> esc_html__('Post a Comment','moto'),
		'comment_notes_after' => '',
		'comment_notes_before'=>'',
		'label_submit'=> esc_html__('POST COMMENT','moto'),
		'comment_field'  => $textarea,
	);
	comment_form($comments_args);
	?>
</div><!-- #comments -->
</div>