<?php
/**
 * moto functions and definitions
 *
 * @package moto
 */
if ( ! function_exists( 'moto_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function moto_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on moto, use a find and replace
	 * to change 'moto' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'moto', get_template_directory() . '/languages' );
	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );
	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );
	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );
	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'MOTO Main Menu', 'moto' ),
		'pre_header' => esc_html__( 'Preheader Menu(You have to enable Preheader from MOTO Options panel to view this menu.)', 'moto' )
	) );
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
	) );
	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'moto_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
	add_theme_support( 'woocommerce' );
	
	global $pagenow;
	if ( is_admin() && 'themes.php' == $pagenow && isset( $_GET['activated'] ) ) {
		wp_redirect(admin_url("options-general.php?page=moto-system-status")); // Your admin page URL
		exit();
	}
	
}
endif; // moto_setup
add_action( 'after_setup_theme', 'moto_setup' );
/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function moto_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'moto_content_width', 640 );
}
add_action( 'after_setup_theme', 'moto_content_width', 0 );
/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function moto_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'moto' ),
		'id'            => 'sidebar-1',		
		'description'   => esc_html__( 'Defualt Sidebar', 'moto' ),
		'before_widget' => '<div id="%1$s" class="row no-margin widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<hr><h4>',
		'after_title'   => '</h4>',
	) ); 
	register_sidebar( array( 
		'name'          => esc_html__( 'Shop Sidebar', 'moto' ),
		'id'            => 'shopsidebar',		
		'description'   => esc_html__( 'Shop Sidebar Show Only Shop pages', 'moto' ),
		'before_widget' => '<div id="%1$s" class="row no-margin widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<hr><h4>',
		'after_title'   => '</h4>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Sidebar - 1', 'moto' ),
		'id'            => 'footer-1',		
		'description'   => esc_html__( 'Footer Sidebar - 1', 'moto' ),
		'before_widget' => '<div class="col-md-3 col-sm-6 text-left">',
		'after_widget'  => '</div>',
		'before_title'  => '<hr><h4>',
		'after_title'   => '</h4>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Sidebar - 2', 'moto' ),
		'id'            => 'footer-2',		
		'description'   => esc_html__( 'Footer Sidebar - 2', 'moto' ),
		'before_widget' => '<div class="col-md-3 col-sm-6 text-left"><div class="mt_footer_content">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<hr><h4>',
		'after_title'   => '</h4>',
	) );
}
add_action( 'widgets_init', 'moto_widgets_init' );
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/function/custom-header.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/function/template-tags.php';
/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/function/extras.php';
/**
 * Customizer additions.
 */
require get_template_directory() . '/function/customizer.php';
/**
 * Load Jetpack compatibility file. 
 */ 
require get_template_directory() . '/function/jetpack.php';

require_once get_template_directory() . '/include/aq_resizer.php';
require_once get_template_directory() . '/include/moto-sys-req.php';
require_once get_template_directory() . '/include/moto-enqueue.php';
require_once get_template_directory() . '/include/moto-functions.php';
require_once get_template_directory() . '/include/theme_plugin/plugin-activate-config.php';
require_once get_template_directory() . '/include/wordpress-reset.php';