<?php
/**
 * Enqueue scripts and styles.
 */
function moto_scripts() {
	/*** Css ***/
	global $redux_moto;
	$color = $redux_moto['moto_theme_color'];
	$version = $redux_moto['moto_theme_version'];
	if( isset($redux_moto['moto_google_map_api']) && !empty($redux_moto['moto_google_map_api']) ){
		$key = $redux_moto['moto_google_map_api'];
	}else{
		$key = '&sensor=false';
	}

	wp_enqueue_style('moto-mCustomScrollbar', get_template_directory_uri() . '/css/jquery.mCustomScrollbar.css', array(), '1', 'all');
	wp_enqueue_style('moto-combined', get_template_directory_uri() . '/css/combined.css', array(), '1', 'all');
	wp_enqueue_style('moto-style', get_stylesheet_uri(), array(), '1', 'all');
	
		
	if ( is_rtl() ) {
		wp_enqueue_style('moto-rtl', get_template_directory_uri() . '/rtl.css', array(), '1', 'all');
	}
	

	/*****color*****/	
	switch( $color ){
		case 'orange':
			wp_enqueue_style('moto-orange', get_template_directory_uri() . '/css/color/orange.css', array(), '1', 'all');
		break;
		case 'blue':
			wp_enqueue_style('moto-blue', get_template_directory_uri() . '/css/color/blue.css', array(), '1', 'all');
		break;
		case 'green':
			wp_enqueue_style('moto-green', get_template_directory_uri() . '/css/color/green.css', array(), '1', 'all');
		break;
		case 'turquoise':
			wp_enqueue_style('moto-turquoise', get_template_directory_uri() . '/css/color/turquoise.css', array(), '1', 'all');
		break;
		case 'pink':
			wp_enqueue_style('moto-pink', get_template_directory_uri() . '/css/color/pink.css', array(), '1', 'all');
		break;
		case 'purple':
			wp_enqueue_style('moto-purple', get_template_directory_uri() . '/css/color/purple.css', array(), '1', 'all');
		break;
		case 'lightblue':
			wp_enqueue_style('moto-lightblue', get_template_directory_uri() . '/css/color/lightblue.css', array(), '1', 'all');
		break;
		case 'red':
			wp_enqueue_style('moto-red', get_template_directory_uri() . '/css/color/red.css', array(), '1', 'all');
		break;
		case 'dark_red':
			wp_enqueue_style('moto-dark-red', get_template_directory_uri() . '/css/color/dark-red.css', array(), '1', 'all');
		break;
		case 'red_stone':
			wp_enqueue_style('moto-red-stone', get_template_directory_uri() . '/css/color/red-stone.css', array(), '1', 'all');
		break;
		case 'spring_rain':
			wp_enqueue_style('moto-spring-rain', get_template_directory_uri() . '/css/color/spring_rain.css', array(), '1', 'all');
		break;
		case 'dark_green':
			wp_enqueue_style('moto-dark-green', get_template_directory_uri() . '/css/color/dark_green.css', array(), '1', 'all');
		break;
		case 'dark_blue':
			wp_enqueue_style('moto-dark-blue', get_template_directory_uri() . '/css/color/dark_blue.css', array(), '1', 'all');
		break;
		case 'bronze':
			wp_enqueue_style('moto-bronze', get_template_directory_uri() . '/css/color/bronze.css', array(), '1', 'all');
		break;
	}
	
	if($version =='version2'){
		wp_enqueue_style('moto-version-2', get_template_directory_uri() . '/css/version/style_version2.css', array(), '1', 'all');
	}
	wp_enqueue_style('moto-colorchange','#'); 
	
	/*** Js ***/
	
	wp_enqueue_script('moto_jquery_bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'),null,true);
	wp_enqueue_script('moto_jquery_images_loaded', get_template_directory_uri() . '/js/images-loaded.js', array('jquery'),null,true); 
	wp_enqueue_script('moto_jquery_isotope', get_template_directory_uri() . '/js/isotope.js', array('jquery'),null,true);
	wp_enqueue_script('moto_appear', get_template_directory_uri() . '/js/appear.js', array('jquery'),null,true); 
	wp_enqueue_script('moto_countTo', get_template_directory_uri() . '/js/jquery.countTo.js', array('jquery'),null,true);
	wp_enqueue_script('moto_jquery_count', get_template_directory_uri() . '/js/jquery.count.js', array('jquery'),null,true); 
	wp_enqueue_script('moto_jquery_prettyPhoto', get_template_directory_uri() . '/js/jquery.prettyPhoto.js', array('jquery'),null,true);
	wp_enqueue_script('moto_parallax', get_template_directory_uri() . '/js/jquery.stellar.js', array('jquery'),null,true);
	wp_enqueue_script('moto_mapjuery', '//maps.googleapis.com/maps/api/js?key='.esc_attr($key).'', array('jquery'));
	wp_enqueue_script('jquery-ui-selectable');
	wp_enqueue_script('moto_jquery_validation', get_template_directory_uri() . '/js/validation.js', array('jquery'),null,true);
	wp_enqueue_script('moto_jquery_owl_carousel', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'),null,true);	
	wp_enqueue_script('moto_jquery_bx_slider', get_template_directory_uri() . '/js/jquery.bxslider.min.js', array('jquery'),null,true);	
	wp_enqueue_script('moto_jquery_selectboxit', get_template_directory_uri() . '/js/select/jquery.selectBoxIt.min.js', array('jquery'),null,true); 
    wp_enqueue_script('moto_jquery_mCustomScrollbar', get_template_directory_uri() . '/js/jquery.mCustomScrollbar.concat.min.js', array('jquery'),null,true);  	
	wp_enqueue_script('moto_switcher-js', get_template_directory_uri() . '/js/switcher.js', array('jquery'),null,true);
	wp_enqueue_script( 'moto-navigation', get_template_directory_uri() . '/js/themejs/navigation.js', array(), '20120206', true );
	wp_enqueue_script( 'moto-skip-link-focus-fix', get_template_directory_uri() . '/js/themejs/skip-link-focus-fix.js', array(), '20130115', true );
	wp_enqueue_script('moto_jquery_main', get_template_directory_uri() . '/js/main.js', array('jquery','moto_jquery_selectboxit'),null,true);
	wp_localize_script( 'moto_jquery_main', 'ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) ); 
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'moto_scripts' );