<?php
/*Add Css to the main menu*/
add_action('wp_head','hook_menu_css');
function hook_menu_css() {

global $redux_moto;
$back_switch = $backg_color = '';
if(isset($redux_moto['moto_menu_back_switch'])){
	$back_switch = $redux_moto['moto_menu_back_switch'];
}
if( isset($redux_moto['sticky_hdback'] ) ){
	$backg_color = $redux_moto['sticky_hdback']['rgba'];
	}
?>
<style>
<?php
if($back_switch == 1){
?>
#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-item > a.mega-menu-link, .mt_custom_info ul li, .nav-right-info ul li a, .mt_welcome_msg p, .mt_right a, .mt_right b{
	color: #fff!important;
} 
.moto_middle_header, .navbar-default{
	background-color:transparent;
}
<?php } ?>
.mt_fixed{
	background-color: <?php echo esc_attr($backg_color); ?>!important;
}
<?php
if( isset($redux_moto['widget_head_color'] ) ){
	$wd_head_color = $redux_moto['widget_head_color']; ?>
	.mt_footer_content h4,.mt_footer_content h5,.mt_footer_content h6,.light_footer h4,.light_footer .mt_footer_content h5{
		color: <?php echo esc_html($wd_head_color); ?>!important;
	}
<?php	
}
if( isset($redux_moto['widget_font_color'] ) ){
	$wd_font_color = $redux_moto['widget_font_color']; ?>
	.mt_footer_content p,.mt_footer_content i,.mt_footer_content ul li,.mt_footer_content span,footer .contact-info h5.accent {
		color: <?php echo esc_html($wd_font_color); ?>!important;
	}
	footer.light_footer #moto_contactform .form-control{
		border-color: <?php echo esc_html($wd_font_color); ?>!important;
		color: <?php echo esc_html($wd_font_color); ?>!important;
	}
<?php	
}
if( isset($redux_moto['moto_typographybodytext']) ){
	$font_family = $redux_moto['moto_typographybodytext']['font-family']; ?>
	ul li, .portfolio-container .item .overlay .description h4,h1.alt, h2.alt, h3.alt, h4.alt, h5.alt, h6.alt,#moto_contactform a,#mega-menu-wrap-primary #mega-menu-primary > li.mega-menu-item > a.mega-menu-link,.moto_left_links ul li a {
    font-family: <?php echo $font_family; ?> !important;
}
<?php	
}
?>

</style>
<?php
	}


/* send mail */
add_action( 'wp_ajax_moto_sndadminmail', 'moto_sndadminmail' );
add_action( 'wp_ajax_nopriv_moto_sndadminmail', 'moto_sndadminmail' );
function moto_sndadminmail(){
	global $redux_moto;
	$message = '';  
	$to = $redux_moto['moto_contactemailaddrs'];
	$from = $redux_moto['moto_fromaddrs'];
	if(isset($_POST['name'])){
		$nm = $_POST['name'];
		$message .= "NAME : ".$_POST['name']."\n";
	}
	if(isset($_POST['email'])){
		$email = $_POST['email'];
		$message .= "EMAIL : ".$_POST['email']."\n";
	}
	if(isset($_POST['phono'])){
		$phone = $_POST['phono'];
		$message .= "NUMBER : ".$_POST['phono']."\n";
	}
	if(isset($_POST['subject'])){ 
		$subject = $_POST['subject'];
		$message .= "SUBJECT : ".$_POST['subject']."\n";
	}
	if(isset($_POST['Message'])){
		$meg = $_POST['Message'];
		$message .= "MESSAGE : ".$_POST['Message'];
	}
	$message .= "\n\n";
	$header = "From: ".esc_attr($from)."\r\n"; 
	$header.= "MIME-Version: 1.0\r\n"; 
	$header.= "Content-Type: text/plain; charset=utf-8\r\n"; 
	$header.= "X-Priority: 1\r\n"; 
	$sub = $redux_moto['moto_mailsubject'];
	if(mail($to,$sub,$message,$header)){
		$meg = $redux_moto['moto_successmessage'];
	}
	else{
		$meg = "Sorry. your mail has not been send successfully."; 
	}
	echo esc_attr($meg);
	die();
}
/* Comment Function */
add_action( 'comment_form_after', 'moto_form_after' );
if(!function_exists('moto_form_after')){
function moto_form_after() {
    $html = ob_get_clean();
    echo preg_replace('/<h3 id="reply-title"(.*)>(.*)<\/h3>/','<hr><h4 id="reply-title"\1>\2</h4>',$html );
    }
}
/*replace reply link*/
add_filter('comment_reply_link', 'moto_replace_reply_link_class', 420, 4);
if(!function_exists('moto_replace_reply_link_class')){
function moto_replace_reply_link_class($link, $args, $comment, $post){
	return str_replace("class='comment-reply-link", "class='btn btn-default btn-reply pull-right", $link);
 }
}
/* moto custom comments*/
if(!function_exists('moto_custom_comments')){
	function moto_custom_comments( $comment, $args, $depth ){
		$GLOBALS['comment'] = $comment;
		extract($args, EXTR_SKIP);
		if ( 'div' == $args['style'] ) {
			$tag = 'div';
			$add_below = 'comment';
		}else{
			$tag = 'li';
			$add_below = 'div-comment';
		}
		$cls = 'row comment';
		if( $depth != 1 )
			$cls .= ' nested';
		echo "<".esc_attr($tag)." "; comment_class( $cls );  echo " id='comment-";comment_ID();echo "' >";
		if ( 'div' != $args['style'] ) : 
			echo '<div id="div-comment-';comment_ID(); echo '">';
		endif;
		echo get_avatar($comment,$size='80');
		echo '<div class="content">';
		$then = strtotime($comment->comment_date); 
		$now = time();
		$difference = $now - $then;
		//Convert seconds into days.
		$days = floor($difference / (60*60*24) );
		if($days < 1){
			$days = floor($difference / 60 );
			$days .= ' minutes';
		}
		echo '<h5 class="alt no-transform">'.esc_attr($comment->comment_author).' - <span class="accent">posted on '.get_comment_date().' '.get_comment_time().'</span></h5>';
		
		if ( $comment->comment_approved != '0' ) { comment_text(); }else{ echo '<p>';  esc_html_e( 'Your comment is awaiting moderation.','moto' ); echo '</p>'; }
		comment_reply_link( array_merge( $args, array(  'add_below' => $add_below,'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) );
		echo '</div>';
		if ( 'div' != $args['style'] ) :
			echo '</div>';
		endif;
	}
}
/* custom css */ 
add_action('wp_head','moto_option_customcss');
if(!function_exists('moto_option_customcss')){
	function moto_option_customcss(){
		global $redux_moto;
		if(isset($redux_moto['moto_customcss'])){
		$css = $redux_moto['moto_customcss'];
		}
		if(!empty($css)) {
		echo "<!-- Custom CSS -->\n<style type=\"text/css\">\n" . $css . "\n</style>";
		} 
	}
}
/* search form */ 
if(!function_exists('moto_search_form')){
	function moto_search_form( $form ) {
		$form = '<form class="search-form" method="get" action="' .esc_url(home_url( '/' )) . '" >
			<div class="search-box">
				<input type="text" value="'.get_search_query().'" class="form-control search" placeholder="'.esc_html__('search for something','moto').'" name="s"/>
				<button type="submit" class="widget_search_btn search-submit sidebar_search_btn"><i class="fa fa-search" aria-hidden="true"></i></button>
			</div>
          </form>';
		return $form;
	} 
}
add_filter( 'get_search_form', 'moto_search_form' );
/* moto custom search form */
if(!function_exists('moto_custom_search_form')){
	function moto_custom_search_form( ) {
		$form = '<form id="moto-search" class="search-form" method="get" action="' .esc_url(home_url( '/' )) . '" >
				<input type="text" value="'.get_search_query().'" placeholder="'.esc_html__('Search for something','moto').'" name="s"/>
				<a href="javascript:;" class="close"><i class="fa fa-times"></i></a>
          </form>';
		return $form;
	}
}
//Custom Searchbox for Shop page
add_filter( 'get_product_search_form' , 'moto_custom_product_searchform' );
function moto_custom_product_searchform( $form ) {
	
	$form = '<form class="search-form" role="search" method="get" id="searchform" action="' . esc_url( home_url( '/'  ) ) . '">
				<div class="search-box">
					<label class="screen-reader-text" for="s">' . __( 'Search for:', 'woocommerce' ) . '</label>
					<input class="form-control search" type="text" value="' . get_search_query() . '" name="s" id="s" placeholder="' . __( 'search products', 'woocommerce' ) . '" />
					<button type="submit" id="searchsubmit" class="widget_search_btn search-submit sidebar_search_btn"><i class="fa fa-search" aria-hidden="true"></i></button>
					<input type="hidden" name="post_type" value="product" />
				</div>
			</form>';
	
	return $form;
	
}
/* get sidebar position */
if(!function_exists('moto_get_sidebar_position')){
	function moto_get_sidebar_position(){
		global $post;
		if(is_page()){
			$position = get_post_meta($post->ID, 'motocore_page_sidebarposition', true);
		}elseif(is_single()){
			$position = get_post_meta($post->ID, 'motocore_post_sidebarposition', true);
			if(empty($position)){
				$position = get_post_meta($post->ID, 'motocore_portfolio_sidebarposition', true);	
			}
			if(empty($position)){
				$position = get_post_meta($post->ID, 'motocore_product_sidebarposition', true);
			}
			if(empty($position)){
				$position = get_post_meta($post->ID, 'motocore_video_sidebarposition', true); 
			}
		}elseif(class_exists( 'WooCommerce' ) && is_shop()){ 
			$page_id = get_option( 'woocommerce_shop_page_id' );
			$position = get_post_meta($page_id, 'motocore_page_sidebarposition', true);
			
		}else{ 
			global $redux_moto;
			if(isset($redux_moto['moto_sidebarposition'])){
				if(is_archive()){
					$position = $redux_moto['moto_archive_sidebarposition'];
				}elseif(is_search()){
					$position = $redux_moto['moto_search_sidebarposition'];
				}elseif(!empty($redux_moto['moto_sidebarposition'])){
					$position = $redux_moto['moto_sidebarposition'];
				}
			} 
		} 
		if(empty($position)){
			$position = 'right';
		}
		return $position;
	}
}
/* set feature image */
if(!function_exists('moto_set_feature_image')){
	function moto_set_feature_image($id, $class = 'blog-header', $w = null, $h = null){
		$thumb = get_post_thumbnail_id($id);
		$attachment_url = wp_get_attachment_url($thumb, 'full');
		if(empty($w) && empty($h)){
			return '<img src="'.esc_url($attachment_url).'" class="'.esc_attr($class).'" alt="">';
		}else{
			$src = moto_resize($attachment_url,$w,$h);
			return '<img src="'.esc_url($src).'" class="'.esc_attr($class).'" alt="">';
		}
	}
}
/* Social */
if(!function_exists('moto_social')){
	function moto_social(){
		global $redux_moto; 
		$result = $vim = $rss = $fb = $twt = $link = $fkr = $yt = $dr = $gp = $sky = $pin = $social = '';
		if(isset($redux_moto['moto_facebookurl']))
			$fb = $redux_moto['moto_facebookurl'];
		if(isset($redux_moto['moto_twitterurl']))
			$twt = $redux_moto['moto_twitterurl'];
		if(isset($redux_moto['moto_linkedinurl']))
			$link = $redux_moto['moto_linkedinurl'];
		if(isset($redux_moto['moto_flickrurl']))
			$fkr = $redux_moto['moto_flickrurl'];
		if(isset($redux_moto['moto_youtubeurl']))
			$yt = $redux_moto['moto_youtubeurl'];
		if(isset($redux_moto['moto_dribbleurl']))
			$dr = $redux_moto['moto_dribbleurl'];
		if(isset($redux_moto['moto_gpurl']))
			$gp = $redux_moto['moto_gpurl'];
		if(isset($redux_moto['moto_skypeurl']))
			$sky = $redux_moto['moto_skypeurl'];
		if(isset($redux_moto['moto_pinteresturl']))
			$pin = $redux_moto['moto_pinteresturl'];
		if(isset($redux_moto['moto_instagram']))
			$insta = $redux_moto['moto_instagram'];
		if(isset($redux_moto['moto_vimeourl']))
			$vim = $redux_moto['moto_vimeourl'];
		if(isset($redux_moto['moto_displaysocial']))
			$social = $redux_moto['moto_displaysocial'];
		if(!empty($social)){
			$result .= '<ul class="social text-center inv_ul_margin">';
			foreach($social['SHOW'] as $v){
				if($v == 'Vimeo'){
				$result .= '<li><a class="vimeo_bg" href="'.esc_url($vim).'" target="_blank"><i class="fa fa-vimeo-square"></i></a></li>';
				} 
				if($v == 'Skype'){ 
				$result .= '<li><a class="skype_bg" href="skype:'.esc_attr($sky).'?call" target="_blank"><i class="fa fa-skype"></i></a></li>';
				}
				if($v == 'Dribbble'){ 
				$result .= '<li><a class="dribbble_bg" href="'.esc_url($dr).'" target="_blank"><i class="fa fa-dribbble"></i></a></li>';
				} 
				if($v == 'Youtube'){ 
				$result .= '<li><a class="youtube_bg" href="'.esc_url($yt).'" target="_blank"><i class="fa fa-youtube"></i></a></li>';
				 } 
				if($v == 'Twitter'){ 
				$result .= '<li><a class="twitter_bg" href="'.esc_url($twt).'" target="_blank"><i class="fa fa-twitter"></i></a></li>';
				}
				if($v == 'Facebook'){
				$result .= '<li><a class="facebook_bg" href="'.esc_url($fb).'" target="_blank"><i class="fa fa-facebook"></i></a></li>';
				} 
				if($v == 'Linkedin'){ 
				$result .= '<li><a class="linkedin_bg" href="'.esc_url($link).'" target="_blank"><i class="fa fa-linkedin-square"></i></a></li>';
				} 
				if($v == 'Flickr'){ 
				$result .= '<li><a class="flickr_bg" href="'.esc_url($fkr).'" target="_blank"><i class="fa fa-flickr"></i></a></li>';
				}
				if($v == 'Google Plus'){ 
				$result .= '<li><a class="gplus_bg" href="'.esc_url($gp).'" target="_blank"><i class="fa fa-google-plus"></i></a></li>';
				}
				if($v == 'Pinterest'){ 
				$result .= '<li><a class="pinterest_bg" href="'.esc_url($pin).'" target="_blank"><i class="fa fa-pinterest"></i></a></li>';
				}
				if($v == 'Instagram'){ 
				$result .= '<li><a class="instagram_bg" href="'.esc_url($insta).'" target="_blank"><i class="fa fa-instagram"></i></a></li>';
				}
			}
			$result .= '</ul>';
		}
		return $result;
	}
}
/* WooCommerce */
add_action( 'init', 'moto_remove_wc_breadcrumbs' );
function moto_remove_wc_breadcrumbs() {
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
}
remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 ); 
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );

remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title',10);
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
add_action( 'woocommerce_shop_loop_item_title', 'lms_woo_product_title',10);
if ( ! function_exists( 'lms_woo_product_title' ) ){ 
function lms_woo_product_title(){ ?>
<h5 class="no-transform mt_product_title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
	<?php 
}
}
/****************limited content start*************************/
if ( ! function_exists( 'moto_excerpt' ) ){
    function moto_excerpt( $count=80 ) {
     global $post;
   $excerpt = $post->post_excerpt;
   $excerpt = strip_tags($excerpt);
   $excerpt = substr($excerpt, 0, $count);
   $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
   echo esc_attr($excerpt);
    }
}
/****************WooCommerce Sidebar*************************/
if ( ! function_exists( 'moto_woo_sidebar' ) ){
    function moto_woo_sidebar() {
    echo '<div class="col-md-4"><div class="sidebar">';
		   if ( ! dynamic_sidebar( 'shopsidebar' ) ) : endif; 
	echo '</div></div>';
   }
}

/****************Loader*************************/
if ( ! function_exists( 'moto_loader_fun' ) ){
   function moto_loader_fun() {
	global $redux_moto;
	if(isset($redux_moto['moto_loader']) && $redux_moto['moto_loader']){
		 
		if( isset( $redux_moto['moto_loader_img'] ) && !empty( $redux_moto['moto_loader_img']['url'] ) ){
			$loder_img = $redux_moto['moto_loader_img']['url'];
		}else{
			$loder_img = get_template_directory_uri() . '/images/Loader (1).gif';
		}
	?>
	
	<div id="preloader_wrapper">
		<div id="preloader_box">
			<img src="<?php echo $loder_img; ?>" alt="">
			<p>Loading...</p>
		</div>
	</div>
	

<?php }     
   }
}
/********WooCommerce  mini cart ***********/
if ( ! function_exists( 'moto_minicart' ) ){
function moto_minicart(){ 
$redux_moto = moto_redux_variables();
$count = WC()->cart->cart_contents_count;
$head_style ='';
$head_style = $redux_moto['header-style'];
if($head_style == 4){
	$amount = floatval( preg_replace( '#[^\d.]#', '', WC()->cart->get_cart_total() ) );
	$currency_sign = get_woocommerce_currency_symbol();
	$head_style = '<a id="mt_cart_count" href="#" data-toggle="dropdown"><i class="fa fa-shopping-cart"></i><span class="mt_count"> '.esc_html($count).'</span></a>';
}else{
	$head_style = '<a id="mt_cart_count" href="#" data-toggle="dropdown" class="mt_cart"><i class="fa fa-shopping-bag" aria-hidden="true"></i><span class="mt_count"> '.esc_html($count).'</span></a>';
}
?>
		<?php echo $head_style; ?>
		<ul class="dropdown-menu dropdown-shop mt_shop_cart animated fadeInDown" role="menu" id="moto_mini_cart">
			 <?php if ( sizeof ( WC ()->cart->get_cart () ) > 0 ) { 
					foreach ( WC ()->cart->get_cart () as $cart_item_key => $cart_item ) { 
						$_product = apply_filters ( 'woocommerce_cart_item_product', $cart_item[ 'data' ], $cart_item, $cart_item_key );
						$product_id = apply_filters ( 'woocommerce_cart_item_product_id', $cart_item[ 'product_id' ], $cart_item, $cart_item_key );
						if ( $_product && $_product->exists () && $cart_item[ 'quantity' ] > 0 && apply_filters ( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
							$product_name = apply_filters ( 'woocommerce_cart_item_name', $_product->get_title (), $cart_item, $cart_item_key );
							;
							$product_price = apply_filters ( 'woocommerce_cart_item_price', WC ()->cart->get_product_price ( $_product ), $cart_item, $cart_item_key );	
							$product = new WC_Product( $product_id );  ?>
								<li><a href="#"><?php echo apply_filters ( 'woocommerce_cart_item_thumbnail', $_product->get_image ( array( 60, 60 ) ), $cart_item, $cart_item_key ); ?></a>
								<?php echo apply_filters ( 'woocommerce_cart_item_remove_link', sprintf ( '<a href="%s" class="pull-right close" title="%s">X</a>', esc_url ( WC ()->cart->get_remove_url ( $cart_item_key ) ), esc_html__( 'Remove this item', 'moto' ) ), $cart_item_key ); ?>
								<div class="desc">
									<h6 class="alt heading"><a href="<?php echo esc_url ( $_product->get_permalink ( $cart_item ) ); ?>"><?php echo esc_html($product_name); ?></a></h6>
									<h6 class="alt accent price"><span><?php echo esc_html($cart_item[ 'quantity' ]); ?> x </span><?php echo esc_html($product->price); ?><sup><?php echo get_woocommerce_currency_symbol(); ?></sup></h6>
								</div>
							</li>
					<?php }  } ?>
					<li>
					  <div class="row">
						<div class="col-sm-6 text-left"><a href="<?php echo esc_url(get_permalink ( get_option ( 'woocommerce_cart_page_id' ) )); ?>" class="btn btn-view-cart"><?php esc_html_e( "View Cart", 'moto' ) ?></a></div>
						<div class="col-sm-6"><span class="cart-price"><?php echo WC ()->cart->get_cart_subtotal (); ?></span></div>
					  </div>
					</li>
				<?php } else { ?>
				<li>
					<div class="row no-margin cart_empty">
					<div class="cart-total">
					<?php echo esc_html__( 'No products in the cart.', 'moto' ); ?>
					</div>
					</div>
				</li>
			<?php } ?>
	 </ul>
<?php }
}
/********WooCommerce  mini cart ajax load***********/
add_filter ( 'woocommerce_add_to_cart_fragments', 'moto_mini_cart_ajax_load' );
if ( ! function_exists( 'moto_mini_cart_ajax_load' ) ){
function moto_mini_cart_ajax_load($fragments){ 
ob_start();

$redux_moto = moto_redux_variables();
$count = WC()->cart->cart_contents_count;
$head_style ='';
$head_style = $redux_moto['header-style'];
if($head_style == 4){
	$amount = floatval( preg_replace( '#[^\d.]#', '', WC()->cart->get_cart_total() ) );
	$currency_sign = get_woocommerce_currency_symbol();
	$head_style = '<a id="mt_cart_count" href="#" data-toggle="dropdown"><i class="fa fa-shopping-cart"></i><span class="mt_count"> '.esc_html($count).'</span></a>';
}else{
	$head_style = '<a id="mt_cart_count" href="#" data-toggle="dropdown" class="mt_cart"><i class="fa fa-shopping-bag" aria-hidden="true"></i><span class="mt_count"> '.esc_html($count).'</span></a>';
}
$fragments['#mt_cart_count'] = ob_get_clean();
ob_start();
?>
		<?php echo $head_style; ?>
		<ul class="dropdown-menu dropdown-shop mt_shop_cart animated fadeInDown" role="menu" id="moto_mini_cart">
			 <?php if ( sizeof ( WC ()->cart->get_cart () ) > 0 ) { 
					foreach ( WC ()->cart->get_cart () as $cart_item_key => $cart_item ) { 
						$_product = apply_filters ( 'woocommerce_cart_item_product', $cart_item[ 'data' ], $cart_item, $cart_item_key );
						$product_id = apply_filters ( 'woocommerce_cart_item_product_id', $cart_item[ 'product_id' ], $cart_item, $cart_item_key );
						if ( $_product && $_product->exists () && $cart_item[ 'quantity' ] > 0 && apply_filters ( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
							$product_name = apply_filters ( 'woocommerce_cart_item_name', $_product->get_title (), $cart_item, $cart_item_key );
							;
							$product_price = apply_filters ( 'woocommerce_cart_item_price', WC ()->cart->get_product_price ( $_product ), $cart_item, $cart_item_key );	
							$product = new WC_Product( $product_id );  ?>
								<li><a href="#"><?php echo apply_filters ( 'woocommerce_cart_item_thumbnail', $_product->get_image ( array( 30, 30 ) ), $cart_item, $cart_item_key ); ?></a>
								<?php echo apply_filters ( 'woocommerce_cart_item_remove_link', sprintf ( '<a href="%s" class="pull-right close" title="%s">X</a>', esc_url ( WC ()->cart->get_remove_url ( $cart_item_key ) ), esc_html__( 'Remove this item', 'moto' ) ), $cart_item_key ); ?>
								<div class="desc">
									<h6 class="alt heading"><a href="<?php echo esc_url ( $_product->get_permalink ( $cart_item ) ); ?>"><?php echo esc_html($product_name); ?></a></h6>
									<h6 class="alt accent price"><span><?php echo esc_html($cart_item[ 'quantity' ]); ?> x </span><?php echo esc_html($product->price); ?><sup><?php echo get_woocommerce_currency_symbol(); ?></sup></h6>
								</div>
							</li>
					<?php }  } ?>
					<li>
					  <div class="row">
						<div class="col-sm-6 text-left"><a href="<?php echo esc_url(get_permalink ( get_option ( 'woocommerce_cart_page_id' ) )); ?>" class="btn btn-view-cart"><?php esc_html_e( "View Cart", 'moto' ) ?></a></div>
						<div class="col-sm-6"><span class="cart-price"><?php echo WC ()->cart->get_cart_subtotal (); ?></span></div>
					  </div>
					</li>
				<?php } else { ?>
				<li>
					<div class="row no-margin cart_empty">
					<div class="cart-total">
					<?php echo esc_html__( 'No products in the cart.', 'moto' ); ?>
					</div>
					</div>
				</li>
			<?php } ?>
	 </ul> 
<?php $fragments['#moto_mini_cart'] = ob_get_clean();
	return $fragments;
	}
}
/*********=============== add a menu ============*****************/
if(!function_exists('moto_menu_editor')){
	function moto_menu_editor($args){
		if ( ! current_user_can( 'manage_options' ) )
		{
			return;
		}
		// see wp-includes/nav-menu-template.php for available arguments
		extract( $args );
		$link = $link_before
			. '<a href="' .admin_url( 'nav-menus.php' ) . '">' . $before . 'Add a menu' . $after . '</a>'
			. $link_after;
		// We have a list
		if ( FALSE !== stripos( $items_wrap, '<ul' )
			or FALSE !== stripos( $items_wrap, '<ol' )
		)
		{
			$link = "<li>$link</li>";
		}
		$output = sprintf( $items_wrap, $menu_id, $menu_class, $link );
		if ( ! empty ( $container ) )
		{
			$output  = "<$container class='$container_class' id='$container_id'>$output</$container>";
		} 
		if ( $echo )
		{
			echo $output;
		}
		return $output;
	}
}
function moto_sort_by_page($count) {
  if (isset($_COOKIE['shop_pageResults'])) { // if normal page load with cookie
     $count = $_COOKIE['shop_pageResults'];
  }
  if (isset($_POST['woocommerce-sort-by-columns'])) { //if form submitted
    setcookie('shop_pageResults', $_POST['woocommerce-sort-by-columns'], time()+1209600, '/', false); //this will fail if any part of page has been output- hope this works!
    $count = $_POST['woocommerce-sort-by-columns'];
  }
  // else normal page load and no cookie
  return $count;
}
add_filter('loop_shop_per_page','moto_sort_by_page');
/*=============================woocommerce ordering=============*/
remove_action( 'woocommerce_before_shop_loop' , 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
add_action ( "woocommerce_before_shop_loop", "moto_woocommerce_before_shop_ordering", 9 );
function moto_woocommerce_before_shop_ordering(){  
	if(!woocommerce_products_will_display()) { return ; } ?> 
			 <?php woocommerce_catalog_ordering(); 
			 global $wp;
			$current_url = home_url(add_query_arg(array(),$wp->request));
			 ?>
				<form action="<?php echo esc_url($current_url); ?>" method="POST" name="results" class="woocommerce-ordering">  
					<select name="woocommerce-sort-by-columns" id="woocommerce-sort-by-columns" class="sortby" onchange="this.form.submit()">
					<?php
					//Get products on page reload
					$_COOKIE['shop_pageResults'] = '';
					if  (isset($_POST['woocommerce-sort-by-columns']) && (($_COOKIE['shop_pageResults'] <> $_POST['woocommerce-sort-by-columns']))) {
					  $numberOfProductsPerPage = $_POST['woocommerce-sort-by-columns'];
					  } else {
					$numberOfProductsPerPage = $_COOKIE['shop_pageResults'];
					  }
					  $product_perpage=array(4,8,16,32);
					//  This is where you can change the amounts per page that the user will use  feel free to change the numbers and text as you want, in my case we had 4 products per row so I chose to have multiples of four for the user to select.
						$shopCatalog_orderby = apply_filters('woocommerce_sortby_page',$product_perpage);
						foreach ( $shopCatalog_orderby as  $sort_name )
							echo '<option value="' . $sort_name . '" ' . selected( $numberOfProductsPerPage, $sort_name, true ) . ' >' . $sort_name .' '.'Items</option>';
					?>     
					</select>
				</form>
<?php
}
function moto_redux_variables(){
	global $redux_moto;
	return $redux_moto;
}
function moto_post_variables(){
	global $post;
	return $post;
}

function moto_removeDemoModeLink() { 
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
    }
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}
add_action('init', 'moto_removeDemoModeLink');

function custom_excerpt_length( $length ) {
	return 40;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

function moto_excerpt_more( $more ) {
    return '...';
}
add_filter( 'excerpt_more', 'moto_excerpt_more' );
/*
======================== Mailchimp Subscription ====================
*/
add_action('wp_ajax_moto_news_letter', 'moto_news_letter');
add_action('wp_ajax_nopriv_moto_news_letter', 'moto_news_letter');
	function moto_news_letter()
	{
	$api_key = $_POST['api_key'];
	$list_id = $_POST['list_id']; 
	require get_template_directory() . '/include/Mailchimp.php';
	$Mailchimp = new Mailchimp( $api_key );
	$Mailchimp_Lists = new Mailchimp_Lists( $Mailchimp );
	
	$subs_email = array( 'email' => htmlentities($_POST['email']) );
	$merge_vars = array( 'FNAME'=> $_POST['subscriber'] );
	$subscriber = $Mailchimp_Lists->subscribe( $list_id, $subs_email, $merge_vars );
		if ( ! empty( $subscriber['leid'] ) ) {
		   echo __('success','moto');
		}
		else
		{
			echo __('fail','moto');
		}
die();
}

if(!function_exists('moto_newsletter')){
	function moto_newsletter(){
	$redux_moto = moto_redux_variables();
	if( isset( $redux_moto['moto_newsletter'] ) && $redux_moto['moto_newsletter'] == 1 ){
		if(isset($redux_moto['moto_newsletter_style']) && $redux_moto['moto_newsletter_style'] == 1){
			echo '<div class="modal fade mt_popup4" id="popup_model4" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<div class="mt_popup4_innerdiv">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">X</button>';
							if(isset($redux_moto['moto_newsletter_title']) && !empty($redux_moto['moto_newsletter_title'])){	
								$title = $redux_moto['moto_newsletter_title'];
								echo '<h3>'.$title.'</h3>';
							}
							echo '<div class="mt_popup4_leftdiv">
								<div class="mt_popup4_img">';
								if(isset($redux_moto['moto_newsletter_image']['url']) && !empty($redux_moto['moto_newsletter_image']['url'])){	
									$imgsrc = moto_resize($redux_moto['moto_newsletter_image']['url'],'315','210',true);
								}else{
									$imgsrc = 'http://placehold.it/315X182';
								}
								echo '<img alt="" src="'.$imgsrc.'" class="img-responsive">';
								echo '</div>
							</div>
							<div class="mt_popup4_rightdiv">
								<div class="mt_popup4_content">';
								if(isset($redux_moto['moto_newsletter_desc']) && !empty($redux_moto['moto_newsletter_desc'])){	
									$desc = $redux_moto['moto_newsletter_desc'];
									echo '<p>'.$desc.'</p>';
								}
								echo '</div>
							</div>
							<div class="mt_divider"></div>';
							
							if(!empty($redux_moto['moto_newsletter_mailchimp_api']) && !empty($redux_moto['moto_newsletter_mailchimp_list'])){
							$api_key = $redux_moto['moto_newsletter_mailchimp_api'];
							$list_id = $redux_moto['moto_newsletter_mailchimp_list'];		
							echo '<div class="mt_popup4_form">
								<div class="form-inline">
									<input type="hidden" id="mailchimp_api" value='.esc_attr($api_key).'>
									<input type="hidden" id="mailchimp_list_id" value='.esc_attr($list_id).'> 
									<div class="form-group">
										<div class="input-group">
										<span class="input-group-addon"><i class="fa fa-envelope"></i></span>
										<input type="text" class="form-control mailchimp_email" placeholder=" Email"> 
										</div> 
									</div> 
									<div class="mt_popup4_btndiv">
										<button class="mt_subscribe_btn news_mailchimp_btn">';
											if(isset($redux_moto['moto_newsletter_btntext']) && !empty($redux_moto['moto_newsletter_btntext'])){
											$btntxt = $redux_moto['moto_newsletter_btntext'];
											echo $btntxt;
											}else{
												echo 'Subscribe';
											}
										echo '</button>
									</div>
									<div class="mailchimp_message"></div>
									<div class="mailchimp_error"></div>
								</div>
							</div>';
							}
						echo '</div>
					</div>
				</div>
			</div>
			</div>'; 
		}elseif(isset($redux_moto['moto_newsletter_style']) && $redux_moto['moto_newsletter_style'] == 2){
			echo '<div class="modal fade mt_popup5" id="popup_model5" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<div class="mt_popup5_innerdiv">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">X</button>';
							if(isset($redux_moto['moto_newsletter_bgimage']['url']) && !empty($redux_moto['moto_newsletter_bgimage']['url'])){	
									$imgsrc = moto_resize($redux_moto['moto_newsletter_bgimage']['url'],700,365,true);
								}else{
									$imgsrc = 'http://placehold.it/700X315';
								}
							echo '<div class="mt_popup5_banner" style="background-image: url('.$imgsrc.');">'; 
								echo '<div class="mt_popup5_overlay_content">';
									if(isset($redux_moto['moto_newsletter_title']) && !empty($redux_moto['moto_newsletter_title'])){	
										$title = $redux_moto['moto_newsletter_title'];
										echo '<h3>'.$title.'</h3>';
									} 
									if(isset($redux_moto['moto_newsletter_desc']) && !empty($redux_moto['moto_newsletter_desc'])){	
										$desc = $redux_moto['moto_newsletter_desc'];
										echo '<p>'.$desc.'</p>';
									}
								echo '</div>
							</div>';
							
							if(!empty($redux_moto['moto_newsletter_mailchimp_api']) && !empty($redux_moto['moto_newsletter_mailchimp_list'])){
							$api_key = $redux_moto['moto_newsletter_mailchimp_api'];
							$list_id = $redux_moto['moto_newsletter_mailchimp_list'];
							
							echo '<div class="mt_popup5_form">
								<div class="form-inline">
									<input type="hidden" id="mailchimp_api" value='.esc_attr($api_key).'>
									<input type="hidden" id="mailchimp_list_id" value='.esc_attr($list_id).'>
									<div class="form-group">
										<div class="input-group">
										<span class="input-group-addon"><i class="fa fa-envelope"></i></span>
										<input type="text" class="form-control mailchimp_email" placeholder="Enter Your Email"> 
										</div>
									</div>
									<div class="mt_popup5_btndiv">
										<button class="mt_subscribe_btn news_mailchimp_btn">';
										if(isset($redux_moto['moto_newsletter_btntext']) && !empty($redux_moto['moto_newsletter_btntext'])){
										$btntxt = $redux_moto['moto_newsletter_btntext'];
										echo $btntxt;
										}else{
										echo 'Subscribe';
										}
										echo '</button>
									</div>
									<div class="mailchimp_message"></div>
									<div class="mailchimp_error"></div>
								</div>
							</div>';
							}
						echo '</div>
					</div> 
				</div>
			</div>
			</div>';		
		}elseif(isset($redux_moto['moto_newsletter_style']) && $redux_moto['moto_newsletter_style'] == 3){
			echo '<div class="modal fade mt_popup6" id="popup_model6" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel">
					<div class="modal-dialog" role="document">';
					if(isset($redux_moto['moto_newsletter_bgimage']['url']) && !empty($redux_moto['moto_newsletter_bgimage']['url'])){	
						$imgsrc = moto_resize($redux_moto['moto_newsletter_bgimage']['url'],'870','450',true);
						}else{
							$imgsrc = 'http://placehold.it/870X415';
						} 
						echo '<div class="modal-content" style="background-image: url('.$imgsrc.');">
							<div class="modal-body">
								<div class="mt_popup6_innerdiv">
									<button type="button" class="close" data-dismiss="modal" aria-label="Close">X</button>
									<div class="mt_popup6_content">';
										if(isset($redux_moto['moto_newsletter_title']) && !empty($redux_moto['moto_newsletter_title'])){	
											$title = $redux_moto['moto_newsletter_title'];
											echo '<h3>'.$title.'</h3>';
										} 
										if(isset($redux_moto['moto_newsletter_desc']) && !empty($redux_moto['moto_newsletter_desc'])){	
												$desc = $redux_moto['moto_newsletter_desc'];
													echo '<p>'.$desc.'</p>';
												}
									echo '</div>'; 
									if(!empty($redux_moto['moto_newsletter_mailchimp_api']) && !empty($redux_moto['moto_newsletter_mailchimp_list'])){
										$api_key = $redux_moto['moto_newsletter_mailchimp_api'];
										$list_id = $redux_moto['moto_newsletter_mailchimp_list'];
									 
									echo '<div class="mt_popup6_form">
										<div class="form-inline">  
										<input type="hidden" id="mailchimp_api" value='.esc_attr($api_key).'>
										<input type="hidden" id="mailchimp_list_id" value='.esc_attr($list_id).'>
											<div class="form-group">
												<input type="text" class="form-control mailchimp_email" placeholder="Enter Your Email">
											</div>
											<div class="mt_popup6_btndiv">
												<button class="mt_subscribe_btn news_mailchimp_btn"><i class="fa fa-arrow-right"></i></button>
											</div>
											<div class="mailchimp_message"></div>
											<div class="mailchimp_error"></div>
										</div>
									</div>';
									
									}
									
								echo '</div>
							</div>
						</div>
					</div>
				</div>';
		}		
	} 
	}
}

// Woocommerce add to cart button text replace
add_filter( 'woocommerce_product_add_to_cart_text', 'woo_custom_cart_button_text' );    // 2.1 +
 
function woo_custom_cart_button_text() {
 
        return __( '', 'woocommerce' );
}	
/** Style Switcher **/
if(!function_exists('moto_style_switcher')){
	function moto_style_switcher(){
		echo '<input type="hidden" name="moto_template_url" value="'.get_template_directory_uri().'" />
				<div id="style-switcher">
			  <h2>Style Switcher <a href="#"><i class="fa fa-cogs" aria-hidden="true"></i></a></h2>
			  <div>
				<h3>Predefined Colors</h3>
					<ul class="colors" id="color1">
					  <li><a href="#" id="default" title="Default"><span></span></a></li>
					  <li><a href="#" id="blue" title="blue"><span></span></a></li>
					  <li><a href="#" id="dark-red" title="dark red"><span></span></a></li>
					  <li><a href="#" id="green" title="green"><span></span></a></li>
					  <li><a href="#" id="spring-rain" title="Spring Rain"><span></span></a></li>
					  <li><a href="#" id="lightblue" title="light blue"><span></span></a></li>
					  <li><a href="#" id="red-stone" title="red stone"><span></span></a></li>
					  <li><a href="#" id="orange" title="orange"><span></span></a></li>
					  <li><a href="#" id="pink" title="pink"><span></span></a></li>
					  <li><a href="#" id="purple" title="purple"><span></span></a></li>
					  <li><a href="#" id="red" title="red"><span></span></a></li>
					  <li><a href="#" id="turquoise" title="turquoise"><span></span></a></li>
					  <li><a href="#" id="dark_green" title="Dark Green"><span></span></a></li>
					  <li><a href="#" id="dark_blue" title="Dark Blue"><span></span></a></li>
					  <li><a href="#" id="bronze" title="Bronze Olive"><span></span></a></li>
					</ul>
			  </div>
			  <div id="reset">
				<button class="button btn-default color" value="Reload Page" onClick="window.location.reload();return false;">Reset</button>
			  </div>
			</div>';
	}
}

/**** Pre Header ****/
if(!function_exists('moto_preheader')){
	function moto_preheader(){
	$redux_moto = moto_redux_variables();	
	if( isset( $redux_moto['moto_preheader'] ) ){
		$pre_header = $redux_moto['moto_preheader'];
	}else{
		$pre_header = '';
	}
	if( isset( $redux_moto['moto_preheader_style'] ) ){
		$preheader_style = $redux_moto['moto_preheader_style'];
	}	
	if( isset( $redux_moto['moto_contactemailaddrs'] ) ){
		$email = $redux_moto['moto_contactemailaddrs'];
	}
	if( isset( $redux_moto['moto_contact_no'] ) ){
		$contact_no = $redux_moto['moto_contact_no'];
	}
	if( $pre_header == 1){
	echo '<div class="moto_top_header">
			<div class="container">
				<div class="row">';
		if( $preheader_style == 2 ){
			echo '<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
						<div class="moto_social_link pull-left">
							'.moto_social().'
						</div>
					</div>
					<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
						<div class="moto_right_links">
							<ul>
								<li><a href="mailto:'.esc_html($email).'"><i class="fa fa-envelope" aria-hidden="true"></i>'.esc_html($email).'</a></li>
								<li><a href="#"><i class="fa fa-phone" aria-hidden="true"></i>'.esc_html($contact_no).'</a></li>
							</ul>
						</div>
					</div>';
		}elseif( $preheader_style == 3 ){
			echo '<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
				<div class="moto_left_links">
					<ul>
						<li><a href="mailto:'.esc_html($email).'"><i class="fa fa-envelope" aria-hidden="true"></i>'.esc_html($email).'</a></li>
						<li><a href="#"><i class="fa fa-phone" aria-hidden="true"></i>'.esc_html($contact_no).'</a></li>
					</ul>
				</div>
			</div>
			<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
				<div class="moto_right_menu">';
					wp_nav_menu( array( 'theme_location'  => 'pre_header' )); 
		  echo '</div>
			</div>';
		}
		else{
			echo '<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
						<div class="moto_left_links">
							<ul>
								<li><a href="mailto:'.esc_html($email).'"><i class="fa fa-envelope" aria-hidden="true"></i>'.esc_html($email).'</a></li>
								<li><a href="tel:'.esc_html($contact_no).'"><i class="fa fa-phone" aria-hidden="true"></i>'.esc_html($contact_no).'</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
						<div class="moto_social_link">
							'.moto_social().'
						</div>
					</div>';
		}
		}
			echo '</div>
			</div>
	</div>';
	}
}

if ( !function_exists('moto_getpost_images') ){
function moto_getpost_images($post_id=null)
{
    global $post; 
    if ($post_id == null) 
    {
        $post_id = $post->ID;
    }

    $value = get_post_meta($post_id, 'miu_images', true);
    $images = unserialize($value);
    $result = array();
    if (!empty($images))
    {
        foreach ($images as $image)
        {
            $result[] = $image;
        }
    }
    return $result;
}
}


/**
 *Single Page Menu Filter
 */
function moto_menu_shrot(){
if ( !function_exists('moto_sort_sections') ){
	function moto_sort_sections(){
		if(!has_nav_menu('primary')){
			return;
		} 
		if ( ( $locations = get_nav_menu_locations()) && isset( $locations['primary'] )){
		$menu = wp_get_nav_menu_object( $locations['primary'] );
			if(!isset($menu->term_id)) return;
			$items  = wp_get_nav_menu_items($menu->term_id);
			$sections = array();
			foreach((array) $items as $key => $menu_items){
				if('page' == $menu_items->object){
					$sections[] = $menu_items->object_id;
				}
			} 
			return $sections;
		}
	}
  } 

/**
 * Navigation Related Functions
 */
add_filter('template_redirect', 'moto_page_section_redirect');
function moto_page_section_redirect(){
	global $wp;
	if(is_404()){
		if(isset($wp->query_vars["page"]) && !empty($wp->query_vars["name"])){
			wp_redirect(home_url('/#').$wp->query_vars["name"]);
		}
	}
}
add_filter( 'wp_nav_menu_objects', 'moto_single_page_nav_links' );
function moto_single_page_nav_links($items) {
	foreach ( $items as $item ) {
		if('page' == $item->object){
			$current_post = get_post($item->object_id); 
			$menu_title = "#moto-".$current_post->post_name;
				if(is_page_template('single-page-website.php')){
					$item->url = $menu_title;
				}else{
					if(is_single() || is_page() || is_category() || is_search() || is_tag() || is_404() || is_archive()){
						$item->url =  esc_url( home_url( '/' ) ).$menu_title;
					}
				}
		}elseif('custom' == $item->type && !is_home()){
			if( 1 === preg_match('/^#([^\/]+)$/', $item->url , $matches)){
			$item->url = esc_url( home_url( '/' ) ).$item->url;
			}
		}
	}
	return $items;   
} 
}