<?php
add_action('admin_menu', 'moto_admin_menu_page');
function moto_admin_menu_page(){
	add_submenu_page(
		'options-general.php', 
		esc_attr__( 'System Status', 'moto' ), 
		esc_attr__( 'System Status', 'moto' ), 
		'edit_theme_options', 
		'moto-system-status', 
		'moto_system_status_tab'
	);
}

function moto_system_status_tab(){
	$my_theme = wp_get_theme();
	$theme_version = $my_theme->get( 'Version' );
	?>
	<style>
		mark.error{
			color: red;
			background: none;
		}
		mark.yes{
			color: green;
			font-weight: 600;
			background: none;
		}
		.moto_main_heading{
			background: #fff;
			border: 1px solid #e5e5e5;
			-webkit-box-shadow: 0 1px 1px rgba(0,0,0,.04);
			box-shadow: 0 1px 1px rgba(0,0,0,.04);
			display: inline-block;
			width: 96%;
			padding: 15px;
			font-size: 25px;
			margin-top: 25px;
		}
		.moto_main_heading h3{
			float: left;
			margin: 0px;
			font-size: 20px;
		}
		.moto_main_heading .moto_version{
			float: right;
			font-size: 13px;
		}
	</style>
	<div class="moto_main_heading">
	<h3 class=""><?php esc_attr_e( 'Moto Versions', 'Moto' ); ?></h3>
	<span class="moto_version">Current Version: <?php echo $theme_version; ?></span>
	</div>
		<div class="half_width" style="width:48%;float:left;margin:25px 25px 25px 0px;">
			<table class="widefat" cellspacing="0">
			<thead>
				<tr>
					<th colspan="2" data-export-label="WordPress Environment"><?php esc_attr_e( 'WordPress Environment', 'Moto' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td data-export-label="Home URL"><?php esc_attr_e( 'Home URL:', 'Moto' ); ?></td>
					<td><?php echo esc_url_raw( home_url() ); ?></td>
				</tr>
				<tr>
					<td data-export-label="Site URL"><?php esc_attr_e( 'Site URL:', 'Moto' ); ?></td>
					<td><?php echo esc_url_raw( site_url() ); ?></td>
				</tr>
				<tr>
					<td data-export-label="WP Version"><?php esc_attr_e( 'WP Version:', 'Moto' ); ?></td>
					<td><?php bloginfo( 'version' ); ?></td>
				</tr>
				<tr>
					<td data-export-label="WP Multisite"><?php esc_attr_e( 'WP Multisite:', 'Moto' ); ?></td>
					<td><?php echo ( is_multisite() ) ? '&#10004;' : '&ndash;'; ?></td>
				</tr>
				<tr>
					<td data-export-label="PHP Memory Limit"><?php esc_attr_e( 'PHP Memory Limit:', 'Moto' ); ?></td>
					<td>
						<?php
						// Get the memory from PHP's configuration.
						$memory = ini_get( 'memory_limit' );
						// If we can't get it, fallback to WP_MEMORY_LIMIT.
						if ( ! $memory || -1 === $memory ) {
							$memory = wp_convert_hr_to_bytes( WP_MEMORY_LIMIT );
						}
						// Make sure the value is properly formatted in bytes.
						if ( ! is_numeric( $memory ) ) {
							$memory = wp_convert_hr_to_bytes( $memory );
						}
						?>
						<?php if ( $memory < 128000000 ) : ?>
							<mark class="error">
								<?php echo wp_kses_post( printf( __( '%1$s - We recommend setting memory to at least <strong>128MB</strong>. <br /> To import classic demo data, <strong>256MB</strong> of memory limit is required. <br /> Please define memory limit in <strong>wp-config.php</strong> file. To learn how, see: <a href="%2$s" target="_blank" rel="noopener noreferrer">Increasing memory allocated to PHP.</a>', 'Moto' ), esc_attr( size_format( $memory ) ), 'http://codex.wordpress.org/Editing_wp-config.php#Increasing_memory_allocated_to_PHP' ) ); ?>
							</mark>
						<?php else : ?>
							<mark class="yes">
								<?php echo esc_attr( size_format( $memory ) ); ?>
							</mark>
							<?php if ( $memory < 256000000 ) : ?>
								<br />
								<mark class="error">
									<?php printf( esc_attr__( 'Your current memory limit is sufficient, but if you need to import classic demo content, the required memory limit is %s', 'Moto' ), '<strong>256MB.</strong>' ); ?>
								</mark>
							<?php endif; ?>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<td data-export-label="WP Debug Mode"><?php esc_attr_e( 'WP Debug Mode:', 'Moto' ); ?></td>
				
					<td>
						<?php if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) : ?>
							<mark class="yes">Yes</mark>
						<?php else : ?>
							<mark class="no">No</mark>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<td data-export-label="Language"><?php esc_attr_e( 'Language:', 'Moto' ); ?></td>
					
					<td><?php echo esc_attr( get_locale() ) ?></td>
				</tr>
			</tbody>
		</table>
		</div>
		<div class="half_width" style="width:48%;float:left;margin:25px 0px 25px 0px;">
		<h3 class="screen-reader-text"><?php esc_attr_e( 'Server Environment', 'Moto' ); ?></h3>
		<table class="widefat" cellspacing="0">
			<thead>
				<tr>
					<th colspan="2" data-export-label="Server Environment"><?php esc_attr_e( 'Server Environment', 'Moto' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td data-export-label="Server Info"><?php esc_attr_e( 'Server Info:', 'Moto' ); ?></td>
					<td><?php echo isset( $_SERVER['SERVER_SOFTWARE'] ) ? esc_attr( sanitize_text_field( wp_unslash( $_SERVER['SERVER_SOFTWARE'] ) ) ) : esc_attr__( 'Unknown', 'Moto' ); ?></td>
				</tr>
				<tr>
					<td data-export-label="PHP Version"><?php esc_attr_e( 'PHP Version:', 'Moto' ); ?></td>
					<td>
						<?php
						$php_version = null;
						if ( defined( 'PHP_VERSION' ) ) {
							$php_version = PHP_VERSION;
						} elseif ( function_exists( 'phpversion' ) ) {
							$php_version = phpversion();
						}
						if ( null === $php_version ) {
							$message = esc_attr__( 'PHP Version could not be detected.', 'Moto' );
						} else {
							if ( version_compare( $php_version, '7.0.0' ) >= 0 ) {
								$message = $php_version;
							} else {
								$message = sprintf( esc_attr__( '%1$s. WordPress recomendation: 7.0.0 or above. See %2$s for details.', 'Moto' ), $php_version, '<a href="https://wordpress.org/about/requirements/" target="_blank">WordPress Requirements</a>' );
							}
						}
						echo wp_kses_post( $message );
						?>
					</td>
				</tr>
				<?php if ( function_exists( 'ini_get' ) ) : ?>
					<tr>
						<td data-export-label="PHP Post Max Size"><?php esc_attr_e( 'PHP Post Max Size:', 'Moto' ); ?></td>
						<td><?php echo esc_attr( size_format( wp_convert_hr_to_bytes( ini_get( 'post_max_size' ) ) ) ); ?></td>
					</tr>
					<tr>
						<td data-export-label="PHP Time Limit"><?php esc_attr_e( 'PHP Time Limit:', 'Moto' ); ?></td>
						<td>
							<?php
							$time_limit = ini_get( 'max_execution_time' );

							if ( 180 > $time_limit && 0 != $time_limit ) {
								echo wp_kses_post( '<mark class="error">' . sprintf( __( '%1$s - We recommend setting max execution time to at least 180. <br /> To import classic demo content, <strong>300</strong> seconds of max execution time is required.<br />See: <a href="%2$s" target="_blank" rel="noopener noreferrer">Increasing max execution to PHP</a>', 'Moto' ), $time_limit, 'http://codex.wordpress.org/Common_WordPress_Errors#Maximum_execution_time_exceeded' ) . '</mark>' );
							} else {
								echo '<mark class="yes">' . esc_attr( $time_limit ) . '</mark>';
								if ( 300 > $time_limit && 0 != $time_limit ) {
									echo wp_kses_post( '<br /><mark class="error">' . __( 'Current time limit is sufficient, but if you need import classic demo content, the required time is <strong>300</strong>.', 'Moto' ) . '</mark>' );
								}
							}
							?>
						</td>
					</tr>
					<tr>
						<td data-export-label="PHP Max Input Vars"><?php esc_attr_e( 'PHP Max Input Vars:', 'Moto' ); ?></td>
						<?php
						$registered_navs = get_nav_menu_locations();
						$menu_items_count = array(
							'0' => '0',
						);
						foreach ( $registered_navs as $handle => $registered_nav ) {
							$menu = wp_get_nav_menu_object( $registered_nav );
							if ( $menu ) {
								$menu_items_count[] = $menu->count;
							}
						}

						$max_items = max( $menu_items_count );
						$required_input_vars = $max_items * 20;
						/*if ( Moto()->settings->get( 'disable_megamenu' ) ) {
							$required_input_vars = $max_items * 20;
						} else {
							$required_input_vars = $max_items * 12;
						}*/
						?>
						<td>
							<?php
							$max_input_vars = ini_get( 'max_input_vars' );
							$required_input_vars = $required_input_vars + ( 500 + 1000 );
							// 1000 = theme options
							if ( $max_input_vars < $required_input_vars ) {
								echo wp_kses_post( '<mark class="error">' . sprintf( __( '%1$s - Recommended Value: %2$s.<br />Max input vars limitation will truncate POST data such as menus. See: <a href="%3$s" target="_blank" rel="noopener noreferrer">Increasing max input vars limit.</a>', 'Moto' ), $max_input_vars, '<strong>' . $required_input_vars . '</strong>', 'http://sevenspark.com/docs/ubermenu-3/faqs/menu-item-limit' ) . '</mark>' );
							} else {
								echo '<mark class="yes">' . esc_attr( $max_input_vars ) . '</mark>';
							}
							?>
						</td>
					</tr>
				<?php endif; ?>
				<tr>
					<td data-export-label="ZipArchive"><?php esc_attr_e( 'ZipArchive:', 'Moto' ); ?></td>
					
					<td><?php echo class_exists( 'ZipArchive' ) ? '<mark class="yes">&#10004;</mark>' : '<mark class="error">ZipArchive is not installed on your server, but is required if you need to import demo content.</mark>'; ?></td>
				</tr>
				<tr>
					<td data-export-label="MySQL Version"><?php esc_attr_e( 'MySQL Version:', 'Moto' ); ?></td>
					
					<td>
						<?php global $wpdb; ?>
						<?php echo esc_attr( $wpdb->db_version() ); ?>
					</td>
				</tr>
				<tr>
					<td data-export-label="Max Upload Size"><?php esc_attr_e( 'Max Upload Size:', 'Moto' ); ?></td>
					
					<td><?php echo esc_attr( size_format( wp_max_upload_size() ) ); ?></td>
				</tr>
				<tr>
					<td data-export-label="DOMDocument"><?php esc_attr_e( 'DOMDocument:', 'Moto' ); ?></td>
					
					<td><?php echo class_exists( 'DOMDocument' ) ? '<mark class="yes">&#10004;</mark>' : '<mark class="error">DOMDocument is not installed on your server, but is required if you need to use the Fusion Page Builder.</mark>'; ?></td>
				</tr>
				<tr>
					<td data-export-label="WP Remote Get"><?php esc_attr_e( 'WP Remote Get:', 'Moto' ); ?></td>
					
					<?php $response = wp_safe_remote_get( 'https://kamleshyadav.in/moto/moto.php', array(
						'moto_get' => true,
					) ); ?>
					<td><?php echo ( ! is_wp_error( $response ) && $response['response']['code'] >= 200 && $response['response']['code'] < 300 ) ? '<mark class="yes">&#10004;</mark>' : '<mark class="error">wp_remote_get() failed. Some theme features may not work. Please contact your hosting provider.</mark>'; ?></td>
				</tr>
				<tr>
					<td data-export-label="WP Remote Post"><?php esc_attr_e( 'WP Remote Post:', 'Moto' ); ?></td>
					
					<?php $response = wp_safe_remote_post( 'https://kamleshyadav.in/moto/moto.php', array(
						'moto_post' => true
					) ); ?>
					<td><?php echo ( ! is_wp_error( $response ) && $response['response']['code'] >= 200 && $response['response']['code'] < 300 ) ? '<mark class="yes">&#10004;</mark>' : '<mark class="error">wp_remote_post() failed. Some theme features may not work. Please contact your hosting provider.</mark>'; ?></td>
				</tr>
				<tr>
					<td data-export-label="GD Library"><?php esc_attr_e( 'GD Library:', 'Moto' ); ?></td>
					
					<td>
						<?php
						$info = esc_attr__( 'Not Installed', 'Moto' );
						if ( extension_loaded( 'gd' ) && function_exists( 'gd_info' ) ) {
							$info = esc_attr__( 'Installed', 'Moto' );
							$gd_info = gd_info();
							if ( isset( $gd_info['GD Version'] ) ) {
								$info = $gd_info['GD Version'];
							}
						}
						echo esc_attr( $info );
						?>
					</td>
				</tr>
			</tbody>
		</table>
		</div>

		
	<?php
}