<?php
/**
 * The template for displaying all single posts.
 *
 * @package moto
 */
get_header(); 
$position = moto_get_sidebar_position(); ?>
<div class="mt_single_vodeo_page">
	<div class="container">
	<div class="row">
	
	<?php if($position == 'full'){ ?><div class="col-lg-12 col-md-12"><?php } ?>
		<?php if($position == 'left') get_sidebar(); ?>
		<?php if($position != 'full'){ ?><div class="col-md-8"><?php } ?>
			<?php while ( have_posts() ) : the_post();
				$author  = get_post_meta( $post->ID,'motocore_video_author', true );
				$vid_url = get_post_meta( $post->ID,'motocore_video_url', true );
				if( !empty( $author ) ){
					$author_name = $author;
				}else{
					$author_name = get_the_author();
				}
				$cats = wp_get_post_terms($post->ID, 'video_categories', array("fields" => "names"));
				?>
				<div class="mt_single_video_wrapper">
					<div class="mt_single_video">
						<iframe src="<?php echo esc_attr($vid_url); ?>" frameborder="0" allowfullscreen=""></iframe>
					</div>
					<div class="mt_video_detail_wrapper">
						<h3 class="mt_video_title"><a href="#"><?php the_title(); ?></a></h3>
						<h4 class="mt_meta_tag"><span class="video_authore"><?php echo esc_html__('By: ','moto').''.esc_html($author_name);?></span><span class="video_date"><?php echo the_date(); ?></span><span class="video_comment"><?php echo get_comments_number().esc_html__(' Comments', 'moto');?></span><span><i class="fa fa-tags" aria-hidden="true"></i><?php
							foreach($cats as $cat)
							{
								echo '<a href="'.get_comments_link().'">'.$cat.', </a>';
							}	
						?></span></h4>
						<?php the_content(); ?>
					</div>
				</div>
				<?php
					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;
				?>
				<?php wp_reset_query(); ?>
			<?php endwhile; // End of the loop. ?>

<?php 
 
// get the custom post type's taxonomy terms
$related_vid = get_post_meta( $post->ID,'motocore_related_videos', true );
if(!empty($related_vid)){
$custom_taxterms = wp_get_object_terms( $post->ID, 'video_categories', array('fields' => 'ids') );
// arguments 
$args = array(
'post_type' => 'video',
'post_status' => 'publish',
'posts_per_page' => $related_vid, // you may edit this number
'orderby' => 'rand',
'tax_query' => array(
    array(
        'taxonomy' => 'video_categories',
        'field' => 'id',
        'terms' => $custom_taxterms
    )
),
'post__not_in' => array ($post->ID),
);
$related_items = new WP_Query( $args );
// loop over query
if ($related_items->have_posts()) : ?>
   <div class="related_project_wrapper">
			<div class="col-lg-12 col-md-12">
				<div class="row">
				<div class="related_projects">
					<div class="owl-carousel owl-theme">
<?php
while ( $related_items->have_posts() ) : $related_items->the_post();
$vid_url = get_post_meta( $post->ID,'motocore_video_url', true );
?>
						<div class="item">
							<div class="mt_latest_video_wrapper">
								<div class="mt_video_img">
									<iframe src="<?php echo esc_attr($vid_url); ?>" frameborder="0" allowfullscreen=""></iframe>	
									<a href="<?php the_permalink(); ?>" class="video_play_btn"><i class="fa fa-play" aria-hidden="true"></i></a>
								</div>
								<h3 class="mt_video_title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
							</div>
						</div>

<?php
endwhile; ?>
					</div>
				</div>
			</div>
		</div>
</div>
<?php
endif;
// Reset Post Data
wp_reset_postdata();
}
?>

		<?php if($position != 'full'){ ?></div><?php } ?>
		<?php if($position == 'right') get_sidebar(); ?>
	</div>
	<?php if($position == 'full'){ ?></div><?php } ?>
</div>
</div>

<?php get_footer(); ?>