<?php
/**
 * The template part for displaying results in search pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package moto
 */

?>

<div id="post-<?php the_ID(); ?>" <?php post_class('blog-post'); ?>>
	<?php the_title( '<h4 class="no-transform post_title"><a href="'.get_the_permalink().'">', '</a></h4>' ); ?>

	
	<div class="entry-thumb">
		<?php 
		$comments_count = wp_count_comments($post->ID);
		$count = $comments_count->approved;
		$categories = '';
			if(has_post_thumbnail($post->ID)){
				echo moto_set_feature_image($post->ID);
			}else{
			$images = moto_getpost_images($post_id = null);
			if( $images ){
			echo '<div class="owl-carousel owl-theme">';
			foreach( $images as $image ){
				echo '<div class="item">
						<img src="'.esc_url($image).'" class="blog-header" alt="">
					</div>';
				}
			echo '</div>';	
			}else{
				$video_quote = get_post_meta($post->ID,'motocore_postquote_video',true);
				if($video_quote == 'video'){
					$video = get_post_meta($post->ID,'motocore_url_youtube',true);
					echo '<div class="moto_video_iframe_wrapper"><iframe class="blog-header video" src="'.esc_url($video).'"></iframe></div>';
				}elseif($video_quote == 'quote'){
					$quote = get_post_meta($post->ID,'motocore_quote',true);
					echo '<a href="'.get_permalink($post->ID).'" class="blog-header quote text-center">'.$quote.'</a>';
				}
			}
			
		}
		?>	
	</div>

	
	<div class="entry-summary">
		<?php 
		$excerpt = strip_tags(get_the_excerpt());
        echo esc_attr($excerpt);
		
		?>
	</div><!-- .entry-summary -->
	
	<?php echo '<a href="'.esc_url( get_permalink() ).'" class="btn btn-default">'.esc_html__('Read More','moto').' <i class="fa fa-long-arrow-right"></i></a>'; ?>
</div><!-- #post-## -->

