<?php
/**
 * Template part for displaying single posts.
 *
 * @package moto
 */

$post = moto_post_variables();
$position = moto_get_sidebar_position(); ?>
<div id="post-<?php the_ID(); ?>" <?php post_class('row blog-post'); ?>>
<?php if($position == 'full') { ?>
<div class="invo_blog_centre">
<?php } ?>
	<?php 
	$comments_count = wp_count_comments($post->ID);
	$count = $comments_count->approved;
	$categories = '';  
		if(has_post_thumbnail($post->ID)){
			echo moto_set_feature_image($post->ID);
		}else{ 
			$images = moto_getpost_images($post_id = null);
			if( $images ){
			echo '<div class="owl-carousel owl-theme">';
			foreach( $images as $image ){
				echo '<div class="item">
						<img src="'.esc_url($image).'" alt="">
					</div>';
				}
			echo '</div>';	
			}else{
			$video_quote = get_post_meta($post->ID,'motocore_postquote_video',true);
			if($video_quote == 'video'){
				$video = get_post_meta($post->ID,'motocore_url_youtube',true);
				echo '<div class="moto_video_iframe_wrapper"><iframe class="blog-header video" src="'.esc_url($video).'"></iframe></div>';
			}elseif($video_quote == 'quote'){ 
				$quote = get_post_meta($post->ID,'motocore_quote',true);
				echo '<a href="'.get_permalink($post->ID).'" class="blog-header quote text-center">'.$quote.'</a>';
			}
		}
	}
		
		the_title( '<h4 class="no-transform post_title">', '</h4>' ); 

		echo '<h6 class="muted mt_post_info">
					<span class="post_admin"><i class="fa fa-user" aria-hidden="true"></i><a href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'">' . esc_attr(get_the_author()) .'</a>'. '</a></span>
					<span class="post_comment"><i class="fa fa-comment" aria-hidden="true"></i><a href="'.get_the_permalink().'">'. esc_attr($count);
					if( $count == 1 ){
						echo esc_html__(' Comment ','moto');
					}else{
						echo esc_html__(' Comments ','moto');
					}
					echo '</a></span>
					<span class="post_comment"><i class="fa fa-clock-o" aria-hidden="true"></i>';
						if ( 'post' == get_post_type() ) : 
								moto_posted_on(); 
						endif;
					echo '</span>
					<span class="post_category"><i class="fa fa-folder-open" aria-hidden="true"></i>';
						$categories_list = get_the_category();
						if(!empty($categories_list)){
							foreach($categories_list as $cat){
								echo '<a href="'.esc_url(get_category_link($cat->cat_ID)).'">'. esc_html($cat->cat_name).' </a>';
							}
						}
					echo '</span>
				</h6>';		
		
		the_content();

		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'moto' ),
			'after'  => '</div>',
		) );
		
		moto_entry_footer();
	?>
	<?php if($position == 'full') { ?>
</div>
<?php } ?>
</div>