<?php
/**
 * Template part for displaying posts.
 *
 * @package moto
 */
$post = moto_post_variables();
$redux_moto = moto_redux_variables();
?>
<div id="post-<?php the_ID(); ?>" <?php post_class('blog-post'); ?>>
	<?php
		$comments_count = wp_count_comments($post->ID);
		$count = $comments_count->approved;
		$categories = '';
		if(has_post_thumbnail($post->ID)){
			echo moto_set_feature_image($post->ID);
		}else{
			$images = moto_getpost_images($post_id = null);
			if( $images ){
			echo '<div class="owl-carousel owl-theme">'; 
			foreach( $images as $image ){
				echo '<div class="item">
						<img src="'.esc_url($image).'" class="blog-header" alt="">
					</div>';
				}
			echo '</div>';	
			}else{
				$video_quote = get_post_meta($post->ID,'motocore_postquote_video',true);
				if($video_quote == 'video'){
					$video = get_post_meta($post->ID,'motocore_url_youtube',true);
					echo '<div class="moto_video_iframe_wrapper"><iframe class="blog-header video" src="'.esc_url($video).'"></iframe></div>';
				}elseif($video_quote == 'quote'){
					$quote = get_post_meta($post->ID,'motocore_quote',true);
					echo '<a href="'.get_permalink($post->ID).'" class="blog-header quote text-center">'.$quote.'</a>';
				}
			}
			
		}
		
		echo '<h4 class="no-transform post_title"><a href="'.esc_url(get_permalink($post->ID)).'">'.get_the_title($post->ID).'</a></h4>';
		
		echo '<h6 class="muted mt_post_info">
					<span class="post_admin"><i class="fa fa-user" aria-hidden="true"></i><a href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'">' . esc_attr(get_the_author()) .'</a>'. '</a></span>
					<span class="post_comment"><i class="fa fa-comment" aria-hidden="true"></i><a href="'.get_the_permalink().'">'. esc_attr($count);
					if( $count == 1 ){
						echo esc_html__(' Comment ','moto');
					}else{
						echo esc_html__(' Comments ','moto');
					}
					echo '</a></span>
					<span class="post_comment"><i class="fa fa-clock-o" aria-hidden="true"></i>';
						if ( 'post' == get_post_type() ) : 
								moto_posted_on(); 
						endif;
					echo '</span>
					<span class="post_category"><i class="fa fa-folder-open" aria-hidden="true"></i>';
						$categories_list = get_the_category();
						if(!empty($categories_list)){
							foreach($categories_list as $cat){
								echo '<a href="'.esc_url(get_category_link($cat->cat_ID)).'">'. esc_html($cat->cat_name).' </a>';
							}
						}
					echo '</span>
				</h6>';
		
		
	 
		if(isset($redux_moto['moto_blog_content']) && $redux_moto['moto_blog_content'] == 'short'){
				the_excerpt();
		}else{
			echo '<p>';
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'moto' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );
			echo '</p>';
		}

		
		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'moto' ),
			'after'  => '</div>',
		) );
		
		echo '<a href="'.esc_url( get_permalink() ).'" class="btn btn-default pull-right">'.esc_html__('Read More','moto').' <i class="fa fa-long-arrow-right"></i></a>';
		
	?>
</div><!-- #post-## -->
