<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product, $woocommerce_loop;

// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) ) {
	$woocommerce_loop['loop'] = 0;
}

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
}

// Ensure visibility
if ( ! $product || ! $product->is_visible() ) {
	return;
}

// Increase loop count
$woocommerce_loop['loop']++;

// Extra post classes
$classes = array();
if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] ) {
	$classes[] = 'first';
}
if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] ) {
	$classes[] = 'last';
} 
// moto column class
if( is_shop() ){
global $redux_moto;
$redux_moto = moto_redux_variables();
if( isset($redux_moto['moto_shop_columns']) ){
	$pos = $redux_moto['moto_shop_columns'];
}
if( $pos == 'col2' ){
	$col = 6;
}elseif( $pos == 'col3' ){
	$col = 4;
}else{
	$col = 3;
}
$classes[] = 'col-md-'.esc_attr($col).' col-sm-6 product_div text-center';
}else{
	if($woocommerce_loop['columns']==4){
	$classes[] = 'col-md-3 col-sm-6 product_div text-center';
	}else{
		$classes[] = 'col-md-4 col-sm-6 product_div text-center';
	}
}  
?>
<div <?php post_class( $classes ); ?>>
<div class="product moto_product">
	<?php do_action( 'woocommerce_before_shop_loop_item' ); ?>
	    <?php
			/**
			 * woocommerce_before_shop_loop_item_title hook
			 *
			 * @hooked woocommerce_show_product_loop_sale_flash - 10
			 * @hooked woocommerce_template_loop_product_thumbnail - 10
			 */
			 ?>
			 <?php 
			    if ($product->is_on_sale()):
                   echo "<span class='moto_sale'>".esc_html__('Sale','moto')."</span>";
                endif;
             ?>
			 <div class="mt_product_wrapper">
			 <div class="product-holder">
			    <?php do_action('woocommerce_before_shop_loop_item_title');	?>
				<div class="overlay">
					<a href="<?php echo  wp_get_attachment_url( get_post_thumbnail_id(), 'full' ); ?>" data-rel="prettyPhoto"><i class="fa fa-plus"></i></a><a href="<?php the_permalink(); ?>"><i class="fa fa-eye" aria-hidden="true"></i></a>
				</div>
			</div>
			<?php			
			/**
			 * woocommerce_shop_loop_item_title hook
			 *
			 * @hooked woocommerce_template_loop_product_title - 10
			 */
			do_action( 'woocommerce_shop_loop_item_title' );
			?>
           
			<?php 
			/**
			 * woocommerce_after_shop_loop_item_title hook
			 *
			 * @hooked woocommerce_template_loop_rating - 5
			 * @hooked woocommerce_template_loop_price - 10
			 */
			do_action( 'woocommerce_after_shop_loop_item_title' );
		?>
		
		<?php
						/**
						 * woocommerce_after_shop_loop_item hook
						 *
						 * @hooked woocommerce_template_loop_add_to_cart - 10
						 */
						do_action( 'woocommerce_after_shop_loop_item' );
					?>
		</div>
	</div>
</div>