<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product;
   /**
	 * woocommerce_before_single_product hook
	 *
	 * @hooked wc_print_notices - 10
	 */
	 do_action( 'woocommerce_before_single_product' );

	 if ( post_password_required() ) {
	 	echo get_the_password_form();
	 	return;
	 }
	 
$position = moto_get_sidebar_position(); 
?>
<?php  if($position == 'full' ){  ?>
	<div class="row text-center product">
<?php } ?>
<?php $product_header_title = get_post_meta($post->ID, 'motocore_product_header_title', true);
     if(!empty($product_header_title)){
		 echo '<hr><h4 class="invo_heading invo_bottom_spacer50">'.esc_attr($product_header_title).'</h4>';
	 } ?>
	
<?php  if($position!='full'){  ?>
	<div class="row text-center">
<?php } ?>


<?php  if($position!='right'){  ?>
	<div class="col-md-6 text-left moto_single_product">
<?php }else{ ?>
	<div class="col-md-12 text-left moto_single_product">
<?php } ?>
   <?php
	    if ($product->is_on_sale()):
                echo "<span class='moto_sale'>".esc_html__('Sale','moto')."</span>";
        endif;
		/**
		 * woocommerce_before_single_product_summary hook
		 *
		 * @hooked woocommerce_show_product_sale_flash - 10
		 * @hooked woocommerce_show_product_images - 20
		 */
		do_action( 'woocommerce_before_single_product_summary' );
	?>
</div>
<?php  if($position!='right'){  ?>
	<div class="col-md-6 text-left moto_single_product">
<?php }else{ ?>
	<div class="col-md-12 text-left moto_single_product">
<?php } ?>
		<?php
		   /**
			 * woocommerce_single_product_summary hook
			 *
			 * @hooked woocommerce_template_single_title - 5
			 * @hooked woocommerce_template_single_rating - 10
			 * @hooked woocommerce_template_single_price - 10
			 * @hooked woocommerce_template_single_excerpt - 20
			 * @hooked woocommerce_template_single_add_to_cart - 30
			 * @hooked woocommerce_template_single_meta - 40
			 * @hooked woocommerce_template_single_sharing - 50
			 */
			do_action( 'woocommerce_single_product_summary' );
		?>
</div>
</div>
<?php
		/**
		 * woocommerce_after_single_product_summary hook
		 *
		 * @hooked woocommerce_output_product_data_tabs - 10
		 * @hooked woocommerce_upsell_display - 15
		 * @hooked woocommerce_output_related_products - 20
		 */
		do_action( 'woocommerce_after_single_product_summary' );
	?>
<?php do_action( 'woocommerce_after_single_product' ); ?>