<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $post, $product;
$attachment_ids = $product->get_gallery_image_ids();
$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
$full_size_image   = wp_get_attachment_image_src( $post_thumbnail_id, 'full' );
$image_title       = get_post_field( 'post_excerpt', $post_thumbnail_id );
$placeholder       = has_post_thumbnail() ? 'with-images' : 'without-images';
$wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
	'woocommerce-product-gallery',
	'woocommerce-product-gallery--' . $placeholder,
	'woocommerce-product-gallery--columns-' . absint( $columns ),
	'images',
) );
$attributes = array(
			'title' => $image_title,
			'data-src' => $full_size_image[0],
			'data-large_image' => $full_size_image[0],
			'data-large_image_width'  => $full_size_image[1],
			'data-large_image_height' => $full_size_image[2],
		  );
if(!empty($attachment_ids)){
?>
<div class="product_slider_wrapper">
    <div class="product_slider bxslider">
    <?php 
	 if ( $attachment_ids && has_post_thumbnail() ) {
	    foreach ( $attachment_ids as $attachment_id ) {
		$full_size_image = wp_get_attachment_image_src( $attachment_id, 'full' );
		$thumbnail       = wp_get_attachment_image_src( $attachment_id, 'shop_thumbnail' );
		$image_title     = get_post_field( 'post_excerpt', $attachment_id );

	   $images = wp_get_attachment_image_src( $attachment_id, 'shop_single', false, $attributes );
	   if(!empty($images[0])):
        ?>
		<div class="product-holder">
		<a href="<?php echo esc_url($images[0]); ?>" data-gal="prettyPhoto[gallery1]">
          <img src="<?php echo esc_url($images[0]); ?>" />
        </a>
		 </div>
		<?php
		endif;
	   } 
      }
	?> 
   </div>
 </div>
<?php 
    }	

	if(empty($images[0])){
    echo '<div class="gallery">
	       <div class="product-holder gallery-pic">';
	   if(has_post_thumbnail()){
		    $html  = '<a href="' . esc_url($full_size_image[0]) . '">';
		    $html .= get_the_post_thumbnail( $post->ID, 'shop_single', $attributes );
		    $html .= '</a>';
	   } else {
	      $html .= sprintf('<img src="%s" alt="%s" class="wp-post-image"/>', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'woocommerce' ));
	   } 
       echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, get_post_thumbnail_id( $post->ID ) );
	?>
    <div class="overlay">
	   <a href="<?php echo esc_url($full_size_image[0]); ?>" data-rel="prettyPhoto"><i class="fa fa-plus"></i></a>
	</div>
	  </div>
	</div>
  <?php } ?>
  
  <?php
  if(!empty($images[0])){
  ?>
  <div class="moto_thumbnails_wrapper">
    <div class="moto_thumbnails">
      <?php do_action( 'woocommerce_product_thumbnails' ); ?> 
    </div>
  </div>
  <?php } ?>
