<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter tabs and allow third parties to add their own
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $tabs ) ) : ?>

	<div class="row">
			<div class="col-md-12">
				<div class="tabs-container">
		<div class="tab-nav tabs wc-tabs">
			<?php foreach ( $tabs as $key => $tab ) : ?>				
					<a href="#tab-<?php echo esc_attr( $key ); ?>"><?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', esc_html( $tab['title'] ), $key ); ?></a>				
			<?php endforeach; ?>
		</div>
		<div class="tab-holder">
		<?php foreach ( $tabs as $key => $tab ) : ?>
			<div class="tab" id="tab-<?php echo esc_attr( $key ); ?>">
				<?php call_user_func( $tab['callback'], $key, $tab ); ?>
			</div>
		<?php endforeach; ?>
		</div>
	</div>
			</div>
		</div>

<?php endif; ?>
